/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutData;
import org.osgi.framework.Bundle;

public class AboutBundleData
extends AboutData {
    private Bundle bundle;
    private ExtendedSigningInfo info;
    private boolean isSignedDetermined = false;
    private boolean isSigned;
    private Date signDate;

    public AboutBundleData(Bundle bundle) {
        this(bundle, null);
    }

    public AboutBundleData(Bundle bundle, ExtendedSigningInfo info) {
        super(AboutBundleData.getResourceString(bundle, "Bundle-Vendor"), AboutBundleData.getResourceString(bundle, "Bundle-Name"), AboutBundleData.getResourceString(bundle, "Bundle-Version"), bundle.getSymbolicName());
        this.bundle = bundle;
        this.info = info;
    }

    public int getState() {
        return this.bundle.getState();
    }

    public String getStateName() {
        switch (this.getState()) {
            case 2: {
                return WorkbenchMessages.AboutPluginsDialog_state_installed;
            }
            case 4: {
                return WorkbenchMessages.AboutPluginsDialog_state_resolved;
            }
            case 8: {
                return WorkbenchMessages.AboutPluginsDialog_state_starting;
            }
            case 16: {
                return WorkbenchMessages.AboutPluginsDialog_state_stopping;
            }
            case 1: {
                return WorkbenchMessages.AboutPluginsDialog_state_uninstalled;
            }
            case 32: {
                return WorkbenchMessages.AboutPluginsDialog_state_active;
            }
        }
        return WorkbenchMessages.AboutPluginsDialog_state_unknown;
    }

    private static String getResourceString(Bundle bundle, String headerName) {
        String value = (String)bundle.getHeaders().get(headerName);
        return value == null ? null : Platform.getResourceString((Bundle)bundle, (String)value);
    }

    public boolean isSignedDetermined() {
        return this.isSignedDetermined;
    }

    public boolean isSigned() throws IllegalStateException {
        SignerInfo[] signers;
        if (this.isSignedDetermined) {
            return this.isSigned;
        }
        SignedContent signedContent = this.getSignedContent();
        boolean bl = this.isSigned = signedContent != null && signedContent.isSigned();
        if (!this.isSigned && this.info != null) {
            this.isSigned = this.info.isSigned(this.bundle);
        }
        if ((signers = signedContent.getSignerInfos()).length == 0) {
            if (this.info != null && this.info.isSigned(this.bundle)) {
                this.signDate = this.info.getSigningTime(this.bundle);
            }
        } else {
            this.signDate = signedContent.getSigningTime(signers[0]);
        }
        this.isSignedDetermined = true;
        return this.isSigned;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public ExtendedSigningInfo getInfo() {
        return this.info;
    }

    public SignedContent getSignedContent() throws IllegalStateException {
        SignedContent[] result = new SignedContent[1];
        ServiceCaller.callOnce(this.getClass(), SignedContentFactory.class, contentFactory -> {
            try {
                signedContentArray[0] = contentFactory.getSignedContent(this.bundle);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        });
        return result[0];
    }

    public Date getSignDate() {
        return this.signDate;
    }

    public static interface ExtendedSigningInfo {
        public boolean isSigned(Bundle var1);

        public String getSigningType(Bundle var1);

        public Date getSigningTime(Bundle var1);

        public String getSigningDetails(Bundle var1);
    }
}

