/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ui.internal.quickaccess.CamelUtil;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public final class QuickAccessMatcher {
    private final QuickAccessElement element;
    private static final int[][] EMPTY_INDICES = new int[0][0];
    private static final String WS_WILD_START = "^\\s*(\\*|\\?)*";
    private static final String WS_WILD_END = "(\\*|\\?)*\\s*$";
    private static final String ANY_WS = "\\s+";
    private static final String EMPTY_STR = "";
    private static final String PAR_START = "\\(";
    private static final String PAR_END = "\\)";
    private static final String ONE_CHAR = ".?";
    private String wsFilter;
    private Pattern wsPattern;
    private String wcFilter;
    private Pattern wcPattern;

    public QuickAccessMatcher(QuickAccessElement element) {
        this.element = element;
    }

    private Pattern getWhitespacesPattern(String filter) {
        if (this.wsPattern == null || !filter.equals(this.wsFilter)) {
            this.wsFilter = filter;
            String sFilter = filter.replaceFirst(WS_WILD_START, EMPTY_STR).replaceFirst(WS_WILD_END, EMPTY_STR).replaceAll(PAR_START, ONE_CHAR).replaceAll(PAR_END, ONE_CHAR);
            sFilter = String.format(".*(%s).*", sFilter.replaceAll(ANY_WS, ").*("));
            this.wsPattern = QuickAccessMatcher.safeCompile(sFilter);
        }
        return this.wsPattern;
    }

    private Pattern getWildcardsPattern(String filter) {
        filter = filter.replaceAll("\\*+", "*");
        if (this.wcPattern == null || !filter.equals(this.wcFilter)) {
            this.wcFilter = filter;
            String sFilter = filter.replaceFirst(WS_WILD_START, EMPTY_STR).replaceFirst(WS_WILD_END, EMPTY_STR).replaceAll(PAR_START, ONE_CHAR).replaceAll(PAR_END, ONE_CHAR);
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < sFilter.length()) {
                char c = sFilter.charAt(i);
                if (c == '*') {
                    sb.append(").").append(c).append("(");
                } else if (c == '?') {
                    int n = 1;
                    while (i + 1 < sFilter.length()) {
                        if (sFilter.charAt(i + 1) != '?') break;
                        ++n;
                        ++i;
                    }
                    sb.append(").").append(n == 1 ? Character.valueOf('?') : String.format("{0,%d}", n)).append("(");
                } else {
                    sb.append(c);
                }
                ++i;
            }
            sFilter = String.format(".*(%s).*", sb.toString());
            sFilter = sFilter.replace("()", EMPTY_STR);
            this.wcPattern = QuickAccessMatcher.safeCompile(sFilter);
        }
        return this.wcPattern;
    }

    private static Pattern safeCompile(String pattern) {
        try {
            return Pattern.compile(pattern, 2);
        }
        catch (Exception exception) {
            return Pattern.compile("\\a");
        }
    }

    public QuickAccessEntry match(String filter, QuickAccessProvider providerForMatching) {
        String matchLabel = this.element.getMatchLabel();
        int index = matchLabel.toLowerCase().indexOf(filter);
        if (index != -1) {
            index = this.element.getLabel().toLowerCase().indexOf(filter);
            if (index != -1) {
                int quality = matchLabel.toLowerCase().equals(filter) ? 0 : (matchLabel.toLowerCase().startsWith(filter) ? 5 : 10);
                return new QuickAccessEntry(this.element, providerForMatching, new int[][]{{index, index + filter.length() - 1}}, EMPTY_INDICES, quality);
            }
            return new QuickAccessEntry(this.element, providerForMatching, EMPTY_INDICES, EMPTY_INDICES, 15);
        }
        Pattern p = filter.contains("*") || filter.contains("?") ? this.getWildcardsPattern(filter) : this.getWhitespacesPattern(filter);
        Matcher m = p.matcher(matchLabel);
        if (m.matches()) {
            String label = this.element.getLabel();
            if (!matchLabel.equals(label) && !(m = p.matcher(this.element.getLabel())).matches()) {
                return new QuickAccessEntry(this.element, providerForMatching, EMPTY_INDICES, EMPTY_INDICES, 10);
            }
            int groupCount = m.groupCount();
            int[][] indices = new int[groupCount][];
            int i = 0;
            while (i < groupCount) {
                int nGrp = i + 1;
                indices[i] = new int[]{m.start(nGrp), m.end(nGrp) - 1};
                ++i;
            }
            int quality = 5;
            return new QuickAccessEntry(this.element, providerForMatching, indices, EMPTY_INDICES, quality);
        }
        String combinedMatchLabel = providerForMatching.getName() + " " + this.element.getMatchLabel();
        String combinedLabel = providerForMatching.getName() + " " + this.element.getLabel();
        index = combinedMatchLabel.toLowerCase().indexOf(filter);
        if (index != -1) {
            index = combinedLabel.toLowerCase().indexOf(filter);
            if (index != -1) {
                int lengthOfElementMatch = index + filter.length() - providerForMatching.getName().length() - 1;
                if (lengthOfElementMatch > 0) {
                    int[][] nArrayArray = new int[1][];
                    int[] nArray = new int[2];
                    nArray[1] = lengthOfElementMatch - 1;
                    nArrayArray[0] = nArray;
                    return new QuickAccessEntry(this.element, providerForMatching, nArrayArray, new int[][]{{index, index + filter.length() - 1}}, 10);
                }
                return new QuickAccessEntry(this.element, providerForMatching, EMPTY_INDICES, new int[][]{{index, index + filter.length() - 1}}, 10);
            }
            return new QuickAccessEntry(this.element, providerForMatching, EMPTY_INDICES, EMPTY_INDICES, 15);
        }
        String camelCase = CamelUtil.getCamelCase(this.element.getLabel());
        index = camelCase.indexOf(filter);
        if (index != -1) {
            int[][] indices = CamelUtil.getCamelCaseIndices(matchLabel, index, filter.length());
            return new QuickAccessEntry(this.element, providerForMatching, indices, EMPTY_INDICES, 10);
        }
        String combinedCamelCase = CamelUtil.getCamelCase(combinedLabel);
        index = combinedCamelCase.indexOf(filter);
        if (index != -1) {
            String providerCamelCase = CamelUtil.getCamelCase(providerForMatching.getName());
            int lengthOfElementMatch = index + filter.length() - providerCamelCase.length();
            if (lengthOfElementMatch > 0) {
                return new QuickAccessEntry(this.element, providerForMatching, CamelUtil.getCamelCaseIndices(matchLabel, 0, lengthOfElementMatch), CamelUtil.getCamelCaseIndices(providerForMatching.getName(), index, filter.length() - lengthOfElementMatch), 10);
            }
            return new QuickAccessEntry(this.element, providerForMatching, EMPTY_INDICES, CamelUtil.getCamelCaseIndices(providerForMatching.getName(), index, filter.length()), 10);
        }
        return null;
    }
}

