/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.oauth.ui;

import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.userstorage.internal.oauth.UIFacade;
import org.eclipse.userstorage.internal.oauth.ui.LoginDialog;
import org.eclipse.userstorage.ui.internal.UIUtil;

public class SWTInternalBrowserFacade
extends UIFacade {
    protected IShellProvider shell;

    public SWTInternalBrowserFacade() {
    }

    public SWTInternalBrowserFacade(Shell shell) {
        this.setShell(shell);
    }

    @Override
    public URI obtainAuthCode(final String providerName, final URI startURI, final URI stopURI) {
        final URI[] authCodeURI = new URI[1];
        this.syncExec(new Runnable(){

            @Override
            public void run() {
                LoginDialog login = new LoginDialog(SWTInternalBrowserFacade.this.getShell());
                login.setTitle(MessageFormat.format("Authorizing with {0}", providerName));
                login.setStartURI(startURI);
                login.setStopURI(stopURI);
                authCodeURI[0] = login.open() == 0 ? login.getFinalURI() : null;
            }
        });
        return authCodeURI[0];
    }

    @Override
    public void showError(final String title, final String description, final IStatus status) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)SWTInternalBrowserFacade.this.getShell(), (String)title, (String)description, (IStatus)status);
            }
        });
    }

    public void setShell(IShellProvider shell) {
        this.shell = shell;
    }

    public void setShell(Shell shell) {
        this.shell = new SameShellProvider((Control)shell);
    }

    protected Shell getShell() {
        if (this.shell != null) {
            return this.shell.getShell();
        }
        return UIUtil.getShell();
    }

    protected void asyncExec(Runnable runnable) {
        this.getDisplay().asyncExec(runnable);
    }

    protected void syncExec(Runnable runnable) {
        this.getDisplay().syncExec(runnable);
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        if (Display.getCurrent() != null) {
            return Display.getCurrent();
        }
        return Display.getDefault();
    }
}

