/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WebSite;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IPersistStreamInit;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SAFEARRAY;
import org.eclipse.swt.internal.win32.SAFEARRAYBOUND;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class IE
extends WebBrowser {
    OleFrame frame;
    WebSite site;
    OleAutomation auto;
    OleListener domListener;
    OleAutomation[] documents = new OleAutomation[0];
    boolean back;
    boolean forward;
    boolean delaySetText;
    boolean ignoreDispose;
    boolean ignoreTraverse;
    boolean performingInitialNavigate;
    boolean installFunctionsOnDocumentComplete;
    boolean untrustedText;
    boolean isRefresh;
    boolean isAboutBlank;
    Point location;
    Point size;
    boolean addressBar = true;
    boolean menuBar = true;
    boolean statusBar = true;
    boolean toolBar = true;
    long globalDispatch;
    String html;
    String lastNavigateURL;
    String uncRedirect;
    Object[] pendingText;
    Object[] pendingUrl;
    int style;
    int lastKeyCode;
    int lastCharCode;
    int lastMouseMoveX;
    int lastMouseMoveY;
    static boolean Initialized;
    static int IEVersion;
    static int PDFCount;
    static String ProgId;
    static final int BeforeNavigate2 = 250;
    static final int CommandStateChange = 105;
    static final int DocumentComplete = 259;
    static final int DownloadComplete = 104;
    static final int NavigateComplete2 = 252;
    static final int NewWindow2 = 251;
    static final int OnMenuBar = 256;
    static final int OnStatusBar = 257;
    static final int OnToolBar = 255;
    static final int OnVisible = 254;
    static final int ProgressChange = 108;
    static final int RegisterAsBrowser = 552;
    static final int StatusTextChange = 102;
    static final int TitleChange = 113;
    static final int WindowClosing = 263;
    static final int WindowSetHeight = 267;
    static final int WindowSetLeft = 264;
    static final int WindowSetResizable = 262;
    static final int WindowSetTop = 265;
    static final int WindowSetWidth = 266;
    static final int NavigateError = 271;
    static final short CSC_NAVIGATEFORWARD = 1;
    static final short CSC_NAVIGATEBACK = 2;
    static final int INET_E_DEFAULT_ACTION = -2146697199;
    static final int INET_E_RESOURCE_NOT_FOUND = -2146697211;
    static final int READYSTATE_COMPLETE = 4;
    static final int URLPOLICY_ALLOW = 0;
    static final int URLPOLICY_DISALLOW = 3;
    static final int URLPOLICY_JAVA_PROHIBIT = 0;
    static final int URLPOLICY_JAVA_LOW = 196608;
    static final int URLZONE_LOCAL_MACHINE = 0;
    static final int URLZONE_INTRANET = 1;
    static final int URLACTION_ACTIVEX_MIN = 4608;
    static final int URLACTION_ACTIVEX_MAX = 5119;
    static final int URLACTION_ACTIVEX_RUN = 4608;
    static final int URLACTION_FEATURE_ZONE_ELEVATION = 8449;
    static final int URLACTION_JAVA_MIN = 7168;
    static final int URLACTION_JAVA_MAX = 7423;
    static final int URLACTION_SCRIPT_RUN = 5120;
    static final int DISPID_AMBIENT_DLCONTROL = -5512;
    static final int DLCTL_DLIMAGES = 16;
    static final int DLCTL_VIDEOS = 32;
    static final int DLCTL_BGSOUNDS = 64;
    static final int DLCTL_NO_SCRIPTS = 128;
    static final int DLCTL_NO_JAVA = 256;
    static final int DLCTL_NO_RUNACTIVEXCTLS = 512;
    static final int DLCTL_NO_DLACTIVEXCTLS = 1024;
    static final int DLCTL_DOWNLOADONLY = 2048;
    static final int DLCTL_NO_FRAMEDOWNLOAD = 4096;
    static final int DLCTL_RESYNCHRONIZE = 8192;
    static final int DLCTL_PRAGMA_NO_CACHE = 16384;
    static final int DLCTL_FORCEOFFLINE = 0x10000000;
    static final int DLCTL_NO_CLIENTPULL = 0x20000000;
    static final int DLCTL_SILENT = 0x40000000;
    static final int DOCHOSTUIFLAG_THEME = 262144;
    static final int DOCHOSTUIFLAG_NO3DBORDER = 4;
    static final int DOCHOSTUIFLAG_NO3DOUTERBORDER = 0x200000;
    static final int DOCHOSTUIFLAG_ENABLE_REDIRECT_NOTIFICATION = 0x4000000;
    static final int DOCHOSTUIFLAG_DPI_AWARE = 0x40000000;
    static final String ABOUT_BLANK = "about:blank";
    static final String CLSID_SHELLEXPLORER1 = "{EAB22AC3-30C1-11CF-A7EB-0000C05BAE0B}";
    static final int DEFAULT_IE_VERSION = 9999;
    static final String EXTENSION_PDF = ".pdf";
    static final String HTML_DOCUMENT = "HTML Document";
    static final int MAX_PDF = 20;
    static final char SEPARATOR_OS;
    static final String PROPERTY_IEVERSION = "org.eclipse.swt.browser.IEVersion";
    static final String VALUE_DEFAULT = "default";
    static final String EVENT_DOUBLECLICK = "dblclick";
    static final String EVENT_DRAGEND = "dragend";
    static final String EVENT_DRAGSTART = "dragstart";
    static final String EVENT_KEYDOWN = "keydown";
    static final String EVENT_KEYPRESS = "keypress";
    static final String EVENT_KEYUP = "keyup";
    static final String EVENT_MOUSEMOVE = "mousemove";
    static final String EVENT_MOUSEWHEEL = "mousewheel";
    static final String EVENT_MOUSEUP = "mouseup";
    static final String EVENT_MOUSEDOWN = "mousedown";
    static final String EVENT_MOUSEOUT = "mouseout";
    static final String EVENT_MOUSEOVER = "mouseover";
    static final String PROTOCOL_FILE = "file://";
    static final String PROPERTY_ALTKEY = "altKey";
    static final String PROPERTY_BUTTON = "button";
    static final String PROPERTY_CTRLKEY = "ctrlKey";
    static final String PROPERTY_DOCUMENT = "Document";
    static final String PROPERTY_FROMELEMENT = "fromElement";
    static final String PROPERTY_KEYCODE = "keyCode";
    static final String PROPERTY_REPEAT = "repeat";
    static final String PROPERTY_RETURNVALUE = "returnValue";
    static final String PROPERTY_SCREENX = "screenX";
    static final String PROPERTY_SCREENY = "screenY";
    static final String PROPERTY_SHIFTKEY = "shiftKey";
    static final String PROPERTY_TOELEMENT = "toElement";
    static final String PROPERTY_TYPE = "type";
    static final String PROPERTY_WHEELDELTA = "wheelDelta";

    static {
        int[] lpcbData;
        ProgId = "Shell.Explorer";
        SEPARATOR_OS = File.separatorChar;
        NativeClearSessions = () -> OS.InternetSetOption(0L, 42, 0L, 0);
        NativeGetCookie = () -> {
            TCHAR url = new TCHAR(0, CookieUrl, true);
            TCHAR cookieData = new TCHAR(0, 8192);
            int[] size = new int[]{cookieData.length()};
            if (!OS.InternetGetCookie(url, null, cookieData, size)) {
                size[0] = size[0] / 2;
                cookieData = new TCHAR(0, size[0]);
                if (!OS.InternetGetCookie(url, null, cookieData, size)) {
                    return;
                }
            }
            String allCookies = cookieData.toString(0, size[0]);
            StringTokenizer tokenizer = new StringTokenizer(allCookies, ";");
            while (tokenizer.hasMoreTokens()) {
                String name;
                String cookie = tokenizer.nextToken();
                int index = cookie.indexOf(61);
                if (index == -1 || !(name = cookie.substring(0, index).trim()).equals(CookieName)) continue;
                CookieValue = cookie.substring(index + 1).trim();
                return;
            }
        };
        NativeSetCookie = () -> {
            TCHAR url = new TCHAR(0, CookieUrl, true);
            TCHAR value = new TCHAR(0, CookieValue, true);
            CookieResult = OS.InternetSetCookie(url, null, value);
        };
        TCHAR key = new TCHAR(0, "Software\\Microsoft\\Internet Explorer", true);
        long[] phkResult = new long[1];
        if (OS.RegOpenKeyEx(-2147483646L, key, 0, 131097, phkResult) == 0) {
            String versionString;
            int index;
            TCHAR lpData;
            TCHAR buffer = new TCHAR(0, "svcVersion", true);
            lpcbData = new int[1];
            int result = OS.RegQueryValueEx(phkResult[0], buffer, 0L, null, null, lpcbData);
            if (result != 0) {
                buffer = new TCHAR(0, "Version", true);
                result = OS.RegQueryValueEx(phkResult[0], buffer, 0L, null, null, lpcbData);
            }
            if (result == 0 && (result = OS.RegQueryValueEx(phkResult[0], buffer, 0L, null, lpData = new TCHAR(0, lpcbData[0] / 2), lpcbData)) == 0 && (index = (versionString = lpData.toString(0, lpData.strlen())).indexOf(".")) != -1) {
                String majorString = versionString.substring(0, index);
                try {
                    IEVersion = Integer.parseInt(majorString);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            OS.RegCloseKey(phkResult[0]);
        }
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, key = new TCHAR(0, "Shell.Explorer\\CLSID", true), 0, 131097, phkResult = new long[1]) == 0) {
            long[] phkResult2;
            String clsid;
            TCHAR lpData;
            lpcbData = new int[1];
            int result = OS.RegQueryValueEx(phkResult[0], null, 0L, null, null, lpcbData);
            if (result == 0 && (result = OS.RegQueryValueEx(phkResult[0], null, 0L, null, lpData = new TCHAR(0, lpcbData[0] / 2), lpcbData)) == 0 && (clsid = lpData.toString(0, lpData.strlen())).equals(CLSID_SHELLEXPLORER1) && OS.RegOpenKeyEx(Integer.MIN_VALUE, key = new TCHAR(0, "Shell.Explorer.2", true), 0, 131097, phkResult2 = new long[1]) == 0) {
                OS.RegCloseKey(phkResult2[0]);
                ProgId = "Shell.Explorer.2";
            }
            OS.RegCloseKey(phkResult[0]);
        }
        if (NativePendingCookies != null) {
            IE.SetPendingCookies(NativePendingCookies);
        }
        NativePendingCookies = null;
    }

    IE() {
    }

    @Override
    public void create(Composite parent, int style) {
        this.style = style;
        this.frame = new OleFrame(this.browser, 0);
        try {
            this.site = new WebSite((Composite)this.frame, 0, ProgId);
        }
        catch (SWTException sWTException) {
            this.browser.dispose();
            SWT.error(2);
        }
        if (!Initialized) {
            long[] key;
            TCHAR subkey;
            Initialized = true;
            int version = 0;
            String versionProperty = System.getProperty(PROPERTY_IEVERSION);
            if (versionProperty != null) {
                if (versionProperty.equalsIgnoreCase(VALUE_DEFAULT)) {
                    version = -1;
                } else {
                    try {
                        version = Integer.parseInt(versionProperty);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (version == 0) {
                version = IEVersion != 0 ? (IEVersion >= 10 ? IEVersion * 1000 + 1 : (IEVersion >= 8 ? IEVersion * 1111 : IEVersion * 1000)) : 9999;
            }
            if (version != -1 && OS.RegCreateKeyEx(-2147483647L, subkey = new TCHAR(0, "Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_BROWSER_EMULATION", true), 0, null, 1, 131079, 0L, key = new long[1], null) == 0) {
                TCHAR lpszFile = new TCHAR(0, 260);
                OS.GetModuleFileName(0L, lpszFile, lpszFile.length());
                String path = lpszFile.toString(0, lpszFile.strlen());
                int index = path.lastIndexOf(SEPARATOR_OS);
                String executable = index != -1 ? path.substring(index + 1) : path;
                TCHAR lpValueName = new TCHAR(0, executable, true);
                int result = OS.RegQueryValueEx(key[0], lpValueName, 0L, null, null, null);
                if ((result == 0 || result == 2) && OS.RegSetValueEx(key[0], lpValueName, 0, 4, new int[]{version}, 4) == 0) {
                    parent.getDisplay().addListener(12, event -> {
                        long[] key1 = new long[1];
                        if (OS.RegOpenKeyEx(-2147483647L, subkey, 0, 131078, key1) == 0) {
                            OS.RegDeleteValue(key1[0], lpValueName);
                        }
                    });
                }
                OS.RegCloseKey(key[0]);
            }
        }
        this.site.doVerb(-5);
        this.auto = new OleAutomation(this.site);
        this.domListener = e -> this.handleDOMEvent(e);
        Listener listener = e -> {
            switch (e.type) {
                case 12: {
                    if (this.ignoreDispose) {
                        this.ignoreDispose = false;
                        break;
                    }
                    this.ignoreDispose = true;
                    this.browser.notifyListeners(e.type, e);
                    e.type = 0;
                    if (!this.browser.isClosing) {
                        LocationListener[] oldLocationListeners = this.locationListeners;
                        this.locationListeners = new LocationListener[0];
                        this.site.ignoreAllMessages = true;
                        this.execute("window.location.href='about:blank'");
                        this.site.ignoreAllMessages = false;
                        this.locationListeners = oldLocationListeners;
                    }
                    if (!this.frame.isDisposed()) {
                        this.unhookDOMListeners(this.documents);
                    }
                    OleAutomation[] oleAutomationArray = this.documents;
                    int n = this.documents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OleAutomation document = oleAutomationArray[n2];
                        document.dispose();
                        ++n2;
                    }
                    this.documents = null;
                    Iterator elements = this.functions.values().iterator();
                    while (elements.hasNext()) {
                        ((BrowserFunction)elements.next()).dispose(false);
                    }
                    this.functions = null;
                    this.uncRedirect = null;
                    this.lastNavigateURL = null;
                    this.domListener = null;
                    if (this.auto != null) {
                        this.auto.dispose();
                    }
                    this.auto = null;
                    break;
                }
                case 11: {
                    this.frame.setBounds(this.browser.getClientArea());
                    break;
                }
                case 37: {
                    e.doit = false;
                    break;
                }
                case 15: {
                    this.site.setFocus();
                    break;
                }
                case 31: {
                    if (e.detail == 8 && e.widget instanceof WebSite) {
                        this.browser.traverse(8, e);
                        e.doit = false;
                    }
                    if (e.detail != 4 || !e.doit || !(e.widget instanceof Browser)) break;
                    e.type = 0;
                    e.doit = false;
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(11, listener);
        this.browser.addListener(31, listener);
        this.site.addListener(37, listener);
        this.site.addListener(31, listener);
        OleListener oleListener = event -> {
            if (this.auto != null) {
                switch (event.type) {
                    case 250: {
                        if (this.performingInitialNavigate) break;
                        Variant varResult1 = event.arguments[1];
                        Object url1 = varResult1.getString();
                        if (this.uncRedirect != null) {
                            if (this.uncRedirect.equals(url1) || this.uncRedirect.startsWith((String)url1) && this.uncRedirect.indexOf(92, 2) == ((String)url1).length()) {
                                Variant cancel1 = event.arguments[6];
                                if (cancel1 != null) {
                                    long pCancel1 = cancel1.getByRef();
                                    OS.MoveMemory(pCancel1, new short[1], 2);
                                }
                                this.setAboutBlank(false);
                                break;
                            }
                            this.uncRedirect = null;
                        }
                        if (((String)url1).indexOf(":/") == -1 && ((String)url1).indexOf(":\\") != -1) {
                            TCHAR filePath1 = new TCHAR(0, (String)url1, true);
                            TCHAR urlResult1 = new TCHAR(0, 2084);
                            int[] size1 = new int[]{urlResult1.length()};
                            url1 = OS.UrlCreateFromPath(filePath1, urlResult1, size1, 0) == 0 ? urlResult1.toString(0, size1[0]) : PROTOCOL_FILE + ((String)url1).replace('\\', '/');
                        }
                        if (((String)url1).startsWith(PROTOCOL_FILE) && this._getUrl().startsWith(ABOUT_BLANK) && this.untrustedText) {
                            Variant cancel2 = event.arguments[6];
                            if (cancel2 == null) break;
                            long pCancel2 = cancel2.getByRef();
                            OS.MoveMemory(pCancel2, new short[]{-1}, 2);
                            break;
                        }
                        LocationEvent newEvent1 = new LocationEvent(this.browser);
                        newEvent1.display = this.browser.getDisplay();
                        newEvent1.widget = this.browser;
                        newEvent1.location = url1;
                        newEvent1.doit = true;
                        LocationListener[] locationListenerArray = this.locationListeners;
                        int n = this.locationListeners.length;
                        int size1 = 0;
                        while (size1 < n) {
                            LocationListener locationListener = locationListenerArray[size1];
                            locationListener.changing(newEvent1);
                            ++size1;
                        }
                        boolean doit1 = newEvent1.doit && !this.browser.isDisposed();
                        Variant cancel3 = event.arguments[6];
                        if (cancel3 != null) {
                            long pCancel3 = cancel3.getByRef();
                            OS.MoveMemory(pCancel3, new short[]{doit1 ? (short)0 : (short)-1}, 2);
                        }
                        if (!doit1) break;
                        varResult1 = event.arguments[0];
                        IDispatch dispatch1 = varResult1.getDispatch();
                        Variant variant1 = new Variant(this.auto);
                        IDispatch top1 = variant1.getDispatch();
                        if (top1.getAddress() != dispatch1.getAddress()) break;
                        this.setAboutBlank(((String)url1).startsWith(ABOUT_BLANK));
                        break;
                    }
                    case 105: {
                        boolean enabled = false;
                        Variant varResult2 = event.arguments[0];
                        int command = varResult2.getInt();
                        varResult2 = event.arguments[1];
                        enabled = varResult2.getBoolean();
                        switch (command) {
                            case 2: {
                                this.back = enabled;
                                break;
                            }
                            case 1: {
                                this.forward = enabled;
                            }
                        }
                        break;
                    }
                    case 259: {
                        if (this.performingInitialNavigate) {
                            this.performingInitialNavigate = false;
                            if (this.pendingText != null) {
                                this.setText((String)this.pendingText[0], (Boolean)this.pendingText[1]);
                            } else if (this.pendingUrl != null) {
                                this.setUrl((String)this.pendingUrl[0], (String)this.pendingUrl[1], (String[])this.pendingUrl[2]);
                            }
                            this.pendingUrl = null;
                            this.pendingText = null;
                            break;
                        }
                        Variant varResult3 = event.arguments[0];
                        IDispatch dispatch2 = varResult3.getDispatch();
                        varResult3 = event.arguments[1];
                        Object url2 = varResult3.getString();
                        if (((String)url2).indexOf(":/") == -1 && ((String)url2).indexOf(":\\") != -1) {
                            TCHAR filePath2 = new TCHAR(0, (String)url2, true);
                            TCHAR urlResult2 = new TCHAR(0, 2084);
                            int[] size2 = new int[]{urlResult2.length()};
                            url2 = OS.UrlCreateFromPath(filePath2, urlResult2, size2, 0) == 0 ? urlResult2.toString(0, size2[0]) : PROTOCOL_FILE + ((String)url2).replace('\\', '/');
                        }
                        if (this.html != null && ((String)url2).equals(ABOUT_BLANK)) {
                            if (this.delaySetText) {
                                this.delaySetText = false;
                                this.browser.getDisplay().asyncExec(() -> {
                                    if (this.browser.isDisposed() || this.html == null) {
                                        return;
                                    }
                                    this.setHTML(this.html);
                                    this.html = null;
                                });
                                break;
                            }
                            this.setHTML(this.html);
                            this.html = null;
                            break;
                        }
                        Variant variant2 = new Variant(this.auto);
                        IDispatch top2 = variant2.getDispatch();
                        LocationEvent locationEvent = new LocationEvent(this.browser);
                        locationEvent.display = this.browser.getDisplay();
                        locationEvent.widget = this.browser;
                        locationEvent.location = url2;
                        locationEvent.top = top2.getAddress() == dispatch2.getAddress();
                        LocationListener[] locationListenerArray = this.locationListeners;
                        int n = this.locationListeners.length;
                        int top1 = 0;
                        while (top1 < n) {
                            LocationListener locationListener = locationListenerArray[top1];
                            locationListener.changed(locationEvent);
                            ++top1;
                        }
                        if (this.browser.isDisposed()) {
                            return;
                        }
                        int[] rgdispid1 = this.auto.getIDsOfNames(new String[]{"ReadyState"});
                        Variant pVarResult1 = this.auto.getProperty(rgdispid1[0]);
                        if (pVarResult1 != null) {
                            int readyState = pVarResult1.getInt();
                            pVarResult1.dispose();
                            if (readyState != 4) break;
                        }
                        if (this.globalDispatch == 0L || dispatch2.getAddress() != this.globalDispatch) break;
                        this.globalDispatch = 0L;
                        IE ie = (IE)this.browser.webBrowser;
                        if (ie.installFunctionsOnDocumentComplete) {
                            ie.installFunctionsOnDocumentComplete = false;
                            for (BrowserFunction function1 : this.functions.values()) {
                                this.execute(function1.functionString);
                            }
                        }
                        ProgressEvent progressEvent1 = new ProgressEvent(this.browser);
                        progressEvent1.display = this.browser.getDisplay();
                        progressEvent1.widget = this.browser;
                        ProgressListener[] progressListenerArray = this.progressListeners;
                        int n2 = this.progressListeners.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            ProgressListener progressListener = progressListenerArray[n3];
                            progressListener.completed(progressEvent1);
                            ++n3;
                        }
                        break;
                    }
                    case 104: {
                        for (BrowserFunction function2 : this.functions.values()) {
                            this.execute(function2.functionString);
                        }
                        if (!this.isRefresh) break;
                        this.isRefresh = false;
                        ProgressEvent progressEvent2 = new ProgressEvent(this.browser);
                        progressEvent2.display = this.browser.getDisplay();
                        progressEvent2.widget = this.browser;
                        ProgressListener[] locationEvent = this.progressListeners;
                        int top2 = this.progressListeners.length;
                        int variant2 = 0;
                        while (variant2 < top2) {
                            ProgressListener progressListener = locationEvent[variant2];
                            progressListener.completed(progressEvent2);
                            ++variant2;
                        }
                        break;
                    }
                    case 252: {
                        boolean isTop;
                        String extension;
                        int extensionIndex;
                        this.jsEnabled = this.jsEnabledOnNextPage;
                        Variant varResult4 = event.arguments[1];
                        String url3 = varResult4.getString();
                        if (!this.performingInitialNavigate) {
                            varResult4 = event.arguments[0];
                            IDispatch dispatch3 = varResult4.getDispatch();
                            Variant variant3 = new Variant(this.auto);
                            IDispatch top3 = variant3.getDispatch();
                            if (top3.getAddress() == dispatch3.getAddress()) {
                                this.setAboutBlank(url3.startsWith(ABOUT_BLANK));
                                this.lastNavigateURL = url3;
                            }
                        }
                        boolean isPDF = false;
                        String path = null;
                        try {
                            path = new URL(url3).getPath();
                        }
                        catch (MalformedURLException malformedURLException) {}
                        if (path != null && (extensionIndex = path.lastIndexOf(46)) != -1 && (extension = path.substring(extensionIndex)).equalsIgnoreCase(EXTENSION_PDF)) {
                            isPDF = true;
                            if (++PDFCount > 20) {
                                COM.FreeUnusedLibraries = false;
                            }
                        }
                        if (this.uncRedirect != null) {
                            if (this.uncRedirect.equals(url3)) {
                                this.uncRedirect = null;
                                break;
                            }
                            if (this.uncRedirect.startsWith(url3)) {
                                this.navigate(this.uncRedirect, null, null, true);
                                break;
                            }
                            this.uncRedirect = null;
                        }
                        varResult4 = event.arguments[0];
                        IDispatch dispatch4 = varResult4.getDispatch();
                        if (this.globalDispatch == 0L) {
                            this.globalDispatch = dispatch4.getAddress();
                        }
                        OleAutomation webBrowser = varResult4.getAutomation();
                        Variant variant4 = new Variant(this.auto);
                        IDispatch top4 = variant4.getDispatch();
                        boolean bl = isTop = top4.getAddress() == dispatch4.getAddress();
                        if (isTop) {
                            this.unhookDOMListeners(this.documents);
                            OleAutomation[] oleAutomationArray = this.documents;
                            int n = this.documents.length;
                            int progressListener = 0;
                            while (progressListener < n) {
                                OleAutomation document = oleAutomationArray[progressListener];
                                document.dispose();
                                ++progressListener;
                            }
                            this.documents = new OleAutomation[0];
                            for (BrowserFunction function3 : this.functions.values()) {
                                this.execute(function3.functionString);
                            }
                        }
                        if (!isPDF) {
                            this.hookDOMListeners(webBrowser, isTop);
                        }
                        webBrowser.dispose();
                        break;
                    }
                    case 271: {
                        int index;
                        int statusCode;
                        if (this.uncRedirect != null) {
                            this.uncRedirect = null;
                            break;
                        }
                        Variant varResult5 = event.arguments[1];
                        String url4 = varResult5.getString();
                        if (!url4.startsWith("\\\\") || (statusCode = (varResult5 = event.arguments[3]).getInt()) != -2146697211 || (index = url4.indexOf(92, 2)) == -1) break;
                        String host = url4.substring(0, index);
                        Variant cancel4 = event.arguments[4];
                        if (cancel4 != null) {
                            long pCancel4 = cancel4.getByRef();
                            OS.MoveMemory(pCancel4, new short[]{-1}, 2);
                        }
                        this.browser.getDisplay().asyncExec(() -> {
                            if (this.browser.isDisposed()) {
                                return;
                            }
                            this.uncRedirect = url4.endsWith("\\") ? url4.substring(0, url4.length() - 1) : url4;
                            this.navigate(host, null, null, true);
                        });
                        break;
                    }
                    case 251: {
                        boolean doit2;
                        Variant cancel5 = event.arguments[1];
                        long pCancel5 = cancel5.getByRef();
                        WindowEvent newEvent2 = new WindowEvent(this.browser);
                        newEvent2.display = this.browser.getDisplay();
                        newEvent2.widget = this.browser;
                        newEvent2.required = false;
                        OpenWindowListener[] top4 = this.openWindowListeners;
                        int pCancel4 = this.openWindowListeners.length;
                        int cancel4 = 0;
                        while (cancel4 < pCancel4) {
                            OpenWindowListener openWindowListener = top4[cancel4];
                            openWindowListener.open(newEvent2);
                            ++cancel4;
                        }
                        IE browser = null;
                        if (newEvent2.browser != null && newEvent2.browser.webBrowser instanceof IE) {
                            browser = (IE)newEvent2.browser.webBrowser;
                        }
                        boolean bl = doit2 = browser != null && !browser.browser.isDisposed();
                        if (doit2) {
                            browser.installFunctionsOnDocumentComplete = true;
                            Variant variant5 = new Variant(browser.auto);
                            IDispatch iDispatch = variant5.getDispatch();
                            Variant ppDisp = event.arguments[0];
                            long byref = ppDisp.getByRef();
                            if (byref != 0L) {
                                OS.MoveMemory(byref, new long[]{iDispatch.getAddress()}, C.PTR_SIZEOF);
                            }
                        }
                        if (!newEvent2.required) break;
                        OS.MoveMemory(pCancel5, new short[]{doit2 ? (short)0 : (short)-1}, 2);
                        break;
                    }
                    case 256: {
                        Variant arg01 = event.arguments[0];
                        this.menuBar = arg01.getBoolean();
                        break;
                    }
                    case 257: {
                        Variant arg02 = event.arguments[0];
                        this.statusBar = arg02.getBoolean();
                        break;
                    }
                    case 255: {
                        Variant arg03 = event.arguments[0];
                        this.toolBar = arg03.getBoolean();
                        if (this.toolBar) break;
                        this.addressBar = false;
                        this.menuBar = false;
                        break;
                    }
                    case 254: {
                        Variant arg11 = event.arguments[0];
                        boolean visible = arg11.getBoolean();
                        WindowEvent newEvent3 = new WindowEvent(this.browser);
                        newEvent3.display = this.browser.getDisplay();
                        newEvent3.widget = this.browser;
                        if (visible) {
                            int[] rgdispid2;
                            Variant pVarResult22;
                            if (this.addressBar && (pVarResult22 = this.auto.getProperty((rgdispid2 = this.auto.getIDsOfNames(new String[]{"AddressBar"}))[0])) != null) {
                                if (pVarResult22.getType() == 11) {
                                    this.addressBar = pVarResult22.getBoolean();
                                }
                                pVarResult22.dispose();
                            }
                            newEvent3.addressBar = this.addressBar;
                            newEvent3.menuBar = this.menuBar;
                            newEvent3.statusBar = this.statusBar;
                            newEvent3.toolBar = this.toolBar;
                            newEvent3.location = this.location;
                            newEvent3.size = this.size;
                            VisibilityWindowListener[] visibilityWindowListenerArray = this.visibilityWindowListeners;
                            int doit2 = this.visibilityWindowListeners.length;
                            int pVarResult22 = 0;
                            while (pVarResult22 < doit2) {
                                VisibilityWindowListener visibilityWindowListener = visibilityWindowListenerArray[pVarResult22];
                                visibilityWindowListener.show(newEvent3);
                                ++pVarResult22;
                            }
                            this.location = null;
                            this.size = null;
                            break;
                        }
                        VisibilityWindowListener[] visibilityWindowListenerArray = this.visibilityWindowListeners;
                        int doit2 = this.visibilityWindowListeners.length;
                        int pVarResult22 = 0;
                        while (pVarResult22 < doit2) {
                            VisibilityWindowListener visibilityWindowListener = visibilityWindowListenerArray[pVarResult22];
                            visibilityWindowListener.hide(newEvent3);
                            ++pVarResult22;
                        }
                        break;
                    }
                    case 108: {
                        if (this.performingInitialNavigate) break;
                        Variant arg12 = event.arguments[0];
                        int nProgress = arg12.getType() != 3 ? 0 : arg12.getInt();
                        Variant arg2 = event.arguments[1];
                        int nProgressMax = arg2.getType() != 3 ? 0 : arg2.getInt();
                        ProgressEvent newEvent4 = new ProgressEvent(this.browser);
                        newEvent4.display = this.browser.getDisplay();
                        newEvent4.widget = this.browser;
                        newEvent4.current = nProgress;
                        newEvent4.total = nProgressMax;
                        if (nProgress == -1) break;
                        ProgressListener[] progressListenerArray = this.progressListeners;
                        int n = this.progressListeners.length;
                        int n4 = 0;
                        while (n4 < n) {
                            ProgressListener progressListener = progressListenerArray[n4];
                            progressListener.changed(newEvent4);
                            ++n4;
                        }
                        break;
                    }
                    case 102: {
                        Variant arg13;
                        if (this.performingInitialNavigate || (arg13 = event.arguments[0]).getType() != 8) break;
                        String text = arg13.getString();
                        StatusTextEvent newEvent5 = new StatusTextEvent(this.browser);
                        newEvent5.display = this.browser.getDisplay();
                        newEvent5.widget = this.browser;
                        newEvent5.text = text;
                        StatusTextListener[] statusTextListenerArray = this.statusTextListeners;
                        int n = this.statusTextListeners.length;
                        int newEvent4 = 0;
                        while (newEvent4 < n) {
                            StatusTextListener statusTextListener = statusTextListenerArray[newEvent4];
                            statusTextListener.changed(newEvent5);
                            ++newEvent4;
                        }
                        break;
                    }
                    case 113: {
                        Variant arg14;
                        if (this.performingInitialNavigate || (arg14 = event.arguments[0]).getType() != 8) break;
                        String title = arg14.getString();
                        TitleEvent newEvent6 = new TitleEvent(this.browser);
                        newEvent6.display = this.browser.getDisplay();
                        newEvent6.widget = this.browser;
                        newEvent6.title = title;
                        TitleListener[] titleListenerArray = this.titleListeners;
                        int n = this.titleListeners.length;
                        int newEvent4 = 0;
                        while (newEvent4 < n) {
                            TitleListener titleListener = titleListenerArray[newEvent4];
                            titleListener.changed(newEvent6);
                            ++newEvent4;
                        }
                        break;
                    }
                    case 263: {
                        this.browser.getDisplay().asyncExec(() -> {
                            if (this.browser.isDisposed()) {
                                return;
                            }
                            WindowEvent newEvent = new WindowEvent(this.browser);
                            newEvent.display = this.browser.getDisplay();
                            newEvent.widget = this.browser;
                            CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
                            int n = this.closeWindowListeners.length;
                            int n2 = 0;
                            while (n2 < n) {
                                CloseWindowListener closeWindowListener = closeWindowListenerArray[n2];
                                closeWindowListener.close(newEvent);
                                ++n2;
                            }
                            this.browser.dispose();
                        });
                        Variant cancel6 = event.arguments[1];
                        long pCancel6 = cancel6.getByRef();
                        Variant arg15 = event.arguments[0];
                        boolean isChildWindow = arg15.getBoolean();
                        OS.MoveMemory(pCancel6, new short[]{isChildWindow ? (short)0 : (short)-1}, 2);
                        break;
                    }
                    case 267: {
                        if (this.size == null) {
                            this.size = new Point(0, 0);
                        }
                        Variant arg16 = event.arguments[0];
                        this.size.y = arg16.getInt();
                        break;
                    }
                    case 264: {
                        if (this.location == null) {
                            this.location = new Point(0, 0);
                        }
                        Variant arg17 = event.arguments[0];
                        this.location.x = arg17.getInt();
                        break;
                    }
                    case 265: {
                        if (this.location == null) {
                            this.location = new Point(0, 0);
                        }
                        Variant arg18 = event.arguments[0];
                        this.location.y = arg18.getInt();
                        break;
                    }
                    case 266: {
                        if (this.size == null) {
                            this.size = new Point(0, 0);
                        }
                        Variant arg19 = event.arguments[0];
                        this.size.x = arg19.getInt();
                    }
                }
            }
        };
        this.site.addEventListener(250, oleListener);
        this.site.addEventListener(105, oleListener);
        this.site.addEventListener(259, oleListener);
        this.site.addEventListener(104, oleListener);
        this.site.addEventListener(252, oleListener);
        this.site.addEventListener(271, oleListener);
        this.site.addEventListener(251, oleListener);
        this.site.addEventListener(256, oleListener);
        this.site.addEventListener(257, oleListener);
        this.site.addEventListener(255, oleListener);
        this.site.addEventListener(254, oleListener);
        this.site.addEventListener(108, oleListener);
        this.site.addEventListener(102, oleListener);
        this.site.addEventListener(113, oleListener);
        this.site.addEventListener(263, oleListener);
        this.site.addEventListener(267, oleListener);
        this.site.addEventListener(264, oleListener);
        this.site.addEventListener(265, oleListener);
        this.site.addEventListener(266, oleListener);
        Variant variant = new Variant(true);
        this.auto.setProperty(552, variant);
        variant.dispose();
        variant = new Variant(false);
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"RegisterAsDropTarget"});
        if (rgdispid != null) {
            this.auto.setProperty(rgdispid[0], variant);
        }
        variant.dispose();
    }

    @Override
    public boolean back() {
        if (!this.back) {
            return false;
        }
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"GoBack"});
        Variant pVarResult = this.auto.invoke(rgdispid[0]);
        return pVarResult != null && pVarResult.getType() == 0;
    }

    @Override
    public boolean close() {
        boolean result = true;
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{PROPERTY_DOCUMENT});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = this.auto.getProperty(dispIdMember);
        if (pVarResult == null || pVarResult.getType() == 0) {
            if (pVarResult != null) {
                pVarResult.dispose();
            }
        } else {
            OleAutomation document = pVarResult.getAutomation();
            pVarResult.dispose();
            rgdispid = document.getIDsOfNames(new String[]{"parentWindow"});
            if (rgdispid != null) {
                dispIdMember = rgdispid[0];
                pVarResult = document.getProperty(dispIdMember);
                if (pVarResult == null || pVarResult.getType() == 0) {
                    if (pVarResult != null) {
                        pVarResult.dispose();
                    }
                } else {
                    OleAutomation window = pVarResult.getAutomation();
                    pVarResult.dispose();
                    rgdispid = window.getIDsOfNames(new String[]{"location"});
                    dispIdMember = rgdispid[0];
                    pVarResult = window.getProperty(dispIdMember);
                    if (pVarResult == null || pVarResult.getType() == 0) {
                        if (pVarResult != null) {
                            pVarResult.dispose();
                        }
                    } else {
                        OleAutomation location = pVarResult.getAutomation();
                        pVarResult.dispose();
                        LocationListener[] oldListeners = this.locationListeners;
                        this.locationListeners = new LocationListener[0];
                        rgdispid = location.getIDsOfNames(new String[]{"replace"});
                        dispIdMember = rgdispid[0];
                        Variant[] args = new Variant[]{new Variant(ABOUT_BLANK)};
                        pVarResult = location.invoke(dispIdMember, args);
                        if (pVarResult == null) {
                            result = false;
                        } else {
                            pVarResult.dispose();
                        }
                        args[0].dispose();
                        this.locationListeners = oldListeners;
                        location.dispose();
                    }
                    window.dispose();
                }
            }
            document.dispose();
        }
        return result;
    }

    static Variant createSafeArray(String string) {
        SAFEARRAYBOUND safeArrayBound;
        byte[] bytes = string.getBytes();
        int length = bytes.length;
        long pvData = OS.GlobalAlloc(64, length);
        C.memmove(pvData, bytes, (long)length);
        int cElements1 = length;
        long pSafeArray = OS.GlobalAlloc(64, SAFEARRAY.sizeof);
        SAFEARRAY safeArray = new SAFEARRAY();
        safeArray.cDims = 1;
        safeArray.fFeatures = (short)16;
        safeArray.cbElements = 1;
        safeArray.pvData = pvData;
        safeArray.rgsabound = safeArrayBound = new SAFEARRAYBOUND();
        safeArrayBound.cElements = cElements1;
        OS.MoveMemory(pSafeArray, safeArray, SAFEARRAY.sizeof);
        long pVariant = OS.GlobalAlloc(64, Variant.sizeof);
        short vt = 8209;
        OS.MoveMemory(pVariant, new short[]{vt}, 2);
        OS.MoveMemory(pVariant + 8L, new long[]{pSafeArray}, C.PTR_SIZEOF);
        return new Variant(pVariant, 16396);
    }

    @Override
    public boolean execute(String script) {
        int[] rgdispid;
        int dispIdMember;
        Variant pVarResult;
        if (!this.performingInitialNavigate && this._getUrl().length() == 0) {
            this.performingInitialNavigate = true;
            this.navigate(ABOUT_BLANK, null, null, true);
        }
        if ((pVarResult = this.auto.getProperty(dispIdMember = (rgdispid = this.auto.getIDsOfNames(new String[]{PROPERTY_DOCUMENT}))[0])) == null || pVarResult.getType() == 0) {
            if (pVarResult != null) {
                pVarResult.dispose();
            }
            return false;
        }
        OleAutomation document = pVarResult.getAutomation();
        pVarResult.dispose();
        rgdispid = document.getIDsOfNames(new String[]{"parentWindow"});
        if (rgdispid == null) {
            document.dispose();
            return false;
        }
        dispIdMember = rgdispid[0];
        pVarResult = document.getProperty(dispIdMember);
        if (pVarResult == null || pVarResult.getType() == 0) {
            if (pVarResult != null) {
                pVarResult.dispose();
            }
            document.dispose();
            return false;
        }
        OleAutomation ihtmlWindow2 = pVarResult.getAutomation();
        pVarResult.dispose();
        document.dispose();
        rgdispid = ihtmlWindow2.getIDsOfNames(new String[]{"execScript", "code"});
        if (rgdispid == null) {
            ihtmlWindow2.dispose();
            return false;
        }
        Variant[] rgvarg = new Variant[]{new Variant(script)};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        pVarResult = ihtmlWindow2.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
        rgvarg[0].dispose();
        ihtmlWindow2.dispose();
        if (pVarResult == null) {
            return false;
        }
        pVarResult.dispose();
        return true;
    }

    @Override
    public boolean forward() {
        if (!this.forward) {
            return false;
        }
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"GoForward"});
        Variant pVarResult = this.auto.invoke(rgdispid[0]);
        return pVarResult != null && pVarResult.getType() == 0;
    }

    @Override
    public String getBrowserType() {
        return "ie";
    }

    @Override
    String getDeleteFunctionString(String functionName) {
        return "window." + functionName + "=undefined";
    }

    @Override
    public String getText() {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{PROPERTY_DOCUMENT});
        Variant pVarResult = this.auto.getProperty(rgdispid[0]);
        if (pVarResult == null || pVarResult.getType() == 0) {
            if (pVarResult != null) {
                pVarResult.dispose();
            }
            return "";
        }
        OleAutomation document = pVarResult.getAutomation();
        pVarResult.dispose();
        rgdispid = document.getIDsOfNames(new String[]{"documentElement"});
        if (rgdispid == null) {
            document.dispose();
            return "";
        }
        pVarResult = document.getProperty(rgdispid[0]);
        document.dispose();
        if (pVarResult == null || pVarResult.getType() == 0 || pVarResult.getType() == 1) {
            if (pVarResult != null) {
                pVarResult.dispose();
            }
            return "";
        }
        OleAutomation element = pVarResult.getAutomation();
        pVarResult.dispose();
        rgdispid = element.getIDsOfNames(new String[]{"outerHTML"});
        pVarResult = element.getProperty(rgdispid[0]);
        element.dispose();
        if (pVarResult == null || pVarResult.getType() == 0) {
            if (pVarResult != null) {
                pVarResult.dispose();
            }
            return "";
        }
        String result = pVarResult.getString();
        pVarResult.dispose();
        return result;
    }

    @Override
    public String getUrl() {
        String result = this._getUrl();
        return result.length() != 0 ? result : ABOUT_BLANK;
    }

    String _getUrl() {
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"LocationURL"});
        Variant pVarResult = this.auto.getProperty(rgdispid[0]);
        if (pVarResult == null || pVarResult.getType() != 8) {
            return "";
        }
        String result = pVarResult.getString();
        pVarResult.dispose();
        return result;
    }

    @Override
    public boolean isBackEnabled() {
        return this.back;
    }

    @Override
    public boolean isForwardEnabled() {
        return this.forward;
    }

    @Override
    public boolean isFocusControl() {
        return this.site.isFocusControl() || this.frame.isFocusControl();
    }

    boolean navigate(String url, String postData, String[] headers, boolean silent) {
        int count = 1;
        if (postData != null) {
            ++count;
        }
        if (headers != null) {
            ++count;
        }
        Variant[] rgvarg = new Variant[count];
        int[] rgdispidNamedArgs = new int[count];
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Navigate", "URL", "PostData", "Headers"});
        int index = 0;
        rgvarg[index] = new Variant(url);
        rgdispidNamedArgs[index++] = rgdispid[1];
        if (postData != null) {
            rgvarg[index] = IE.createSafeArray(postData);
            rgdispidNamedArgs[index++] = rgdispid[2];
        }
        if (headers != null) {
            StringBuilder buffer = new StringBuilder();
            String[] stringArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                int sep;
                String current = stringArray[n2];
                if (current != null && (sep = current.indexOf(58)) != -1) {
                    String key = current.substring(0, sep).trim();
                    String value = current.substring(sep + 1).trim();
                    if (key.length() > 0 && value.length() > 0) {
                        buffer.append(key);
                        buffer.append(':');
                        buffer.append(value);
                        buffer.append("\r\n");
                    }
                }
                ++n2;
            }
            rgvarg[index] = new Variant(buffer.toString());
            rgdispidNamedArgs[index++] = rgdispid[3];
        }
        boolean oldValue = false;
        if (silent && IEVersion >= 7) {
            int hResult = OS.CoInternetIsFeatureEnabled(21, 2);
            oldValue = hResult == 0;
            OS.CoInternetSetFeatureEnabled(21, 2, true);
        }
        Variant pVarResult = this.auto.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
        if (silent && IEVersion >= 7) {
            OS.CoInternetSetFeatureEnabled(21, 2, oldValue);
        }
        int i = 0;
        while (i < count) {
            rgvarg[i].dispose();
            ++i;
        }
        if (pVarResult == null) {
            return false;
        }
        boolean result = pVarResult.getType() == 0;
        pVarResult.dispose();
        return result;
    }

    @Override
    public void refresh() {
        String extension;
        this.uncRedirect = null;
        String url = this._getUrl();
        int extensionIndex = url.lastIndexOf(46);
        if (extensionIndex != -1 && (extension = url.substring(extensionIndex)).equalsIgnoreCase(EXTENSION_PDF) && ++PDFCount > 20) {
            COM.FreeUnusedLibraries = false;
        }
        this.isRefresh = true;
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Refresh"});
        this.auto.invoke(rgdispid[0]);
    }

    void setHTML(String string) {
        int charCount = string.length();
        char[] chars = new char[charCount];
        string.getChars(0, charCount, chars, 0);
        int byteCount = OS.WideCharToMultiByte(65001, 0, chars, charCount, null, 0, null, null);
        byte[] UTF8BOM = new byte[]{-17, -69, -65};
        long hGlobal = OS.GlobalAlloc(64, UTF8BOM.length + byteCount);
        if (hGlobal != 0L) {
            OS.MoveMemory(hGlobal, UTF8BOM, UTF8BOM.length);
            OS.WideCharToMultiByte(65001, 0, chars, charCount, hGlobal + (long)UTF8BOM.length, byteCount, null, null);
            long[] ppstm = new long[1];
            if (OS.CreateStreamOnHGlobal(hGlobal, true, ppstm) == 0) {
                long[] ppvObject;
                int[] rgdispid = this.auto.getIDsOfNames(new String[]{PROPERTY_DOCUMENT});
                Variant pVarResult = this.auto.getProperty(rgdispid[0]);
                IDispatch dispatchDocument = pVarResult.getDispatch();
                int result = dispatchDocument.QueryInterface(COM.IIDIPersistStreamInit, ppvObject = new long[1]);
                if (result == 0) {
                    IPersistStreamInit persistStreamInit = new IPersistStreamInit(ppvObject[0]);
                    if (persistStreamInit.InitNew() == 0) {
                        persistStreamInit.Load(ppstm[0]);
                    }
                    persistStreamInit.Release();
                }
                pVarResult.dispose();
                IUnknown stream = new IUnknown(ppstm[0]);
                stream.Release();
            } else {
                OS.GlobalFree(hGlobal);
            }
        }
    }

    private void setAboutBlank(boolean value) {
        this.isAboutBlank = value;
        this.updateForceTrusted();
    }

    private void setUntrustedText(boolean value) {
        this.untrustedText = value;
        this.updateForceTrusted();
    }

    private void updateForceTrusted() {
        this.site.isForceTrusted = this.isAboutBlank && !this.untrustedText;
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        int[] rgdispid;
        if (this.performingInitialNavigate) {
            this.pendingText = new Object[]{html, trusted};
            this.pendingUrl = null;
            return true;
        }
        boolean blankLoading = this.html != null;
        this.html = html;
        this.setUntrustedText(!trusted);
        if (blankLoading) {
            return true;
        }
        if (this._getUrl().length() != 0) {
            rgdispid = this.auto.getIDsOfNames(new String[]{"ReadyState"});
            Variant pVarResult = this.auto.getProperty(rgdispid[0]);
            if (pVarResult == null) {
                return false;
            }
            this.delaySetText = pVarResult.getInt() != 4;
            pVarResult.dispose();
            rgdispid = this.auto.getIDsOfNames(new String[]{"Stop"});
            this.auto.invoke(rgdispid[0]);
        }
        rgdispid = this.auto.getIDsOfNames(new String[]{"Navigate", "URL"});
        Variant[] rgvarg = new Variant[]{new Variant(ABOUT_BLANK)};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        boolean oldValue = false;
        if (IEVersion >= 7) {
            int hResult = OS.CoInternetIsFeatureEnabled(21, 2);
            oldValue = hResult == 0;
            OS.CoInternetSetFeatureEnabled(21, 2, true);
        }
        Variant pVarResult = this.auto.invoke(rgdispid[0], rgvarg, rgdispidNamedArgs);
        if (IEVersion >= 7) {
            OS.CoInternetSetFeatureEnabled(21, 2, oldValue);
        }
        rgvarg[0].dispose();
        if (pVarResult == null) {
            return false;
        }
        boolean result = pVarResult.getType() == 0;
        pVarResult.dispose();
        return result;
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        this.uncRedirect = null;
        this.html = null;
        if (this._getUrl().length() == 0 && !ABOUT_BLANK.equalsIgnoreCase(url)) {
            this.pendingText = null;
            this.pendingUrl = new Object[]{url, postData, headers};
            this.performingInitialNavigate = true;
            this.navigate(ABOUT_BLANK, null, null, true);
            return true;
        }
        if (url.endsWith(".xml")) {
            int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Stop"});
            this.auto.invoke(rgdispid[0]);
        }
        return this.navigate(url, postData, headers, false);
    }

    @Override
    public void stop() {
        if (this.performingInitialNavigate) {
            this.pendingUrl = null;
            this.pendingText = null;
            return;
        }
        if (this._getUrl().length() == 0) {
            return;
        }
        this.setAboutBlank(this.getUrl().startsWith(ABOUT_BLANK));
        this.uncRedirect = null;
        int[] rgdispid = this.auto.getIDsOfNames(new String[]{"Stop"});
        this.auto.invoke(rgdispid[0]);
    }

    @Override
    boolean translateMnemonics() {
        return false;
    }

    void handleDOMEvent(OleEvent e) {
        boolean isInternal;
        if (e.arguments == null || e.arguments.length == 0) {
            return;
        }
        Variant arg = e.arguments[0];
        OleAutomation event = arg.getAutomation();
        int[] rgdispid = event.getIDsOfNames(new String[]{PROPERTY_TYPE});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = event.getProperty(dispIdMember);
        String eventType = pVarResult.getString();
        pVarResult.dispose();
        if (eventType.equals(EVENT_KEYDOWN)) {
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_KEYCODE});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            this.lastKeyCode = this.translateKey(pVarResult.getInt());
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_RETURNVALUE});
            pVarResult = event.getProperty(rgdispid[0]);
            boolean consume = pVarResult != null && pVarResult.getType() == 11 && !pVarResult.getBoolean();
            pVarResult.dispose();
            MSG msg = new MSG();
            int flags = 2 | (consume ? 1 : 0);
            if (OS.PeekMessage(msg, this.frame.handle, 258, 258, flags)) {
                event.dispose();
                return;
            }
            if (consume) {
                event.dispose();
                return;
            }
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_REPEAT});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            boolean repeating = pVarResult.getBoolean();
            pVarResult.dispose();
            if (repeating) {
                event.dispose();
                return;
            }
            int mask = 0;
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_ALTKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x10000;
            }
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_CTRLKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x40000;
            }
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_SHIFTKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x20000;
            }
            pVarResult.dispose();
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 1;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.stateMask = mask;
            keyEvent.stateMask &= ~this.lastKeyCode;
            switch (this.lastKeyCode) {
                case 8: {
                    keyEvent.character = (char)8;
                    this.lastCharCode = 8;
                    break;
                }
                case 13: {
                    keyEvent.character = (char)13;
                    this.lastCharCode = 13;
                    break;
                }
                case 127: {
                    keyEvent.character = (char)127;
                    this.lastCharCode = 127;
                    break;
                }
                case 9: {
                    keyEvent.character = (char)9;
                    this.lastCharCode = 9;
                }
            }
            if (!this.sendKeyEvent(keyEvent)) {
                rgdispid = event.getIDsOfNames(new String[]{PROPERTY_RETURNVALUE});
                dispIdMember = rgdispid[0];
                Variant pVarFalse = new Variant(false);
                event.setProperty(dispIdMember, pVarFalse);
                pVarFalse.dispose();
            }
            if (this.lastKeyCode == 0x100000E) {
                this.isRefresh = true;
            }
            event.dispose();
            return;
        }
        if (eventType.equals(EVENT_KEYPRESS)) {
            int mask = 0;
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_CTRLKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x40000;
            }
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_SHIFTKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x20000;
            }
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_ALTKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x10000;
            }
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_KEYCODE});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            this.lastCharCode = pVarResult.getInt();
            pVarResult.dispose();
            if (this.lastCharCode == 13 || this.lastCharCode == 10) {
                event.dispose();
                return;
            }
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 1;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = mask;
            if (!this.sendKeyEvent(keyEvent)) {
                rgdispid = event.getIDsOfNames(new String[]{PROPERTY_RETURNVALUE});
                dispIdMember = rgdispid[0];
                Variant pVarFalse = new Variant(false);
                event.setProperty(dispIdMember, pVarFalse);
                pVarFalse.dispose();
            }
            event.dispose();
            return;
        }
        if (eventType.equals(EVENT_KEYUP)) {
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_KEYCODE});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            int keyCode = this.translateKey(pVarResult.getInt());
            pVarResult.dispose();
            if (keyCode == 0) {
                this.lastCharCode = 0;
                this.lastKeyCode = 0;
                event.dispose();
                return;
            }
            if (keyCode != this.lastKeyCode) {
                this.lastKeyCode = keyCode;
                this.lastCharCode = 0;
            }
            int mask = 0;
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_CTRLKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x40000;
            }
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_ALTKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x10000;
            }
            pVarResult.dispose();
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_SHIFTKEY});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            if (pVarResult.getBoolean()) {
                mask |= 0x20000;
            }
            pVarResult.dispose();
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = 2;
            keyEvent.keyCode = this.lastKeyCode;
            keyEvent.character = (char)this.lastCharCode;
            keyEvent.stateMask = mask;
            switch (this.lastKeyCode) {
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: {
                    keyEvent.stateMask |= this.lastKeyCode;
                }
            }
            this.browser.notifyListeners(keyEvent.type, keyEvent);
            if (!keyEvent.doit) {
                rgdispid = event.getIDsOfNames(new String[]{PROPERTY_RETURNVALUE});
                dispIdMember = rgdispid[0];
                Variant pVarFalse = new Variant(false);
                event.setProperty(dispIdMember, pVarFalse);
                pVarFalse.dispose();
            }
            this.lastCharCode = 0;
            this.lastKeyCode = 0;
            event.dispose();
            return;
        }
        if (eventType.equals(EVENT_MOUSEOVER)) {
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_FROMELEMENT});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            isInternal = pVarResult.getType() != 0;
            pVarResult.dispose();
            if (isInternal) {
                event.dispose();
                return;
            }
        }
        if (eventType.equals(EVENT_MOUSEOUT)) {
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_TOELEMENT});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            isInternal = pVarResult.getType() != 0;
            pVarResult.dispose();
            if (isInternal) {
                event.dispose();
                return;
            }
        }
        int mask = 0;
        Event newEvent = new Event();
        newEvent.widget = this.browser;
        rgdispid = event.getIDsOfNames(new String[]{PROPERTY_SCREENX});
        dispIdMember = rgdispid[0];
        pVarResult = event.getProperty(dispIdMember);
        int screenX = pVarResult.getInt();
        pVarResult.dispose();
        rgdispid = event.getIDsOfNames(new String[]{PROPERTY_SCREENY});
        dispIdMember = rgdispid[0];
        pVarResult = event.getProperty(dispIdMember);
        int screenY = pVarResult.getInt();
        pVarResult.dispose();
        Point position = DPIUtil.autoScaleDown(new Point(screenX, screenY));
        position = this.browser.getDisplay().map(null, (Control)this.browser, position);
        newEvent.x = position.x;
        newEvent.y = position.y;
        rgdispid = event.getIDsOfNames(new String[]{PROPERTY_CTRLKEY});
        dispIdMember = rgdispid[0];
        pVarResult = event.getProperty(dispIdMember);
        if (pVarResult.getBoolean()) {
            mask |= 0x40000;
        }
        pVarResult.dispose();
        rgdispid = event.getIDsOfNames(new String[]{PROPERTY_ALTKEY});
        dispIdMember = rgdispid[0];
        pVarResult = event.getProperty(dispIdMember);
        if (pVarResult.getBoolean()) {
            mask |= 0x10000;
        }
        pVarResult.dispose();
        rgdispid = event.getIDsOfNames(new String[]{PROPERTY_SHIFTKEY});
        dispIdMember = rgdispid[0];
        pVarResult = event.getProperty(dispIdMember);
        if (pVarResult.getBoolean()) {
            mask |= 0x20000;
        }
        pVarResult.dispose();
        newEvent.stateMask = mask;
        rgdispid = event.getIDsOfNames(new String[]{PROPERTY_BUTTON});
        dispIdMember = rgdispid[0];
        pVarResult = event.getProperty(dispIdMember);
        int button = pVarResult.getInt();
        pVarResult.dispose();
        switch (button) {
            case 1: {
                button = 1;
                break;
            }
            case 2: {
                button = 3;
                break;
            }
            case 4: {
                button = 2;
            }
        }
        if (eventType.equals(EVENT_MOUSEDOWN)) {
            newEvent.type = 3;
            newEvent.button = button;
            newEvent.count = 1;
        } else if (eventType.equals(EVENT_MOUSEUP) || eventType.equals(EVENT_DRAGEND)) {
            newEvent.type = 4;
            newEvent.button = button != 0 ? button : 1;
            newEvent.count = 1;
            switch (newEvent.button) {
                case 1: {
                    newEvent.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    newEvent.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    newEvent.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    newEvent.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    newEvent.stateMask |= 0x2000000;
                }
            }
        } else if (eventType.equals(EVENT_MOUSEWHEEL)) {
            newEvent.type = 37;
            rgdispid = event.getIDsOfNames(new String[]{PROPERTY_WHEELDELTA});
            dispIdMember = rgdispid[0];
            pVarResult = event.getProperty(dispIdMember);
            newEvent.count = pVarResult.getInt() / 120 * 3;
            pVarResult.dispose();
        } else if (eventType.equals(EVENT_MOUSEMOVE)) {
            if (newEvent.x == this.lastMouseMoveX && newEvent.y == this.lastMouseMoveY) {
                event.dispose();
                return;
            }
            newEvent.type = 5;
            this.lastMouseMoveX = newEvent.x;
            this.lastMouseMoveY = newEvent.y;
        } else if (eventType.equals(EVENT_MOUSEOVER)) {
            newEvent.type = 6;
        } else if (eventType.equals(EVENT_MOUSEOUT)) {
            newEvent.type = 7;
        } else if (eventType.equals(EVENT_DRAGSTART)) {
            newEvent.type = 29;
            newEvent.button = 1;
            newEvent.stateMask |= 0x80000;
        }
        event.dispose();
        this.browser.notifyListeners(newEvent.type, newEvent);
        if (eventType.equals(EVENT_DOUBLECLICK)) {
            newEvent = new Event();
            newEvent.widget = this.browser;
            newEvent.type = 8;
            newEvent.x = position.x;
            newEvent.y = position.y;
            newEvent.stateMask = mask;
            newEvent.type = 8;
            newEvent.button = 1;
            newEvent.count = 2;
            this.browser.notifyListeners(newEvent.type, newEvent);
        }
    }

    void hookDOMListeners(OleAutomation webBrowser, boolean isTop) {
        int[] rgdispid = webBrowser.getIDsOfNames(new String[]{PROPERTY_DOCUMENT});
        int dispIdMember = rgdispid[0];
        Variant pVarResult = webBrowser.getProperty(dispIdMember);
        if (pVarResult == null) {
            return;
        }
        if (pVarResult.getType() == 0) {
            pVarResult.dispose();
            return;
        }
        OleAutomation document = pVarResult.getAutomation();
        pVarResult.dispose();
        this.unhookDOMListeners(new OleAutomation[]{document});
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -602, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -603, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -604, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -605, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -607, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", 1033, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -601, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -606, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -2147418101, this.domListener);
        this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -2147418091, this.domListener);
        if (isTop) {
            this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -2147418104, this.domListener);
            this.site.addEventListener(document, "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}", -2147418103, this.domListener);
        }
        OleAutomation[] newDocuments = new OleAutomation[this.documents.length + 1];
        System.arraycopy(this.documents, 0, newDocuments, 0, this.documents.length);
        newDocuments[this.documents.length] = document;
        this.documents = newDocuments;
    }

    void unhookDOMListeners(OleAutomation[] documents) {
        GUID guid;
        char[] buffer = "{3050F613-98B5-11CF-BB82-00AA00BDCE0B}\u0000".toCharArray();
        if (COM.IIDFromString(buffer, guid = new GUID()) == 0) {
            OleAutomation[] oleAutomationArray = documents;
            int n = documents.length;
            int n2 = 0;
            while (n2 < n) {
                OleAutomation document = oleAutomationArray[n2];
                this.site.removeEventListener(document, guid, -602, this.domListener);
                this.site.removeEventListener(document, guid, -603, this.domListener);
                this.site.removeEventListener(document, guid, -604, this.domListener);
                this.site.removeEventListener(document, guid, -605, this.domListener);
                this.site.removeEventListener(document, guid, -607, this.domListener);
                this.site.removeEventListener(document, guid, 1033, this.domListener);
                this.site.removeEventListener(document, guid, -601, this.domListener);
                this.site.removeEventListener(document, guid, -606, this.domListener);
                this.site.removeEventListener(document, guid, -2147418101, this.domListener);
                this.site.removeEventListener(document, guid, -2147418091, this.domListener);
                this.site.removeEventListener(document, guid, -2147418104, this.domListener);
                this.site.removeEventListener(document, guid, -2147418103, this.domListener);
                ++n2;
            }
        }
    }
}

