/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui;

import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class WorkbenchEncoding {
    private static String defaultEncoding;

    public static String getWorkbenchDefaultEncoding() {
        if (defaultEncoding == null) {
            String encoding = null;
            List<String> commandLineArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : commandLineArgs) {
                if (!arg.startsWith("-Dfile.encoding=")) continue;
                encoding = arg.substring("-Dfile.encoding=".length());
            }
            if (encoding == null || encoding.isBlank()) {
                encoding = Platform.getSystemCharset().name();
            }
            defaultEncoding = encoding;
        }
        return defaultEncoding;
    }

    public static List<String> getDefinedEncodings() {
        List<String> definedEncodings = Collections.synchronizedList(new ArrayList());
        EncodingsRegistryReader reader = new EncodingsRegistryReader(definedEncodings);
        reader.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.ui", "encodings");
        String[] encodings = new String[definedEncodings.size()];
        ArrayList<String> invalid = new ArrayList<String>();
        definedEncodings.toArray(encodings);
        String[] stringArray = encodings;
        int n = encodings.length;
        int n2 = 0;
        while (n2 < n) {
            String encoding = stringArray[n2];
            try {
                if (!Charset.isSupported(encoding)) {
                    invalid.add(encoding);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                invalid.add(encoding);
            }
            ++n2;
        }
        for (String next : invalid) {
            WorkbenchPlugin.log(NLS.bind((String)WorkbenchMessages.WorkbenchEncoding_invalidCharset, (Object)next));
            definedEncodings.remove(next);
        }
        return definedEncodings;
    }

    private static class EncodingsRegistryReader
    extends RegistryReader {
        private List<String> encodings;

        public EncodingsRegistryReader(List<String> definedEncodings) {
            this.encodings = definedEncodings;
        }

        @Override
        protected boolean readElement(IConfigurationElement element) {
            String name = element.getAttribute("name");
            if (name != null) {
                this.encodings.add(name);
            }
            return true;
        }
    }
}

