/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import org.bouncycastle.pqc.legacy.crypto.sike.PointProj;
import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Fpx {
    private SIKEEngine engine;

    Fpx(SIKEEngine sIKEEngine) {
        this.engine = sIKEEngine;
    }

    private void mp_shiftl1(long[] lArray, int n) {
        for (int i = n - 1; i > 0; --i) {
            lArray[i] = lArray[i] << 1 ^ lArray[i - 1] >>> 63;
        }
        lArray[0] = lArray[0] << 1;
    }

    protected void sqr_Fp2_cycl(long[][] lArray, long[] lArray2) {
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        this.fpaddPRIME(lArray[0], lArray[1], lArray3);
        this.fpsqr_mont(lArray3, lArray3);
        this.fpsubPRIME(lArray3, lArray2, lArray[1]);
        this.fpsqr_mont(lArray[0], lArray3);
        this.fpaddPRIME(lArray3, lArray3, lArray3);
        this.fpsubPRIME(lArray3, lArray2, lArray[0]);
    }

    protected void mont_n_way_inv(long[][][] lArray, int n, long[][][] lArray2) {
        int n2;
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        this.fp2copy(lArray[0], lArray2[0]);
        for (n2 = 1; n2 < n; ++n2) {
            this.fp2mul_mont(lArray2[n2 - 1], lArray[n2], lArray2[n2]);
        }
        this.fp2copy(lArray2[n - 1], lArray3);
        this.fp2inv_mont_bingcd(lArray3);
        for (n2 = n - 1; n2 >= 1; --n2) {
            this.fp2mul_mont(lArray2[n2 - 1], lArray3, lArray2[n2]);
            this.fp2mul_mont(lArray3, lArray[n2], lArray3);
        }
        this.fp2copy(lArray3, lArray2[0]);
    }

    protected void fpcopy(long[] lArray, int n, long[] lArray2) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            lArray2[i] = lArray[i + n];
        }
    }

    protected void mp2_add(long[][] lArray, long[][] lArray2, long[][] lArray3) {
        this.mp_add(lArray[0], lArray2[0], lArray3[0], this.engine.params.NWORDS_FIELD);
        this.mp_add(lArray[1], lArray2[1], lArray3[1], this.engine.params.NWORDS_FIELD);
    }

    protected void fp2correction(long[][] lArray) {
        this.fpcorrectionPRIME(lArray[0]);
        this.fpcorrectionPRIME(lArray[1]);
    }

    protected int mp_add(long[] lArray, long[] lArray2, long[] lArray3, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i] + (long)n2;
            lArray3[i] = lArray2[i] + l;
            n2 = this.is_digit_lessthan_ct(l, n2) | this.is_digit_lessthan_ct(lArray3[i], l);
        }
        return n2;
    }

    private int mp_add(long[] lArray, int n, long[] lArray2, long[] lArray3, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            long l = lArray[i + n] + (long)n4;
            lArray3[i + n2] = lArray2[i] + l;
            n4 = this.is_digit_lessthan_ct(l, n4) | this.is_digit_lessthan_ct(lArray3[i + n2], l);
        }
        return n4;
    }

    private int mp_add(long[] lArray, int n, long[] lArray2, int n2, long[] lArray3, int n3, int n4) {
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            long l = lArray[i + n] + (long)n5;
            lArray3[i + n3] = lArray2[i + n2] + l;
            n5 = this.is_digit_lessthan_ct(l, n5) | this.is_digit_lessthan_ct(lArray3[i + n3], l);
        }
        return n5;
    }

    private int is_digit_lessthan_ct(long l, long l2) {
        return (int)((l ^ (l ^ l2 | l - l2 ^ l2)) >>> 63);
    }

    private int is_digit_nonzero_ct(long l) {
        return (int)((l | 0L - l) >>> 63);
    }

    private int is_digit_zero_ct(long l) {
        return 1 ^ this.is_digit_nonzero_ct(l);
    }

    void fp2neg(long[][] lArray) {
        this.fpnegPRIME(lArray[0]);
        this.fpnegPRIME(lArray[1]);
    }

    protected boolean is_felm_zero(long[] lArray) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            if (lArray[i] == 0L) continue;
            return false;
        }
        return true;
    }

    private boolean is_felm_lt(long[] lArray, long[] lArray2) {
        for (int i = this.engine.params.NWORDS_FIELD - 1; i >= 0; --i) {
            if (lArray[i] + Long.MIN_VALUE < lArray2[i] + Long.MIN_VALUE) {
                return true;
            }
            if (lArray[i] + Long.MIN_VALUE <= lArray2[i] + Long.MIN_VALUE) continue;
            return false;
        }
        return false;
    }

    private static boolean is_felm_even(long[] lArray) {
        return (lArray[0] & 1L) == 0L;
    }

    protected boolean is_sqr_fp2(long[][] lArray, long[] lArray2) {
        int n;
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray6 = new long[this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(lArray[0], lArray3);
        this.fpsqr_mont(lArray[1], lArray4);
        this.fpaddPRIME(lArray3, lArray4, lArray5);
        this.fpcopy(lArray5, 0, lArray2);
        for (n = 0; n < this.engine.params.OALICE_BITS - 2; ++n) {
            this.fpsqr_mont(lArray2, lArray2);
        }
        for (n = 0; n < this.engine.params.OBOB_EXPON; ++n) {
            this.fpsqr_mont(lArray2, lArray6);
            this.fpmul_mont(lArray2, lArray6, lArray2);
        }
        this.fpsqr_mont(lArray2, lArray6);
        this.fpcorrectionPRIME(lArray6);
        this.fpcorrectionPRIME(lArray5);
        return Fpx.subarrayEquals(lArray6, lArray5, this.engine.params.NWORDS_FIELD);
    }

    private void fpinv_mont_bingcd_partial(long[] lArray, long[] lArray2, int[] nArray) {
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        this.fpcopy(lArray, 0, lArray3);
        this.fpcopy(this.engine.params.PRIME, 0, lArray4);
        this.fpzero(lArray2);
        lArray2[0] = 1L;
        this.fpzero(lArray5);
        nArray[0] = 0;
        while (!this.is_felm_zero(lArray4)) {
            int n = (nArray[0] + 1) / 64 + 1;
            if (n < this.engine.params.NWORDS_FIELD) {
                if (Fpx.is_felm_even(lArray4)) {
                    this.mp_shiftr1(lArray4);
                    this.mp_shiftl1(lArray2, n);
                } else if (Fpx.is_felm_even(lArray3)) {
                    this.mp_shiftr1(lArray3);
                    this.mp_shiftl1(lArray5, n);
                } else if (!this.is_felm_lt(lArray4, lArray3)) {
                    this.mp_sub(lArray4, lArray3, lArray4, this.engine.params.NWORDS_FIELD);
                    this.mp_shiftr1(lArray4);
                    this.mp_add(lArray2, lArray5, lArray5, n);
                    this.mp_shiftl1(lArray2, n);
                } else {
                    this.mp_sub(lArray3, lArray4, lArray3, this.engine.params.NWORDS_FIELD);
                    this.mp_shiftr1(lArray3);
                    this.mp_add(lArray2, lArray5, lArray2, n);
                    this.mp_shiftl1(lArray5, n);
                }
            } else if (Fpx.is_felm_even(lArray4)) {
                this.mp_shiftr1(lArray4);
                this.mp_shiftl1(lArray2, this.engine.params.NWORDS_FIELD);
            } else if (Fpx.is_felm_even(lArray3)) {
                this.mp_shiftr1(lArray3);
                this.mp_shiftl1(lArray5, this.engine.params.NWORDS_FIELD);
            } else if (!this.is_felm_lt(lArray4, lArray3)) {
                this.mp_sub(lArray4, lArray3, lArray4, this.engine.params.NWORDS_FIELD);
                this.mp_shiftr1(lArray4);
                this.mp_add(lArray2, lArray5, lArray5, this.engine.params.NWORDS_FIELD);
                this.mp_shiftl1(lArray2, this.engine.params.NWORDS_FIELD);
            } else {
                this.mp_sub(lArray3, lArray4, lArray3, this.engine.params.NWORDS_FIELD);
                this.mp_shiftr1(lArray3);
                this.mp_add(lArray2, lArray5, lArray2, this.engine.params.NWORDS_FIELD);
                this.mp_shiftl1(lArray5, this.engine.params.NWORDS_FIELD);
            }
            nArray[0] = nArray[0] + 1;
        }
        if (this.is_felm_lt(this.engine.params.PRIME, lArray2)) {
            this.mp_sub(lArray2, this.engine.params.PRIME, lArray2, this.engine.params.NWORDS_FIELD);
        }
    }

    private void power2_setup(long[] lArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            lArray[n3] = 0L;
        }
        n3 = 0;
        while (n >= 0) {
            if (n < 64) {
                lArray[n3] = 1L << n;
            }
            n -= 64;
            ++n3;
        }
    }

    private void fpinv_mont_bingcd(long[] lArray) {
        long[] lArray2 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        int[] nArray = new int[1];
        if (this.is_felm_zero(lArray)) {
            return;
        }
        this.fpinv_mont_bingcd_partial(lArray, lArray2, nArray);
        if (nArray[0] <= this.engine.params.MAXBITS_FIELD) {
            this.fpmul_mont(lArray2, this.engine.params.Montgomery_R2, lArray2);
            nArray[0] = nArray[0] + this.engine.params.MAXBITS_FIELD;
        }
        this.fpmul_mont(lArray2, this.engine.params.Montgomery_R2, lArray2);
        this.power2_setup(lArray3, 2 * this.engine.params.MAXBITS_FIELD - nArray[0], this.engine.params.NWORDS_FIELD);
        this.fpmul_mont(lArray2, lArray3, lArray);
    }

    protected void fp2inv_mont_bingcd(long[][] lArray) {
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(lArray[0], lArray2[0]);
        this.fpsqr_mont(lArray[1], lArray2[1]);
        this.fpaddPRIME(lArray2[0], lArray2[1], lArray2[0]);
        this.fpinv_mont_bingcd(lArray2[0]);
        this.fpnegPRIME(lArray[1]);
        this.fpmul_mont(lArray[0], lArray2[0], lArray[0]);
        this.fpmul_mont(lArray[1], lArray2[0], lArray[1]);
    }

    protected void fp2div2(long[][] lArray, long[][] lArray2) {
        this.fpdiv2_PRIME(lArray[0], lArray2[0]);
        this.fpdiv2_PRIME(lArray[1], lArray2[1]);
    }

    private void fpdiv2_PRIME(long[] lArray, long[] lArray2) {
        int n = 0;
        long l = 0L - (lArray[0] & 1L);
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            long l2 = lArray[i] + (long)n;
            lArray2[i] = (this.engine.params.PRIME[i] & l) + l2;
            n = this.is_digit_lessthan_ct(l2, n) | this.is_digit_lessthan_ct(lArray2[i], l2);
        }
        this.mp_shiftr1(lArray2);
    }

    private void mp_subPRIME_p2(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        int n;
        int n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray[n] - lArray2[n];
            int n3 = this.is_digit_lessthan_ct(lArray[n], lArray2[n]) | n2 & this.is_digit_zero_ct(l);
            lArray3[n] = l - (long)n2;
            n2 = n3;
        }
        n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray3[n] + (long)n2;
            lArray3[n] = this.engine.params.PRIMEx2[n] + l;
            n2 = this.is_digit_lessthan_ct(l, n2) | this.is_digit_lessthan_ct(lArray3[n], l);
        }
    }

    private void mp_subPRIME_p4(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        int n;
        int n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray[n] - lArray2[n];
            int n3 = this.is_digit_lessthan_ct(lArray[n], lArray2[n]) | n2 & this.is_digit_zero_ct(l);
            lArray3[n] = l - (long)n2;
            n2 = n3;
        }
        n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray3[n] + (long)n2;
            lArray3[n] = this.engine.params.PRIMEx4[n] + l;
            n2 = this.is_digit_lessthan_ct(l, n2) | this.is_digit_lessthan_ct(lArray3[n], l);
        }
    }

    private void digit_x_digit(long l, long l2, long[] lArray) {
        long l3 = 0xFFFFFFFFL;
        long l4 = -4294967296L;
        long l5 = l & l3;
        long l6 = l >>> 32;
        long l7 = l2 & l3;
        long l8 = l2 >>> 32;
        long l9 = l5 * l7;
        long l10 = l5 * l8;
        long l11 = l6 * l7;
        long l12 = l6 * l8;
        lArray[0] = l9 & l3;
        long l13 = l9 >>> 32;
        long l14 = l11 & l3;
        long l15 = l10 & l3;
        long l16 = l13 + l14 + l15;
        long l17 = l16 >>> 32;
        lArray[0] = lArray[0] ^ l16 << 32;
        l13 = l11 >>> 32;
        l14 = l10 >>> 32;
        l15 = l12 & l3;
        l16 = l13 + l14 + l15 + l17;
        lArray[1] = l16 & l3;
        l17 = l16 & l4;
        lArray[1] = lArray[1] ^ (l12 & l4) + l17;
    }

    private void rdc_mont(long[] lArray, long[] lArray2) {
        int n;
        long l;
        long l2;
        int n2;
        int n3;
        int n4 = this.engine.params.PRIME_ZERO_WORDS;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long[] lArray3 = new long[2];
        for (n3 = 0; n3 < this.engine.params.NWORDS_FIELD; ++n3) {
            lArray2[n3] = 0L;
        }
        for (n3 = 0; n3 < this.engine.params.NWORDS_FIELD; ++n3) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (n2 >= n3 - this.engine.params.PRIME_ZERO_WORDS + 1) continue;
                this.digit_x_digit(lArray2[n2], this.engine.params.PRIMEp1[n3 - n2], lArray3);
                l2 = lArray3[0];
                l5 += l2;
                l2 = lArray3[1] + (long)this.is_digit_lessthan_ct(l5, l2);
                l3 += (long)this.is_digit_lessthan_ct(l4 += l2, l2);
            }
            l = lArray[n3];
            n = this.is_digit_lessthan_ct(l5 += l, l);
            l4 += (long)n;
            l3 += (long)(n &= this.is_digit_zero_ct(l4));
            lArray2[n3] = l5;
            l5 = l4;
            l4 = l3;
            l3 = 0L;
        }
        for (n3 = this.engine.params.NWORDS_FIELD; n3 < 2 * this.engine.params.NWORDS_FIELD - 1; ++n3) {
            if (n4 > 0) {
                --n4;
            }
            for (n2 = n3 - this.engine.params.NWORDS_FIELD + 1; n2 < this.engine.params.NWORDS_FIELD; ++n2) {
                if (n2 >= this.engine.params.NWORDS_FIELD - n4) continue;
                this.digit_x_digit(lArray2[n2], this.engine.params.PRIMEp1[n3 - n2], lArray3);
                l2 = lArray3[0];
                l5 += l2;
                l2 = lArray3[1] + (long)this.is_digit_lessthan_ct(l5, l2);
                l3 += (long)this.is_digit_lessthan_ct(l4 += l2, l2);
            }
            l = lArray[n3];
            n = this.is_digit_lessthan_ct(l5 += l, l);
            l4 += (long)n;
            l3 += (long)(n &= this.is_digit_zero_ct(l4));
            lArray2[n3 - this.engine.params.NWORDS_FIELD] = l5;
            l5 = l4;
            l4 = l3;
            l3 = 0L;
        }
        l = lArray[2 * this.engine.params.NWORDS_FIELD - 1];
        n = this.is_digit_lessthan_ct(l5 += l, l);
        lArray2[this.engine.params.NWORDS_FIELD - 1] = l5;
    }

    protected static boolean subarrayEquals(long[] lArray, long[] lArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected static boolean subarrayEquals(long[][] lArray, long[][] lArray2, int n) {
        int n2 = lArray2[0].length;
        for (int i = 0; i < n; ++i) {
            if (lArray[i / n2][i % n2] == lArray2[i / n2][i % n2]) continue;
            return false;
        }
        return true;
    }

    protected static boolean subarrayEquals(long[][] lArray, long[][] lArray2, int n, int n2) {
        int n3 = lArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            if (lArray[i / n3][i % n3] == lArray2[(i + n) / n3][(i + n) % n3]) continue;
            return false;
        }
        return true;
    }

    protected static boolean subarrayEquals(long[][] lArray, long[] lArray2, int n, int n2) {
        int n3 = lArray[0].length;
        for (int i = 0; i < n2; ++i) {
            if (lArray[i / n3][i % n3] == lArray2[i + n]) continue;
            return false;
        }
        return true;
    }

    void sqrt_Fp2(long[][] lArray, long[][] lArray2) {
        int n;
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray6 = new long[this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(lArray[0], lArray3);
        this.fpsqr_mont(lArray[1], lArray4);
        this.fpaddPRIME(lArray3, lArray4, lArray3);
        this.fpcopy(lArray3, 0, lArray4);
        for (n = 0; n < this.engine.params.OALICE_BITS - 2; ++n) {
            this.fpsqr_mont(lArray4, lArray4);
        }
        for (n = 0; n < this.engine.params.OBOB_EXPON; ++n) {
            this.fpsqr_mont(lArray4, lArray3);
            this.fpmul_mont(lArray4, lArray3, lArray4);
        }
        this.fpaddPRIME(lArray[0], lArray4, lArray3);
        this.fpdiv2_PRIME(lArray3, lArray3);
        this.fpcopy(lArray3, 0, lArray5);
        this.fpinv_chain_mont(lArray5);
        this.fpmul_mont(lArray3, lArray5, lArray4);
        this.fpmul_mont(lArray5, lArray[1], lArray5);
        this.fpdiv2_PRIME(lArray5, lArray5);
        this.fpsqr_mont(lArray4, lArray6);
        this.fpcorrectionPRIME(lArray3);
        this.fpcorrectionPRIME(lArray6);
        if (Fpx.subarrayEquals(lArray3, lArray6, this.engine.params.NWORDS_FIELD)) {
            this.fpcopy(lArray4, 0, lArray2[0]);
            this.fpcopy(lArray5, 0, lArray2[1]);
        } else {
            this.fpnegPRIME(lArray4);
            this.fpcopy(lArray5, 0, lArray2[0]);
            this.fpcopy(lArray4, 0, lArray2[1]);
        }
    }

    protected void fp2sqr_mont(long[][] lArray, long[][] lArray2) {
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        this.mp_add(lArray[0], lArray[1], lArray3, this.engine.params.NWORDS_FIELD);
        this.mp_subPRIME_p4(lArray[0], lArray[1], lArray4);
        this.mp_add(lArray[0], lArray[0], lArray5, this.engine.params.NWORDS_FIELD);
        this.fpmul_mont(lArray3, lArray4, lArray2[0]);
        this.fpmul_mont(lArray5, lArray[1], lArray2[1]);
    }

    protected void fpaddPRIME(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        int n;
        int n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray[n] + (long)n2;
            lArray3[n] = lArray2[n] + l;
            n2 = this.is_digit_lessthan_ct(l, n2) | this.is_digit_lessthan_ct(lArray3[n], l);
        }
        n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray3[n] - this.engine.params.PRIMEx2[n];
            int n3 = this.is_digit_lessthan_ct(lArray3[n], this.engine.params.PRIMEx2[n]) | n2 & this.is_digit_zero_ct(l);
            lArray3[n] = l - (long)n2;
            n2 = n3;
        }
        long l2 = 0 - n2;
        n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray3[n] + (long)n2;
            lArray3[n] = (this.engine.params.PRIMEx2[n] & l2) + l;
            n2 = this.is_digit_lessthan_ct(l, n2) | this.is_digit_lessthan_ct(lArray3[n], l);
        }
    }

    protected void cube_Fp2_cycl(long[][] lArray, long[] lArray2) {
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        this.fpaddPRIME(lArray[0], lArray[0], lArray3);
        this.fpsqr_mont(lArray3, lArray3);
        this.fpsubPRIME(lArray3, lArray2, lArray3);
        this.fpmul_mont(lArray[1], lArray3, lArray[1]);
        this.fpsubPRIME(lArray3, lArray2, lArray3);
        this.fpsubPRIME(lArray3, lArray2, lArray3);
        this.fpmul_mont(lArray[0], lArray3, lArray[0]);
    }

    protected void fpsubPRIME(long[] lArray, long[] lArray2, int n, long[] lArray3) {
        long l;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.engine.params.NWORDS_FIELD; ++n2) {
            l = lArray[n2] - lArray2[n2 + n];
            int n4 = this.is_digit_lessthan_ct(lArray[n2], lArray2[n2 + n]) | n3 & this.is_digit_zero_ct(l);
            lArray3[n2] = l - (long)n3;
            n3 = n4;
        }
        long l2 = 0 - n3;
        n3 = 0;
        for (n2 = 0; n2 < this.engine.params.NWORDS_FIELD; ++n2) {
            l = lArray3[n2] + (long)n3;
            lArray3[n2] = (this.engine.params.PRIMEx2[n2] & l2) + l;
            n3 = this.is_digit_lessthan_ct(l, n3) | this.is_digit_lessthan_ct(lArray3[n2], l);
        }
    }

    protected void fpsubPRIME(long[] lArray, int n, long[] lArray2, long[] lArray3) {
        long l;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.engine.params.NWORDS_FIELD; ++n2) {
            l = lArray[n2 + n] - lArray2[n2];
            int n4 = this.is_digit_lessthan_ct(lArray[n2 + n], lArray2[n2]) | n3 & this.is_digit_zero_ct(l);
            lArray3[n2] = l - (long)n3;
            n3 = n4;
        }
        long l2 = 0 - n3;
        n3 = 0;
        for (n2 = 0; n2 < this.engine.params.NWORDS_FIELD; ++n2) {
            l = lArray3[n2] + (long)n3;
            lArray3[n2] = (this.engine.params.PRIMEx2[n2] & l2) + l;
            n3 = this.is_digit_lessthan_ct(l, n3) | this.is_digit_lessthan_ct(lArray3[n2], l);
        }
    }

    protected void fpsubPRIME(long[] lArray, long[] lArray2, long[] lArray3) {
        long l;
        int n;
        int n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray[n] - lArray2[n];
            int n3 = this.is_digit_lessthan_ct(lArray[n], lArray2[n]) | n2 & this.is_digit_zero_ct(l);
            lArray3[n] = l - (long)n2;
            n2 = n3;
        }
        long l2 = 0 - n2;
        n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray3[n] + (long)n2;
            lArray3[n] = (this.engine.params.PRIMEx2[n] & l2) + l;
            n2 = this.is_digit_lessthan_ct(l, n2) | this.is_digit_lessthan_ct(lArray3[n], l);
        }
    }

    protected void fpnegPRIME(long[] lArray) {
        int n = 0;
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            long l = this.engine.params.PRIMEx2[i] - lArray[i];
            int n2 = this.is_digit_lessthan_ct(this.engine.params.PRIMEx2[i], lArray[i]) | n & this.is_digit_zero_ct(l);
            lArray[i] = l - (long)n;
            n = n2;
        }
    }

    protected void from_fp2mont(long[][] lArray, long[][] lArray2) {
        this.from_mont(lArray[0], lArray2[0]);
        this.from_mont(lArray[1], lArray2[1]);
    }

    protected void fp2_encode(long[][] lArray, byte[] byArray, int n) {
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        this.from_fp2mont(lArray, lArray2);
        this.encode_to_bytes(lArray2[0], byArray, n, this.engine.params.FP2_ENCODED_BYTES / 2);
        this.encode_to_bytes(lArray2[1], byArray, n + this.engine.params.FP2_ENCODED_BYTES / 2, this.engine.params.FP2_ENCODED_BYTES / 2);
    }

    protected void fp2_decode(byte[] byArray, long[][] lArray, int n) {
        this.decode_to_digits(byArray, n, lArray[0], this.engine.params.FP2_ENCODED_BYTES / 2, this.engine.params.NWORDS_FIELD);
        this.decode_to_digits(byArray, n + this.engine.params.FP2_ENCODED_BYTES / 2, lArray[1], this.engine.params.FP2_ENCODED_BYTES / 2, this.engine.params.NWORDS_FIELD);
        this.to_fp2mont(lArray, lArray);
    }

    protected void to_Montgomery_mod_order(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        this.Montgomery_multiply_mod_order(lArray, lArray5, lArray2, lArray3, lArray4);
    }

    protected void Montgomery_multiply_mod_order(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        int n;
        int n2 = 0;
        int n3 = 0;
        long[] lArray6 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray8 = new long[2 * this.engine.params.NWORDS_ORDER];
        this.multiply(lArray, lArray2, lArray6, this.engine.params.NWORDS_ORDER);
        this.multiply(lArray6, lArray5, lArray7, this.engine.params.NWORDS_ORDER);
        this.multiply(lArray7, lArray4, lArray8, this.engine.params.NWORDS_ORDER);
        n2 = this.mp_add(lArray6, lArray8, lArray8, 2 * this.engine.params.NWORDS_ORDER);
        for (n = 0; n < this.engine.params.NWORDS_ORDER; ++n) {
            lArray3[n] = lArray8[this.engine.params.NWORDS_ORDER + n];
        }
        n3 = this.mp_sub(lArray3, lArray4, lArray3, this.engine.params.NWORDS_ORDER);
        long l = n2 - n3;
        for (n = 0; n < this.engine.params.NWORDS_ORDER; ++n) {
            lArray8[n] = lArray4[n] & l;
        }
        this.mp_add(lArray3, lArray8, lArray3, this.engine.params.NWORDS_ORDER);
    }

    protected void inv_mod_orderA(long[] lArray, long[] lArray2) {
        int n = 0;
        long[] lArray3 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray4 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray5 = new long[2 * this.engine.params.NWORDS_ORDER];
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        long l = -1L >>> this.engine.params.NBITS_ORDER - this.engine.params.OALICE_BITS;
        lArray7[this.engine.params.NWORDS_ORDER - 1] = 1L << 64 - (this.engine.params.NBITS_ORDER - this.engine.params.OALICE_BITS);
        lArray6[0] = 1L;
        this.mp_sub(lArray, lArray6, lArray3, this.engine.params.NWORDS_ORDER);
        if ((lArray[0] & 1L) == 0L || this.is_zero(lArray3, this.engine.params.NWORDS_ORDER)) {
            this.copy_words(lArray, lArray2, this.engine.params.NWORDS_ORDER);
            int n2 = this.engine.params.NWORDS_ORDER - 1;
            lArray2[n2] = lArray2[n2] & l;
        } else {
            this.mp_sub(lArray7, lArray3, lArray2, this.engine.params.NWORDS_ORDER);
            this.mp_add(lArray2, lArray6, lArray2, this.engine.params.NWORDS_ORDER);
            this.copy_words(lArray3, lArray4, this.engine.params.NWORDS_ORDER);
            while ((lArray4[0] & 1L) == 0L) {
                ++n;
                this.mp_shiftr1(lArray4, this.engine.params.NWORDS_ORDER);
            }
            int n3 = this.engine.params.OALICE_BITS / n;
            for (int i = 1; i < n3; i <<= 1) {
                this.multiply(lArray3, lArray3, lArray5, this.engine.params.NWORDS_ORDER);
                this.copy_words(lArray5, lArray3, this.engine.params.NWORDS_ORDER);
                int n4 = this.engine.params.NWORDS_ORDER - 1;
                lArray3[n4] = lArray3[n4] & l;
                this.mp_add(lArray3, lArray6, lArray4, this.engine.params.NWORDS_ORDER);
                int n5 = this.engine.params.NWORDS_ORDER - 1;
                lArray4[n5] = lArray4[n5] & l;
                this.multiply(lArray2, lArray4, lArray5, this.engine.params.NWORDS_ORDER);
                this.copy_words(lArray5, lArray2, this.engine.params.NWORDS_ORDER);
                int n6 = this.engine.params.NWORDS_ORDER - 1;
                lArray2[n6] = lArray2[n6] & l;
            }
        }
    }

    protected void multiply(long[] lArray, long[] lArray2, long[] lArray3, int n) {
        long l;
        int n2;
        int n3;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long[] lArray4 = new long[2];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 <= n3; ++n2) {
                this.digit_x_digit(lArray[n2], lArray2[n3 - n2], lArray4);
                l = lArray4[0];
                l4 += l;
                l = lArray4[1] + (long)this.is_digit_lessthan_ct(l4, l);
                l2 += (long)this.is_digit_lessthan_ct(l3 += l, l);
            }
            lArray3[n3] = l4;
            l4 = l3;
            l3 = l2;
            l2 = 0L;
        }
        for (n3 = n; n3 < 2 * n - 1; ++n3) {
            for (n2 = n3 - n + 1; n2 < n; ++n2) {
                this.digit_x_digit(lArray[n2], lArray2[n3 - n2], lArray4);
                l = lArray4[0];
                l4 += l;
                l = lArray4[1] + (long)this.is_digit_lessthan_ct(l4, l);
                l2 += (long)this.is_digit_lessthan_ct(l3 += l, l);
            }
            lArray3[n3] = l4;
            l4 = l3;
            l3 = l2;
            l2 = 0L;
        }
        lArray3[2 * n - 1] = l4;
    }

    private boolean is_zero_mod_order(long[] lArray) {
        for (int i = 0; i < this.engine.params.NWORDS_ORDER; ++i) {
            if (lArray[i] == 0L) continue;
            return false;
        }
        return true;
    }

    private boolean is_even_mod_order(long[] lArray) {
        return (lArray[0] & 1L ^ 1L) == 1L;
    }

    private boolean is_lt_mod_order(long[] lArray, long[] lArray2) {
        for (int i = this.engine.params.NWORDS_ORDER - 1; i >= 0; --i) {
            if (lArray[i] + Long.MIN_VALUE < lArray2[i] + Long.MIN_VALUE) {
                return true;
            }
            if (lArray[i] + Long.MIN_VALUE <= lArray2[i] + Long.MIN_VALUE) continue;
            return false;
        }
        return false;
    }

    private boolean is_zero(long[] lArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == 0L) continue;
            return false;
        }
        return true;
    }

    private void Montgomery_inversion_mod_order_bingcd_partial(long[] lArray, long[] lArray2, int[] nArray, long[] lArray3) {
        long[] lArray4 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray5 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        this.copy_words(lArray, lArray4, this.engine.params.NWORDS_ORDER);
        this.copy_words(lArray3, lArray5, this.engine.params.NWORDS_ORDER);
        this.copy_words(lArray6, lArray2, this.engine.params.NWORDS_ORDER);
        lArray2[0] = 1L;
        nArray[0] = 0;
        while (!this.is_zero_mod_order(lArray5)) {
            int n = (nArray[0] + 1) / 64 + 1;
            if (n < this.engine.params.NWORDS_ORDER) {
                if (this.is_even_mod_order(lArray5)) {
                    this.mp_shiftr1(lArray5, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftl1(lArray2, n);
                } else if (this.is_even_mod_order(lArray4)) {
                    this.mp_shiftr1(lArray4, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftl1(lArray6, n);
                } else if (!this.is_lt_mod_order(lArray5, lArray4)) {
                    this.mp_sub(lArray5, lArray4, lArray5, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftr1(lArray5, this.engine.params.NWORDS_ORDER);
                    this.mp_add(lArray2, lArray6, lArray6, n);
                    this.mp_shiftl1(lArray2, n);
                } else {
                    this.mp_sub(lArray4, lArray5, lArray4, this.engine.params.NWORDS_ORDER);
                    this.mp_shiftr1(lArray4, this.engine.params.NWORDS_ORDER);
                    this.mp_add(lArray2, lArray6, lArray2, n);
                    this.mp_shiftl1(lArray6, n);
                }
            } else if (this.is_even_mod_order(lArray5)) {
                this.mp_shiftr1(lArray5, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(lArray2, this.engine.params.NWORDS_ORDER);
            } else if (this.is_even_mod_order(lArray4)) {
                this.mp_shiftr1(lArray4, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(lArray6, this.engine.params.NWORDS_ORDER);
            } else if (!this.is_lt_mod_order(lArray5, lArray4)) {
                this.mp_sub(lArray5, lArray4, lArray5, this.engine.params.NWORDS_ORDER);
                this.mp_shiftr1(lArray5, this.engine.params.NWORDS_ORDER);
                this.mp_add(lArray2, lArray6, lArray6, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(lArray2, this.engine.params.NWORDS_ORDER);
            } else {
                this.mp_sub(lArray4, lArray5, lArray4, this.engine.params.NWORDS_ORDER);
                this.mp_shiftr1(lArray4, this.engine.params.NWORDS_ORDER);
                this.mp_add(lArray2, lArray6, lArray2, this.engine.params.NWORDS_ORDER);
                this.mp_shiftl1(lArray6, this.engine.params.NWORDS_ORDER);
            }
            nArray[0] = nArray[0] + 1;
        }
        if (this.is_lt_mod_order(lArray3, lArray2)) {
            this.mp_sub(lArray2, lArray3, lArray2, this.engine.params.NWORDS_ORDER);
        }
    }

    protected void Montgomery_inversion_mod_order_bingcd(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, long[] lArray5) {
        long[] lArray6 = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        int[] nArray = new int[1];
        if (this.is_zero(lArray, this.engine.params.NWORDS_ORDER)) {
            this.copy_words(lArray7, lArray2, this.engine.params.NWORDS_ORDER);
            return;
        }
        this.Montgomery_inversion_mod_order_bingcd_partial(lArray, lArray6, nArray, lArray3);
        if (nArray[0] <= this.engine.params.NBITS_ORDER) {
            this.Montgomery_multiply_mod_order(lArray6, lArray5, lArray6, lArray3, lArray4);
            nArray[0] = nArray[0] + this.engine.params.NBITS_ORDER;
        }
        this.Montgomery_multiply_mod_order(lArray6, lArray5, lArray6, lArray3, lArray4);
        this.power2_setup(lArray7, 2 * this.engine.params.NBITS_ORDER - nArray[0], this.engine.params.NWORDS_ORDER);
        this.Montgomery_multiply_mod_order(lArray6, lArray7, lArray2, lArray3, lArray4);
    }

    protected void from_Montgomery_mod_order(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4) {
        long[] lArray5 = new long[this.engine.params.NWORDS_ORDER];
        lArray5[0] = 1L;
        this.Montgomery_multiply_mod_order(lArray, lArray5, lArray2, lArray3, lArray4);
    }

    protected int mod3(long[] lArray) {
        int n = 0;
        int[] nArray = Pack.littleEndianToInt(Pack.longToLittleEndian(lArray), 0, lArray.length * 2);
        for (int i = 2 * this.engine.params.NWORDS_ORDER - 1; i >= 0; --i) {
            long l = (long)n << 32 | (long)nArray[i] & 0xFFFFFFFFL;
            n = (int)(l % 3L);
        }
        return n;
    }

    protected void to_fp2mont(long[][] lArray, long[][] lArray2) {
        this.to_mont(lArray[0], lArray2[0]);
        this.to_mont(lArray[1], lArray2[1]);
    }

    private void to_mont(long[] lArray, long[] lArray2) {
        this.fpmul_mont(lArray, this.engine.params.Montgomery_R2, lArray2);
    }

    protected void fpcorrectionPRIME(long[] lArray) {
        long l;
        int n;
        int n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray[n] - this.engine.params.PRIME[n];
            int n3 = this.is_digit_lessthan_ct(lArray[n], this.engine.params.PRIME[n]) | n2 & this.is_digit_zero_ct(l);
            lArray[n] = l - (long)n2;
            n2 = n3;
        }
        long l2 = 0 - n2;
        n2 = 0;
        for (n = 0; n < this.engine.params.NWORDS_FIELD; ++n) {
            l = lArray[n] + (long)n2;
            lArray[n] = (this.engine.params.PRIME[n] & l2) + l;
            n2 = this.is_digit_lessthan_ct(l, n2) | this.is_digit_lessthan_ct(lArray[n], l);
        }
    }

    protected byte cmp_f2elm(long[][] lArray, long[][] lArray2) {
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        int n = 0;
        this.fp2copy(lArray, lArray3);
        this.fp2copy(lArray2, lArray4);
        this.fp2correction(lArray3);
        this.fp2correction(lArray4);
        for (int i = this.engine.params.NWORDS_FIELD - 1; i >= 0; --i) {
            n = (byte)((long)n | (lArray3[0][i] ^ lArray4[0][i] | lArray3[1][i] ^ lArray4[1][i]));
        }
        return (byte)(-n >>> 7);
    }

    protected void encode_to_bytes(long[] lArray, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 * 4 + 7 & 0xFFFFFFF8];
        Pack.longToLittleEndian(lArray, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, n, n2);
    }

    protected void decode_to_digits(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        lArray[n3 - 1] = 0L;
        byte[] byArray2 = new byte[n2 + 7 & 0xFFFFFFF8];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        Pack.littleEndianToLong(byArray2, 0, lArray);
    }

    protected void fp2_conj(long[][] lArray, long[][] lArray2) {
        this.fpcopy(lArray[0], 0, lArray2[0]);
        this.fpcopy(lArray[1], 0, lArray2[1]);
        if (!this.is_felm_zero(lArray2[1])) {
            this.fpnegPRIME(lArray2[1]);
        }
    }

    private void from_mont(long[] lArray, long[] lArray2) {
        long[] lArray3 = new long[this.engine.params.NWORDS_FIELD];
        lArray3[0] = 1L;
        this.fpmul_mont(lArray, lArray3, lArray2);
        this.fpcorrectionPRIME(lArray2);
    }

    private void mp_shiftr1(long[] lArray) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD - 1; ++i) {
            lArray[i] = lArray[i] >>> 1 ^ lArray[i + 1] << 63;
        }
        int n = this.engine.params.NWORDS_FIELD - 1;
        lArray[n] = lArray[n] >>> 1;
    }

    private void mp_shiftr1(long[] lArray, int n) {
        for (int i = 0; i < n - 1; ++i) {
            lArray[i] = lArray[i] >>> 1 ^ lArray[i + 1] << 63;
        }
        int n2 = n - 1;
        lArray[n2] = lArray[n2] >>> 1;
    }

    protected void fp2copy(long[][] lArray, long[][] lArray2) {
        this.fpcopy(lArray[0], 0, lArray2[0]);
        this.fpcopy(lArray[1], 0, lArray2[1]);
    }

    protected void fp2copy(long[][] lArray, int n, long[][] lArray2) {
        this.fpcopy(lArray[0 + n], 0, lArray2[0]);
        this.fpcopy(lArray[1 + n], 0, lArray2[1]);
    }

    protected void fp2copy(long[] lArray, int n, long[][] lArray2) {
        this.fpcopy(lArray, n, lArray2[0]);
        this.fpcopy(lArray, n + this.engine.params.NWORDS_FIELD, lArray2[1]);
    }

    protected void fpzero(long[] lArray) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            lArray[i] = 0L;
        }
    }

    protected void mp2_sub_p2(long[][] lArray, long[][] lArray2, long[][] lArray3) {
        this.mp_subPRIME_p2(lArray[0], lArray2[0], lArray3[0]);
        this.mp_subPRIME_p2(lArray[1], lArray2[1], lArray3[1]);
    }

    protected void mp_mul(long[] lArray, long[] lArray2, long[] lArray3, int n) {
        long l;
        int n2;
        int n3;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long[] lArray4 = new long[2];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 <= n3; ++n2) {
                this.digit_x_digit(lArray[n2], lArray2[n3 - n2], lArray4);
                l = lArray4[0];
                l4 += l;
                l = lArray4[1] + (long)this.is_digit_lessthan_ct(l4, l);
                l2 += (long)this.is_digit_lessthan_ct(l3 += l, l);
            }
            lArray3[n3] = l4;
            l4 = l3;
            l3 = l2;
            l2 = 0L;
        }
        for (n3 = n; n3 < 2 * n - 1; ++n3) {
            for (n2 = n3 - n + 1; n2 < n; ++n2) {
                this.digit_x_digit(lArray[n2], lArray2[n3 - n2], lArray4);
                l = lArray4[0];
                l4 += l;
                l = lArray4[1] + (long)this.is_digit_lessthan_ct(l4, l);
                l2 += (long)this.is_digit_lessthan_ct(l3 += l, l);
            }
            lArray3[n3] = l4;
            l4 = l3;
            l3 = l2;
            l2 = 0L;
        }
        lArray3[2 * n - 1] = l4;
    }

    protected void mp_mul(long[] lArray, int n, long[] lArray2, long[] lArray3, int n2) {
        long l;
        int n3;
        int n4;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long[] lArray4 = new long[2];
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 <= n4; ++n3) {
                this.digit_x_digit(lArray[n3 + n], lArray2[n4 - n3], lArray4);
                l = lArray4[0];
                l4 += l;
                l = lArray4[1] + (long)this.is_digit_lessthan_ct(l4, l);
                l2 += (long)this.is_digit_lessthan_ct(l3 += l, l);
            }
            lArray3[n4] = l4;
            l4 = l3;
            l3 = l2;
            l2 = 0L;
        }
        for (n4 = n2; n4 < 2 * n2 - 1; ++n4) {
            for (n3 = n4 - n2 + 1; n3 < n2; ++n3) {
                this.digit_x_digit(lArray[n3 + n], lArray2[n4 - n3], lArray4);
                l = lArray4[0];
                l4 += l;
                l = lArray4[1] + (long)this.is_digit_lessthan_ct(l4, l);
                l2 += (long)this.is_digit_lessthan_ct(l3 += l, l);
            }
            lArray3[n4] = l4;
            l4 = l3;
            l3 = l2;
            l2 = 0L;
        }
        lArray3[2 * n2 - 1] = l4;
    }

    protected void fp2mul_mont(long[][] lArray, long[][] lArray2, long[][] lArray3) {
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray6 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] lArray7 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] lArray8 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_add(lArray[0], lArray[1], lArray4, this.engine.params.NWORDS_FIELD);
        this.mp_add(lArray2[0], lArray2[1], lArray5, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray[0], lArray2[0], lArray6, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray[1], lArray2[1], lArray7, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray4, lArray5, lArray8, this.engine.params.NWORDS_FIELD);
        this.mp_dblsubfast(lArray6, lArray7, lArray8);
        this.mp_subaddfast(lArray6, lArray7, lArray6);
        this.rdc_mont(lArray8, lArray3[1]);
        this.rdc_mont(lArray6, lArray3[0]);
    }

    protected void fp2mul_mont(long[][] lArray, long[][] lArray2, int n, long[][] lArray3) {
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray6 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] lArray7 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] lArray8 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_add(lArray[0], lArray[1], lArray4, this.engine.params.NWORDS_FIELD);
        this.mp_add(lArray2[0 + n], lArray2[n + 1], lArray5, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray[0], lArray2[n + 0], lArray6, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray[1], lArray2[n + 1], lArray7, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray4, lArray5, lArray8, this.engine.params.NWORDS_FIELD);
        this.mp_dblsubfast(lArray6, lArray7, lArray8);
        this.mp_subaddfast(lArray6, lArray7, lArray6);
        this.rdc_mont(lArray8, lArray3[1]);
        this.rdc_mont(lArray6, lArray3[0]);
    }

    protected void fp2mul_mont(long[][] lArray, long[] lArray2, int n, long[][] lArray3) {
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray5 = new long[this.engine.params.NWORDS_FIELD];
        long[] lArray6 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] lArray7 = new long[2 * this.engine.params.NWORDS_FIELD];
        long[] lArray8 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_add(lArray[0], lArray[1], lArray4, this.engine.params.NWORDS_FIELD);
        this.mp_add(lArray2, n, lArray2, n + this.engine.params.NWORDS_FIELD, lArray5, 0, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray2, n, lArray[0], lArray6, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray2, n + this.engine.params.NWORDS_FIELD, lArray[1], lArray7, this.engine.params.NWORDS_FIELD);
        this.mp_mul(lArray4, lArray5, lArray8, this.engine.params.NWORDS_FIELD);
        this.mp_dblsubfast(lArray6, lArray7, lArray8);
        this.mp_subaddfast(lArray6, lArray7, lArray6);
        this.rdc_mont(lArray8, lArray3[1]);
        this.rdc_mont(lArray6, lArray3[0]);
    }

    private void mp_dblsubfast(long[] lArray, long[] lArray2, long[] lArray3) {
        this.mp_sub(lArray3, lArray, lArray3, 2 * this.engine.params.NWORDS_FIELD);
        this.mp_sub(lArray3, lArray2, lArray3, 2 * this.engine.params.NWORDS_FIELD);
    }

    protected int mp_sub(long[] lArray, long[] lArray2, long[] lArray3, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = lArray[i] - lArray2[i];
            int n3 = this.is_digit_lessthan_ct(lArray[i], lArray2[i]) | n2 & this.is_digit_zero_ct(l);
            lArray3[i] = l - (long)n2;
            n2 = n3;
        }
        return n2;
    }

    protected boolean is_orderelm_lt(long[] lArray, long[] lArray2) {
        for (int i = this.engine.params.NWORDS_ORDER - 1; i >= 0; --i) {
            if (lArray[i] + Long.MIN_VALUE < lArray2[i] + Long.MIN_VALUE) {
                return true;
            }
            if (lArray[i] + Long.MIN_VALUE <= lArray2[i] + Long.MIN_VALUE) continue;
            return false;
        }
        return false;
    }

    private void mp_subaddfast(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = new long[this.engine.params.NWORDS_FIELD];
        long l = 0L - (long)this.mp_sub(lArray, lArray2, lArray3, 2 * this.engine.params.NWORDS_FIELD);
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            lArray4[i] = this.engine.params.PRIME[i] & l;
        }
        this.mp_add(lArray3, this.engine.params.NWORDS_FIELD, lArray4, lArray3, this.engine.params.NWORDS_FIELD, this.engine.params.NWORDS_FIELD);
    }

    protected void fpsqr_mont(long[] lArray, long[] lArray2) {
        long[] lArray3 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_mul(lArray, lArray, lArray3, this.engine.params.NWORDS_FIELD);
        this.rdc_mont(lArray3, lArray2);
    }

    private void fpinv_mont(long[] lArray) {
        long[] lArray2 = new long[this.engine.params.NWORDS_FIELD];
        this.fpcopy(lArray, 0, lArray2);
        this.fpinv_chain_mont(lArray2);
        this.fpsqr_mont(lArray2, lArray2);
        this.fpsqr_mont(lArray2, lArray2);
        this.fpmul_mont(lArray, lArray2, lArray);
    }

    protected void fp2inv_mont(long[][] lArray) {
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        this.fpsqr_mont(lArray[0], lArray2[0]);
        this.fpsqr_mont(lArray[1], lArray2[1]);
        this.fpaddPRIME(lArray2[0], lArray2[1], lArray2[0]);
        this.fpinv_mont(lArray2[0]);
        this.fpnegPRIME(lArray[1]);
        this.fpmul_mont(lArray[0], lArray2[0], lArray[0]);
        this.fpmul_mont(lArray[1], lArray2[0], lArray[1]);
    }

    protected void mul3(byte[] byArray) {
        long[] lArray = new long[this.engine.params.NWORDS_ORDER];
        long[] lArray2 = new long[this.engine.params.NWORDS_ORDER];
        this.decode_to_digits(byArray, 0, lArray, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.mp_add(lArray, lArray, lArray2, this.engine.params.NWORDS_ORDER);
        this.mp_add(lArray, lArray2, lArray, this.engine.params.NWORDS_ORDER);
        this.encode_to_bytes(lArray, byArray, 0, this.engine.params.SECRETKEY_B_BYTES);
    }

    protected byte ct_compare(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = (byte)(n2 | byArray[i] ^ byArray2[i]);
        }
        return (byte)(-n2 >>> 7);
    }

    protected void ct_cmov(byte[] byArray, byte[] byArray2, int n, byte by) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] ^ by & (byArray2[i] ^ byArray[i]));
        }
    }

    protected void copy_words(long[] lArray, long[] lArray2, int n) {
        for (int i = 0; i < n; ++i) {
            lArray2[i] = lArray[i];
        }
    }

    protected void fp2shl(long[][] lArray, int n, long[][] lArray2) {
        this.fp2copy(lArray, lArray2);
        for (int i = 0; i < n; ++i) {
            this.fp2add(lArray2, lArray2, lArray2);
        }
    }

    protected void copy_words(PointProj pointProj, PointProj pointProj2) {
        for (int i = 0; i < this.engine.params.NWORDS_FIELD; ++i) {
            pointProj2.X[0][i] = pointProj.X[0][i];
            pointProj2.X[1][i] = pointProj.X[1][i];
            pointProj2.Z[0][i] = pointProj.Z[0][i];
            pointProj2.Z[1][i] = pointProj.Z[1][i];
        }
    }

    void Montgomery_neg(long[] lArray, long[] lArray2) {
        int n = 0;
        for (int i = 0; i < this.engine.params.NWORDS_ORDER; ++i) {
            long l = lArray2[i] - lArray[i];
            int n2 = this.is_digit_lessthan_ct(lArray2[i], lArray[i]) | n & this.is_digit_zero_ct(l);
            lArray[i] = l - (long)n;
            n = n2;
        }
    }

    protected void fp2add(long[][] lArray, long[][] lArray2, long[][] lArray3) {
        this.fpaddPRIME(lArray[0], lArray2[0], lArray3[0]);
        this.fpaddPRIME(lArray[1], lArray2[1], lArray3[1]);
    }

    protected void fp2sub(long[][] lArray, long[][] lArray2, long[][] lArray3) {
        this.fpsubPRIME(lArray[0], lArray2[0], lArray3[0]);
        this.fpsubPRIME(lArray[1], lArray2[1], lArray3[1]);
    }

    protected void fpmul_mont(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_mul(lArray, lArray2, lArray4, this.engine.params.NWORDS_FIELD);
        this.rdc_mont(lArray4, lArray3);
    }

    protected void fpmul_mont(long[] lArray, int n, long[] lArray2, long[] lArray3) {
        long[] lArray4 = new long[2 * this.engine.params.NWORDS_FIELD];
        this.mp_mul(lArray, n, lArray2, lArray4, this.engine.params.NWORDS_FIELD);
        this.rdc_mont(lArray4, lArray3);
    }

    private void fpinv_chain_mont(long[] lArray) {
        int n;
        int n2;
        Object object;
        Object object2;
        if (this.engine.params.NBITS_FIELD == 434) {
            object2 = new long[this.engine.params.NWORDS_FIELD];
            object = new long[31][this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(lArray, (long[])object2);
            this.fpmul_mont(lArray, (long[])object2, object[0]);
            for (n2 = 0; n2 <= 29; ++n2) {
                this.fpmul_mont(object[n2], (long[])object2, object[n2 + 1]);
            }
            this.fpcopy(lArray, 0, (long[])object2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[5], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 10; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[14], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[3], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[23], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[13], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[24], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[7], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[12], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[30], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[1], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[30], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[21], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[2], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[19], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[1], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[24], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[26], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[16], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[10], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[6], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[0], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[20], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[9], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[25], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[30], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[26], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(lArray, (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[28], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[6], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[10], (long[])object2, (long[])object2);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object2, (long[])object2);
            }
            this.fpmul_mont(object[22], (long[])object2, (long[])object2);
            for (n = 0; n < 35; ++n) {
                for (n2 = 0; n2 < 6; ++n2) {
                    this.fpsqr_mont((long[])object2, (long[])object2);
                }
                this.fpmul_mont(object[30], (long[])object2, (long[])object2);
            }
            this.fpcopy((long[])object2, 0, lArray);
        }
        if (this.engine.params.NBITS_FIELD == 503) {
            object2 = new long[15][this.engine.params.NWORDS_FIELD];
            object = new long[this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(lArray, (long[])object);
            this.fpmul_mont(lArray, (long[])object, (long[])object2[0]);
            for (n2 = 0; n2 <= 13; ++n2) {
                this.fpmul_mont((long[])object2[n2], (long[])object, (long[])object2[n2 + 1]);
            }
            this.fpcopy(lArray, 0, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont(lArray, (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[8], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[9], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[0], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont(lArray, (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[8], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont(lArray, (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[10], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[0], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[10], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[10], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[3], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 12; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[12], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[8], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[12], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[11], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[14], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[14], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[8], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont(lArray, (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[4], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[7], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont(lArray, (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[0], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[11], (long[])object, (long[])object);
            for (n2 = 0; n2 < 5; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[13], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[1], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[10], (long[])object, (long[])object);
            for (n = 0; n < 49; ++n) {
                for (n2 = 0; n2 < 5; ++n2) {
                    this.fpsqr_mont((long[])object, (long[])object);
                }
                this.fpmul_mont((long[])object2[14], (long[])object, (long[])object);
            }
            this.fpcopy((long[])object, 0, lArray);
        }
        if (this.engine.params.NBITS_FIELD == 610) {
            object2 = new long[31][this.engine.params.NWORDS_FIELD];
            object = new long[this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(lArray, (long[])object);
            this.fpmul_mont(lArray, (long[])object, (long[])object2[0]);
            for (n2 = 0; n2 <= 29; ++n2) {
                this.fpmul_mont((long[])object2[n2], (long[])object, (long[])object2[n2 + 1]);
            }
            this.fpcopy(lArray, 0, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[30], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[25], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[28], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[7], (long[])object, (long[])object);
            for (n2 = 0; n2 < 11; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[11], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont(lArray, (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[0], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[3], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[16], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[24], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[28], (long[])object, (long[])object);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[16], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[4], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[3], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[20], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[11], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[14], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[15], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[0], (long[])object, (long[])object);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[15], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[19], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[9], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[27], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[28], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[29], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[1], (long[])object, (long[])object);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[3], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[30], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[25], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[28], (long[])object, (long[])object);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[22], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[3], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[22], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[7], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[9], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[4], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[20], (long[])object, (long[])object);
            for (n2 = 0; n2 < 11; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[10], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[26], (long[])object, (long[])object);
            for (n2 = 0; n2 < 11; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n = 0; n < 50; ++n) {
                for (n2 = 0; n2 < 6; ++n2) {
                    this.fpsqr_mont((long[])object, (long[])object);
                }
                this.fpmul_mont((long[])object2[30], (long[])object, (long[])object);
            }
            this.fpcopy((long[])object, 0, lArray);
        }
        if (this.engine.params.NBITS_FIELD == 751) {
            object2 = new long[27][this.engine.params.NWORDS_FIELD];
            object = new long[this.engine.params.NWORDS_FIELD];
            this.fpsqr_mont(lArray, (long[])object);
            this.fpmul_mont(lArray, (long[])object, (long[])object2[0]);
            this.fpmul_mont((long[])object2[0], (long[])object, (long[])object2[1]);
            this.fpmul_mont((long[])object2[1], (long[])object, (long[])object2[2]);
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object2[3]);
            this.fpmul_mont((long[])object2[3], (long[])object, (long[])object2[3]);
            for (n2 = 3; n2 <= 8; ++n2) {
                this.fpmul_mont((long[])object2[n2], (long[])object, (long[])object2[n2 + 1]);
            }
            this.fpmul_mont((long[])object2[9], (long[])object, (long[])object2[9]);
            for (n2 = 9; n2 <= 20; ++n2) {
                this.fpmul_mont((long[])object2[n2], (long[])object, (long[])object2[n2 + 1]);
            }
            this.fpmul_mont((long[])object2[21], (long[])object, (long[])object2[21]);
            for (n2 = 21; n2 <= 24; ++n2) {
                this.fpmul_mont((long[])object2[n2], (long[])object, (long[])object2[n2 + 1]);
            }
            this.fpmul_mont((long[])object2[25], (long[])object, (long[])object2[25]);
            this.fpmul_mont((long[])object2[25], (long[])object, (long[])object2[26]);
            this.fpcopy(lArray, 0, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[20], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[24], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[11], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[8], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[23], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 9; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 10; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[15], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[13], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[26], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[20], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[11], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[10], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[14], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[4], (long[])object, (long[])object);
            for (n2 = 0; n2 < 10; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[18], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[1], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[22], (long[])object, (long[])object);
            for (n2 = 0; n2 < 10; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[6], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[24], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[9], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[18], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[17], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont(lArray, (long[])object, (long[])object);
            for (n2 = 0; n2 < 10; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[16], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[7], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[0], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[12], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[19], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[22], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[25], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[10], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[22], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[18], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[4], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[14], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[13], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[23], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[21], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[23], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[12], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[9], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[3], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[13], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[17], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[26], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[5], (long[])object, (long[])object);
            for (n2 = 0; n2 < 8; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[8], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[2], (long[])object, (long[])object);
            for (n2 = 0; n2 < 6; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[11], (long[])object, (long[])object);
            for (n2 = 0; n2 < 7; ++n2) {
                this.fpsqr_mont((long[])object, (long[])object);
            }
            this.fpmul_mont((long[])object2[20], (long[])object, (long[])object);
            for (n = 0; n < 61; ++n) {
                for (n2 = 0; n2 < 6; ++n2) {
                    this.fpsqr_mont((long[])object, (long[])object);
                }
                this.fpmul_mont((long[])object2[26], (long[])object, (long[])object);
            }
            this.fpcopy((long[])object, 0, lArray);
        }
    }
}

