/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.questionnaire;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.setup.ui.questionnaire.AnimatedShell;
import org.eclipse.oomph.setup.ui.questionnaire.GearAnimator;
import org.eclipse.oomph.setup.ui.questionnaire.Messages;
import org.eclipse.oomph.util.Pair;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GearShell
extends AnimatedShell<Map<URI, Pair<String, String>>>
implements GearAnimator.Listener {
    private static final boolean TEST_OVERLAYS = false;
    private GearAnimator animator;

    public GearShell(Display display) {
        super(display, 65536);
    }

    public GearShell(Shell parent) {
        super(parent, 65536);
    }

    public final GearAnimator getAnimator() {
        return this.animator;
    }

    @Override
    public void onAnswer(GearAnimator animator, GearAnimator.Page page, GearAnimator.Answer answer) {
        if (page instanceof GearAnimator.SummaryPage) {
            GearAnimator.Page[] pages;
            HashMap<URI, Pair> preferences = new HashMap<URI, Pair>();
            GearAnimator.Page[] pageArray = pages = animator.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                GearAnimator.PreferencePage preferencePage;
                int choice;
                GearAnimator.Page p = pageArray[n2];
                if (p instanceof GearAnimator.PreferencePage && (choice = (preferencePage = (GearAnimator.PreferencePage)p).getChoice()) != -1) {
                    URI key = preferencePage.getPreferenceKey();
                    String value = choice == 0 ? preferencePage.getYesValue() : preferencePage.getNoValue();
                    preferences.put(key, new Pair(null, (Object)value));
                }
                ++n2;
            }
            this.setResult(preferences);
            this.dispose();
        }
    }

    @Override
    public void onExit(GearAnimator animator, GearAnimator.Page page) {
        this.dispose();
    }

    @Override
    protected void init() {
        super.init();
        Display display = this.getDisplay();
        this.animator = new GearAnimator(display){

            @Override
            protected boolean onKeyPressed(KeyEvent e) {
                return super.onKeyPressed(e);
            }

            @Override
            protected boolean shouldShowOverlay() {
                return super.shouldShowOverlay();
            }
        };
        this.animator.addListener(this);
        this.getCanvas().addAnimator(this.animator);
        int width = Math.max(this.animator.getWidth(), 620) + 60;
        int height = this.animator.getHeight() + 420 + 90;
        this.setSize(width, height);
        Composite parent = this.getParent();
        if (parent != null) {
            Rectangle bounds = parent.getBounds();
            this.setLocation(bounds.x + (bounds.width - width) / 2, bounds.y + (bounds.height - height) / 2);
        }
    }

    public static void main(String[] args) {
        final Display display = new Display();
        GearShell shell = new GearShell(display){

            @Override
            public void onAnswer(GearAnimator animator, GearAnimator.Page page, GearAnimator.Answer answer) {
                if (page instanceof GearAnimator.SummaryPage) {
                    System.out.println(Messages.GearShell_finish);
                    GearAnimator.Page[] pages = animator.getPages();
                    int i = 1;
                    while (i < 7) {
                        System.out.println("  " + pages[i].getTitle() + " = " + pages[i].getChoice());
                        ++i;
                    }
                    display.dispose();
                }
            }
        };
        shell.setText(Messages.GearShell_text);
        shell.openModal();
        display.dispose();
    }
}

