/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class SelectFilesOperation
implements IRunnableWithProgress {
    IProgressMonitor monitor;
    Object root;
    IImportStructureProvider provider;
    String[] desiredExtensions;
    FileSystemElement result;

    public SelectFilesOperation(Object rootObject, IImportStructureProvider structureProvider) {
        this.root = rootObject;
        this.provider = structureProvider;
    }

    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject) throws InterruptedException {
        String elementLabel;
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        boolean isContainer = this.provider.isFolder(fileSystemObject);
        String string = elementLabel = parent == null ? this.provider.getFullPath(fileSystemObject) : this.provider.getLabel(fileSystemObject);
        if (!isContainer && !this.hasDesiredExtension(elementLabel)) {
            return null;
        }
        FileSystemElement result = new FileSystemElement(elementLabel, parent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        if (isContainer) {
            boolean haveChildOrFile = false;
            ArrayList children = this.provider.getChildren(fileSystemObject);
            if (children == null) {
                children = new ArrayList(1);
            }
            Iterator childrenEnum = children.iterator();
            while (childrenEnum.hasNext()) {
                if (this.createElement(result, childrenEnum.next()) == null) continue;
                haveChildOrFile = true;
            }
            if (!haveChildOrFile && parent != null) {
                parent.removeFolder(result);
                result = null;
            }
        }
        return result;
    }

    protected String getExtensionFor(String filename) {
        int nIndex = filename.lastIndexOf(46);
        if (nIndex >= 0) {
            return filename.substring(nIndex + 1);
        }
        return "";
    }

    public FileSystemElement getResult() {
        return this.result;
    }

    protected boolean hasDesiredExtension(String filename) {
        if (this.desiredExtensions == null) {
            return true;
        }
        int extensionsSize = this.desiredExtensions.length;
        int i = 0;
        while (i < extensionsSize) {
            if (this.getExtensionFor(filename).equalsIgnoreCase(this.desiredExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        try {
            this.monitor = monitor;
            monitor.beginTask(DataTransferMessages.DataTransfer_scanningMatching, -1);
            this.result = this.createElement(null, this.root);
            if (this.result == null) {
                this.result = new FileSystemElement(this.provider.getLabel(this.root), null, this.provider.isFolder(this.root));
                this.result.setFileSystemObject(this.root);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setDesiredExtensions(String[] extensions) {
        this.desiredExtensions = extensions;
    }
}

