/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.jreinfo;

import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.jreinfo.Messages;
import org.eclipse.oomph.util.StringUtil;

public final class JREFilter {
    private final Integer major;
    private final Integer minor;
    private final Integer micro;
    private final Integer bitness;
    private final String arch;
    private final Boolean jdk;
    private final Boolean descriptor;

    public JREFilter() {
        this((Integer)null, (Integer)null, (Integer)null);
    }

    public JREFilter(Integer major, Integer minor, Integer micro) {
        this(major, minor, micro, null);
    }

    public JREFilter(Integer major, Integer minor, Integer micro, Integer bitness) {
        this(major, minor, micro, bitness, null);
    }

    public JREFilter(Integer major, Integer minor, Integer micro, Integer bitness, Boolean jdk) {
        if (major == null && minor != null) {
            throw new IllegalArgumentException(Messages.JREFilter_BadMinor_exception);
        }
        if (minor == null && micro != null) {
            throw new IllegalArgumentException(Messages.JREFilter_BadMicro_exception);
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.bitness = bitness;
        this.jdk = jdk;
        this.descriptor = Boolean.FALSE;
        this.arch = "";
    }

    public JREFilter(int bitness) {
        this(null, null, null, bitness, null);
    }

    public JREFilter(boolean jdk) {
        this(null, null, null, null, jdk);
    }

    public JREFilter(String version, Integer bitness, Boolean jdk) {
        this(version, bitness, jdk, Boolean.FALSE);
    }

    public JREFilter(String version, Integer bitness, Boolean jdk, Boolean descriptor) {
        this(version, bitness, jdk, descriptor, "");
    }

    public JREFilter(String version, Integer bitness, Boolean jdk, Boolean descriptor, String arch) {
        if (StringUtil.isEmpty((String)version)) {
            this.major = null;
            this.minor = null;
            this.micro = null;
        } else {
            String[] tokens = version.split("\\.");
            this.major = JREFilter.getSegment(tokens, 0);
            this.minor = JREFilter.getSegment(tokens, 1);
            this.micro = JREFilter.getSegment(tokens, 2);
        }
        this.bitness = bitness;
        this.jdk = jdk;
        this.descriptor = descriptor;
        this.arch = arch;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getMicro() {
        return this.micro;
    }

    public Integer getBitness() {
        return this.bitness;
    }

    public String getArch() {
        return this.arch;
    }

    public Boolean isJDK() {
        return this.jdk;
    }

    public Boolean isDescriptor() {
        return this.descriptor;
    }

    public String getQuery() {
        return String.valueOf(JREFilter.safe(JREManager.OS_TYPE.ordinal())) + "_" + JREFilter.safe(this.major) + "_" + JREFilter.safe(this.minor) + "_" + JREFilter.safe(this.micro) + "_" + JREFilter.safe(this.bitness) + "_" + (Boolean.TRUE.equals(this.jdk) ? "1" : "0");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.major != null) {
            builder.append(this.major);
        }
        if (this.minor != null) {
            builder.append("." + this.minor);
        }
        if (this.micro != null) {
            builder.append("." + this.micro);
        }
        if (this.bitness != null) {
            if (builder.length() != 0) {
                builder.append(" ");
            }
            builder.append(this.bitness);
            builder.append(" Bit");
        }
        if (builder.length() != 0) {
            builder.append(" ");
        }
        if (!StringUtil.isEmpty((String)this.arch)) {
            builder.append(this.arch);
            builder.append(" ");
        }
        if (this.jdk != null) {
            builder.append(this.jdk != false ? " JDK" : " JRE");
        } else {
            builder.append("VM");
        }
        return builder.toString();
    }

    private static Integer getSegment(String[] tokens, int i) {
        if (tokens.length > i) {
            try {
                return Integer.parseInt(tokens[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String safe(Integer parameter) {
        return parameter == null ? "0" : parameter.toString();
    }
}

