/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.internal.views.markers.GroupFilterConfigurationArea;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkerTypeFieldFilter;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;

public class TypesConfigurationArea
extends GroupFilterConfigurationArea {
    private static Collection<MarkerTypeEntry> EMPTY_COLLECTION = new HashSet<MarkerTypeEntry>();
    private HashMap<MarkerFieldFilterGroup, List<TypesEntry>> models = new HashMap(0);
    private CheckboxTreeViewer typesViewer;

    @Override
    public void apply(MarkerFieldFilter filter) {
        ArrayList<MarkerType> selectedTypes = new ArrayList<MarkerType>();
        Object[] objectArray = this.typesViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof MarkerTypeEntry) {
                selectedTypes.add(((MarkerTypeEntry)checkedElement).getMarkerType());
            }
            ++n2;
        }
        MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)this.typesViewer.getInput();
        ((MarkerTypeFieldFilter)filter).setSelectedTypes(selectedTypes, group.generator);
    }

    @Override
    public void applyToGroup(MarkerFieldFilterGroup group) {
    }

    @Override
    public void createContents(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        Tree tree = new Tree(parent, 68386);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(false);
        this.typesViewer = new CheckboxTreeViewer(tree);
        this.initializeFontMetrics((Control)tree);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)100);
        gridData.heightHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.getFontMetrics(), (int)50);
        final ITreeContentProvider typesContentProvider = this.getTypesContentProvider();
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)typesContentProvider);
        this.typesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((TypesEntry)element).getLabel();
            }
        });
        this.typesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((TypesEntry)e1).getLabel().compareTo(((TypesEntry)e2).getLabel());
            }
        });
        this.typesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                boolean checked = event.getChecked();
                TypesConfigurationArea.this.typesViewer.setGrayed(element, false);
                this.setChildrenChecked(element, checked);
                this.setParentCheckState(element, checked);
            }

            private void setChildrenChecked(Object element, boolean checked) {
                Object[] children = typesContentProvider.getChildren(element);
                if (children.length > 0) {
                    Object[] objectArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        TypesConfigurationArea.this.typesViewer.setChecked(child, checked);
                        ++n2;
                    }
                }
            }

            private void setParentCheckState(Object element, boolean checked) {
                Object parentType = typesContentProvider.getParent(element);
                if (parentType == null) {
                    return;
                }
                Object[] objectArray = typesContentProvider.getChildren(parentType);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (TypesConfigurationArea.this.typesViewer.getChecked(child) != checked) {
                        TypesConfigurationArea.this.typesViewer.setGrayChecked(parentType, true);
                        return;
                    }
                    ++n2;
                }
                TypesConfigurationArea.this.typesViewer.setGrayed(parentType, false);
                TypesConfigurationArea.this.typesViewer.setChecked(parentType, checked);
            }
        });
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)buttonsData);
        Button selectAllButton = new Button(buttonComposite, 8);
        selectAllButton.setText(MarkerMessages.filtersDialog_selectAllTypes);
        selectAllButton.addSelectionListener(this.getSelectAllButtonListener(typesContentProvider, true));
        this.setButtonLayoutData(selectAllButton);
        Button deselectAllButton = new Button(buttonComposite, 8);
        deselectAllButton.setText(MarkerMessages.filtersDialog_deselectAllTypes);
        deselectAllButton.addSelectionListener(this.getSelectAllButtonListener(typesContentProvider, false));
        this.setButtonLayoutData(deselectAllButton);
    }

    @Override
    public boolean grabExcessVerticalSpace() {
        return true;
    }

    private SelectionListener getSelectAllButtonListener(final ITreeContentProvider typesContentProvider, final boolean checked) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = typesContentProvider.getElements(TypesConfigurationArea.this.typesViewer.getInput());
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    TypesConfigurationArea.this.typesViewer.setSubtreeChecked(element, checked);
                    ++n2;
                }
            }
        };
    }

    protected List<TypesEntry> elementsForGroup(MarkerFieldFilterGroup group) {
        if (this.models.containsKey(group)) {
            return this.models.get(group);
        }
        Iterator<MarkerType> roots = group.getAllTypes().iterator();
        ArrayList<TypesEntry> markerNodes = new ArrayList<TypesEntry>();
        HashMap<String, CategoryEntry> categories = new HashMap<String, CategoryEntry>();
        while (roots.hasNext()) {
            CategoryEntry category;
            MarkerType markerType = roots.next();
            String categoryName = MarkerSupportRegistry.getInstance().getCategory(markerType.getId());
            if (categoryName == null) {
                markerNodes.add(new MarkerTypeEntry(markerType));
                continue;
            }
            if (categories.containsKey(categoryName)) {
                category = (CategoryEntry)categories.get(categoryName);
            } else {
                category = new CategoryEntry(categoryName);
                categories.put(categoryName, category);
                markerNodes.add(category);
            }
            MarkerTypeEntry node = new MarkerTypeEntry(markerType);
            category.add(node);
        }
        this.models.put(group, markerNodes);
        return markerNodes;
    }

    private void findTypeEntries(MarkerFieldFilterGroup group, Collection<TypesEntry> entries, Collection<TypesEntry> greyEntries) {
        Iterator<TypesEntry> elements = this.elementsForGroup(group).iterator();
        Collection<MarkerType> selectedTypes = ((MarkerTypeFieldFilter)group.getFilter(this.getField())).getSelectedTypes();
        block0: while (elements.hasNext()) {
            TypesEntry entry = elements.next();
            entry.addElementsMatching(selectedTypes, entries);
            if (!entry.hasChildren()) continue;
            Collection<MarkerTypeEntry> children = entry.getChildren();
            if (entries.containsAll(children)) {
                entries.add(entry);
                continue;
            }
            Iterator<MarkerTypeEntry> iterator = children.iterator();
            while (iterator.hasNext()) {
                if (!entries.contains(iterator.next())) continue;
                greyEntries.add(entry);
                continue block0;
            }
        }
    }

    private ITreeContentProvider getTypesContentProvider() {
        return new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return ((TypesEntry)parentElement).getChildren().toArray();
            }

            public Object[] getElements(Object inputElement) {
                return TypesConfigurationArea.this.elementsForGroup((MarkerFieldFilterGroup)inputElement).toArray();
            }

            public Object getParent(Object element) {
                return ((TypesEntry)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((TypesEntry)element).hasChildren();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    @Override
    public void initialize(MarkerFieldFilter filter) {
    }

    @Override
    public void initializeFromGroup(MarkerFieldFilterGroup group) {
        this.typesViewer.setInput((Object)group);
        this.typesViewer.refresh();
        HashSet<TypesEntry> checked = new HashSet<TypesEntry>();
        HashSet<TypesEntry> greyed = new HashSet<TypesEntry>();
        this.findTypeEntries(group, checked, greyed);
        checked.addAll(greyed);
        this.typesViewer.setCheckedElements(checked.toArray());
        this.typesViewer.setGrayedElements(greyed.toArray());
    }

    @Override
    public String getTitle() {
        return MarkerMessages.filtersDialog_typesTitle;
    }

    private class CategoryEntry
    extends TypesEntry {
        private Collection<MarkerTypeEntry> children = new ArrayList<MarkerTypeEntry>();
        private String name;

        public CategoryEntry(String categoryName) {
            this.name = categoryName;
        }

        public void add(MarkerTypeEntry node) {
            this.children.add(node);
            node.setParent(this);
        }

        @Override
        public void addElementsMatching(Collection<MarkerType> selectedTypes, Collection<TypesEntry> entries) {
            Iterator<MarkerTypeEntry> childIterator = this.children.iterator();
            while (childIterator.hasNext()) {
                childIterator.next().addElementsMatching(selectedTypes, entries);
            }
        }

        @Override
        public Collection<MarkerTypeEntry> getChildren() {
            return this.children;
        }

        @Override
        public String getLabel() {
            return this.name;
        }

        @Override
        public TypesEntry getParent() {
            return null;
        }

        @Override
        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    private class MarkerTypeEntry
    extends TypesEntry {
        private CategoryEntry category;
        private MarkerType markerType;

        public MarkerTypeEntry(MarkerType markerType) {
            this.markerType = markerType;
        }

        @Override
        public void addElementsMatching(Collection<MarkerType> selectedTypes, Collection<TypesEntry> entries) {
            if (selectedTypes.contains(this.markerType)) {
                entries.add(this);
            }
        }

        @Override
        public Collection<MarkerTypeEntry> getChildren() {
            return EMPTY_COLLECTION;
        }

        @Override
        public String getLabel() {
            return this.markerType.getLabel();
        }

        public MarkerType getMarkerType() {
            return this.markerType;
        }

        @Override
        public TypesEntry getParent() {
            return this.category;
        }

        @Override
        public boolean hasChildren() {
            return false;
        }

        public void setParent(CategoryEntry categoryEntry) {
            this.category = categoryEntry;
        }
    }

    private static abstract class TypesEntry {
        private TypesEntry() {
        }

        public abstract void addElementsMatching(Collection<MarkerType> var1, Collection<TypesEntry> var2);

        public abstract Collection<MarkerTypeEntry> getChildren();

        public abstract String getLabel();

        public abstract TypesEntry getParent();

        public abstract boolean hasChildren();
    }
}

