/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.cwt.v.VButton;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class VTracker
implements DisposeListener {
    private static VTracker tracker;
    private static Boolean lock;
    private Map<Composite, VPanel> panels;
    private VControl activeControl = null;
    private Listener filter = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 31: {
                    VTracker.this.lastTraverse = event.detail;
                    if (16 != event.detail && 8 != event.detail || VTracker.this.focusControl == null) break;
                    event.doit = true;
                    VTracker.this.focusControl.handleEvent(event);
                    if (!event.doit) break;
                    Composite comp = VTracker.this.focusControl.getWidget();
                    if (16 == event.detail) {
                        VTracker.setFocusToNext(comp);
                        break;
                    }
                    VTracker.setFocusToPrev(comp);
                    break;
                }
                case 15: {
                    VTracker.this.setFocusControl(VTracker.getVControl(event.widget));
                    break;
                }
                case 3: {
                    VTracker.this.mouseButton = event.button;
                    VTracker.this.mouseDown = new Point(event.x, event.y);
                    if (VTracker.this.activeControl == null || !VTracker.this.activeControl.setState(32, true)) break;
                    VTracker.this.activeControl.redraw();
                    break;
                }
                case 5: {
                    if (VTracker.this.panels.containsKey(event.widget)) {
                        VControl vcontrol = ((VPanel)VTracker.this.panels.get(event.widget)).getControl(event.x, event.y, true);
                        if (vcontrol == VTracker.this.activeControl || vcontrol != null && !vcontrol.isEnabled()) break;
                        VTracker.this.activate(vcontrol);
                        break;
                    }
                    if (VTracker.this.activeControl == null || event.widget == VTracker.this.activeControl.getControl()) break;
                    VTracker.this.activeControl.deactivate();
                    VTracker.this.activeControl = null;
                    break;
                }
                case 4: {
                    VTracker.this.mouseButton = -1;
                    VTracker.this.mouseDown = null;
                    if (VTracker.this.activeControl == null || !VTracker.this.activeControl.setState(32, false)) break;
                    VTracker.this.activeControl.redraw();
                }
            }
        }
    };
    private VControl focusControl = null;
    private boolean listening = false;
    private int mouseButton = -1;
    private Point mouseDown = null;
    private int lastTraverse = -1;

    static {
        lock = new Boolean(true);
    }

    static void addTopLevelPanel(VPanel panel) {
        VTracker tracker = VTracker.instance();
        if (tracker.panels == null) {
            tracker.panels = new HashMap<Composite, VPanel>();
        }
        tracker.panels.put(panel.composite, panel);
        if (!tracker.listening) {
            tracker.listening = true;
            Display.getDefault().addFilter(15, tracker.filter);
            Display.getDefault().addFilter(5, tracker.filter);
            Display.getDefault().addFilter(3, tracker.filter);
            Display.getDefault().addFilter(4, tracker.filter);
            Display.getDefault().addFilter(31, tracker.filter);
        }
        panel.composite.addDisposeListener((DisposeListener)tracker);
    }

    public static void deactivate() {
        VTracker.instance().deactivate(VTracker.getActiveControl());
    }

    public static int getLastTraverse() {
        return VTracker.instance().lastTraverse;
    }

    public static int getMouseDownButton() {
        return VTracker.instance().mouseButton;
    }

    public static Point getMouseDownLocation() {
        return VTracker.instance().mouseDown;
    }

    public static boolean isFocusControl(Control control) {
        VControl focusControl = VTracker.instance().focusControl;
        return focusControl != null && focusControl.isSameWidgetAs((Widget)control);
    }

    public static boolean isMouseDown() {
        return VTracker.instance().mouseDown != null;
    }

    public static VControl getFocusControl() {
        return VTracker.instance().focusControl;
    }

    public static VControl getActiveControl() {
        return VTracker.instance().activeControl;
    }

    private static boolean setFocusFromPrev(Control control) {
        Control c = null;
        Composite parent = control.getParent();
        if (parent == null) {
            c = control;
        } else {
            Control[] ca = parent.getTabList();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] == control) {
                    if (i == ca.length - 1) {
                        c = ca[0];
                        break;
                    }
                    c = ca[i + 1];
                    break;
                }
                ++i;
            }
        }
        if (c != null) {
            c.setFocus();
        }
        return false;
    }

    private static boolean setFocusFromNext(Control control) {
        Control c = null;
        Composite parent = control.getParent();
        if (parent == null) {
            c = control;
        } else {
            Control[] ca = parent.getTabList();
            int i = 0;
            while (i < ca.length) {
                if (ca[i] == control) {
                    if (i == 0) {
                        c = ca[ca.length - 1];
                        break;
                    }
                    c = ca[i - 1];
                    break;
                }
                ++i;
            }
        }
        if (c != null) {
            c.setFocus();
        }
        return false;
    }

    private static void setFocusToNext(Composite comp) {
        block11: {
            if (comp == null) break block11;
            Composite parent = comp.getParent();
            Control[] controls = parent.getTabList();
            if (parent instanceof Shell) {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        int j = 0;
                        while (j < controls.length) {
                            if (++i > controls.length - 1) {
                                i = 0;
                            }
                            if (controls[i].forceFocus()) {
                                return;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        while (i < controls.length - 1) {
                            if (controls[i + 1].forceFocus()) {
                                return;
                            }
                            ++i;
                        }
                        VTracker.setFocusToNext(comp.getParent());
                    }
                    ++i;
                }
            }
        }
    }

    private static void setFocusToPrev(Composite comp) {
        block11: {
            if (comp == null) break block11;
            Composite parent = comp.getParent();
            Control[] controls = parent.getTabList();
            if (parent instanceof Shell) {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        int j = 0;
                        while (j < controls.length) {
                            if (--i < 0) {
                                i = controls.length - 1;
                            }
                            if (controls[i].forceFocus()) {
                                return;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < controls.length) {
                    if (controls[i] == comp) {
                        int j = i;
                        while (j > 0) {
                            if (controls[j - 1].forceFocus()) {
                                return;
                            }
                            --j;
                        }
                        VTracker.setFocusToPrev(comp.getParent());
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VTracker instance() {
        if (tracker == null) {
            Boolean bl = lock;
            synchronized (bl) {
                if (tracker == null) {
                    tracker = new VTracker();
                }
            }
        }
        return tracker;
    }

    public static VControl getVControl(Widget widget) {
        Object o;
        Control[] ca;
        if (widget instanceof Shell && (ca = ((Shell)widget).getTabList()).length > 0) {
            widget = ca[0];
        }
        if ((o = widget.getData("cwt_vcontrol")) instanceof VControl) {
            return (VControl)o;
        }
        return null;
    }

    private VTracker() {
    }

    void activate(VControl vcontrol) {
        if (this.activeControl != null && !this.activeControl.isDisposed()) {
            this.activeControl.deactivate();
        }
        this.activeControl = vcontrol;
        if (this.activeControl != null) {
            this.activeControl.activate();
        }
    }

    void deactivate(VControl vcontrol) {
        if (vcontrol != null) {
            if (!vcontrol.isDisposed()) {
                vcontrol.deactivate();
            }
            if (this.activeControl == vcontrol) {
                this.activeControl = null;
            }
        }
    }

    private VControl getNewFocus(VPanel panel) {
        VControl[] vControlArray = panel.getChildren();
        int n = vControlArray.length;
        int n2 = 0;
        while (n2 < n) {
            VControl child = vControlArray[n2];
            if (!child.hasStyle(524288)) {
                if (child instanceof VPanel) {
                    VControl newFocus = this.getNewFocus((VPanel)child);
                    if (newFocus != null) {
                        return newFocus;
                    }
                } else {
                    return child;
                }
            }
            ++n2;
        }
        return null;
    }

    boolean setFocusControl(VControl control) {
        VControl newFocus = control;
        if (newFocus instanceof VPanel) {
            newFocus = this.getNewFocus((VPanel)newFocus);
        } else if (control != null && control.hasStyle(524288)) {
            return false;
        }
        if (newFocus == this.focusControl) {
            if (newFocus != null && !newFocus.isDisposed()) {
                return newFocus.getControl().forceFocus();
            }
            return false;
        }
        try {
            Display.getDefault().removeFilter(15, this.filter);
            VControl oldFocus = this.focusControl;
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.setFocus(false);
            }
            if (newFocus != null) {
                if (!newFocus.isDisposed() && newFocus.setFocus(true)) {
                    if (!newFocus.getControl().forceFocus()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            this.focusControl = newFocus;
            if (newFocus != null) {
                newFocus.redraw();
            }
            if (oldFocus != null && !oldFocus.isDisposed()) {
                oldFocus.redraw();
            }
            this.notifyWidgetFocusListeners(this.focusControl, oldFocus);
            return newFocus != null;
            {
            }
        }
        finally {
            Display.getDefault().addFilter(15, this.filter);
        }
    }

    private void notifyWidgetFocusListeners(VControl newFocus, VControl oldFocus) {
        Event event;
        Composite widget;
        if (newFocus != null && !newFocus.isSameWidgetAs(oldFocus) && (widget = newFocus.getWidget()).getData("cwt_focus") == null) {
            widget.setData("cwt_focus", (Object)this);
            event = new Event();
            event.widget = widget;
            event.data = this;
            event.type = 15;
            event.widget.notifyListeners(15, event);
        }
        if (!(newFocus != null && newFocus instanceof VButton && ((VButton)newFocus).getParent().getData("PickerPart") != null || oldFocus == null || oldFocus.isSameWidgetAs(newFocus) || (widget = oldFocus.getWidget()).getData("cwt_focus") == null)) {
            widget.setData("cwt_focus", null);
            event = new Event();
            event.widget = widget;
            event.data = this;
            event.type = 16;
            event.widget.notifyListeners(16, event);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        VTracker tracker = VTracker.instance();
        if (tracker.panels != null && tracker.panels.containsKey(e.widget)) {
            tracker.panels.remove(e.widget);
            if (tracker.panels.isEmpty()) {
                Control control;
                Display.getDefault().removeFilter(15, tracker.filter);
                Display.getDefault().removeFilter(5, tracker.filter);
                Display.getDefault().removeFilter(3, tracker.filter);
                Display.getDefault().removeFilter(4, tracker.filter);
                Display.getDefault().removeFilter(31, tracker.filter);
                tracker.listening = false;
                if (this.activeControl != null && (control = this.activeControl.getControl()) != null && !control.isDisposed()) {
                    control.dispose();
                }
                tracker.panels = null;
            }
        }
    }
}

