/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.ThreadPool;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class P2Indexer
implements IApplication {
    private static final String CHARSET = "UTF-8";
    private final Map<URI, Repository> repositories = new ConcurrentHashMap<URI, Repository>();
    private final Map<String, List<Capability>> capabilities = new HashMap<String, List<Capability>>();
    private final Map<String, Set<String>> capabilityIndex = new HashMap<String, Set<String>>();
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private final Queue<SAXParser> parserPool = new ConcurrentLinkedQueue<SAXParser>();
    private final ThreadPool threadPool = new ThreadPool();
    private final long timeStamp = System.currentTimeMillis();
    private int refreshHours = 24;
    private URI baseURI;
    private int maxRepos = Integer.MAX_VALUE;
    private boolean checkTimeStamps;
    private boolean verbose;
    private Reporter reporter;

    public Object start(IApplicationContext context) throws Exception {
        long start = System.currentTimeMillis();
        String[] args = (String[])context.getArguments().get("application.args");
        LinkedList<String> arguments = new LinkedList<String>(Arrays.asList(args));
        try {
            File scanFolder = new File(arguments.removeFirst()).getCanonicalFile();
            this.refreshHours = Integer.parseInt(arguments.removeFirst());
            this.baseURI = URI.createURI((String)arguments.removeFirst());
            File outputFolder = new File(arguments.removeFirst()).getCanonicalFile();
            while (!arguments.isEmpty()) {
                String arg = arguments.removeFirst();
                if ("-maxRepos".equalsIgnoreCase(arg) || "-m".equals(arg)) {
                    this.maxRepos = Integer.parseInt(arguments.removeFirst());
                    continue;
                }
                if ("-verbose".equalsIgnoreCase(arg) || "-v".equals(arg)) {
                    this.verbose = true;
                    continue;
                }
                if ("-checkTimeStamps".equalsIgnoreCase(arg)) {
                    this.checkTimeStamps = true;
                    continue;
                }
                if (!"-report".equalsIgnoreCase(arg) && !"-r".equals(arg)) continue;
                File reportFolder = new File(arguments.removeFirst());
                this.reporter = new Reporter(this.baseURI.toString(), reportFolder);
            }
            if (this.baseURI.hasTrailingPathSeparator()) {
                this.baseURI = this.baseURI.trimSegments(1);
            }
            System.out.println();
            System.out.println("Starting analysis: " + new Date(start));
            this.scanFolder(scanFolder, this.baseURI);
            this.threadPool.awaitFinished();
            this.generateRepositoryMetadata();
            this.threadPool.awaitFinished();
            long end = System.currentTimeMillis();
            System.out.println("Analysis finished after " + (end - start) / 1000L + " seconds.");
            System.out.println();
            System.out.println("Generating index to " + outputFolder);
            this.generateIndex(outputFolder);
            System.out.println("Finished after " + (System.currentTimeMillis() - end) / 1000L + " seconds.");
            if (this.reporter != null) {
                System.out.println();
                System.out.println("Writing report to " + this.reporter.getReportFolder());
                this.reporter.writeReport(this, start, end - start);
            }
        }
        finally {
            System.out.println();
            System.out.println("Overall duration: " + (System.currentTimeMillis() - start) / 1000L + " seconds.");
            System.out.println();
            this.threadPool.shutdown();
        }
        return null;
    }

    public void stop() {
    }

    private void scanFolder(final File folder, final URI uri) {
        if (this.repositories.size() >= this.maxRepos) {
            return;
        }
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                File metadataFile = P2Indexer.this.getMetadataFile(folder);
                if (metadataFile != null) {
                    if (P2Indexer.this.verbose) {
                        System.out.println("Found " + metadataFile);
                    }
                    if (metadataFile.getName().startsWith("composite")) {
                        P2Indexer.this.repositories.put(uri, new Repository.Composite(P2Indexer.this, uri, metadataFile));
                    } else {
                        P2Indexer.this.repositories.put(uri, new Repository.Simple(P2Indexer.this, uri, metadataFile));
                    }
                }
            }
        });
        Object[] children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return P2Indexer.isValidFolder(file);
            }
        });
        if (children != null) {
            Arrays.sort(children);
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String encodedName;
                Object child = objectArray[n2];
                String name = ((File)child).getName();
                if (name.equals(URI.decode((String)(encodedName = URI.encodeSegment((String)name, (boolean)false))))) {
                    this.threadPool.submit(new Runnable((File)child, uri, encodedName){
                        private final /* synthetic */ File val$child;
                        private final /* synthetic */ URI val$uri;
                        private final /* synthetic */ String val$encodedName;
                        {
                            this.val$child = file;
                            this.val$uri = uRI;
                            this.val$encodedName = string;
                        }

                        @Override
                        public void run() {
                            P2Indexer.this.scanFolder(this.val$child, this.val$uri.appendSegment(this.val$encodedName));
                        }
                    });
                } else {
                    System.err.println("Can't encode " + child);
                }
                ++n2;
            }
        }
    }

    private File getMetadataFile(File folder) {
        File file;
        Map properties;
        String factoryOrder;
        File p2IndexFile = new File(folder, "p2.index");
        if (p2IndexFile.canRead() && (factoryOrder = (String)(properties = PropertiesUtil.loadProperties((File)p2IndexFile)).get("metadata.repository.factory.order")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(factoryOrder, ",");
            while (tokenizer.hasMoreTokens()) {
                File file2;
                String factory = tokenizer.nextToken();
                if ("!".equals(factory)) break;
                if ("content.xml".equals(factory)) {
                    file2 = new File(folder, "content.jar");
                    if (file2.isFile()) {
                        return file2;
                    }
                    file2 = new File(folder, "content.xml");
                    if (file2.isFile()) {
                        return file2;
                    }
                }
                if (!"compositeContent.xml".equals(factory)) continue;
                file2 = new File(folder, "compositeContent.jar");
                if (file2.isFile()) {
                    return file2;
                }
                file2 = new File(folder, "compositeContent.xml");
                if (!file2.isFile()) continue;
                return file2;
            }
        }
        if ((file = new File(folder, "content.jar")).isFile()) {
            return file;
        }
        file = new File(folder, "content.xml");
        if (file.isFile()) {
            return file;
        }
        file = new File(folder, "compositeContent.jar");
        if (file.isFile()) {
            return file;
        }
        file = new File(folder, "compositeContent.xml");
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    private void generateRepositoryMetadata() {
        for (final Repository repository : this.repositories.values()) {
            this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    if (P2Indexer.this.verbose) {
                        System.out.println("Processing " + repository.getMetadataFile());
                    }
                    SAXParser parser = null;
                    try {
                        try {
                            parser = P2Indexer.this.acquireParser();
                            repository.processsMetadata(parser);
                        }
                        catch (FileNotFoundException ex) {
                            URI uri = repository.getURI();
                            P2Indexer.this.repositories.remove(uri);
                            if (P2Indexer.this.verbose) {
                                System.out.println(uri + " --> Metadata file has been deleted");
                            }
                            if (parser != null) {
                                P2Indexer.this.releaseParser(parser);
                            }
                        }
                        catch (Exception ex) {
                            String message = P2Indexer.getStackTrace(ex);
                            if (P2Indexer.this.reporter != null) {
                                P2Indexer.this.reporter.reportError(repository, message);
                            }
                            System.err.println(repository.getURI() + " --> " + message);
                            if (parser != null) {
                                P2Indexer.this.releaseParser(parser);
                            }
                        }
                    }
                    finally {
                        if (parser != null) {
                            P2Indexer.this.releaseParser(parser);
                        }
                    }
                }
            });
        }
    }

    private SAXParser acquireParser() throws ParserConfigurationException, SAXException {
        SAXParser parser = this.parserPool.poll();
        if (parser == null) {
            parser = this.parserFactory.newSAXParser();
        }
        return parser;
    }

    private void releaseParser(SAXParser parser) {
        this.parserPool.add(parser);
    }

    private void generateIndex(File outputFolder) throws Exception {
        int id = 0;
        for (Repository repository : this.repositories.values()) {
            repository.setID(++id);
        }
        outputFolder.mkdirs();
        int count = this.writeCapabilities(outputFolder);
        this.writeRepositories(outputFolder);
        this.writeCapabilityIndex(outputFolder);
        System.out.println(String.valueOf(this.repositories.size()) + " repositories");
        System.out.println(String.valueOf(count) + " capabilities");
    }

    private void writeCapabilityIndex(File outputFolder) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileOutputStream outputStream = null;
        try {
            File capabilitiesFile = new File(outputFolder, "capabilities");
            outputStream = new FileOutputStream(capabilitiesFile);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
            options.put("DATA_CONVERTER", Boolean.TRUE);
            options.put("BUFFER_CAPACITY", 8192);
            BinaryResourceImpl.EObjectOutputStream stream = new BinaryResourceImpl.EObjectOutputStream((OutputStream)outputStream, options);
            stream.writeInt(this.refreshHours);
            stream.writeCompressedInt(this.capabilityIndex.size());
            for (Map.Entry<String, Set<String>> entry : this.capabilityIndex.entrySet()) {
                Set<String> values = entry.getValue();
                stream.writeSegmentedString(entry.getKey());
                stream.writeCompressedInt(values.size());
                for (String value : values) {
                    stream.writeSegmentedString(value);
                }
            }
            stream.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)outputStream);
    }

    private void writeRepositories(File outputFolder) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileOutputStream outputStream = null;
        try {
            File repositoriesFile = new File(outputFolder, "repositories");
            outputStream = new FileOutputStream(repositoriesFile);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
            options.put("DATA_CONVERTER", Boolean.TRUE);
            options.put("BUFFER_CAPACITY", 8192);
            BinaryResourceImpl.EObjectOutputStream stream = new BinaryResourceImpl.EObjectOutputStream((OutputStream)outputStream, options);
            stream.writeLong(this.timeStamp);
            stream.writeInt(this.refreshHours);
            stream.writeInt(this.repositories.size());
            ArrayList<Repository> problematicRepositories = new ArrayList<Repository>();
            for (Repository repository : this.repositories.values()) {
                repository.write(stream);
                if (repository.unresolvedChildren <= 0) continue;
                problematicRepositories.add(repository);
            }
            stream.writeInt(problematicRepositories.size());
            for (Repository repository : problematicRepositories) {
                stream.writeInt(repository.getID());
                stream.writeInt(repository.unresolvedChildren);
            }
            stream.flush();
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)outputStream);
    }

    private int writeCapabilities(final File outputFolder) throws InterruptedException {
        for (final Map.Entry<String, List<Capability>> entry : this.capabilities.entrySet()) {
            this.threadPool.submit(new Runnable(){

                @Override
                public void run() {
                    P2Indexer.this.writeCapability(outputFolder, (String)entry.getKey(), (List)entry.getValue());
                }
            });
        }
        this.threadPool.awaitFinished();
        return this.capabilities.size();
    }

    private void writeCapability(File outputFolder, String name, List<Capability> capabilities) {
        if (this.verbose) {
            System.out.println("Capability " + name);
        }
        HashMap<Repository, HashSet<String>> versions = new HashMap<Repository, HashSet<String>>();
        for (Capability capability : capabilities) {
            Repository repository = capability.getRepository();
            if (!this.repositories.containsKey(repository.getURI())) continue;
            HashSet<String> set = (HashSet<String>)versions.get(repository);
            if (set == null) {
                set = new HashSet<String>();
                versions.put(repository, set);
            }
            set.add(capability.getVersion());
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(Long.toString(this.timeStamp));
        for (Map.Entry versionEntry : versions.entrySet()) {
            Repository repository = (Repository)versionEntry.getKey();
            StringBuilder builder = new StringBuilder();
            builder.append(repository.getID());
            for (String version : (Set)versionEntry.getValue()) {
                builder.append(",");
                builder.append(version);
            }
            lines.add(builder.toString());
        }
        try {
            File file = new File(outputFolder, name);
            file.getParentFile().mkdirs();
            IOUtil.writeLines((File)file, (String)CHARSET, lines);
        }
        catch (Exception ex) {
            System.err.println("Capability " + name + " --> " + P2Indexer.getStackTrace(ex));
        }
    }

    private static boolean isValidFolder(File folder) {
        try {
            return folder.isDirectory() && folder.getAbsoluteFile().equals(folder.getCanonicalFile());
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static String getStackTrace(Exception exception) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bytes);
            exception.printStackTrace(out);
            return bytes.toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    private static final class Capability {
        private final Repository repository;
        private final String version;

        public Capability(Repository repository, String version) {
            this.repository = repository;
            this.version = version;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public String getVersion() {
            return this.version;
        }
    }

    private static final class Reporter {
        private final File reportFolder;
        private final ProjectRegistry projectRegistry;
        private final ProjectMapper projectMapper;
        private final Map<String, Project> projectsByID = new HashMap<String, Project>();
        private final Map<Repository, Project> projectsByRepository = new HashMap<Repository, Project>();
        private final Project unassigned = new Project("_unassigned", "Unassigned Repositories");

        public Reporter(String baseURI, File reportFolder) {
            this.reportFolder = reportFolder;
            this.projectRegistry = new ProjectRegistry();
            this.projectMapper = new ProjectMapper(baseURI.toString());
        }

        public File getReportFolder() {
            return this.reportFolder;
        }

        public synchronized void reportRepository(Repository repository) {
            String projectID = this.projectMapper.getProjectID(repository.getURI());
            if (projectID != null) {
                Project project = this.projectsByID.get(projectID);
                if (project == null) {
                    String projectName = this.projectRegistry.getProjectName(projectID);
                    project = new Project(projectID, projectName);
                    this.projectsByID.put(projectID, project);
                }
                this.projectsByRepository.put(repository, project);
                project.addRepository(repository);
            } else {
                this.unassigned.addRepository(repository);
            }
        }

        public synchronized String reportError(Repository repository, String message) {
            Project project = this.projectsByRepository.get(repository);
            if (project != null) {
                project.addError(repository, message);
                message = String.valueOf(message) + " (" + project.getID() + ")";
            } else {
                this.unassigned.addError(repository, message);
            }
            return message;
        }

        public void writeReport(P2Indexer indexer, long start, long duration) throws IOException {
            HashMap<Repository, Set<Repository>> childrenMap = new HashMap<Repository, Set<Repository>>();
            HashMap<Repository, Pair<Project, Integer>> ids = new HashMap<Repository, Pair<Project, Integer>>();
            int nextID = 0;
            for (Repository repository : indexer.repositories.values()) {
                Project project = this.projectsByRepository.get(repository);
                ids.put(repository, Pair.create((Object)project, (Object)(++nextID)));
                for (Repository.Composite composite : repository.getComposites()) {
                    CollectionUtil.add(childrenMap, (Object)composite, (Object)repository);
                }
            }
            ArrayList<Project> projects = new ArrayList<Project>(this.projectsByID.values());
            Collections.sort(projects, new Comparator<Project>(){

                @Override
                public int compare(Project o1, Project o2) {
                    return o1.getLabel().toLowerCase().compareTo(o2.getLabel().toLowerCase());
                }
            });
            int projectRepos = 0;
            int erroneousProjects = 0;
            int erroneousRepos = 0;
            int totalErrors = 0;
            for (Project project : projects) {
                projectRepos += project.getTotalRepos();
                int erroneousProjectRepos = project.getErroneousRepos();
                erroneousRepos += erroneousProjectRepos;
                totalErrors += project.getTotalErrors();
                if (erroneousProjectRepos <= 0) continue;
                ++erroneousProjects;
            }
            BufferedWriter writer = null;
            try {
                this.reportFolder.mkdirs();
                this.writeCSS();
                writer = new BufferedWriter(new FileWriter(new File(this.reportFolder, "index.html")));
                writer.write("<html>\n");
                writer.write("<head>\n");
                writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"report.css\">\n");
                writer.write("</head>\n");
                writer.write("<body>\n");
                writer.write("<h1>Project Repository Reports</h1>\n");
                writer.write("<p class=\"meta\">Generated " + new Date(start) + ", took " + duration / 1000L + " seconds.</p>\n");
                writer.write("<table border=\"0\">\n");
                writer.write("<tr><td>Projects with repositories:</td><td align=\"right\">" + projects.size() + "</td><td rowspan=\"2\">&nbsp;&nbsp;&nbsp;<a class=\"button\" href=\"mailto:stepper@esc-net.de?cc=ed.merks@gmail.com&amp;subject=My%20project%20is%20missing\">Report missing project</a></td></tr>\n");
                if (erroneousProjects > 0) {
                    writer.write("<tr><td class=\"error\">Projects with erroneous repositories:</td><td class=\"error\" align=\"right\">" + erroneousProjects + "</td><td></td></tr>\n");
                }
                if (this.unassigned.getTotalRepos() > 0) {
                    writer.write("<tr><td><a href=\"" + this.unassigned.getFileName() + "\">Unassigned repositories</a>:</td><td align=\"right\">" + this.unassigned.getTotalRepos() + "</td><td></td></tr>\n");
                }
                writer.write("<tr><td>Total repositories:</td><td align=\"right\">" + projectRepos + "</td><td></td></tr>\n");
                if (erroneousRepos > 0) {
                    writer.write("<tr><td class=\"error\">Erroneous repositories:</td><td class=\"error\" align=\"right\">" + erroneousRepos + "</td><td></td></tr>\n");
                }
                if (totalErrors > 0) {
                    writer.write("<tr><td class=\"error\">Total errors:</td><td class=\"error\" align=\"right\">" + totalErrors + "</td><td></td></tr>\n");
                }
                writer.write("</table>\n");
                writer.write("<hr>\n");
                writer.write("<ul>\n");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.unassigned.writeReport(this.reportFolder, childrenMap, ids);
            for (Project project : projects) {
                if (!project.writeReport(this.reportFolder, childrenMap, ids) || writer == null) continue;
                int errors = project.getErroneousRepos();
                String suffix = errors > 0 ? "<span class=\"error\">&nbsp;&nbsp;&nbsp;" + errors + "&nbsp;erroneous&nbsp;" + (errors == 1 ? "repository" : "repositories") + "</span>" : "";
                writer.write("<li><a href=\"" + project.getID() + ".html\">" + project.getLabel() + "</a>" + suffix + "\n");
            }
            if (writer != null) {
                writer.write("</ul>\n");
                writer.write("</body>\n");
                writer.write("</html>\n");
                IOUtil.close((Closeable)writer);
            }
        }

        private void writeCSS() throws IOException {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(new File(this.reportFolder, "report.css")));
                writer.write("@import url('https://fonts.googleapis.com/css?family=Roboto:400,700');\n");
                writer.write("\n");
                writer.write("body {\n");
                writer.write("  font-family: 'Roboto', sans-serif;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write("h4 {\n");
                writer.write("  margin-left: 24px;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write(".button {\n");
                writer.write("  border: 1px solid gray;\n");
                writer.write("  border-radius: 3px;\n");
                writer.write("  box-shadow: 1px 1px 1px darkgray;\n");
                writer.write("  padding: 0.25ex 0.25em;\n");
                writer.write("  background-color: lightgray;\n");
                writer.write("  color: black;\n");
                writer.write("  font-weight: bold;\n");
                writer.write("  text-align: center;\n");
                writer.write("  text-decoration: none;\n");
                writer.write("  display: inline-block;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write(".error {\n");
                writer.write("  color: red;\n");
                writer.write("  font-weight: bold;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write(".meta {\n");
                writer.write("  color: gray;\n");
                writer.write("  font-size: 0.75em;\n");
                writer.write("  margin-top: -12px;\n");
                writer.write("  margin-bottom: 12px;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write("a:link {\n");
                writer.write("  text-decoration: none;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write("a:visited {\n");
                writer.write("  text-decoration: none;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write("a:hover {\n");
                writer.write("  text-decoration: underline;\n");
                writer.write("}\n");
                writer.write("\n");
                writer.write("a:active {\n");
                writer.write("  text-decoration: underline;\n");
                writer.write("}\n");
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
            IOUtil.close((Closeable)writer);
        }

        private static final class Project {
            private final String id;
            private final String name;
            private final Map<Repository, List<String>> repositories = Collections.synchronizedMap(new HashMap());

            public Project(String id, String name) {
                this.id = id;
                this.name = name;
            }

            public String getID() {
                return this.id;
            }

            public String getLabel() {
                return this.name != null && this.name.length() != 0 ? this.name : this.id;
            }

            public String getFileName() {
                return String.valueOf(this.id) + ".html";
            }

            public int getTotalRepos() {
                return this.repositories.size();
            }

            public int getComposedRepos() {
                int result = 0;
                for (Repository repository : this.repositories.keySet()) {
                    if (!repository.isComposed()) continue;
                    ++result;
                }
                return result;
            }

            public int getErroneousRepos() {
                int result = 0;
                for (List<String> errors : this.repositories.values()) {
                    if (errors.isEmpty()) continue;
                    ++result;
                }
                return result;
            }

            public int getTotalErrors() {
                int result = 0;
                for (List<String> errors : this.repositories.values()) {
                    result += errors.size();
                }
                return result;
            }

            public void addRepository(Repository repository) {
                this.repositories.put(repository, new ArrayList());
            }

            public void addError(Repository repository, String message) {
                List<String> errors = this.repositories.get(repository);
                errors.add(message);
            }

            public boolean writeReport(File folder, Map<Repository, Set<Repository>> childrenMap, Map<Repository, Pair<Project, Integer>> ids) {
                block16: {
                    if (this.repositories.isEmpty()) {
                        return false;
                    }
                    BufferedWriter writer = null;
                    try {
                        try {
                            ArrayList<Map.Entry<Repository, List<String>>> entries = new ArrayList<Map.Entry<Repository, List<String>>>(this.repositories.entrySet());
                            Collections.sort(entries, new Comparator<Map.Entry<Repository, List<String>>>(){

                                @Override
                                public int compare(Map.Entry<Repository, List<String>> o1, Map.Entry<Repository, List<String>> o2) {
                                    return o1.getKey().getURI().toString().compareTo(o2.getKey().getURI().toString());
                                }
                            });
                            int totalRepos = this.getTotalRepos();
                            int compositeRepos = this.getComposedRepos();
                            int simpleRepos = totalRepos - compositeRepos;
                            int erroneousRepos = this.getErroneousRepos();
                            int totalErrors = this.getTotalErrors();
                            folder.mkdirs();
                            writer = new BufferedWriter(new FileWriter(new File(folder, this.getFileName())));
                            writer.write("<html>\n");
                            writer.write("<head>\n");
                            writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"report.css\">\n");
                            writer.write("</head>\n");
                            writer.write("<body>\n");
                            writer.write("<h1><a href=\"https://projects.eclipse.org/projects/" + this.id + "\">" + (this.name != null && this.name.length() != 0 ? this.name : this.id) + "</a></h1>\n");
                            writer.write("<table border=\"0\">\n");
                            writer.write("<tr><td>Simple repositories:</td><td align=\"right\">" + simpleRepos + "</td><td></td></tr>\n");
                            writer.write("<tr><td>Composite repositories:</td><td align=\"right\">" + compositeRepos + "</td><td></td></tr>\n");
                            writer.write("<tr><td>Total repositories:</td><td align=\"right\">" + (simpleRepos + compositeRepos) + "</td><td></td></tr>\n");
                            if (totalErrors > 0) {
                                writer.write("<tr><td class=\"error\">Erroneous repositories:</td><td class=\"error\" align=\"right\">" + erroneousRepos + "</td><td rowspan=\"2\">" + (erroneousRepos > 0 ? "&nbsp;<a class=\"button\" href=\"#err0\">Goto first error</a>" : "") + "</td></tr>\n");
                                writer.write("<tr><td class=\"error\">Total errors:</td><td class=\"error\" align=\"right\">" + totalErrors + "</td><td></td></tr>\n");
                            }
                            writer.write("</table>\n");
                            writer.write("<hr>\n");
                            int erroneousRepo = 0;
                            for (Map.Entry entry : entries) {
                                List<Repository.Composite> composites;
                                Set<Repository> children;
                                Repository repository = (Repository)entry.getKey();
                                List errors = (List)entry.getValue();
                                Pair<Project, Integer> pair = ids.get(repository);
                                Integer idWrapper = (Integer)pair.getElement2();
                                int id = idWrapper;
                                writer.write("<h3><a name=\"repo" + id + "\">" + (errors.isEmpty() ? "" : "<a name=\"err" + erroneousRepo + "\">") + (repository.isComposed() ? "Composite" : "Simple") + " Repository <a href=\"" + repository.getURI() + "\">" + repository.getURI() + "</a></h3>\n");
                                writer.write("<ul>\n");
                                writer.write("<li><span style=\"white-space:nowrap;\">");
                                writer.write(new Date(repository.getTimestamp()).toString());
                                writer.write("</span>&nbsp;(");
                                writer.write(String.valueOf(repository.getTimestamp()));
                                writer.write(")\n");
                                if (repository.isCompressed()) {
                                    writer.write("<li>Compressed\n");
                                }
                                writer.write("<li>");
                                int iuCount = this.getIUCount(repository, childrenMap);
                                writer.write(String.valueOf(iuCount));
                                writer.write("&nbsp;installable&nbsp;");
                                writer.write(iuCount == 1 ? "unit" : "units");
                                writer.write("\n");
                                writer.write("<li>");
                                int capabilityCount = this.getCapabilityCount(repository, childrenMap);
                                writer.write(String.valueOf(capabilityCount));
                                writer.write("&nbsp;");
                                writer.write(capabilityCount == 1 ? "capability" : "capabilities");
                                writer.write("\n");
                                if (!errors.isEmpty()) {
                                    writer.write("<li class=\"error\">");
                                    writer.write(String.valueOf(errors.size()));
                                    writer.write("&nbsp;");
                                    writer.write(errors.size() == 1 ? "error" : "errors");
                                    writer.write("\n");
                                }
                                writer.write("</ul>\n");
                                if (!errors.isEmpty()) {
                                    writer.write("<h4>Errors</h4>\n");
                                    writer.write("<ul>\n");
                                    for (String error : errors) {
                                        writer.write("<li class=\"error\">" + error.replace("\n", "<br>") + "\n");
                                    }
                                    if (++erroneousRepo < erroneousRepos) {
                                        writer.write("<li><a class=\"button\" href=\"#err" + erroneousRepo + "\">Goto next error</a>\n");
                                    }
                                    writer.write("</ul>\n");
                                }
                                if ((children = childrenMap.get(repository)) != null && !children.isEmpty()) {
                                    writer.write("<h4>Children</h4>\n");
                                    writer.write("<ul>\n");
                                    for (Repository child : children) {
                                        writer.write("<li>");
                                        this.writeRepositoryLink(writer, child, ids);
                                        writer.write("\n");
                                    }
                                    writer.write("</ul>\n");
                                }
                                if ((composites = repository.getComposites()) == null || composites.isEmpty()) continue;
                                writer.write("<h4>Composites</h4>\n");
                                writer.write("<ul>\n");
                                for (Repository.Composite composite : composites) {
                                    writer.write("<li>");
                                    this.writeRepositoryLink(writer, composite, ids);
                                    writer.write("\n");
                                }
                                writer.write("</ul>\n");
                            }
                            writer.write("</body>\n");
                            writer.write("</html>\n");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            IOUtil.close(writer);
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(writer);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)writer);
                }
                return true;
            }

            private void writeRepositoryLink(BufferedWriter writer, Repository repository, Map<Repository, Pair<Project, Integer>> ids) throws IOException {
                Pair<Project, Integer> pair = ids.get(repository);
                Project project = (Project)pair.getElement1();
                int id = (Integer)pair.getElement2();
                String href = project != null ? String.valueOf(project == this ? "" : project.getFileName()) + "#repo" + id : repository.getURI().toString();
                writer.write("<a href=\"" + href + "\">" + repository.getURI() + "</a>");
            }

            private int getIUCount(Repository repository, Map<Repository, Set<Repository>> childrenMap) {
                if (repository instanceof Repository.Composite) {
                    int sum = 0;
                    Set<Repository> children = childrenMap.get(repository);
                    if (children != null && !children.isEmpty()) {
                        for (Repository child : children) {
                            sum += this.getIUCount(child, childrenMap);
                        }
                    }
                    return sum;
                }
                return repository.getIUCount();
            }

            private int getCapabilityCount(Repository repository, Map<Repository, Set<Repository>> childrenMap) {
                if (repository instanceof Repository.Composite) {
                    int sum = 0;
                    Set<Repository> children = childrenMap.get(repository);
                    if (children != null && !children.isEmpty()) {
                        for (Repository child : children) {
                            sum += this.getCapabilityCount(child, childrenMap);
                        }
                    }
                    return sum;
                }
                return repository.getCapabilityCount();
            }
        }

        private static final class ProjectMapper {
            private static final String MAPPINGS_TXT = System.getProperty("mappings.txt", "/home/data/httpd/download.eclipse.org/oomph/archive/projects/mappings.txt");
            private final URIMappingRegistryImpl registry = new URIMappingRegistryImpl();
            private final String baseURI;

            public ProjectMapper(String baseURI) {
                this.baseURI = baseURI;
                File file = new File(MAPPINGS_TXT);
                if (file.exists()) {
                    for (String line : IOUtil.readLines((File)file, (String)P2Indexer.CHARSET)) {
                        int tab = line.indexOf(9);
                        String path = line.substring(0, tab);
                        String project = line.substring(tab + 1);
                        this.registry.put((Object)this.createURI(path), (Object)URI.createURI((String)("project://" + project + "/")));
                    }
                } else {
                    System.out.println(String.valueOf(ProjectMapper.class.getSimpleName()) + ": " + MAPPINGS_TXT + " not found.");
                }
            }

            public String getProjectID(URI uri) {
                URI projectURI = this.registry.getURI(uri);
                if (projectURI != null && "project".equals(projectURI.scheme())) {
                    return projectURI.authority();
                }
                return null;
            }

            private URI createURI(String path) {
                if (!path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
                return URI.createURI((String)(String.valueOf(this.baseURI) + "/" + path));
            }
        }

        private static final class ProjectRegistry {
            private static final String PROJECTS_TXT = System.getProperty("projects.txt", "/home/data/httpd/download.eclipse.org/oomph/archive/projects/projects.txt");
            private final Map<String, String> names = new HashMap<String, String>();

            public ProjectRegistry() {
                File file = new File(PROJECTS_TXT);
                if (file.exists()) {
                    for (String line : IOUtil.readLines((File)file, (String)P2Indexer.CHARSET)) {
                        int tab = line.indexOf(9);
                        String id = line.substring(0, tab);
                        String name = line.substring(tab + 1);
                        this.names.put(id, name);
                    }
                } else {
                    System.out.println(String.valueOf(ProjectRegistry.class.getSimpleName()) + ": " + PROJECTS_TXT + " not found.");
                }
            }

            public String getProjectName(String id) {
                return this.names.get(id);
            }
        }
    }

    private static abstract class Repository
    extends DefaultHandler {
        private static final String XML_SUFFIX = ".xml";
        private static final String JAR_SUFFIX = ".jar";
        private static final long NO_TIMESTAMP = 0L;
        protected final List<Composite> composites = new ArrayList<Composite>();
        protected final P2Indexer indexer;
        protected final URI uri;
        protected final File metadataFile;
        protected final long timestamp;
        protected String elementPath;
        protected int id;
        protected int unresolvedChildren;

        public Repository(P2Indexer indexer, URI uri, File metadataFile) {
            this.indexer = indexer;
            this.uri = uri;
            this.metadataFile = metadataFile;
            this.timestamp = metadataFile.lastModified();
            if (indexer.reporter != null) {
                indexer.reporter.reportRepository(this);
            }
        }

        public File getMetadataFile() {
            return this.metadataFile;
        }

        public URI getURI() {
            return this.uri;
        }

        public int getID() {
            return this.id;
        }

        public void setID(int id) {
            this.id = id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<Composite> getComposites() {
            return this.composites;
        }

        public abstract boolean isComposed();

        public boolean isCompressed() {
            return this.metadataFile.getName().endsWith(JAR_SUFFIX);
        }

        public int getIUCount() {
            return 0;
        }

        public int getCapabilityCount() {
            return 0;
        }

        public void processsMetadata(SAXParser parser) throws IOException, SAXException {
            ZipFile jarFile = null;
            InputStream inputStream = null;
            try {
                if (this.isCompressed()) {
                    String name = this.metadataFile.getName();
                    name = String.valueOf(name.substring(0, name.length() - JAR_SUFFIX.length())) + XML_SUFFIX;
                    jarFile = new JarFile(this.metadataFile);
                    JarEntry jarEntry = ((JarFile)jarFile).getJarEntry(name);
                    inputStream = ((JarFile)jarFile).getInputStream(jarEntry);
                } else {
                    inputStream = new FileInputStream(this.metadataFile);
                }
                inputStream = new BufferedInputStream(inputStream);
                parser.parse(inputStream, (DefaultHandler)this);
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                if (jarFile != null) {
                    jarFile.close();
                }
                throw throwable;
            }
            IOUtil.close((Closeable)inputStream);
            if (jarFile != null) {
                jarFile.close();
            }
        }

        protected boolean startElement(String elementPath, Attributes attributes) {
            if (this.indexer.checkTimeStamps && "repository>properties>property".equals(elementPath)) {
                String name;
                if (this.timestamp == 0L && "p2.timestamp".equals(name = attributes.getValue("name"))) {
                    String value = attributes.getValue("value");
                    if (value != null) {
                        try {
                            Long.parseLong(value);
                        }
                        catch (NumberFormatException ex) {
                            String message = "Bad timestamp value '" + value + "'";
                            if (this.indexer.reporter != null) {
                                message = this.indexer.reporter.reportError(this, message);
                            }
                            System.err.println(this.uri + " --> " + message);
                        }
                    } else {
                        String message = "No timestamp value";
                        if (this.indexer.reporter != null) {
                            message = this.indexer.reporter.reportError(this, message);
                        }
                        System.err.println(this.uri + " --> " + message);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.elementPath = this.elementPath == null ? qName : String.valueOf(this.elementPath) + ">" + qName;
            this.startElement(this.elementPath, attributes);
        }

        @Override
        public final void endElement(String uri, String localName, String qName) throws SAXException {
            int pos = this.elementPath.lastIndexOf(62);
            this.elementPath = pos >= 0 ? this.elementPath.substring(0, pos) : null;
        }

        public void write(BinaryResourceImpl.EObjectOutputStream stream) throws IOException {
            stream.writeURI(this.uri);
            stream.writeBoolean(this.isComposed());
            stream.writeBoolean(this.isCompressed());
            stream.writeLong(this.timestamp);
            if (!this.isComposed()) {
                stream.writeInt(this.getCapabilityCount());
            }
            for (Composite composite : this.composites) {
                stream.writeBoolean(true);
                stream.writeInt(composite.getID());
            }
            stream.writeBoolean(false);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Repository other = (Repository)obj;
            return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
        }

        public String toString() {
            return this.uri.toString();
        }

        private static final class Composite
        extends Repository {
            public Composite(P2Indexer indexer, URI uri, File metadataFile) {
                super(indexer, uri, metadataFile);
            }

            @Override
            public boolean isComposed() {
                return true;
            }

            @Override
            protected boolean startElement(String elementPath, Attributes attributes) {
                String child;
                if (super.startElement(elementPath, attributes)) {
                    return true;
                }
                if ("repository>children>child".equals(elementPath) && !StringUtil.isEmpty((String)(child = attributes.getValue("location")))) {
                    Repository childRepository;
                    URI childURI = URI.createURI((String)child);
                    if (childURI.hasTrailingPathSeparator()) {
                        childURI = childURI.trimSegments(1);
                    }
                    if (childURI.scheme() != null && !"https".equals(childURI.scheme())) {
                        String message = "Child repository URI " + childURI + " is absolute and is not secure";
                        if (this.indexer.reporter != null) {
                            message = this.indexer.reporter.reportError(this, message);
                        }
                        System.err.println(this.uri + " --> " + message);
                    }
                    if (childURI.isRelative()) {
                        if ((childURI = childURI.resolve(this.uri.hasTrailingPathSeparator() ? this.uri : this.uri.appendSegment(""))).hasTrailingPathSeparator()) {
                            childURI = childURI.trimSegments(1);
                        }
                    } else if (!this.indexer.baseURI.scheme().equals(childURI.scheme()) && this.indexer.baseURI.authority().equals(childURI.authority())) {
                        childURI = this.indexer.baseURI.appendSegments(childURI.segments());
                    }
                    if ((childRepository = this.indexer.repositories.get(childURI)) != null) {
                        childRepository.composites.add(this);
                    } else if (this.indexer.baseURI.scheme().equals(childURI.scheme()) && this.indexer.baseURI.authority().equals(childURI.authority())) {
                        ++this.unresolvedChildren;
                        String message = "Child repository " + childURI + " not found";
                        if (this.indexer.reporter != null) {
                            message = this.indexer.reporter.reportError(this, message);
                        }
                        System.err.println(this.uri + " --> " + message);
                    }
                }
                return false;
            }
        }

        private static final class Simple
        extends Repository {
            private int iuCount;
            private int capabilityCount;

            public Simple(P2Indexer indexer, URI uri, File metadataFile) {
                super(indexer, uri, metadataFile);
            }

            @Override
            public boolean isComposed() {
                return false;
            }

            @Override
            public int getIUCount() {
                return this.iuCount;
            }

            @Override
            public int getCapabilityCount() {
                return this.capabilityCount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean startElement(String elementPath, Attributes attributes) {
                if (super.startElement(elementPath, attributes)) {
                    return true;
                }
                if ("repository>units>unit".equals(elementPath)) {
                    ++this.iuCount;
                } else if ("repository>units>unit>provides>provided".equals(elementPath)) {
                    String namespace = URI.encodeSegment((String)attributes.getValue("namespace"), (boolean)false);
                    String name = URI.encodeSegment((String)attributes.getValue("name"), (boolean)false);
                    String version = attributes.getValue("version");
                    String qualifiedName = String.valueOf(namespace) + "/" + name;
                    if (name.equals(".") || name.equals("..") || name.startsWith("file:")) {
                        if (this.indexer.verbose) {
                            System.err.println("Skipping " + qualifiedName);
                        }
                        return true;
                    }
                    Map<String, Set<String>> map = this.indexer.capabilityIndex;
                    synchronized (map) {
                        CollectionUtil.add(this.indexer.capabilityIndex, (Object)namespace, (Object)name);
                        List<Capability> list = this.indexer.capabilities.get(qualifiedName);
                        if (list == null) {
                            list = new ArrayList<Capability>();
                            this.indexer.capabilities.put(qualifiedName, list);
                        }
                        list.add(new Capability(this, version));
                        ++this.capabilityCount;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

