/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.Messages;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Snapshot;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.setup.internal.sync.Synchronizer;
import org.eclipse.oomph.setup.internal.sync.SynchronizerException;
import org.eclipse.oomph.setup.sync.RemoteData;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.setup.sync.SyncActionType;
import org.eclipse.oomph.setup.sync.SyncDelta;
import org.eclipse.oomph.setup.sync.SyncDeltaType;
import org.eclipse.oomph.setup.sync.SyncFactory;
import org.eclipse.oomph.setup.sync.SyncPackage;
import org.eclipse.oomph.setup.sync.SyncPolicy;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synchronization {
    private final ResourceSet resourceSet = SyncUtil.createResourceSet();
    private final Set<String> ids = new HashSet<String>();
    private final Map<String, String> preferenceIDs = new HashMap<String, String>();
    private final Synchronizer synchronizer;
    private final Snapshot.WorkingCopy remoteWorkingCopy;
    private final EMap<String, SyncPolicy> remotePolicies;
    private final Map<String, SyncDelta> remoteDeltas;
    private Snapshot.WorkingCopy localWorkingCopy;
    private Map<String, SyncDelta> localDeltas;
    private Map<String, SyncAction> actions;
    private Map<String, SyncAction> unresolvedActions;
    private boolean committed;
    private boolean disposed;
    private int lastID;

    public Synchronization(Synchronizer synchronizer, boolean deferLocal) throws IOException {
        this.synchronizer = synchronizer;
        synchronizer.syncStarted();
        this.remoteWorkingCopy = this.createWorkingCopy(DataProvider.Location.REMOTE);
        synchronizer.workingCopyCreated(this.remoteWorkingCopy);
        this.remotePolicies = this.getPolicies(this.remoteWorkingCopy);
        this.remoteDeltas = this.computeDeltas(DataProvider.Location.REMOTE);
        if (!deferLocal) {
            this.synchronizeLocal();
        }
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public EMap<String, SyncPolicy> getRemotePolicies() {
        return this.remotePolicies;
    }

    public Map<String, String> getPreferenceIDs() {
        return this.preferenceIDs;
    }

    public Map<String, SyncAction> synchronizeLocal() throws IOException {
        if (this.localWorkingCopy != null) {
            this.localWorkingCopy.dispose();
        }
        this.localWorkingCopy = this.createWorkingCopy(DataProvider.Location.LOCAL);
        this.synchronizer.workingCopyCreated(this.localWorkingCopy);
        this.localDeltas = this.computeDeltas(DataProvider.Location.LOCAL);
        this.actions = this.computeSyncActions();
        this.synchronizer.actionsComputed(this.actions);
        return this.actions;
    }

    private Snapshot.WorkingCopy createWorkingCopy(DataProvider.Location location) throws IOException {
        Snapshot snapshot = location.pick(this.synchronizer.getLocalSnapshot(), this.synchronizer.getRemoteSnapshot());
        Snapshot.WorkingCopy workingCopy = snapshot.createWorkingCopy();
        File oldFile = snapshot.getOldFile();
        this.unloadResource(oldFile);
        if (oldFile != null && !oldFile.exists()) {
            SyncUtil.inititalizeFile(oldFile, location.getDataType(), this.resourceSet);
        }
        File tmpFile = workingCopy.getTmpFile();
        this.unloadResource(tmpFile);
        File newFile = snapshot.getNewFile();
        if (!newFile.exists()) {
            SyncUtil.inititalizeFile(tmpFile, location.getDataType(), this.resourceSet);
        } else {
            IOUtil.copyFile((File)newFile, (File)tmpFile);
        }
        return workingCopy;
    }

    private EMap<String, SyncPolicy> getPolicies(Snapshot.WorkingCopy remoteWorkingCopy) {
        File file = remoteWorkingCopy.getTmpFile();
        RemoteData remoteData = (RemoteData)this.loadObject(file, DataProvider.Location.REMOTE.getDataType());
        return remoteData.getPolicies();
    }

    private boolean isIncluded(String id) {
        return SyncPolicy.EXCLUDE != this.remotePolicies.get((Object)id);
    }

    private Map<String, SyncDelta> computeDeltas(DataProvider.Location location) {
        EClass dataType = location.getDataType();
        Snapshot.WorkingCopy workingCopy = location.pick(this.localWorkingCopy, this.remoteWorkingCopy);
        Snapshot snapshot = workingCopy.getSnapshot();
        File oldFile = snapshot.getOldFile();
        File tmpFile = workingCopy.getTmpFile();
        CompoundTask oldData = oldFile != null ? (SetupTaskContainer)this.loadObject(oldFile, dataType) : SetupFactory.eINSTANCE.createCompoundTask();
        SetupTaskContainer newData = (SetupTaskContainer)this.loadObject(tmpFile, dataType);
        return this.compareTasks(location, (SetupTaskContainer)oldData, newData);
    }

    private Map<String, SyncAction> computeSyncActions() {
        SyncAction action;
        String id;
        HashMap<String, SyncAction> actions = new HashMap<String, SyncAction>();
        HashMap<String, SyncDelta> tmpRemoteDeltas = new HashMap<String, SyncDelta>(this.remoteDeltas);
        for (Map.Entry<String, SyncDelta> entry : this.localDeltas.entrySet()) {
            SyncDelta remoteDelta;
            id = entry.getKey();
            SyncDelta localDelta = entry.getValue();
            SyncAction action2 = this.compareDeltas(localDelta, remoteDelta = (SyncDelta)tmpRemoteDeltas.remove(id));
            if (action2 == null) continue;
            actions.put(id, action2);
        }
        for (SyncDelta syncDelta : tmpRemoteDeltas.values()) {
            id = syncDelta.getID();
            action = this.compareDeltas(null, syncDelta);
            actions.put(id, action);
        }
        for (Map.Entry<String, SyncDelta> entry : actions.entrySet()) {
            id = entry.getKey();
            action = (SyncAction)((Object)entry.getValue());
            new ActionAdapter(action, id);
        }
        return actions;
    }

    private SyncAction compareDeltas(SyncDelta localDelta, SyncDelta remoteDelta) {
        SyncDeltaType remoteDeltaType;
        SyncDeltaType localDeltaType = localDelta == null ? SyncDeltaType.UNCHANGED : localDelta.getType();
        SyncActionType actionType = this.compareDeltaTypes(localDeltaType, remoteDeltaType = remoteDelta == null ? SyncDeltaType.UNCHANGED : remoteDelta.getType());
        if (actionType == SyncActionType.NONE) {
            PreferenceTask localPreference = (PreferenceTask)localDelta.getNewTask();
            PreferenceTask remotePreference = (PreferenceTask)remoteDelta.getNewTask();
            actionType = ObjectUtil.equals((Object)localPreference.getValue(), (Object)remotePreference.getValue()) ? null : SyncActionType.CONFLICT;
        }
        if (actionType != null) {
            return SyncFactory.eINSTANCE.createSyncAction(localDelta, remoteDelta, actionType);
        }
        return null;
    }

    private SyncActionType compareDeltaTypes(SyncDeltaType localDeltaType, SyncDeltaType remoteDeltaType) {
        switch (localDeltaType) {
            case UNCHANGED: {
                switch (remoteDeltaType) {
                    case UNCHANGED: {
                        return null;
                    }
                    case CHANGED: {
                        return SyncActionType.SET_REMOTE;
                    }
                    case REMOVED: {
                        return SyncActionType.REMOVE_REMOTE;
                    }
                }
                break;
            }
            case CHANGED: {
                switch (remoteDeltaType) {
                    case UNCHANGED: {
                        return SyncActionType.SET_LOCAL;
                    }
                    case CHANGED: {
                        return SyncActionType.NONE;
                    }
                    case REMOVED: {
                        return SyncActionType.CONFLICT;
                    }
                }
                break;
            }
            case REMOVED: {
                switch (remoteDeltaType) {
                    case UNCHANGED: {
                        return SyncActionType.REMOVE_LOCAL;
                    }
                    case CHANGED: {
                        return SyncActionType.CONFLICT;
                    }
                    case REMOVED: {
                        return null;
                    }
                }
            }
        }
        throw new IllegalArgumentException();
    }

    private Map<String, SyncDelta> compareTasks(DataProvider.Location location, SetupTaskContainer oldTaskContainer, SetupTaskContainer newTaskContainer) {
        String id;
        HashMap<String, SyncDelta> deltas = new HashMap<String, SyncDelta>();
        Map<String, SetupTask> oldTasks = this.collectTasks(oldTaskContainer);
        Map<String, SetupTask> newTasks = this.collectTasks(newTaskContainer);
        this.synchronizer.tasksCollected(this, location, oldTasks, newTasks);
        for (Map.Entry<String, SetupTask> oldEntry : oldTasks.entrySet()) {
            SetupTask newTask;
            SetupTask oldTask;
            SyncDelta delta;
            id = oldEntry.getKey();
            if (!this.isIncluded(id) || (delta = this.compareTasks(id, oldTask = oldEntry.getValue(), newTask = newTasks.remove(id))) == null) continue;
            deltas.put(id, delta);
        }
        for (Map.Entry<String, SetupTask> newEntry : newTasks.entrySet()) {
            id = newEntry.getKey();
            if (!this.isIncluded(id)) continue;
            SetupTask newTask = newEntry.getValue();
            SyncDelta delta = this.compareTasks(id, null, newTask);
            deltas.put(id, delta);
        }
        return deltas;
    }

    private SyncDelta compareTasks(String id, SetupTask oldTask, SetupTask newTask) {
        if (oldTask == null) {
            if (newTask == null) {
                return null;
            }
            return SyncFactory.eINSTANCE.createSyncDelta(id, oldTask, newTask, SyncDeltaType.CHANGED);
        }
        if (newTask == null) {
            return SyncFactory.eINSTANCE.createSyncDelta(id, oldTask, newTask, SyncDeltaType.REMOVED);
        }
        PreferenceTask oldPreference = (PreferenceTask)oldTask;
        PreferenceTask newPreference = (PreferenceTask)newTask;
        if (!ObjectUtil.equals((Object)oldPreference.getKey(), (Object)newPreference.getKey())) {
            return null;
        }
        if (ObjectUtil.equals((Object)oldPreference.getValue(), (Object)newPreference.getValue())) {
            return null;
        }
        return SyncFactory.eINSTANCE.createSyncDelta(id, (SetupTask)oldPreference, (SetupTask)newPreference, SyncDeltaType.CHANGED);
    }

    private Map<String, SetupTask> collectTasks(SetupTaskContainer taskContainer) {
        EList setupTasks = taskContainer.getSetupTasks();
        this.collectIDs((EList<SetupTask>)setupTasks);
        HashMap<String, SetupTask> tasks = new HashMap<String, SetupTask>();
        if (this.collectTasks((EList<SetupTask>)setupTasks, tasks)) {
            new ChangedAdapter((EObject)taskContainer);
        }
        return tasks;
    }

    private void collectIDs(EList<SetupTask> tasks) {
        for (SetupTask task : tasks) {
            this.rememberID(task);
            if (!(task instanceof CompoundTask)) continue;
            CompoundTask compoundTask = (CompoundTask)task;
            this.collectIDs((EList<SetupTask>)compoundTask.getSetupTasks());
        }
    }

    private boolean collectTasks(EList<SetupTask> tasks, Map<String, SetupTask> result) {
        boolean changed = false;
        for (SetupTask task : tasks) {
            String id = this.rememberID(task);
            if (this.isSychronizable(task)) {
                if (StringUtil.isEmpty((String)id)) {
                    id = this.getPreferenceID(task);
                    if (StringUtil.isEmpty((String)id)) {
                        id = this.createID();
                    } else {
                        this.ids.add(id);
                    }
                    String oldID = task.getID();
                    if (!id.equals(oldID)) {
                        task.setID(id);
                        changed |= true;
                    }
                    this.rememberPreferenceID(task);
                }
                if (result.put(id, task) == null) continue;
                throw new DuplicateIDException(id);
            }
            if (!(task instanceof CompoundTask)) continue;
            CompoundTask compoundTask = (CompoundTask)task;
            changed |= this.collectTasks((EList<SetupTask>)compoundTask.getSetupTasks(), result);
        }
        return changed;
    }

    private boolean isSychronizable(SetupTask task) {
        return task instanceof PreferenceTask;
    }

    private void rememberIDs(Resource resource) {
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject object = (EObject)it.next();
            String id = EcoreUtil.getID((EObject)object);
            if (StringUtil.isEmpty((String)id)) continue;
            this.ids.add(id);
        }
    }

    private String rememberID(SetupTask task) {
        String id = task.getID();
        if (!StringUtil.isEmpty((String)id)) {
            this.ids.add(id);
            this.rememberPreferenceID(task);
        }
        return id;
    }

    private void rememberPreferenceID(SetupTask task) {
        PreferenceTask preferenceTask;
        String key;
        String id = task.getID();
        if (!StringUtil.isEmpty((String)id) && task instanceof PreferenceTask && !StringUtil.isEmpty((String)(key = (preferenceTask = (PreferenceTask)task).getKey()))) {
            this.preferenceIDs.put(key, id);
        }
    }

    private String getPreferenceID(SetupTask task) {
        PreferenceTask preferenceTask;
        String key;
        if (task instanceof PreferenceTask && !StringUtil.isEmpty((String)(key = (preferenceTask = (PreferenceTask)task).getKey()))) {
            return this.preferenceIDs.get(key);
        }
        return null;
    }

    private String createID() {
        int i = this.lastID + 1;
        while (i < Integer.MAX_VALUE) {
            String id = "sync" + i;
            if (this.ids.add(id)) {
                this.lastID = i;
                return id;
            }
            ++i;
        }
        throw new IllegalStateException(Messages.Synchronization_TooManyIDs_exception);
    }

    public String getID(SyncAction action) {
        String id = action.getID();
        if (id != null) {
            return id;
        }
        ActionAdapter adapter = (ActionAdapter)EcoreUtil.getAdapter((List)action.eAdapters(), ActionAdapter.class);
        if (adapter != null) {
            return adapter.getID();
        }
        return null;
    }

    public Map<String, SyncAction> getActions() {
        return this.actions;
    }

    public Map<String, SyncAction> getUnresolvedActions() {
        if (this.unresolvedActions == null) {
            this.unresolvedActions = new HashMap<String, SyncAction>();
            for (Map.Entry<String, SyncAction> entry : this.actions.entrySet()) {
                SyncAction action = entry.getValue();
                if (action.getEffectiveType() != SyncActionType.CONFLICT) continue;
                String id = entry.getKey();
                this.unresolvedActions.put(id, action);
            }
        }
        return this.unresolvedActions;
    }

    public Synchronization resolve(String id, SyncActionType resolvedType) {
        SyncAction action = this.actions.get(id);
        if (action != null) {
            action.setResolvedType(resolvedType);
        }
        return this;
    }

    public void commit() throws IOException, DataProvider.NotCurrentException {
        if (!this.committed && !this.disposed) {
            this.committed = true;
            this.doCommit();
        }
    }

    private void doCommit() throws IOException, DataProvider.NotCurrentException {
        this.synchronizer.commitStarted();
        try {
            boolean updateRemoteDataProvider = this.applyActions(DataProvider.Location.REMOTE);
            this.remoteWorkingCopy.commit(updateRemoteDataProvider);
            boolean updateLocalDataProvider = this.applyActions(DataProvider.Location.LOCAL);
            this.localWorkingCopy.commit(updateLocalDataProvider);
            this.synchronizer.commitFinished(null);
        }
        catch (IOException ex) {
            this.synchronizer.commitFinished(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.synchronizer.commitFinished(ex);
            throw ex;
        }
        catch (Error ex) {
            this.synchronizer.commitFinished(ex);
            throw ex;
        }
    }

    private boolean applyActions(DataProvider.Location location) {
        Snapshot.WorkingCopy workingCopy = location.pick(this.localWorkingCopy, this.remoteWorkingCopy);
        File file = workingCopy.getTmpFile();
        SetupTaskContainer taskContainer = (SetupTaskContainer)this.loadObject(file, location.getDataType());
        Map<String, SetupTask> tasks = this.collectTasks(taskContainer);
        boolean changed = ChangedAdapter.isChanged((EObject)taskContainer);
        for (Map.Entry<String, SyncAction> entry : this.actions.entrySet()) {
            String id = entry.getKey();
            SyncAction action = entry.getValue();
            SyncActionType type = action.getEffectiveType();
            switch (type) {
                case CONFLICT: {
                    throw new ConflictException(action);
                }
                case SET_LOCAL: {
                    changed |= this.include(id);
                    changed |= this.applySetAction(taskContainer, tasks, id, action.getLocalDelta());
                    break;
                }
                case SET_REMOTE: {
                    if (location == DataProvider.Location.REMOTE) break;
                    changed |= this.include(id);
                    changed |= this.applySetAction(taskContainer, tasks, id, action.getRemoteDelta());
                    break;
                }
                case REMOVE_LOCAL: {
                    changed |= this.include(id);
                    changed |= this.applyRemoveAction(taskContainer, tasks, action.getLocalDelta());
                    break;
                }
                case REMOVE_REMOTE: {
                    if (location == DataProvider.Location.REMOTE) break;
                    changed |= this.include(id);
                    changed |= this.applyRemoveAction(taskContainer, tasks, action.getRemoteDelta());
                    break;
                }
                case EXCLUDE: {
                    changed |= this.exclude(id);
                    changed |= this.applyRemoveAction(taskContainer, tasks, action.getRemoteDelta());
                    break;
                }
            }
        }
        if (changed) {
            BaseUtil.saveEObject((EObject)taskContainer);
        }
        return changed;
    }

    private boolean applySetAction(SetupTaskContainer taskContainer, Map<String, SetupTask> tasks, String id, SyncDelta delta) {
        SetupTask newTask;
        if (delta != null && (newTask = delta.getNewTask()) != null) {
            newTask = (SetupTask)EcoreUtil.copy((EObject)newTask);
            newTask.setID(id);
            newTask.getRestrictions().clear();
            newTask.getPredecessors().clear();
            newTask.getSuccessors().clear();
            SetupTask oldTask = tasks.get(id);
            if (oldTask != null) {
                EcoreUtil.replace((EObject)oldTask, (EObject)newTask);
            } else {
                taskContainer.getSetupTasks().add((Object)newTask);
            }
            return true;
        }
        return false;
    }

    private boolean applyRemoveAction(SetupTaskContainer taskContainer, Map<String, SetupTask> tasks, SyncDelta delta) {
        String id;
        SetupTask oldTask;
        if (delta != null && (oldTask = tasks.get(id = delta.getID())) != null) {
            EcoreUtil.remove((EObject)oldTask);
            return true;
        }
        return false;
    }

    private boolean include(String id) {
        return this.remotePolicies.put((Object)id, (Object)SyncPolicy.INCLUDE) != SyncPolicy.INCLUDE;
    }

    private boolean exclude(String id) {
        return this.remotePolicies.put((Object)id, (Object)SyncPolicy.EXCLUDE) != SyncPolicy.EXCLUDE;
    }

    public void dispose() {
        if (!this.disposed) {
            this.doDispose();
        }
    }

    private void doDispose() {
        this.disposed = true;
        try {
            if (this.localWorkingCopy != null) {
                this.localWorkingCopy.dispose();
            }
        }
        catch (Throwable ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
        try {
            if (this.remoteWorkingCopy != null) {
                this.remoteWorkingCopy.dispose();
            }
        }
        catch (Throwable ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
        try {
            if (this.synchronizer != null) {
                this.synchronizer.releaseLock();
            }
        }
        catch (Throwable ex) {
            SetupSyncPlugin.INSTANCE.log(ex);
        }
    }

    private Resource getResource(File file, boolean loadOnDemand) {
        URI uri = URI.createFileURI((String)file.getAbsolutePath());
        return this.resourceSet.getResource(uri, loadOnDemand);
    }

    private <T extends EObject> T loadObject(File file, EClass eClass) {
        Resource resource = this.getResource(file, true);
        this.rememberIDs(resource);
        return (T)((EObject)BaseUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)eClass));
    }

    private void unloadResource(File file) {
        Resource resource = this.getResource(file, false);
        if (resource != null) {
            resource.unload();
        }
    }

    private final class ActionAdapter
    extends AdapterImpl {
        private final String id;

        public ActionAdapter(SyncAction action, String id) {
            this.id = id;
            action.eAdapters().add((Object)this);
        }

        public String getID() {
            return this.id;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == SyncPackage.Literals.SYNC_ACTION__RESOLVED_TYPE && !msg.isTouch()) {
                Synchronization.this.unresolvedActions = null;
                SyncAction action = (SyncAction)this.getTarget();
                Synchronization.this.synchronizer.actionResolved(action, this.id);
            }
        }
    }

    private static final class ChangedAdapter
    extends AdapterImpl {
        public ChangedAdapter(EObject object) {
            object.eAdapters().add((Object)this);
        }

        public static boolean isChanged(EObject object) {
            for (Adapter adapter : object.eAdapters()) {
                if (adapter.getClass() != ChangedAdapter.class) continue;
                return true;
            }
            return false;
        }
    }

    public static class ConflictException
    extends SynchronizerException {
        private static final long serialVersionUID = 1L;

        public ConflictException(SyncAction action) {
            super(NLS.bind((String)Messages.Synchronization_Conflict_exception, (Object)action));
        }
    }

    public static class DuplicateIDException
    extends SynchronizerException {
        private static final long serialVersionUID = 1L;

        public DuplicateIDException(String id) {
            super(NLS.bind((String)Messages.Synchronization_DuplicateID_exception, (Object)id));
        }
    }
}

