/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import org.eclipse.core.net.proxy.IProxyData;

public class ProxyData
implements IProxyData {
    private String type;
    private String host;
    private int port;
    private String user;
    private String password;
    private boolean requiresAuthentication;
    private String source;
    private boolean dynamic = false;

    public ProxyData(String type, String host, int port, boolean requiresAuthentication, String source) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.requiresAuthentication = requiresAuthentication;
        this.source = source;
    }

    public ProxyData(String type) {
        this.type = type;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getUserId() {
        return this.user;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setHost(String host) {
        if (host != null && host.length() == 0) {
            host = null;
        }
        this.host = host;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void setUserid(String userid) {
        this.user = userid;
        this.requiresAuthentication = userid != null;
    }

    @Override
    public boolean isRequiresAuthentication() {
        return this.requiresAuthentication;
    }

    @Override
    public void disable() {
        this.host = null;
        this.port = -1;
        this.user = null;
        this.password = null;
        this.requiresAuthentication = false;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type: ");
        builder.append(this.type);
        builder.append(" host: ");
        builder.append(this.host);
        builder.append(" port: ");
        builder.append(this.port);
        builder.append(" user: ");
        builder.append(this.user);
        builder.append(" password: ");
        builder.append(this.password);
        builder.append(" reqAuth: ");
        builder.append(this.requiresAuthentication);
        builder.append(" source: ");
        builder.append(this.source);
        builder.append(" dynamic: ");
        builder.append(this.dynamic);
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dynamic ? 1231 : 1237);
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.requiresAuthentication ? 1231 : 1237);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyData other = (ProxyData)obj;
        if (this.dynamic != other.dynamic) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.requiresAuthentication != other.requiresAuthentication) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }
}

