/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.jface.internal.databinding.swt.WidgetBooleanValueProperty;
import org.eclipse.jface.internal.databinding.swt.WidgetListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public abstract class VisibleProperty<S extends Widget>
extends WidgetBooleanValueProperty<S> {
    private static final int[] EVENT_TYPES = new int[]{22, 23};
    private static final String CACHED_VALUE_KEY = String.valueOf(VisibleProperty.class.getName()) + ".IS_VISIBLE";

    public VisibleProperty() {
        super(EVENT_TYPES);
    }

    protected abstract boolean doGetVisibleValue(S var1);

    @Override
    protected final boolean doGetBooleanValue(S source) {
        Boolean cachedVisibleValue = (Boolean)source.getData(CACHED_VALUE_KEY);
        return cachedVisibleValue == null ? this.doGetVisibleValue(source) : cachedVisibleValue.booleanValue();
    }

    @Override
    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends Boolean>> listener) {
        return new WidgetListener<S, ValueDiff<? extends Boolean>>((IProperty)this, listener, EVENT_TYPES, null){

            @Override
            public void handleEvent(Event event) {
                event.widget.setData(CACHED_VALUE_KEY, (Object)(event.type == 22 ? 1 : 0));
                super.handleEvent(event);
            }

            @Override
            protected void doRemoveFrom(S source) {
                source.setData(CACHED_VALUE_KEY, null);
                super.doRemoveFrom(source);
            }
        };
    }
}

