/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.edit.NoChildrenDelegatingWrapperItemProvider;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.provider.ScopeItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceItemProvider
extends ScopeItemProvider {
    private static final String EXPECTED_SUFFIX = ".metadata/.plugins/org.eclipse.oomph.setup/workspace.setup";

    public WorkspaceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addStreamsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addStreamsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Workspace_streams_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Workspace_streams_feature", "_UI_Workspace_type"), (EStructuralFeature)SetupPackage.Literals.WORKSPACE__STREAMS, true, false, true, null, null, null));
    }

    private Collection<? extends EStructuralFeature> getChildrenFeaturesGen(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SetupPackage.Literals.WORKSPACE__STREAMS);
        }
        return this.childrenFeatures;
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.getChildrenFeaturesGen(object);
            this.childrenFeatures.remove(SetupPackage.Literals.WORKSPACE__STREAMS);
            this.childrenFeatures.add(0, SetupPackage.Literals.WORKSPACE__STREAMS);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        if (feature == SetupPackage.Literals.WORKSPACE__STREAMS) {
            return new NoChildrenDelegatingWrapperItemProvider(value, object, feature, index, this.adapterFactory){

                public String getText(Object object) {
                    return ((Stream)this.value).getQualifiedLabel();
                }
            };
        }
        return null;
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Workspace"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        URI uri;
        Workspace workspace = (Workspace)object;
        if (workspace.eContainer() != null) {
            return super.getText(object);
        }
        String label = this.getString("_UI_Workspace_type");
        Resource resource = workspace.eResource();
        if (resource != null && (uri = resource.getURI()) != null && (label = String.valueOf(label) + " " + uri).endsWith(EXPECTED_SUFFIX)) {
            label = label.substring(0, label.length() - EXPECTED_SUFFIX.length());
        }
        return label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Workspace.class)) {
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        Collection collection = commandParameter.getCollection();
        ArrayList<Object> streams = new ArrayList<Object>();
        if (collection != null) {
            for (Object object : collection) {
                Project project;
                EList projectStreams;
                if (object instanceof Stream) {
                    streams.add(object);
                    continue;
                }
                if (!(object instanceof Project) || (projectStreams = (project = (Project)object).getStreams()).isEmpty()) continue;
                streams.add(projectStreams.get(0));
            }
            Workspace workspace = (Workspace)commandParameter.getOwner();
            streams.removeAll((Collection<?>)workspace.getStreams());
            if (!streams.isEmpty()) {
                return AddCommand.create((EditingDomain)domain, (Object)workspace, (Object)SetupPackage.Literals.WORKSPACE__STREAMS, streams);
            }
        }
        return super.factorAddCommand(domain, commandParameter);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

