/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredViewerTreeIterator
extends AbstractTreeIterator<Object> {
    private static final long serialVersionUID = 1L;
    private transient StructuredViewer viewer;
    private transient ITreeContentProvider treeContentProvider;

    public StructuredViewerTreeIterator(StructuredViewer viewer) {
        super((Object)viewer, false);
        this.viewer = viewer;
    }

    protected Iterator<Object> getChildren(Object object) {
        if (object == this.viewer) {
            IContentProvider contentProvider = this.viewer.getContentProvider();
            if (contentProvider instanceof IStructuredContentProvider) {
                IStructuredContentProvider structuredContentProvider = (IStructuredContentProvider)contentProvider;
                if (structuredContentProvider instanceof ITreeContentProvider) {
                    this.treeContentProvider = (ITreeContentProvider)structuredContentProvider;
                }
                return Arrays.asList(structuredContentProvider.getElements(this.viewer.getInput())).iterator();
            }
            return Collections.emptyList().iterator();
        }
        if (this.treeContentProvider != null) {
            return Arrays.asList(this.treeContentProvider.getChildren(object)).iterator();
        }
        return Collections.emptyList().iterator();
    }

    public static interface Provider {
        public StructuredViewerTreeIterator create();
    }
}

