/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.jreinfo.JRE;
import org.eclipse.oomph.jreinfo.JREFilter;
import org.eclipse.oomph.jreinfo.ui.JREController;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.util.Request;
import org.eclipse.swt.widgets.Label;

public class AugmentedJREController
extends JREController {
    public AugmentedJREController(Label label, StructuredViewer viewer, Request.Handler downloadHandler) {
        super(label, viewer, downloadHandler);
    }

    protected JREFilter createJREFilter() {
        return new JREFilter(this.getJavaVersion(), Integer.valueOf(this.getBitness()), null, null);
    }

    protected void updateSetupContext(SetupContext setupContext, JRE jre) {
        JRE.Descriptor jreDescriptor;
        Installation installation = setupContext.getInstallation();
        EList setupTasks = installation.getSetupTasks();
        for (SetupTask setupTask : setupTasks) {
            if (setupTask.getAnnotation("http://www.eclipse.org/oomph/setup/JRE") == null) continue;
            EcoreUtil.remove((EObject)setupTask);
            break;
        }
        if (jre != null && (jreDescriptor = jre.getDescriptor()) != null) {
            SetupTask setupTask = (SetupTask)jreDescriptor.getData();
            SetupTask setupTaskCopy = (SetupTask)EcoreUtil.copy((EObject)setupTask);
            Annotation annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/JRE");
            setupTaskCopy.getAnnotations().add((Object)annotation);
            setupTaskCopy.setExcludedTriggers(new LinkedHashSet<Trigger>(Arrays.asList(Trigger.STARTUP, Trigger.MANUAL)));
            setupTasks.add(0, (Object)setupTaskCopy);
        }
    }

    protected JRE getDefaultJRE(String javaVersion) {
        JRE jre = this.getJRE();
        if (jre != null && jre.isMatch(this.createJREFilter())) {
            return jre;
        }
        return super.getDefaultJRE(javaVersion);
    }
}

