/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.synchronizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.PreferenceTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.sync.LocalDataProvider;
import org.eclipse.oomph.setup.internal.sync.Snapshot;
import org.eclipse.oomph.setup.internal.sync.SyncUtil;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.provider.PreferenceTaskItemProvider;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.setup.sync.SyncActionType;
import org.eclipse.oomph.setup.sync.SyncDelta;
import org.eclipse.oomph.setup.sync.SyncPolicy;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.setup.ui.SetupLabelProvider;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.Pair;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.userstorage.IStorageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizerDialog
extends AbstractSetupDialog {
    private static final boolean DEBUG_SYNC_ACTIONS = false;
    private static final int ICON = 16;
    private static final int SPACE = 5;
    private static final int H_INDENT = 10;
    private static final int V_INDENT = 1;
    private static String POLICY_HELP_MESSAGE = " Click the policy header to toggle all policies.";
    private final PaintHandler paintHandler = new PaintHandler();
    private final MouseHandler mouseHandler = new MouseHandler();
    private final ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
    private final ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
    private final Map<SetupTask, TaskItem> taskItems = new HashMap<SetupTask, TaskItem>();
    private final Map<String, TaskItem> taskItemsByPreferenceKey = new HashMap<String, TaskItem>();
    private final Mode mode;
    private final RecorderTransaction recorderTransaction;
    private final Set<URI> recorderValuesToRemove = new HashSet<URI>();
    private final Scope recorderTarget;
    private final Image recorderTargetImage;
    private final String recorderTargetText;
    private final Synchronization synchronization;
    private Tree tree;
    private boolean treePopulated;
    private TreeColumn labelColumn;
    private TreeColumn localColumn;
    private TreeColumn remoteColumn;
    private final ColumnManager[] columnManagers = new ColumnManager[3];
    private LocalColumnManager localColumnManager;
    private RemoteColumnManager remoteColumnManager;
    private Text valueText;
    private Button enableRecorderButton;
    private boolean enableRecorder = RecorderManager.INSTANCE.isRecorderEnabled();
    private Button okButton;

    public SynchronizerDialog(Shell parentShell) {
        this(parentShell, null, null);
    }

    public SynchronizerDialog(Shell parentShell, RecorderTransaction transaction, Synchronization sync) {
        super(parentShell, SynchronizerDialog.getTitle(transaction), 800, 600, SetupUIPlugin.INSTANCE, true);
        PreferenceTaskItemProvider.setShortenLabelText((AdapterFactory)this.adapterFactory);
        if (transaction != null) {
            this.recorderTarget = RecorderManager.INSTANCE.getRecorderTargetObject(this.resourceSet);
            ItemProviderAdapter itemProvider = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)this.recorderTarget, IItemLabelProvider.class);
            this.recorderTargetImage = SetupUIPlugin.INSTANCE.getSWTImage(SetupLabelProvider.getImageDescriptor(itemProvider, (EObject)this.recorderTarget));
            this.recorderTargetText = SetupLabelProvider.getText(itemProvider, (EObject)this.recorderTarget);
            if (sync != null) {
                this.mode = Mode.RECORD_AND_SYNC;
                this.recorderTransaction = transaction;
                this.synchronization = sync;
            } else {
                this.mode = Mode.RECORD;
                this.recorderTransaction = transaction;
                this.synchronization = null;
            }
        } else {
            this.mode = Mode.SYNC;
            this.recorderTransaction = null;
            this.recorderTarget = null;
            this.recorderTargetImage = null;
            this.recorderTargetText = null;
            this.synchronization = sync;
        }
    }

    public boolean isEnableRecorder() {
        return this.enableRecorder;
    }

    public String getHelpPath() {
        return String.valueOf(SetupUIPlugin.INSTANCE.getSymbolicName()) + "/html/RecorderHelp.html";
    }

    protected String getShellText() {
        return SynchronizerDialog.getTitle(this.recorderTransaction);
    }

    protected String getDefaultMessage() {
        switch (this.mode) {
            case RECORD: {
                if (this.recorderTarget instanceof User) {
                    return "Select what to record for reuse across all workspaces." + POLICY_HELP_MESSAGE;
                }
                if (this.recorderTarget instanceof Installation) {
                    return "Select what to record for reuse across all workspaces of the current installation." + POLICY_HELP_MESSAGE;
                }
                if (this.recorderTarget instanceof Workspace) {
                    return "Select what to record for the use of just this workspace." + POLICY_HELP_MESSAGE;
                }
                return "Select what to record into " + this.recorderTargetText + "." + POLICY_HELP_MESSAGE;
            }
            case SYNC: {
                return "Select what to synchronize with " + SynchronizerDialog.getServiceLabel() + " for reuse across all machines." + POLICY_HELP_MESSAGE;
            }
            case RECORD_AND_SYNC: {
                return "Select what to record for reuse across all workspaces on this machine and what to synchronize with " + SynchronizerDialog.getServiceLabel() + " for reuse across all your other machines." + POLICY_HELP_MESSAGE;
            }
        }
        return null;
    }

    protected void createUI(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SynchronizerDialog.this.localColumnManager != null) {
                    SynchronizerDialog.this.localColumnManager.dispose();
                }
                if (SynchronizerDialog.this.remoteColumnManager != null) {
                    SynchronizerDialog.this.remoteColumnManager.dispose();
                }
                SynchronizerDialog.this.adapterFactory.dispose();
            }
        });
        this.initializeDialogUnits((Control)parent);
        SashForm sashForm = new SashForm(parent, 66048);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree = new Tree((Composite)sashForm, 65536);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.addListener(41, (Listener)this.paintHandler);
        this.tree.addListener(42, (Listener)this.paintHandler);
        this.tree.addListener(3, (Listener)this.mouseHandler);
        this.tree.setFocus();
        this.labelColumn = new TreeColumn(this.tree, 0);
        this.labelColumn.setText("Preference");
        this.labelColumn.setWidth(200);
        this.labelColumn.setResizable(true);
        int column = 1;
        if (this.mode.isRecord()) {
            this.localColumn = new TreeColumn(this.tree, 0);
            this.localColumn.setText("Local Policy");
            this.localColumn.setWidth(200);
            this.localColumn.setResizable(true);
            this.localColumnManager = new LocalColumnManager(this);
            this.columnManagers[column++] = this.localColumnManager;
        }
        if (this.mode.isSync()) {
            this.remoteColumn = new TreeColumn(this.tree, 0);
            this.remoteColumn.setText("Remote Policy");
            this.remoteColumn.setWidth(200);
            this.remoteColumn.setResizable(true);
            this.remoteColumnManager = new RemoteColumnManager(this, SynchronizerDialog.getServiceLabel());
            this.columnManagers[column++] = this.remoteColumnManager;
        }
        this.populateTree();
        this.initColumnResizer();
        this.valueText = new Text((Composite)sashForm, 776);
        this.valueText.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TaskItem taskItem;
                SetupTask task;
                String value = "";
                if (event.item instanceof TaskItem && (task = (taskItem = (TaskItem)event.item).getTask()) instanceof PreferenceTask) {
                    PreferenceTask preferenceTask = (PreferenceTask)task;
                    value = preferenceTask.getValue();
                }
                SynchronizerDialog.this.valueText.setText(StringUtil.safe((String)value).replace('\u0000', '\n'));
            }
        });
        Listener scrollBarListener = new Listener(){
            protected boolean changing;

            public void handleEvent(Event event) {
                if (!this.changing) {
                    this.changing = true;
                    Rectangle clientArea = SynchronizerDialog.this.valueText.getClientArea();
                    Rectangle trimArea = SynchronizerDialog.this.valueText.computeTrim(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
                    Point size = SynchronizerDialog.this.valueText.computeSize(-1, -1, true);
                    SynchronizerDialog.this.valueText.getHorizontalBar().setVisible(trimArea.width <= size.x);
                    SynchronizerDialog.this.valueText.getVerticalBar().setVisible(trimArea.height <= size.y);
                    this.changing = false;
                }
            }
        };
        this.valueText.addListener(11, scrollBarListener);
        this.valueText.addListener(24, scrollBarListener);
        sashForm.setWeights(new int[]{4, 1});
        Dialog.applyDialogFont((Control)sashForm);
        SynchronizerDialog.showFirstTimeHelp((TrayDialog)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.mode.isRecord()) {
            this.enableRecorderButton = this.createCheckbox(parent, "Recorder enabled");
            this.enableRecorderButton.setToolTipText("The enablement can be changed later on the preference page Oomph | Setup | Preference Recorder");
            this.enableRecorderButton.setSelection(this.enableRecorder);
            this.enableRecorderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SynchronizerDialog.this.validatePage();
                }
            });
        }
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.validatePage();
    }

    protected void validatePage() {
        if (this.treePopulated) {
            if (this.mode.isRecord() && this.enableRecorderButton != null) {
                this.enableRecorder = this.enableRecorderButton.getSelection();
                this.tree.setEnabled(this.enableRecorder);
                if (this.valueText != null) {
                    this.valueText.setVisible(this.enableRecorder);
                }
            }
            boolean noConflicts = true;
            if (this.mode.isSync()) {
                noConflicts = this.synchronization.getUnresolvedActions().isEmpty();
            }
            if (this.okButton != null) {
                this.okButton.setEnabled(noConflicts);
            }
        }
    }

    protected void okPressed() {
        Map<URI, Pair<String, String>> preferences;
        if (this.mode.isRecord() && (preferences = this.recorderTransaction.getPreferences()) != null) {
            preferences.keySet().removeAll(this.recorderValuesToRemove);
        }
        super.okPressed();
    }

    private ColumnManager getColumnManager(int column) {
        if (column < this.columnManagers.length) {
            return this.columnManagers[column];
        }
        return null;
    }

    private void initColumnResizer() {
        ControlAdapter columnResizer = new ControlAdapter(){
            private int clientWidth = 0;
            private int labelWidth = 0;
            private int recorderWidth = 0;
            private int synchronizerWidth = 0;
            private boolean resizing;

            public void controlResized(ControlEvent e) {
                boolean inputChanged;
                if (this.resizing) {
                    return;
                }
                Rectangle clientArea = SynchronizerDialog.this.tree.getClientArea();
                int clientWidth = clientArea.width - clientArea.x;
                int labelWidth = SynchronizerDialog.this.labelColumn.getWidth();
                int recorderWidth = SynchronizerDialog.this.localColumn == null ? 0 : SynchronizerDialog.this.localColumn.getWidth();
                int synchronizerWidth = SynchronizerDialog.this.remoteColumn == null ? 0 : SynchronizerDialog.this.remoteColumn.getWidth();
                boolean bl = inputChanged = e == null;
                if (inputChanged || clientWidth != this.clientWidth || labelWidth != this.labelWidth || recorderWidth != this.recorderWidth || synchronizerWidth != this.synchronizerWidth) {
                    try {
                        this.resizing = true;
                        SynchronizerDialog.this.tree.setRedraw(false);
                        TreeItem[] items = SynchronizerDialog.this.tree.getItems();
                        if (items.length == 0) {
                            recorderWidth = clientWidth / 2;
                            SynchronizerDialog.this.labelColumn.setWidth(clientWidth - recorderWidth - synchronizerWidth);
                            if (SynchronizerDialog.this.localColumn != null) {
                                SynchronizerDialog.this.localColumn.setWidth(recorderWidth);
                            }
                            if (SynchronizerDialog.this.remoteColumn != null) {
                                SynchronizerDialog.this.remoteColumn.setWidth(synchronizerWidth);
                            }
                        } else {
                            if (SynchronizerDialog.this.localColumn != null) {
                                SynchronizerDialog.this.localColumn.pack();
                                recorderWidth = SynchronizerDialog.this.localColumn.getWidth() + 10;
                                SynchronizerDialog.this.localColumn.setWidth(recorderWidth);
                            }
                            if (SynchronizerDialog.this.remoteColumn != null) {
                                SynchronizerDialog.this.remoteColumn.pack();
                                synchronizerWidth = SynchronizerDialog.this.remoteColumn.getWidth() + 10;
                                SynchronizerDialog.this.remoteColumn.setWidth(synchronizerWidth);
                            }
                            labelWidth = clientWidth - recorderWidth - synchronizerWidth;
                            SynchronizerDialog.this.labelColumn.setWidth(labelWidth);
                        }
                    }
                    finally {
                        this.clientWidth = clientWidth;
                        this.labelWidth = labelWidth;
                        this.recorderWidth = recorderWidth;
                        this.synchronizerWidth = synchronizerWidth;
                        SynchronizerDialog.this.tree.setRedraw(true);
                        this.resizing = false;
                    }
                }
            }
        };
        this.tree.addControlListener((ControlListener)columnResizer);
        this.labelColumn.addControlListener((ControlListener)columnResizer);
        if (this.localColumn != null) {
            this.localColumn.addControlListener((ControlListener)columnResizer);
        }
        if (this.remoteColumn != null) {
            this.remoteColumn.addControlListener((ControlListener)columnResizer);
        }
        columnResizer.controlResized(null);
    }

    private Map<URI, String> getRecorderPreferences() {
        HashMap<URI, String> result = new HashMap<URI, String>();
        Map<String, PreferenceTask> commitResult = this.recorderTransaction.getCommitResult();
        if (commitResult != null) {
            for (PreferenceTask preferenceTask : commitResult.values()) {
                URI uri = PreferencesFactory.eINSTANCE.createURI(preferenceTask.getKey());
                String value = preferenceTask.getValue();
                result.put(uri, value);
            }
        } else {
            for (Map.Entry<URI, Pair<String, String>> entry : this.recorderTransaction.getPreferences().entrySet()) {
                URI uri = entry.getKey();
                String value = (String)entry.getValue().getElement2();
                result.put(uri, value);
            }
        }
        return result;
    }

    private void addTask(PreferenceTask task, String pluginID, Map<String, Set<SetupTask>> tasks, Map<SetupTask, String> labels, Map<SetupTask, Image> images, Map<String, CompoundTask> compounds) {
        CollectionUtil.add(tasks, (Object)pluginID, (Object)task);
        CompoundTask compound = compounds.get(pluginID);
        if (compound == null) {
            compound = SetupFactory.eINSTANCE.createCompoundTask(pluginID);
        }
        compound.getSetupTasks().add((Object)task);
        ItemProviderAdapter itemProvider = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)task, IItemLabelProvider.class);
        labels.put((SetupTask)task, SetupLabelProvider.getText(itemProvider, (EObject)task));
        images.put((SetupTask)task, SetupUIPlugin.INSTANCE.getSWTImage(SetupLabelProvider.getImageDescriptor(itemProvider, (EObject)task)));
    }

    private void populateTree() {
        HashMap<String, Set<SetupTask>> tasks = new HashMap<String, Set<SetupTask>>();
        HashMap<SetupTask, String> labels = new HashMap<SetupTask, String>();
        HashMap<SetupTask, Image> images = new HashMap<SetupTask, Image>();
        if (this.mode.isRecord()) {
            HashMap<String, CompoundTask> compounds = new HashMap<String, CompoundTask>();
            Map<String, Boolean> cleanLocalPolicies = this.recorderTransaction.getPolicies(true);
            Map<String, Boolean> dirtyLocalPolicies = this.recorderTransaction.getPolicies(false);
            Map<URI, String> preferences = this.getRecorderPreferences();
            for (Map.Entry<URI, String> entry : preferences.entrySet()) {
                URI uri = entry.getKey();
                String pluginID = uri.segment(0);
                String key = PreferencesFactory.eINSTANCE.convertURI(uri);
                String value = entry.getValue();
                PreferenceTask task = SetupFactory.eINSTANCE.createPreferenceTask();
                task.setKey(key);
                task.setValue(value);
                boolean remotePolicyMissing = false;
                boolean conflict = false;
                if (this.mode.isSync()) {
                    EMap remotePolicies = this.synchronization.getRemotePolicies();
                    Map preferenceIDs = this.synchronization.getPreferenceIDs();
                    String syncID = (String)preferenceIDs.get(key);
                    if (syncID != null) {
                        SyncPolicy remotePolicy;
                        task.setID(syncID);
                        SyncAction syncAction = (SyncAction)this.synchronization.getActions().get(syncID);
                        if (syncAction != null && syncAction.getComputedType() == SyncActionType.CONFLICT) {
                            conflict = true;
                            task.eAdapters().add((Object)new ConflictAdapter());
                        }
                        if ((remotePolicy = (SyncPolicy)remotePolicies.get((Object)syncID)) == null) {
                            remotePolicyMissing = true;
                            if (cleanLocalPolicies.containsKey(key)) {
                                task.eAdapters().add((Object)new LocalChoiceDisabledAdapter());
                            }
                        }
                    }
                }
                if (!dirtyLocalPolicies.containsKey(key) && !remotePolicyMissing && !conflict) continue;
                this.addTask(task, pluginID, tasks, labels, images, compounds);
            }
        } else {
            HashMap<String, CompoundTask> compounds = new HashMap<String, CompoundTask>();
            Map syncActions = this.synchronization.getActions();
            for (Map.Entry entry : syncActions.entrySet()) {
                String syncID = (String)entry.getKey();
                SyncAction syncAction = (SyncAction)entry.getValue();
                Map.Entry preference = syncAction.getPreference();
                String key = (String)preference.getKey();
                String value = (String)preference.getValue();
                PreferenceTask task = SetupFactory.eINSTANCE.createPreferenceTask();
                task.setKey(key);
                task.setValue(value);
                task.setID(syncID);
                if (syncAction.getComputedType() == SyncActionType.CONFLICT) {
                    task.eAdapters().add((Object)new ConflictAdapter());
                }
                URI uri = PreferencesFactory.eINSTANCE.createURI(key);
                String pluginID = uri.segment(0);
                this.addTask(task, pluginID, tasks, labels, images, compounds);
            }
        }
        this.populateTree(tasks, labels, images);
    }

    private void populateTree(Map<String, Set<SetupTask>> tasks, final Map<SetupTask, String> labels, Map<SetupTask, Image> images) {
        ArrayList<String> nodes = new ArrayList<String>(tasks.keySet());
        Collections.sort(nodes);
        Comparator<SetupTask> comparator = new Comparator<SetupTask>(){

            @Override
            public int compare(SetupTask t1, SetupTask t2) {
                String l1 = (String)labels.get(t1);
                String l2 = (String)labels.get(t2);
                return l1.compareTo(l2);
            }
        };
        for (String node : nodes) {
            NodeItem nodeItem = new NodeItem(this.tree, this.adapterFactory, node);
            ArrayList list = new ArrayList(tasks.get(node));
            Collections.sort(list, comparator);
            for (SetupTask task : list) {
                Choice[] choices;
                EList adapters = task.eAdapters();
                boolean conflict = EcoreUtil.getAdapter((List)adapters, ConflictAdapter.class) != null;
                boolean localChoiceDisabled = EcoreUtil.getAdapter((List)adapters, LocalChoiceDisabledAdapter.class) != null;
                Image image = images.get(task);
                String text = labels.get(task);
                TaskItem taskItem = new TaskItem(nodeItem, task, conflict, localChoiceDisabled, image, text);
                this.taskItems.put(task, taskItem);
                if (task instanceof PreferenceTask) {
                    PreferenceTask preferenceTask = (PreferenceTask)task;
                    this.taskItemsByPreferenceKey.put(preferenceTask.getKey(), taskItem);
                }
                if (this.localColumnManager != null) {
                    choices = this.localColumnManager.getChoices(taskItem);
                    taskItem.setLocalChoice(choices[0]);
                }
                if (this.remoteColumnManager == null) continue;
                choices = this.remoteColumnManager.getChoices(taskItem);
                taskItem.setRemoteChoice(choices[0]);
            }
            nodeItem.setExpanded(true);
        }
        this.synchronizeLocal(false);
        this.treePopulated = true;
    }

    private void synchronizeLocal(boolean resynchronize) {
        try {
            if (this.mode.isSync()) {
                if (resynchronize) {
                    Snapshot localSnapshot = this.synchronization.getSynchronizer().getLocalSnapshot();
                    SyncUtil.deleteFile((File)localSnapshot.getNewFile());
                    RecorderManager.copyRecorderTarget(this.recorderTarget, localSnapshot.getFolder());
                }
                Set<String> preferenceKeys = null;
                if (this.mode.isRecord()) {
                    HashMap<String, PolicyAndValue> preferenceChanges = new HashMap<String, PolicyAndValue>();
                    for (TaskItem taskItem : this.taskItems.values()) {
                        SetupTask task = taskItem.getTask();
                        if (!(task instanceof PreferenceTask)) continue;
                        PreferenceTask preferenceTask = (PreferenceTask)task;
                        String key = preferenceTask.getKey();
                        Choice localChoice = taskItem.getLocalChoice();
                        if (localChoice instanceof Choice.RecordAlways) {
                            preferenceChanges.put(key, new PolicyAndValue(preferenceTask.getValue()));
                            continue;
                        }
                        if (!(localChoice instanceof Choice.RecordNever) && !(localChoice instanceof Choice.RecordSkip)) continue;
                        preferenceChanges.put(key, new PolicyAndValue());
                    }
                    preferenceKeys = SynchronizerDialog.adjustLocalSnapshot(this.synchronization, preferenceChanges);
                }
                this.synchronization.synchronizeLocal();
                this.adjustSyncActions(preferenceKeys);
            }
        }
        catch (IOException ex) {
            SetupUIPlugin.INSTANCE.log(ex);
        }
    }

    private void adjustSyncActions(Set<String> preferenceKeys) {
        if (this.mode.isRecord() || preferenceKeys == null) {
            Map syncActions = this.synchronization.getActions();
            Iterator it = syncActions.entrySet().iterator();
            while (it.hasNext()) {
                SetupTask task;
                Map.Entry entry = it.next();
                SyncAction syncAction = (SyncAction)entry.getValue();
                SyncDelta localDelta = syncAction.getLocalDelta();
                if (localDelta == null || !((task = localDelta.getNewTask()) instanceof PreferenceTask)) continue;
                PreferenceTask preferenceTask = (PreferenceTask)task;
                String key = preferenceTask.getKey();
                if (preferenceKeys == null || preferenceKeys.contains(key)) {
                    TaskItem taskItem = this.taskItemsByPreferenceKey.get(key);
                    if (taskItem == null) continue;
                    Choice remoteChoice = taskItem.getRemoteChoice();
                    remoteChoice.applyTo(syncAction);
                    continue;
                }
                it.remove();
            }
        }
        this.validatePage();
    }

    private static String getServiceLabel() {
        IStorageService service = SynchronizerManager.INSTANCE.getStorage().getService();
        if (service == null) {
            return "remote service";
        }
        return service.getServiceLabel();
    }

    private static String getTitle(RecorderTransaction recorderTransaction) {
        return recorderTransaction != null ? "Preference Recorder" : "Preference Synchronizer";
    }

    public static Set<String> adjustLocalSnapshot(Synchronization synchronization, Map<String, PolicyAndValue> preferenceChanges) {
        Snapshot localSnapshot = synchronization.getSynchronizer().getLocalSnapshot();
        LocalDataProvider localDataProvider = (LocalDataProvider)localSnapshot.getDataProvider();
        File target = localDataProvider.getLocalFile();
        URI targetURI = URI.createFileURI((String)target.getAbsolutePath());
        Resource resource = synchronization.getResourceSet().getResource(targetURI, true);
        HashSet<String> preferenceKeys = new HashSet<String>();
        HashMap<URI, Pair<String, String>> preferenceMap = new HashMap<URI, Pair<String, String>>();
        RecorderTransaction tmpTransaction = RecorderTransaction.openTmp(resource);
        tmpTransaction.setPreferences(preferenceMap);
        for (Map.Entry<String, PolicyAndValue> entry : preferenceChanges.entrySet()) {
            String key = entry.getKey();
            PolicyAndValue policyAndValue = entry.getValue();
            if (policyAndValue.isRecord()) {
                tmpTransaction.setPolicy(key, true);
                String value = policyAndValue.getValue();
                preferenceMap.put(PreferencesFactory.eINSTANCE.createURI(key), (Pair<String, String>)new Pair(null, (Object)value));
                preferenceKeys.add(key);
                continue;
            }
            tmpTransaction.setPolicy(key, false);
        }
        try {
            tmpTransaction.commit();
        }
        finally {
            tmpTransaction.close();
            resource.unload();
        }
        return preferenceKeys;
    }

    private static abstract class Choice {
        private final Image image;
        private final Image imageDisabled;
        private final String text;

        public Choice(Image image, String text) {
            this.image = image;
            this.text = text;
            this.imageDisabled = new Image(image.getDevice(), image, 1);
        }

        public Image getImage() {
            return this.image;
        }

        public String getText() {
            return this.text;
        }

        public int paintItem(GC gc, int x, int y, TaskItem taskItem, boolean enabled) {
            gc.drawImage(enabled ? this.image : this.imageDisabled, x, y);
            return x + 16 + 5;
        }

        public boolean isRecord() {
            return false;
        }

        public boolean hasTarget() {
            return this.isRecord();
        }

        public void applyTo(SyncAction syncAction) {
        }

        protected final void applyTo(SyncAction syncAction, SyncDelta delta, SyncActionType setActionType, SyncActionType removeActionType) {
            SetupTask newTask = delta.getNewTask();
            if (newTask == null) {
                syncAction.setResolvedType(removeActionType);
            } else {
                syncAction.setResolvedType(setActionType);
            }
        }

        private static final class RecordAlways
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Right");

            public RecordAlways(String targetText) {
                super(IMAGE, "Always record into " + targetText);
            }

            public boolean isRecord() {
                return true;
            }
        }

        private static final class RecordNever
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Exclude");

            public RecordNever(String targetText) {
                super(IMAGE, "Never record into " + targetText);
            }
        }

        private static final class RecordSkip
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Skip");

            public RecordSkip() {
                super(IMAGE, "Skip this time");
            }
        }

        private static final class SyncAlways
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Right");

            public SyncAlways(String serviceLabel) {
                super(IMAGE, "Always synchronize with " + serviceLabel);
            }

            public boolean hasTarget() {
                return true;
            }

            public void applyTo(SyncAction syncAction) {
                SyncDelta remoteDelta = syncAction.getRemoteDelta();
                if (remoteDelta != null) {
                    this.applyTo(syncAction, remoteDelta, SyncActionType.SET_REMOTE, SyncActionType.REMOVE_REMOTE);
                    return;
                }
                SyncDelta localDelta = syncAction.getLocalDelta();
                if (localDelta != null) {
                    this.applyTo(syncAction, localDelta, SyncActionType.SET_LOCAL, SyncActionType.REMOVE_LOCAL);
                    return;
                }
            }
        }

        private static final class SyncConflict
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Conflict");

            public SyncConflict(String serviceLabel) {
                super(IMAGE, "Conflict between local and " + serviceLabel + " values");
            }

            public boolean hasTarget() {
                return true;
            }

            public void applyTo(SyncAction syncAction) {
                syncAction.setResolvedType(SyncActionType.CONFLICT);
            }
        }

        private static final class SyncLocal
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Right");

            public SyncLocal() {
                super(IMAGE, "Resolve with local value");
            }

            public boolean hasTarget() {
                return true;
            }

            public void applyTo(SyncAction syncAction) {
                this.applyTo(syncAction, syncAction.getLocalDelta(), SyncActionType.SET_LOCAL, SyncActionType.REMOVE_LOCAL);
            }
        }

        private static final class SyncNever
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Exclude");

            public SyncNever(String serviceLabel) {
                super(IMAGE, "Never synchronize with " + serviceLabel);
            }

            public void applyTo(SyncAction syncAction) {
                syncAction.setResolvedType(SyncActionType.EXCLUDE);
            }
        }

        private static final class SyncRemote
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Left");

            public SyncRemote(String serviceLabel) {
                super(IMAGE, "Resolve with " + serviceLabel + " value");
            }

            public boolean hasTarget() {
                return true;
            }

            public void applyTo(SyncAction syncAction) {
                this.applyTo(syncAction, syncAction.getRemoteDelta(), SyncActionType.SET_REMOTE, SyncActionType.REMOVE_REMOTE);
            }
        }

        private static final class SyncSkip
        extends Choice {
            private static final Image IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Skip");

            public SyncSkip() {
                super(IMAGE, "Skip this time");
            }

            public void applyTo(SyncAction syncAction) {
                syncAction.setResolvedType(SyncActionType.NONE);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ColumnManager {
        private static final ColorRegistry COLOR_REGISTRY = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        private static final Color CHEVRON_COLOR = COLOR_REGISTRY.get("CONTENT_ASSIST_FOREGROUND_COLOR");
        private static final int CHEVRON_WIDTH = 9;
        private static final int WIDTH = 71;
        private static final int HEIGHT = 18;
        private final SynchronizerDialog dialog;
        private final Image targetImage;
        private final Image targetImageDisabled;

        public ColumnManager(final SynchronizerDialog dialog, TreeColumn targetColumn, Image targetImage) {
            this.dialog = dialog;
            this.targetImage = targetImage;
            this.targetImageDisabled = new Image(targetImage.getDevice(), targetImage, 1);
            targetColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (dialog.treePopulated) {
                        ColumnManager.this.handleToggleAllChoices();
                    }
                }
            });
        }

        protected void handleToggleAllChoices() {
            Choice choice;
            TreeItem[] items = this.dialog.tree.getItems();
            HashMap<Choice[], Choice> minimumnChoice = new HashMap<Choice[], Choice>();
            LinkedHashSet<TaskItem> taskItems = new LinkedHashSet<TaskItem>();
            this.visit(minimumnChoice, taskItems, items);
            boolean hasConflictChoice = false;
            for (Map.Entry entry : minimumnChoice.entrySet()) {
                Choice nextChoice;
                Choice[] choices = (Choice[])entry.getKey();
                int index = ColumnManager.indexOf(choices, (Choice)entry.getValue());
                Choice choice2 = nextChoice = index + 1 == choices.length ? choices[0] : choices[index + 1];
                if (nextChoice instanceof Choice.SyncConflict) {
                    nextChoice = choices[1];
                }
                if (nextChoice instanceof Choice.SyncLocal || nextChoice instanceof Choice.SyncRemote) {
                    hasConflictChoice = true;
                }
                entry.setValue(nextChoice);
            }
            if (hasConflictChoice) {
                for (Map.Entry entry : minimumnChoice.entrySet()) {
                    choice = (Choice)entry.getValue();
                    if (choice instanceof Choice.SyncLocal || choice instanceof Choice.SyncRemote) continue;
                    entry.setValue(((Choice[])entry.getKey())[0]);
                }
            }
            for (TaskItem taskItem : taskItems) {
                choice = (Choice)minimumnChoice.get(this.getChoices(taskItem));
                this.setChoice(taskItem, choice);
            }
            this.dialog.tree.redraw();
        }

        private void visit(Map<Choice[], Choice> minimumnChoice, Set<TaskItem> taskItems, TreeItem[] items) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TaskItem taskItem;
                TreeItem item = treeItemArray[n2];
                if (item instanceof TaskItem && !this.isChoiceDisabled(taskItem = (TaskItem)item)) {
                    taskItems.add(taskItem);
                    Choice[] choices = this.getChoices(taskItem);
                    Choice choice = this.getChoice(taskItem);
                    Choice currentMinimumChoice = minimumnChoice.get(choices);
                    if (currentMinimumChoice == null || ColumnManager.indexOf(choices, choice) < ColumnManager.indexOf(choices, currentMinimumChoice)) {
                        minimumnChoice.put(choices, choice);
                        currentMinimumChoice = choice;
                    }
                }
                this.visit(minimumnChoice, taskItems, item.getItems());
                ++n2;
            }
        }

        private static int indexOf(Choice[] choices, Choice choice) {
            int i = 0;
            while (i < choices.length) {
                if (choices[i] == choice) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public SynchronizerDialog getDialog() {
            return this.dialog;
        }

        public boolean isChoiceDisabled(TaskItem taskItem) {
            return false;
        }

        public abstract Choice[] getChoices(TaskItem var1);

        public abstract Choice getChoice(TaskItem var1);

        public abstract void setChoice(TaskItem var1, Choice var2);

        public void measureItem(Event event) {
            if (event.item instanceof TaskItem) {
                event.width = Math.max(event.width, 71);
                event.height = Math.max(event.height, 18);
            }
        }

        public void paintItem(Event event) {
            if (event.item instanceof TaskItem) {
                TaskItem taskItem = (TaskItem)event.item;
                GC gc = event.gc;
                int x = event.x + event.width + 10;
                int y = event.y + 1;
                Choice choice = this.getChoice(taskItem);
                boolean choiceDisabled = this.isChoiceDisabled(taskItem);
                boolean enabled = taskItem.getParent().isEnabled() && !choiceDisabled;
                x = choice.paintItem(gc, x, y, taskItem, enabled);
                gc.drawImage(enabled && choice.hasTarget() ? this.targetImage : this.targetImageDisabled, x, y);
                if (enabled) {
                    int[] chevronPoints = new int[]{(x += 21) + 1, y + 4, x + 4, y + 8, x + 8, y + 4};
                    if (CHEVRON_COLOR != null) {
                        Color oldBackground = gc.getBackground();
                        gc.setBackground(CHEVRON_COLOR);
                        gc.fillPolygon(chevronPoints);
                        gc.setBackground(oldBackground);
                    } else {
                        gc.fillPolygon(chevronPoints);
                    }
                }
            }
        }

        public boolean handleClick(final TaskItem taskItem, boolean close, final int column, Rectangle itemBounds, Point eventPoint, Point point) {
            final Tree tree = taskItem.getParent();
            if (!tree.isEnabled() || this.isChoiceDisabled(taskItem)) {
                return false;
            }
            Menu menu = tree.getMenu();
            if (menu != null) {
                menu.dispose();
            }
            if (close) {
                return false;
            }
            menu = new Menu((Control)tree);
            Choice currentChoice = this.getChoice(taskItem);
            Choice[] choiceArray = this.getChoices(taskItem);
            int n = choiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Choice choice = choiceArray[n2];
                if (!(choice instanceof Choice.SyncConflict)) {
                    MenuItem menuItem = new MenuItem(menu, 16);
                    menuItem.setSelection(choice == currentChoice);
                    menuItem.setImage(choice.getImage());
                    menuItem.setText(choice.getText());
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ColumnManager.this.handleMenu(taskItem, column, choice, tree);
                        }
                    });
                }
                ++n2;
            }
            Point location = tree.toDisplay(itemBounds.x, itemBounds.y);
            location.x += 4;
            location.y += itemBounds.height;
            menu.setLocation(location);
            menu.setVisible(true);
            return true;
        }

        public void handleMenu(TaskItem taskItem, int column, Choice choice, Tree tree) {
            this.dialog.mouseHandler.reset();
            this.setChoice(taskItem, choice);
            Rectangle bounds = taskItem.getBounds(column);
            tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }

        public void dispose() {
            this.targetImageDisabled.dispose();
        }
    }

    private static final class ConflictAdapter
    extends AdapterImpl {
        private ConflictAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == ConflictAdapter.class;
        }
    }

    private static final class LocalChoiceDisabledAdapter
    extends AdapterImpl {
        private LocalChoiceDisabledAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == LocalChoiceDisabledAdapter.class;
        }
    }

    private static final class LocalColumnManager
    extends ColumnManager {
        private final Choice[] choices = new Choice[3];

        public LocalColumnManager(SynchronizerDialog dialog) {
            super(dialog, dialog.localColumn, dialog.recorderTargetImage);
            this.choices[0] = new Choice.RecordAlways(dialog.recorderTargetText);
            this.choices[1] = new Choice.RecordNever(dialog.recorderTargetText);
            this.choices[2] = new Choice.RecordSkip();
        }

        public Choice[] getChoices(TaskItem taskItem) {
            return this.choices;
        }

        public Choice getChoice(TaskItem taskItem) {
            return taskItem.getLocalChoice();
        }

        public void setChoice(TaskItem taskItem, Choice choice) {
            taskItem.setLocalChoice(choice);
            PreferenceTask task = (PreferenceTask)taskItem.getTask();
            String key = task.getKey();
            URI uri = PreferencesFactory.eINSTANCE.createURI(key);
            SynchronizerDialog dialog = this.getDialog();
            RecorderTransaction transaction = dialog.recorderTransaction;
            Set recorderValuesToRemove = dialog.recorderValuesToRemove;
            if (choice instanceof Choice.RecordAlways) {
                transaction.setPolicy(key, true);
                recorderValuesToRemove.remove(uri);
            } else if (choice instanceof Choice.RecordNever) {
                transaction.setPolicy(key, false);
                recorderValuesToRemove.remove(uri);
            } else if (choice instanceof Choice.RecordSkip) {
                transaction.removePolicy(key);
                recorderValuesToRemove.add(uri);
            }
        }

        public boolean isChoiceDisabled(TaskItem taskItem) {
            return taskItem.isLocalChoiceDisabled();
        }

        public void handleMenu(TaskItem taskItem, int column, Choice choice, Tree tree) {
            super.handleMenu(taskItem, column, choice, tree);
            int nextColumn = column + 1;
            if (nextColumn < tree.getColumnCount()) {
                SynchronizerDialog dialog = this.getDialog();
                dialog.synchronizeLocal(true);
                Rectangle bounds = taskItem.getBounds(nextColumn);
                tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        RECORD_AND_SYNC(true, true),
        RECORD(true, false),
        SYNC(false, true);

        private final boolean record;
        private final boolean sync;

        private Mode(boolean record, boolean sync) {
            this.record = record;
            this.sync = sync;
        }

        public boolean isRecord() {
            return this.record;
        }

        public boolean isSync() {
            return this.sync;
        }
    }

    private final class MouseHandler
    implements Listener {
        private boolean lastOpen;
        private TaskItem lastTaskItem;
        private int lastColumn;

        private MouseHandler() {
        }

        public void reset() {
            this.lastOpen = false;
            this.lastTaskItem = null;
            this.lastColumn = 0;
        }

        public void handleEvent(Event event) {
            Point eventPoint = new Point(event.x, event.y);
            TreeItem treeItem = SynchronizerDialog.this.tree.getItem(eventPoint);
            if (treeItem instanceof TaskItem) {
                TaskItem taskItem = (TaskItem)treeItem;
                int columns = SynchronizerDialog.this.tree.getColumnCount();
                int column = 1;
                while (column < columns) {
                    Rectangle itemBounds = taskItem.getBounds(column);
                    if (itemBounds.contains(eventPoint)) {
                        int x = eventPoint.x - itemBounds.x;
                        int y = eventPoint.y - itemBounds.y;
                        boolean close = this.lastOpen && taskItem == this.lastTaskItem && column == this.lastColumn;
                        this.lastOpen = this.handleClick(taskItem, close, column, itemBounds, eventPoint, new Point(x, y));
                        this.lastTaskItem = taskItem;
                        this.lastColumn = column;
                        return;
                    }
                    ++column;
                }
            }
            this.reset();
        }

        private boolean handleClick(TaskItem taskItem, boolean close, int column, Rectangle itemBounds, Point eventPoint, Point point) {
            ColumnManager manager = SynchronizerDialog.this.getColumnManager(column);
            if (manager != null) {
                return manager.handleClick(taskItem, close, column, itemBounds, eventPoint, point);
            }
            return false;
        }
    }

    private static final class NodeItem
    extends TreeItem {
        private static Image compoundImage;

        public NodeItem(Tree tree, ComposedAdapterFactory adapterFactory, String text) {
            super(tree, 0);
            if (compoundImage == null) {
                CompoundTask compoundTask = SetupFactory.eINSTANCE.createCompoundTask();
                ItemProviderAdapter compoundItemProvider = (ItemProviderAdapter)adapterFactory.adapt((Notifier)compoundTask, IItemLabelProvider.class);
                compoundImage = SetupUIPlugin.INSTANCE.getSWTImage(SetupLabelProvider.getImageDescriptor(compoundItemProvider, (EObject)compoundTask));
            }
            this.setImage(compoundImage);
            this.setText(text);
        }

        protected void checkSubclass() {
        }
    }

    private final class PaintHandler
    implements Listener {
        private PaintHandler() {
        }

        public void handleEvent(Event event) {
            ColumnManager manager = SynchronizerDialog.this.getColumnManager(event.index);
            if (manager != null) {
                switch (event.type) {
                    case 41: {
                        manager.measureItem(event);
                        break;
                    }
                    case 42: {
                        manager.paintItem(event);
                    }
                }
            }
        }
    }

    public static final class PolicyAndValue {
        private final boolean record;
        private final String value;

        public PolicyAndValue() {
            this.record = false;
            this.value = null;
        }

        public PolicyAndValue(String value) {
            this.record = true;
            this.value = value;
        }

        public boolean isRecord() {
            return this.record;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.record ? "record (" + this.value + ")" : "ignore";
        }
    }

    private static final class RemoteColumnManager
    extends ColumnManager {
        private static final Image TARGET_IMAGE = SetupUIPlugin.INSTANCE.getSWTImage("sync/Remote");
        private final Choice[] normalChoices = new Choice[3];
        private final Choice[] conflictChoices = new Choice[5];

        public RemoteColumnManager(SynchronizerDialog dialog, String serviceLabel) {
            super(dialog, dialog.remoteColumn, TARGET_IMAGE);
            this.normalChoices[0] = new Choice.SyncAlways(serviceLabel);
            this.normalChoices[1] = new Choice.SyncNever(serviceLabel);
            this.normalChoices[2] = new Choice.SyncSkip();
            this.conflictChoices[0] = new Choice.SyncConflict(serviceLabel);
            this.conflictChoices[1] = new Choice.SyncLocal();
            this.conflictChoices[2] = new Choice.SyncRemote(serviceLabel);
            this.conflictChoices[3] = new Choice.SyncNever(serviceLabel);
            this.conflictChoices[4] = new Choice.SyncSkip();
        }

        protected void handleToggleAllChoices() {
            super.handleToggleAllChoices();
            this.getDialog().adjustSyncActions(null);
        }

        public Choice[] getChoices(TaskItem taskItem) {
            return taskItem.isConflict() ? this.conflictChoices : this.normalChoices;
        }

        public Choice getChoice(TaskItem taskItem) {
            return taskItem.getRemoteChoice();
        }

        public void setChoice(TaskItem taskItem, Choice choice) {
            taskItem.setRemoteChoice(choice);
        }

        public void measureItem(Event event) {
            if (this.isApplicable(event.item)) {
                super.measureItem(event);
            }
        }

        public void paintItem(Event event) {
            if (this.isApplicable(event.item)) {
                super.paintItem(event);
            }
        }

        public boolean handleClick(TaskItem taskItem, boolean close, int column, Rectangle itemBounds, Point eventPoint, Point point) {
            if (this.isApplicable((Widget)taskItem)) {
                return super.handleClick(taskItem, close, column, itemBounds, eventPoint, point);
            }
            return false;
        }

        public void handleMenu(TaskItem taskItem, int column, Choice choice, Tree tree) {
            super.handleMenu(taskItem, column, choice, tree);
            SynchronizerDialog dialog = this.getDialog();
            dialog.adjustSyncActions(null);
        }

        private boolean isApplicable(Widget item) {
            TaskItem taskItem;
            Choice localChoice;
            return !(item instanceof TaskItem) || (localChoice = (taskItem = (TaskItem)item).getLocalChoice()) == null || localChoice.isRecord();
        }
    }

    private static final class TaskItem
    extends TreeItem {
        private final SetupTask task;
        private final boolean conflict;
        private final boolean localChoiceDisabled;
        private Choice localChoice;
        private Choice remoteChoice;

        public TaskItem(NodeItem nodeItem, SetupTask task, boolean conflict, boolean localChoiceDisabled, Image image, String text) {
            super((TreeItem)nodeItem, 0);
            this.task = task;
            this.conflict = conflict;
            this.localChoiceDisabled = localChoiceDisabled;
            this.setImage(image);
            this.setText(text);
        }

        public SetupTask getTask() {
            return this.task;
        }

        public boolean isConflict() {
            return this.conflict;
        }

        public boolean isLocalChoiceDisabled() {
            return this.localChoiceDisabled;
        }

        public Choice getLocalChoice() {
            return this.localChoice;
        }

        public void setLocalChoice(Choice choice) {
            this.localChoice = choice;
        }

        public Choice getRemoteChoice() {
            return this.remoteChoice;
        }

        public void setRemoteChoice(Choice choice) {
            this.remoteChoice = choice;
        }

        protected void checkSubclass() {
        }
    }
}

