/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLOptionsImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeDocumentRoot;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.io.MetadataWriter;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryIO;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.p2.internal.core.RepositoryIndex;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.eclipse.oomph.util.ZIPUtil;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryIntegrityAnalyzer
implements IApplication {
    private static final String DOWNLOAD_ECLIPSE_ORG_AUTHORITY = "download.eclipse.org";
    private static final File DOWNLOAD_ECLIPSE_ORG_FOLDER = new File("/home/data/httpd/download.eclipse.org");
    private static final boolean DOWNLOAD_ECLIPSE_ORG_FOLDER_EXISTS = DOWNLOAD_ECLIPSE_ORG_FOLDER.exists();
    private static final String DOWNLOAD_ECLIPSE_ORG_FOLDER_URI = DOWNLOAD_ECLIPSE_ORG_FOLDER.toURI().toString();
    private static final String DOWNLOAD_ECLIPSE_ORG_SERVER_URI = "https://download.eclipse.org/";
    private static final String PROCESSED = ".processed";
    private static final Comparator<IInstallableUnit> NAME_VERSION_COMPARATOR = new Comparator<IInstallableUnit>(){
        private final Comparator<String> comparator = CommonPlugin.INSTANCE.getComparator();

        @Override
        public int compare(IInstallableUnit iu1, IInstallableUnit iu2) {
            int result;
            String name2;
            String name1 = iu1.getProperty("org.eclipse.equinox.p2.name", null);
            if (name1 == null) {
                name1 = iu1.getId();
            }
            if ((name2 = iu2.getProperty("org.eclipse.equinox.p2.name", null)) == null) {
                name2 = iu2.getId();
            }
            if ((result = this.comparator.compare(name1, name2)) == 0) {
                result = iu1.getVersion().compareTo((Object)iu2.getVersion());
            }
            return result;
        }
    };
    private final Map<String, Report.LicenseDetail> details = new LinkedHashMap<String, Report.LicenseDetail>();
    private final Map<URI, Report> reports = new LinkedHashMap<URI, Report>();
    private final Map<java.net.URI, IMetadataRepository> metadataRepositories = new LinkedHashMap<java.net.URI, IMetadataRepository>();
    private final Map<java.net.URI, IArtifactRepository> artifactRepositories = new LinkedHashMap<java.net.URI, IArtifactRepository>();
    private final Map<URI, byte[]> imageBytes = new HashMap<URI, byte[]>();
    private final Map<Object, String> images = new HashMap<Object, String>();
    private final Map<File, Future<List<String>>> fileIndices = new TreeMap<File, Future<List<String>>>();
    private Agent agent;
    private ExecutorService executor;
    private boolean verbose;

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        File outputLocation = new File(".").getCanonicalFile();
        File publishLocation = null;
        String reportSource = "https://ci.eclipse.org/oomph/job/repository-analyzer/";
        String reportBranding = "https://wiki.eclipse.org/images/d/dc/Oomph_Project_Logo.png";
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                File file;
                String option = arguments[i];
                if ("-output".equals(option) || "-o".equals(option)) {
                    file = new File(arguments[++i]);
                    outputLocation = file.getCanonicalFile();
                } else if ("-publish".equals(option) || "-p".equals(option)) {
                    file = new File(arguments[++i]);
                    publishLocation = file.getCanonicalFile();
                } else if ("-source".equals(option) || "-s".equals(option)) {
                    reportSource = arguments[++i];
                } else if ("-branding".equals(option) || "-b".equals(option)) {
                    reportBranding = arguments[++i];
                } else if ("-verbose".equals(option) || "-v".equals(option)) {
                    this.verbose = true;
                } else {
                    URI uri = URI.createURI((String)arguments[i]);
                    if ("".equals(uri.lastSegment())) {
                        uri = uri.trimSegments(1);
                    }
                    uris.add(uri);
                }
                ++i;
            }
        }
        reportBranding = reportBranding.replaceFirst("https:", "http:");
        RepositoryIntegrityAnalyzer.createFolders(outputLocation);
        CompositeMetadataRepository metadataRepository = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)this.getAgent().getProvisioningAgent());
        this.metadataRepositories.put(metadataRepository.getLocation(), (IMetadataRepository)metadataRepository);
        for (URI uri : uris) {
            metadataRepository.addChild(this.toInternalRepositoryLocation(uri));
        }
        CompositeArtifactRepository artifactRepository = CompositeArtifactRepository.createMemoryComposite((IProvisioningAgent)this.getAgent().getProvisioningAgent());
        this.artifactRepositories.put(metadataRepository.getLocation(), (IArtifactRepository)artifactRepository);
        for (URI uri : uris) {
            artifactRepository.addChild(this.toInternalRepositoryLocation(uri));
        }
        File artifactCacheLocation = new File(outputLocation, "artifacts");
        artifactCacheLocation.mkdir();
        RepositoryIndex repositoryIndex = RepositoryIndex.create("\n");
        HashSet<File> reportLocations = new HashSet<File>();
        TreeMap<String, String> allReports = new TreeMap<String, String>();
        for (URI uri : uris) {
            if (this.verbose) {
                System.out.println("Computing report information for '" + uri + "'");
            }
            String relativePath = RepositoryIntegrityAnalyzer.toRelativePath(uri);
            File reportLocation = new File(outputLocation, relativePath);
            reportLocations.add(reportLocation);
            IOUtil.deleteBestEffort((File)reportLocation);
            RepositoryIntegrityAnalyzer.createFolders(reportLocation);
            Report report = this.generateReport(null, uri, outputLocation, uri, reportLocation, artifactCacheLocation, reportSource, reportBranding);
            if (this.verbose) {
                System.out.println("Waiting for report information completion for '" + uri + "'");
            }
            this.shutDownExecutor();
            this.emitReport(allReports, new HashSet<Report>(), report, reportLocation, repositoryIndex);
            if (publishLocation != null) {
                File reportPublishLocation = new File(publishLocation, relativePath);
                RepositoryIntegrityAnalyzer.publish(reportLocation, reportPublishLocation);
                if (this.verbose) {
                    System.out.println("Publish report for '" + uri + "' to '" + reportPublishLocation);
                }
            }
            this.images.clear();
            this.reports.clear();
        }
        reportLocations.add(artifactCacheLocation);
        IndexReport indexReport = new IndexReport(null, reportSource, reportBranding, outputLocation, publishLocation, reportLocations, allReports);
        this.generateIndex(indexReport, repositoryIndex, reportSource, reportBranding);
        return null;
    }

    private java.net.URI toInternalRepositoryLocation(URI uri) throws URISyntaxException {
        if (DOWNLOAD_ECLIPSE_ORG_AUTHORITY.equals(uri.authority()) && DOWNLOAD_ECLIPSE_ORG_FOLDER_EXISTS) {
            File file = DOWNLOAD_ECLIPSE_ORG_FOLDER;
            String[] stringArray = uri.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                file = new File(file, segment);
                ++n2;
            }
            boolean exists = file.exists();
            if (this.verbose) {
                System.out.println("Redirecting '" + uri + "' to '" + file + "' success=" + exists);
            }
            if (exists) {
                return file.toURI();
            }
        }
        java.net.URI location = new java.net.URI(uri.toString());
        return location;
    }

    private URI toExternalRepositoryLocation(java.net.URI child) {
        URI uri;
        String downloadEclipseOrgFolderLocation;
        String childLocation = child.toString();
        if (childLocation.startsWith(downloadEclipseOrgFolderLocation = DOWNLOAD_ECLIPSE_ORG_FOLDER_URI.toString())) {
            URI.createURI((String)(DOWNLOAD_ECLIPSE_ORG_SERVER_URI + childLocation.substring(DOWNLOAD_ECLIPSE_ORG_FOLDER_URI.length())));
        }
        if ("".equals((uri = URI.createURI((String)child.toString())).lastSegment())) {
            uri = uri.trimSegments(1);
        }
        return uri;
    }

    private static String toRelativePath(URI uri) {
        String device;
        StringBuilder result = new StringBuilder();
        String authority = uri.authority();
        if (!StringUtil.isEmpty((String)authority)) {
            result.append(IOUtil.encodeFileName((String)authority));
        }
        if (!StringUtil.isEmpty((String)(device = uri.device()))) {
            if (result.length() != 0) {
                result.append("/");
            }
            result.append(IOUtil.encodeFileName((String)device));
        }
        String[] stringArray = uri.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!StringUtil.isEmpty((String)segment)) {
                if (result.length() != 0) {
                    result.append("/");
                }
                result.append(IOUtil.encodeFileName((String)segment));
            }
            ++n2;
        }
        return result.toString();
    }

    private static void publish(File outputLocation, File publishLocation) throws IOException {
        File newPublishLocation = new File(String.valueOf(publishLocation.toString()) + ".new");
        if (newPublishLocation.exists() && !IOUtil.deleteBestEffort((File)newPublishLocation)) {
            throw new IOException("The location '" + newPublishLocation + "' cannot be deleted");
        }
        IOUtil.copyTree((File)outputLocation, (File)newPublishLocation);
        File oldPublishLocation = null;
        if (publishLocation.exists()) {
            oldPublishLocation = new File(String.valueOf(publishLocation.toString()) + ".old");
            if (oldPublishLocation.exists() && !IOUtil.deleteBestEffort((File)oldPublishLocation)) {
                throw new IOException("The location '" + oldPublishLocation + "' cannot be deleted");
            }
            if (!publishLocation.renameTo(oldPublishLocation)) {
                throw new IOException("The location '" + publishLocation + "' cannot be renamed to '" + oldPublishLocation + "'");
            }
        }
        if (!newPublishLocation.renameTo(publishLocation)) {
            throw new IOException("The location '" + newPublishLocation + "' cannot be renamed to '" + publishLocation + "'");
        }
        if (oldPublishLocation != null) {
            IOUtil.deleteBestEffort(oldPublishLocation);
        }
    }

    private static void createFolders(File folder) throws IOException {
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                throw new IOException("The location '" + folder + "' already exists as a file");
            }
        } else if (!folder.mkdirs()) {
            throw new IOException("The location '" + folder + "' cannot be created as a directory");
        }
    }

    private void generateIndex(IndexReport indexReport, RepositoryIndex repositoryIndex, String reportSource, String reportBranding) throws IOException {
        if (this.verbose) {
            System.out.println("Generating report index for '" + indexReport.getFolder());
        }
        String result = repositoryIndex.generate(indexReport);
        this.images.clear();
        FileOutputStream out = null;
        try {
            File outputLocation = indexReport.getFolder();
            File index = new File(outputLocation, "index.html");
            out = new FileOutputStream(index);
            new PrintStream((OutputStream)out, false, "UTF-8").print(result);
            File publishLocation = indexReport.getPublishLocation();
            if (publishLocation != null) {
                IOUtil.copyFile((File)index, (File)new File(publishLocation, "index.html"));
                File[] fileArray = outputLocation.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String name = file.getName();
                    if (name.endsWith(".png")) {
                        IOUtil.copyFile((File)file, (File)new File(publishLocation, name));
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(out);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)out);
        for (IndexReport child : indexReport.getChildren()) {
            this.generateIndex(child, repositoryIndex, reportSource, reportBranding);
        }
    }

    private void emitReport(Map<String, String> allReports, Set<Report> visited, Report report, final File outputLocation, final RepositoryIndex repositoryIndexEmitter) throws IOException, InterruptedException {
        if (visited.add(report)) {
            if (this.verbose) {
                System.out.println("Emmitting report for '" + report.getSiteURL() + "'");
            }
            String result = repositoryIndexEmitter.generate(report);
            String relativeIndexURL = report.getRelativeIndexURL();
            if (outputLocation == null) {
                System.out.println("---" + relativeIndexURL + "---");
                System.out.println(result);
            } else {
                FileOutputStream out = null;
                try {
                    File reportOutputLocation = new File(outputLocation, relativeIndexURL);
                    out = new FileOutputStream(reportOutputLocation);
                    allReports.put(report.getSiteURL(), reportOutputLocation.toString());
                    new PrintStream((OutputStream)out, false, "UTF-8").print(result);
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(out);
                    throw throwable;
                }
                IOUtil.closeSilent((Closeable)out);
            }
            List<IUReport> iuReports = report.getIUReports();
            if (!iuReports.isEmpty()) {
                URI iuReportFolder = URI.createURI((String)relativeIndexURL).trimFileExtension();
                new File(outputLocation, iuReportFolder.toString()).mkdir();
                ExecutorService executor = this.getExecutor();
                ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
                for (final IUReport iUReport : iuReports) {
                    futures.add(executor.submit(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            String iuResult = repositoryIndexEmitter.generate(iUReport);
                            String relativeIUReportURL = iUReport.getRelativeReportURL();
                            FileOutputStream out = null;
                            try {
                                out = new FileOutputStream(new File(outputLocation, relativeIUReportURL));
                                new PrintStream((OutputStream)out, false, "UTF-8").print(iuResult);
                            }
                            catch (Throwable throwable) {
                                IOUtil.closeSilent(out);
                                throw throwable;
                            }
                            IOUtil.closeSilent((Closeable)out);
                            return null;
                        }
                    }));
                }
                if (this.verbose) {
                    System.out.println("Emmitting report IU details for '" + report.getSiteURL() + "'");
                }
                for (Future future : futures) {
                    RepositoryIntegrityAnalyzer.get(future);
                }
            }
            for (Report childReport : report.getChildren()) {
                this.emitReport(allReports, visited, childReport, outputLocation, repositoryIndexEmitter);
            }
        }
    }

    public void stop() {
    }

    private Report.LicenseDetail getLicenseDetail(ILicense license, boolean demandCreate) {
        java.net.URI location = license.getLocation();
        URI locationURI = location == null ? Report.NO_LICENSE_URI : URI.createURI((String)location.toString());
        String uuid = license.getUUID();
        Report.LicenseDetail licenseDetail = this.details.get(uuid);
        if (licenseDetail == null && demandCreate) {
            licenseDetail = new Report.LicenseDetail(locationURI, license);
            this.details.put(uuid, licenseDetail);
        }
        return licenseDetail;
    }

    private List<Report.LicenseDetail> getLicenses(IInstallableUnit installableUnit) {
        ArrayList<Report.LicenseDetail> result = new ArrayList<Report.LicenseDetail>();
        Collection licenses = installableUnit.getLicenses(null);
        if (licenses.isEmpty()) {
            result.add(this.getLicenseDetail(Report.NO_LICENSE, true));
        } else {
            for (ILicense license : licenses) {
                result.add(this.getLicenseDetail(license, true));
            }
        }
        return result;
    }

    private Set<IInstallableUnit> query(IMetadataRepository metadataRepository, IQuery<IInstallableUnit> query) {
        IQueryResult queryResult = metadataRepository.query(query, (IProgressMonitor)new NullProgressMonitor());
        TreeSet<IInstallableUnit> result = new TreeSet<IInstallableUnit>();
        for (IInstallableUnit iu : P2Util.asIterable(queryResult)) {
            result.add(iu);
        }
        return result;
    }

    public Report generateReport(Report parentReport, URI rootURI, File rootOutputLocation, URI uri, File outputLocation, File artifactCacheFolder, String reportSource, String reportBranding) throws Exception {
        Report report = this.reports.get(uri);
        if (report == null) {
            IArtifactRepository loadedArtifactRepository;
            this.reports.put(uri, null);
            final IMetadataRepository metadataRepository = this.loadMetadataRepository(this.getMetadataRepositoryManager(), uri);
            try {
                loadedArtifactRepository = this.loadArtifactRepository(this.getArtifactRepositoryManager(), uri);
            }
            catch (ProvisionException provisionException) {
                loadedArtifactRepository = null;
            }
            IArtifactRepository artifactRepository = loadedArtifactRepository;
            LinkedHashMap<IArtifactKey, Future<Map<IArtifactDescriptor, File>>> artifactCache = new LinkedHashMap<IArtifactKey, Future<Map<IArtifactDescriptor, File>>>();
            Set<IInstallableUnit> allIUs = this.query(metadataRepository, (IQuery<IInstallableUnit>)QueryUtil.createIUAnyQuery());
            if (artifactRepository != null) {
                for (IInstallableUnit iu : allIUs) {
                    for (IArtifactKey artifactKey : iu.getArtifacts()) {
                        this.getArtifacts(artifactKey, artifactRepository, artifactCache, artifactCacheFolder);
                    }
                }
            }
            Set<IInstallableUnit> productIUs = this.query(metadataRepository, (IQuery<IInstallableUnit>)QueryUtil.createIUProductQuery());
            LinkedHashMap licenseIUs = new LinkedHashMap();
            for (ILicense sua : Report.SUAS) {
                licenseIUs.put(this.getLicenseDetail(sua, true), new LinkedHashSet());
            }
            HashSet<String> expectedDuplicates = new HashSet<String>();
            expectedDuplicates.add("a.jre.javase");
            expectedDuplicates.add("config.a.jre.javase");
            IQueryResult groupQuery = metadataRepository.query(QueryUtil.createIUGroupQuery(), (IProgressMonitor)new NullProgressMonitor());
            for (IInstallableUnit iu : P2Util.asIterable(groupQuery)) {
                CollectionUtil.addAll(licenseIUs, this.getLicenses(iu), (Object)iu);
                HashSet<String> ids = new HashSet<String>();
                for (IRequirement requirement : iu.getRequirements()) {
                    String name;
                    Object requiredCapability;
                    String namespace;
                    if (!(requirement instanceof IRequiredCapability) || !"org.eclipse.equinox.p2.iu".equals(namespace = (requiredCapability = (IRequiredCapability)requirement).getNamespace()) || ids.add(name = requiredCapability.getName())) continue;
                    expectedDuplicates.add(name);
                }
            }
            LinkedHashMap<Report.LicenseDetail, Object> sortedLicenseIUs = new LinkedHashMap<Report.LicenseDetail, Object>();
            while (!licenseIUs.isEmpty()) {
                Map.Entry biggestEntry = null;
                for (Map.Entry entry : licenseIUs.entrySet()) {
                    if (biggestEntry == null) {
                        biggestEntry = entry;
                        continue;
                    }
                    if (((Set)biggestEntry.getValue()).size() >= ((Set)entry.getValue()).size()) continue;
                    biggestEntry = entry;
                }
                licenseIUs.remove(biggestEntry.getKey());
                Set ius = (Set)biggestEntry.getValue();
                if (ius.isEmpty()) break;
                TreeSet<IInstallableUnit> sortedLicenseIUValues = new TreeSet<IInstallableUnit>(NAME_VERSION_COMPARATOR);
                sortedLicenseIUValues.addAll((Collection)biggestEntry.getValue());
                sortedLicenseIUs.put((Report.LicenseDetail)biggestEntry.getKey(), sortedLicenseIUValues);
            }
            ArrayList<IInstallableUnit> featureIUs = new ArrayList<IInstallableUnit>();
            for (IInstallableUnit featureIU : P2Util.asIterable(groupQuery)) {
                if ("true".equals(featureIU.getProperty("org.eclipse.equinox.p2.type.product"))) continue;
                featureIUs.add(featureIU);
            }
            Collections.sort(featureIUs, NAME_VERSION_COMPARATOR);
            LinkedHashMap<IInstallableUnit, Future<URI>> brandingImages = new LinkedHashMap<IInstallableUnit, Future<URI>>();
            if (artifactRepository != null) {
                for (IInstallableUnit featureIU : featureIUs) {
                    this.getBrandingImage(featureIU, metadataRepository, artifactRepository, brandingImages, artifactCache, artifactCacheFolder);
                }
            }
            LinkedHashMap<IInstallableUnit, Map<File, Future<SignedContent>>> signedContentCache = new LinkedHashMap<IInstallableUnit, Map<File, Future<SignedContent>>>();
            for (IInstallableUnit iu : allIUs) {
                this.getSignedContent(iu, artifactCache, signedContentCache);
            }
            HashMap<Object, IRequirement> requiredCapabilities = new HashMap<Object, IRequirement>();
            HashMap<IRequirement, Future<Set<IInstallableUnit>>> futures = new HashMap<IRequirement, Future<Set<IInstallableUnit>>>();
            HashMap requiringIUs = new HashMap();
            for (IInstallableUnit iu : allIUs) {
                for (final IRequirement requirement : iu.getRequirements()) {
                    CollectionUtil.add(requiringIUs, (Object)requirement, (Object)iu);
                    Future future = (Future)futures.get(requirement);
                    if (future != null) continue;
                    IMatchExpression match = requirement.getMatches();
                    if (RequiredCapability.isVersionRangeRequirement((IMatchExpression)match)) {
                        ArrayList key = new ArrayList(3);
                        key.add(RequiredCapability.extractNamespace((IMatchExpression)match));
                        key.add(RequiredCapability.extractName((IMatchExpression)match));
                        key.add(RequiredCapability.extractRange((IMatchExpression)match).toString());
                        requiredCapabilities.put(key, requirement);
                    }
                    futures.put(requirement, this.getExecutor().submit(new Callable<Set<IInstallableUnit>>(){

                        @Override
                        public Set<IInstallableUnit> call() throws Exception {
                            return RepositoryIntegrityAnalyzer.this.query(metadataRepository, (IQuery<IInstallableUnit>)QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0]));
                        }
                    }));
                }
            }
            HashMap allProvidedCapabilities = new HashMap();
            HashMap<IRequirement, Set> resolvedRequirements = new HashMap<IRequirement, Set>();
            HashMap resolvedCapabilities = new HashMap();
            HashMap capabilityResolutions = new HashMap();
            HashMap requirementResolutions = new HashMap();
            for (Map.Entry entry : futures.entrySet()) {
                IRequirement requirement = (IRequirement)entry.getKey();
                Set ius = (Set)RepositoryIntegrityAnalyzer.get((Future)entry.getValue());
                resolvedRequirements.put(requirement, ius);
                if (!(requirement instanceof IRequiredCapability)) continue;
                IRequiredCapability requiredCapability = (IRequiredCapability)requirement;
                String requirementNamespace = requiredCapability.getNamespace();
                String requirementName = requiredCapability.getName();
                VersionRange range = requiredCapability.getRange();
                for (IInstallableUnit iInstallableUnit : ius) {
                    Collection providedCapabilities = iInstallableUnit.getProvidedCapabilities();
                    for (IProvidedCapability providedCapability : providedCapabilities) {
                        String namespace = providedCapability.getNamespace();
                        String name = providedCapability.getName();
                        Version version = providedCapability.getVersion();
                        ArrayList<String> key = new ArrayList<String>();
                        key.add(namespace);
                        key.add(name);
                        key.add(version.toString());
                        allProvidedCapabilities.put(key, providedCapability);
                        if (!ObjectUtil.equals((Object)requirementNamespace, (Object)namespace) || !ObjectUtil.equals((Object)requirementName, (Object)name) || !range.isIncluded(version)) continue;
                        CollectionUtil.add(capabilityResolutions, (Object)providedCapability, (Object)requirement);
                        CollectionUtil.add(requirementResolutions, (Object)requirement, (Object)providedCapability);
                        Set resolvedIUs = (Set)requiringIUs.get(requirement);
                        if (resolvedIUs == null) continue;
                        for (IInstallableUnit resolvedIU : resolvedIUs) {
                            CollectionUtil.add(resolvedCapabilities, (Object)providedCapability, (Object)resolvedIU);
                        }
                    }
                }
            }
            TreeMap iuFiles = new TreeMap();
            TreeMap<File, SignedContent> fileSignedContents = new TreeMap<File, SignedContent>();
            TreeMap<File, List<String>> localFileIndices = new TreeMap<File, List<String>>();
            TreeSet<IInstallableUnit> classContainingIUs = new TreeSet<IInstallableUnit>();
            TreeMap iuIDVersions = new TreeMap();
            for (IInstallableUnit iu : allIUs) {
                LinkedHashSet<File> files = new LinkedHashSet<File>();
                block19: for (Map.Entry entry : ((Map)signedContentCache.get(iu)).entrySet()) {
                    File file = (File)entry.getKey();
                    files.add(file);
                    SignedContent signedContent = (SignedContent)RepositoryIntegrityAnalyzer.get((Future)entry.getValue());
                    fileSignedContents.put(file, signedContent);
                    List<String> index = RepositoryIntegrityAnalyzer.get(this.getIndex(file));
                    localFileIndices.put(file, index);
                    for (String string : index) {
                        if (!string.endsWith(".class")) continue;
                        classContainingIUs.add(iu);
                        continue block19;
                    }
                }
                iuFiles.put(iu, files);
                CollectionUtil.add(iuIDVersions, (Object)iu.getId(), (Object)iu.getVersion());
            }
            ArrayList<Report> childReports = new ArrayList<Report>();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class MyReport
            extends Report {
                private Set<IInstallableUnit> pluginsWithMissingPackGZ;
                private Set<IInstallableUnit> unsignedIUs;
                private Set<IInstallableUnit> badProviderIUs;
                private Set<IInstallableUnit> badLicenseIUs;
                private Set<IInstallableUnit> brokenBrandingIUs;
                private Map<List<Certificate>, Map<String, IInstallableUnit>> certificates;
                private final /* synthetic */ Set val$allIUs;
                private final /* synthetic */ Map val$artifactCache;
                private final /* synthetic */ File val$rootOutputLocation;
                private final /* synthetic */ URI val$uri;
                private final /* synthetic */ URI val$rootURI;
                private final /* synthetic */ IMetadataRepository val$metadataRepository;
                private final /* synthetic */ String val$reportSource;
                private final /* synthetic */ String val$reportBranding;
                private final /* synthetic */ File val$outputLocation;
                private final /* synthetic */ Map val$brandingImages;
                private final /* synthetic */ List val$featureIUs;
                private final /* synthetic */ Map val$iuIDVersions;
                private final /* synthetic */ Set val$classContainingIUs;
                private final /* synthetic */ Map val$iuFiles;
                private final /* synthetic */ Map val$fileSignedContents;
                private final /* synthetic */ File val$artifactCacheFolder;
                private final /* synthetic */ Report val$parentReport;
                private final /* synthetic */ List val$childReports;
                private final /* synthetic */ IArtifactRepository val$artifactRepository;
                private final /* synthetic */ Map val$sortedLicenseIUs;
                private final /* synthetic */ Set val$productIUs;
                private final /* synthetic */ Set val$expectedDuplicates;
                private final /* synthetic */ Map val$resolvedRequirements;
                private final /* synthetic */ Map val$allProvidedCapabilities;
                private final /* synthetic */ Map val$resolvedCapabilities;
                private final /* synthetic */ Map val$capabilityResolutions;
                private final /* synthetic */ Map val$requiredCapabilities;
                private final /* synthetic */ Map val$requirementResolutions;

                MyReport(Set set, Map map, File file, URI uRI, URI uRI2, IMetadataRepository iMetadataRepository, String string, String string2, File file2, Map map2, List list, Map map3, Set set2, Map map4, Map map5, File file3, Report report, List list2, IArtifactRepository iArtifactRepository, Map map6, Set set3, Set set4, Map map7, Map map8, Map map9, Map map10, Map map11, Map map12) {
                    this.val$allIUs = set;
                    this.val$artifactCache = map;
                    this.val$rootOutputLocation = file;
                    this.val$uri = uRI;
                    this.val$rootURI = uRI2;
                    this.val$metadataRepository = iMetadataRepository;
                    this.val$reportSource = string;
                    this.val$reportBranding = string2;
                    this.val$outputLocation = file2;
                    this.val$brandingImages = map2;
                    this.val$featureIUs = list;
                    this.val$iuIDVersions = map3;
                    this.val$classContainingIUs = set2;
                    this.val$iuFiles = map4;
                    this.val$fileSignedContents = map5;
                    this.val$artifactCacheFolder = file3;
                    this.val$parentReport = report;
                    this.val$childReports = list2;
                    this.val$artifactRepository = iArtifactRepository;
                    this.val$sortedLicenseIUs = map6;
                    this.val$productIUs = set3;
                    this.val$expectedDuplicates = set4;
                    this.val$resolvedRequirements = map7;
                    this.val$allProvidedCapabilities = map8;
                    this.val$resolvedCapabilities = map9;
                    this.val$capabilityResolutions = map10;
                    this.val$requiredCapabilities = map11;
                    this.val$requirementResolutions = map12;
                }

                public void getArtifacts() {
                    TreeMap artifacts = new TreeMap();
                    for (IInstallableUnit iu : this.val$allIUs) {
                        for (IArtifactKey artifactKey : iu.getArtifacts()) {
                            for (File file : ((Map)RepositoryIntegrityAnalyzer.get((Future)this.val$artifactCache.get(artifactKey))).values()) {
                                CollectionUtil.add(artifacts, (Object)file, (Object)iu);
                            }
                        }
                    }
                }

                @Override
                public Map<String, String> getBreadcrumbs() {
                    LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                    String rootFolderName = this.val$rootOutputLocation.getName();
                    result.put(rootFolderName, null);
                    int segmentCount = this.val$uri.segmentCount();
                    URI relativeURI = URI.createURI((String)RepositoryIntegrityAnalyzer.toRelativePath(this.val$uri));
                    int relativeSegmentCount = relativeURI.segmentCount();
                    int extraSegmentCount = relativeSegmentCount - segmentCount;
                    int depth = URI.createURI((String)RepositoryIntegrityAnalyzer.toRelativePath(this.val$rootURI)).segmentCount();
                    int i = 0;
                    while (i < relativeSegmentCount) {
                        String segment = relativeURI.segment(i);
                        Object href = null;
                        URI parentURI = this.val$uri.trimSegments(relativeSegmentCount - i - extraSegmentCount);
                        Report parentReport = (Report)RepositoryIntegrityAnalyzer.this.reports.get(parentURI);
                        if (parentReport == null) {
                            int j = i + extraSegmentCount;
                            while (j < depth) {
                                href = href == null ? URI.createURI((String)"..") : href.appendSegment("..");
                                ++j;
                            }
                            href = href == null ? URI.createURI((String)"index.html") : href.appendSegment("index.html");
                        } else if (parentReport != this) {
                            int j = i + extraSegmentCount;
                            while (j < depth) {
                                href = href == null ? URI.createURI((String)"..") : href.appendSegment("..");
                                ++j;
                            }
                            String relativeIndexURL = parentReport.getRelativeIndexURL();
                            href = href == null ? URI.createURI((String)relativeIndexURL) : href.appendSegment(relativeIndexURL);
                            result.put(segment, href.toString());
                        }
                        result.put(segment, href == null ? null : href.toString());
                        if (i == 0) {
                            result.put(rootFolderName, href == null ? "../index.html" : "../" + href);
                        }
                        ++i;
                    }
                    return result;
                }

                @Override
                public boolean isSimple() {
                    return !(this.val$metadataRepository instanceof ICompositeRepository);
                }

                @Override
                public boolean isRoot() {
                    return this.val$rootURI.equals(this.val$uri);
                }

                @Override
                public String getReportSource() {
                    return this.val$reportSource;
                }

                @Override
                public String getReportBrandingImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)this.val$reportBranding), this.val$outputLocation);
                }

                @Override
                public boolean hasBrandingImage(IInstallableUnit iu) {
                    String brandingImage = this.getBrandingImage(iu);
                    return !brandingImage.equals(RepositoryIntegrityAnalyzer.this.getWarningImage(this.val$outputLocation)) && !brandingImage.equals(this.getErrorImage());
                }

                @Override
                public boolean hasBrokenBrandingImage(IInstallableUnit iu) {
                    String brandingImage = this.getBrandingImage(iu);
                    return brandingImage.equals(this.getErrorImage());
                }

                @Override
                public String getBrandingImage(IInstallableUnit iu) {
                    Future brandingImage = (Future)this.val$brandingImages.get(iu);
                    if (brandingImage != null) {
                        try {
                            URI brandingImageURI = (URI)brandingImage.get();
                            if (brandingImageURI != null) {
                                return RepositoryIntegrityAnalyzer.this.getImage(brandingImageURI, this.val$outputLocation);
                            }
                            return RepositoryIntegrityAnalyzer.this.getWarningImage(this.val$outputLocation);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    return null;
                }

                @Override
                public Map<String, Set<IInstallableUnit>> getFeatureProviders() {
                    TreeMap<String, Set<IInstallableUnit>> result = new TreeMap<String, Set<IInstallableUnit>>();
                    for (IInstallableUnit iu : this.val$featureIUs) {
                        String provider = iu.getProperty("org.eclipse.equinox.p2.provider", null);
                        CollectionUtil.add(result, (Object)String.valueOf(provider), (Object)iu);
                    }
                    return result;
                }

                @Override
                public Set<String> getBrandingImages(Collection<IInstallableUnit> ius) {
                    LinkedHashSet<String> result = new LinkedHashSet<String>();
                    for (IInstallableUnit iu : ius) {
                        result.add(this.getBrandingImage(iu));
                    }
                    String image = RepositoryIntegrityAnalyzer.this.getWarningImage(this.val$outputLocation);
                    if (result.size() > 1) {
                        result.remove(image);
                    }
                    return result;
                }

                @Override
                public String getSignedImage(boolean signed) {
                    return RepositoryIntegrityAnalyzer.this.getImage("org.eclipse.ui", signed ? "icons/full/obj16/signed_yes_tbl.png" : "icons/full/obj16/signed_no_tbl.png", this.val$outputLocation);
                }

                @Override
                public Map<String, Set<Version>> getIUVersions() {
                    return this.val$iuIDVersions;
                }

                @Override
                public Set<IInstallableUnit> getPluginsWithMissingPackGZ() {
                    if (this.pluginsWithMissingPackGZ == null) {
                        this.pluginsWithMissingPackGZ = new TreeSet<IInstallableUnit>();
                        for (IInstallableUnit iu : this.val$classContainingIUs) {
                            Set files = (Set)this.val$iuFiles.get(iu);
                            if (files.size() == 2) continue;
                            this.pluginsWithMissingPackGZ.add(iu);
                        }
                    }
                    return this.pluginsWithMissingPackGZ;
                }

                @Override
                public Set<IInstallableUnit> getUnsignedIUs() {
                    if (this.unsignedIUs == null) {
                        this.unsignedIUs = new TreeSet<IInstallableUnit>();
                        for (IInstallableUnit iu : this.val$allIUs) {
                            Map<String, Boolean> iuArtifacts = this.getIUArtifacts(iu);
                            if (!iuArtifacts.containsValue(Boolean.FALSE)) continue;
                            this.unsignedIUs.add(iu);
                        }
                    }
                    return this.unsignedIUs;
                }

                @Override
                public Set<IInstallableUnit> getBadProviderIUs() {
                    if (this.badProviderIUs == null) {
                        this.badProviderIUs = new TreeSet<IInstallableUnit>();
                        Map<String, Set<IInstallableUnit>> featureProviders = this.getFeatureProviders();
                        for (Map.Entry<String, Set<IInstallableUnit>> entry : featureProviders.entrySet()) {
                            String provider = entry.getKey();
                            if (provider != null && provider.toLowerCase().contains("eclipse")) continue;
                            this.badProviderIUs.addAll((Collection<IInstallableUnit>)entry.getValue());
                        }
                    }
                    return this.badProviderIUs;
                }

                @Override
                public Set<IInstallableUnit> getBadLicenseIUs() {
                    if (this.badLicenseIUs == null) {
                        this.badLicenseIUs = new TreeSet<IInstallableUnit>();
                        Map<Report.LicenseDetail, Set<IInstallableUnit>> licenses = this.getLicenses();
                        for (Map.Entry<Report.LicenseDetail, Set<IInstallableUnit>> entry : licenses.entrySet()) {
                            if (entry.getKey().isSUA()) continue;
                            this.badLicenseIUs.addAll((Collection<IInstallableUnit>)entry.getValue());
                        }
                    }
                    return this.badLicenseIUs;
                }

                @Override
                public Set<IInstallableUnit> getBrokenBrandingIUs() {
                    if (this.brokenBrandingIUs == null) {
                        this.brokenBrandingIUs = new TreeSet<IInstallableUnit>();
                        for (IInstallableUnit iu : this.getFeatureIUs()) {
                            if (!this.hasBrokenBrandingImage(iu)) continue;
                            this.brokenBrandingIUs.add(iu);
                        }
                    }
                    return this.brokenBrandingIUs;
                }

                @Override
                public Map<String, Boolean> getIUArtifacts(IInstallableUnit iu) {
                    TreeMap<String, Boolean> result = new TreeMap<String, Boolean>();
                    Set files = (Set)this.val$iuFiles.get(iu);
                    for (File file : files) {
                        SignedContent signedContent = (SignedContent)this.val$fileSignedContents.get(file);
                        int prefixLength = this.val$artifactCacheFolder.toString().length() + 1;
                        String path = file.toString().substring(prefixLength).replace('\\', '/');
                        result.put(path, signedContent == null || path.startsWith("binary/") ? null : Boolean.valueOf(signedContent.isSigned()));
                    }
                    return result;
                }

                @Override
                public Map<String, String> getCertificateComponents(Certificate certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    X500Principal subjectX500Principal = x509Certificate.getSubjectX500Principal();
                    String name = subjectX500Principal.getName();
                    Pattern namePattern = Pattern.compile("([A-Za-z]+)=(([^,\\\\]|\\\\,)+),");
                    Matcher matcher = namePattern.matcher(name);
                    LinkedHashMap<String, String> components = new LinkedHashMap<String, String>();
                    while (matcher.find()) {
                        components.put(matcher.group(1), matcher.group(2).replaceAll("\\\\", ""));
                    }
                    return components;
                }

                @Override
                public List<Certificate> getCertificates(IInstallableUnit iu) {
                    for (Map.Entry<List<Certificate>, Map<String, IInstallableUnit>> entry : this.getCertificates().entrySet()) {
                        if (!entry.getValue().values().contains(iu)) continue;
                        return entry.getKey();
                    }
                    return null;
                }

                @Override
                public Map<List<Certificate>, Map<String, IInstallableUnit>> getCertificates() {
                    if (this.certificates == null) {
                        Comparator<List<Certificate>> certificateComparator = new Comparator<List<Certificate>>(){

                            @Override
                            public int compare(List<Certificate> o1, List<Certificate> o2) {
                                int size = o1.size();
                                int result = Integer.compare(size, o2.size());
                                if (result == 0 && size != 0) {
                                    X509Certificate certificate1 = (X509Certificate)o1.get(0);
                                    X509Certificate certificate2 = (X509Certificate)o2.get(0);
                                    result = certificate1.getSubjectX500Principal().getName().compareTo(certificate2.getSubjectX500Principal().getName());
                                }
                                return result;
                            }
                        };
                        int prefixLength = this.val$artifactCacheFolder.toString().length() + 1;
                        this.certificates = new TreeMap<List<Certificate>, Map<String, IInstallableUnit>>(certificateComparator);
                        for (Map.Entry entry : this.val$iuFiles.entrySet()) {
                            IInstallableUnit iu = (IInstallableUnit)entry.getKey();
                            Set files = (Set)entry.getValue();
                            for (File file : files) {
                                String path = file.toString().substring(prefixLength).replace('\\', '/');
                                if (path.startsWith("binary/")) continue;
                                SignedContent signedContent = (SignedContent)this.val$fileSignedContents.get(file);
                                if (signedContent.isSigned()) {
                                    SignerInfo[] signerInfos;
                                    SignerInfo[] signerInfoArray = signerInfos = signedContent.getSignerInfos();
                                    int n = signerInfos.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        SignerInfo signerInfo = signerInfoArray[n2];
                                        Certificate[] certificateChain = signerInfo.getCertificateChain();
                                        List<Certificate> certificateList = Arrays.asList(certificateChain);
                                        Map<String, IInstallableUnit> artifacts = this.certificates.get(certificateList);
                                        if (artifacts == null) {
                                            artifacts = new TreeMap<String, IInstallableUnit>();
                                            this.certificates.put(certificateList, artifacts);
                                        }
                                        artifacts.put(path, iu);
                                        ++n2;
                                    }
                                    continue;
                                }
                                Map<String, IInstallableUnit> artifacts = this.certificates.get(Collections.emptyList());
                                if (artifacts == null) {
                                    artifacts = new TreeMap<String, IInstallableUnit>();
                                    this.certificates.put(Collections.emptyList(), artifacts);
                                }
                                artifacts.put(path, iu);
                            }
                        }
                    }
                    return this.certificates;
                }

                @Override
                public List<String> getXML(IInstallableUnit iu, Map<String, String> replacements) {
                    this.getLicenses(iu);
                    if (Boolean.FALSE.booleanValue()) {
                        Collection requirements = iu.getRequirements();
                        HashMap requiredCapabilities = new HashMap();
                        for (IRequirement requirement : requirements) {
                            IMatchExpression match = requirement.getMatches();
                            if (!RequiredCapability.isVersionRangeRequirement((IMatchExpression)match)) continue;
                            ArrayList<String> key = new ArrayList<String>(3);
                            key.add(RequiredCapability.extractNamespace((IMatchExpression)match));
                            key.add(RequiredCapability.extractName((IMatchExpression)match));
                            key.add(RequiredCapability.extractRange((IMatchExpression)match).toString());
                            requiredCapabilities.put(key, requirement);
                        }
                    }
                    final HashMap ids = new HashMap();
                    InstallableUnitWriter.ValueHandler valueHandler = new InstallableUnitWriter.ValueHandler(){
                        private String uuid;
                        private String namespace;
                        private String name;

                        private String handleLicense(String content) {
                            String plainContent = new InstallableUnitWriter().expandEntities(content);
                            ILicense license = MetadataFactory.createLicense(null, (String)plainContent);
                            Report.LicenseDetail licenseDetail = RepositoryIntegrityAnalyzer.this.getLicenseDetail(license, false);
                            if (licenseDetail != null) {
                                return licenseDetail.getUUID();
                            }
                            return null;
                        }

                        @Override
                        public String handleElementContent(List<String> elementNames, String elementContent) {
                            String licenseReplacement;
                            if ("license".equals(this.getCurrentElementName(elementNames)) && (licenseReplacement = this.handleLicense(elementContent)) != null) {
                                return licenseReplacement;
                            }
                            return super.handleElementContent(elementNames, elementContent);
                        }

                        @Override
                        public void startElement(List<String> elementNames, String uuid) {
                            this.uuid = uuid;
                        }

                        @Override
                        public String handleAttributeValue(List<String> elementNames, String attributeName, String attributeValue) {
                            String elementName = this.getCurrentElementName(elementNames);
                            if ("property".equals(elementName)) {
                                String licenseReplacement;
                                if ("value".equals(attributeName) && attributeValue.contains("&#xA;") && (licenseReplacement = this.handleLicense(attributeValue)) != null) {
                                    return licenseReplacement;
                                }
                            } else if ("provided".equals(elementName)) {
                                if ("namespace".equals(attributeName)) {
                                    this.namespace = attributeValue;
                                } else if ("name".equals(attributeName)) {
                                    this.name = attributeValue;
                                } else if ("version".equals(attributeName)) {
                                    Set matchingIUs;
                                    ArrayList<String> key = new ArrayList<String>();
                                    key.add(this.namespace);
                                    key.add(this.name);
                                    key.add(attributeValue);
                                    IProvidedCapability providedCapability = (IProvidedCapability)val$allProvidedCapabilities.get(key);
                                    if (providedCapability != null) {
                                        ids.put(this.uuid, RepositoryIntegrityAnalyzer.getProvidedCapabilityID(providedCapability));
                                    }
                                    if ((matchingIUs = (Set)val$resolvedCapabilities.get(providedCapability)) == null || matchingIUs.isEmpty()) {
                                        return "<span class=\"unused-capability\">" + attributeValue + "</span>";
                                    }
                                    StringBuilder links = new StringBuilder();
                                    String id = "_" + EcoreUtil.generateUUID();
                                    links.append(" <button id=\"" + id + "_arrows\" style=\"font-size: 70%; bottom-margin: 1pt; \" class=\"orange bb xml-links_button\" onclick=\"expand_collapse_inline_block('" + id + "');\">&#x25B7;</button>");
                                    links.append("<span id=\"" + id + "\" class=\"xml-links\" style=\"display: none; margin-top: 0.2ex; vertical-align : top;\">");
                                    for (IInstallableUnit iu : new TreeSet(matchingIUs)) {
                                        links.append(" <a href=\"");
                                        links.append(this.getIUID(iu));
                                        links.append(".html");
                                        HashSet requirements = new HashSet(iu.getRequirements());
                                        requirements.retainAll((Collection)val$capabilityResolutions.get(providedCapability));
                                        if (!requirements.isEmpty()) {
                                            links.append('#');
                                            links.append(RepositoryIntegrityAnalyzer.getRequirementID((IRequirement)requirements.iterator().next()));
                                        }
                                        links.append('\"');
                                        links.append(">\u27a6");
                                        links.append(iu.getId());
                                        links.append(" ");
                                        links.append(iu.getVersion());
                                        links.append("</a><br/>");
                                    }
                                    links.append("</span>");
                                    return "<span class=\"used-capability\">" + attributeValue + links + "</span>";
                                }
                            } else if ("required".equals(elementName)) {
                                if ("namespace".equals(attributeName)) {
                                    this.namespace = attributeValue;
                                } else if ("name".equals(attributeName)) {
                                    this.name = attributeValue;
                                } else if ("range".equals(attributeName)) {
                                    Set matchingIUs;
                                    ArrayList<String> key = new ArrayList<String>();
                                    key.add(this.namespace);
                                    key.add(this.name);
                                    key.add(attributeValue);
                                    IRequirement requirement = (IRequirement)val$requiredCapabilities.get(key);
                                    if (requirement != null) {
                                        ids.put(this.uuid, RepositoryIntegrityAnalyzer.getRequirementID(requirement));
                                    }
                                    if ((matchingIUs = (Set)val$resolvedRequirements.get(requirement)) == null || matchingIUs.isEmpty()) {
                                        return "<span class=\"unresolved-requirement\">" + attributeValue + "</span>";
                                    }
                                    String requirementName = "";
                                    if (requirement instanceof IRequiredCapability) {
                                        requirementName = ((IRequiredCapability)requirement).getName();
                                    }
                                    StringBuilder links = new StringBuilder();
                                    String id = "_" + EcoreUtil.generateUUID();
                                    links.append(" <button id=\"" + id + "_arrows\" style=\"font-size: 70%; bottom-marin: 1pt;\" class=\"orange bb xml-links_button\" onclick=\"expand_collapse_inline_block('" + id + "');\">&#x25B7;</button>");
                                    links.append("<span id=\"" + id + "\" class=\"xml-links\" style=\"display: none; margin-top: 0.2ex; vertical-align : top;\">");
                                    for (IInstallableUnit iu : new TreeSet(matchingIUs)) {
                                        links.append(" <a href=\"");
                                        links.append(this.getIUID(iu));
                                        links.append(".html");
                                        HashSet providedCapabilities = new HashSet(iu.getProvidedCapabilities());
                                        providedCapabilities.retainAll((Collection)val$requirementResolutions.get(requirement));
                                        if (!providedCapabilities.isEmpty()) {
                                            links.append('#');
                                            links.append(RepositoryIntegrityAnalyzer.getProvidedCapabilityID((IProvidedCapability)providedCapabilities.iterator().next()));
                                        }
                                        links.append('\"');
                                        links.append(">\u27a5");
                                        String iuID = iu.getId();
                                        if (!requirementName.equals(iuID)) {
                                            links.append(iuID);
                                            links.append(' ');
                                        }
                                        links.append(iu.getVersion());
                                        links.append("</a><br/>");
                                    }
                                    links.append("</span>");
                                    ids.put(this.uuid, RepositoryIntegrityAnalyzer.getRequirementID(requirement));
                                    return "<span class=\"resolved-requirement\">" + attributeValue + links + "</span>";
                                }
                            }
                            return super.handleAttributeValue(elementNames, attributeName, attributeValue);
                        }
                    };
                    String xml = new InstallableUnitWriter().toHTML(iu, valueHandler);
                    if (replacements != null) {
                        for (Map.Entry entry : replacements.entrySet()) {
                            xml = xml.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                        }
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    Matcher matcher = Pattern.compile("id=\"([^\"]+)\"").matcher(xml);
                    while (matcher.find()) {
                        String id = matcher.group(1);
                        String replacement = (String)ids.get(id);
                        if (replacement == null) continue;
                        matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement("id=\"" + replacement + '\"'));
                    }
                    matcher.appendTail(stringBuffer);
                    return StringUtil.explode((String)stringBuffer.toString(), (String)"\n");
                }

                @Override
                public String getErrorImage() {
                    return RepositoryIntegrityAnalyzer.this.getErrorImage(this.val$outputLocation);
                }

                @Override
                public Report getParent() {
                    return this.val$parentReport;
                }

                @Override
                public List<Report> getChildren() {
                    return this.val$childReports;
                }

                @Override
                public Map<String, String> getNavigation() {
                    LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                    for (Report report : RepositoryIntegrityAnalyzer.this.reports.values()) {
                        String title = report.getTitle(true);
                        if (report == this) {
                            title = String.valueOf(title) + '@';
                        }
                        result.put(report.getRelativeIndexURL(), title);
                    }
                    return result;
                }

                @Override
                public String getSiteURL() {
                    return this.val$metadataRepository.getLocation().toString();
                }

                private String getXML(CompositeRepositoryState state, String type) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    new CompositeRepositoryIO().write(state, (OutputStream)out, type);
                    final String siteHost = URI.createURI((String)this.getSiteURL()).host();
                    InstallableUnitWriter.ValueHandler valueHandler = new InstallableUnitWriter.ValueHandler(){

                        @Override
                        public String handleAttributeValue(List<String> elementNames, String attributeName, String attributeValue) {
                            URI uri;
                            String host;
                            if ("location".equals(attributeName) && (host = (uri = URI.createURI((String)attributeValue)).host()) != null && host.equals(siteHost)) {
                                return "<span class=\"bad-absolute-location\">" + attributeValue + "</span>";
                            }
                            return super.handleAttributeValue(elementNames, attributeName, attributeValue);
                        }
                    };
                    InstallableUnitWriter.HTMLResource htmlResource = new InstallableUnitWriter.HTMLResource(valueHandler);
                    try {
                        htmlResource.load(new ByteArrayInputStream(out.toByteArray()), null);
                        out.reset();
                        XMLTypeDocumentRoot documentRoot = (XMLTypeDocumentRoot)htmlResource.getContents().get(0);
                        FeatureMap mixed = documentRoot.getMixed();
                        Iterator it = mixed.iterator();
                        while (it.hasNext()) {
                            FeatureMap.Entry entry = (FeatureMap.Entry)it.next();
                            if (!FeatureMapUtil.isProcessingInstruction((FeatureMap.Entry)entry)) continue;
                            it.remove();
                        }
                        htmlResource.save(out, null);
                        return new String(out.toByteArray(), "UTF-8");
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }

                @Override
                public String getMetadataXML() {
                    if (this.val$metadataRepository instanceof CompositeMetadataRepository) {
                        CompositeMetadataRepository compositeMetadataRepository = (CompositeMetadataRepository)this.val$metadataRepository;
                        return this.getXML(compositeMetadataRepository.toState(), "compositeArtifactRepository");
                    }
                    return null;
                }

                @Override
                public String getArtifactML() {
                    if (this.val$artifactRepository instanceof CompositeArtifactRepository) {
                        CompositeArtifactRepository compositeArtifactRepository = (CompositeArtifactRepository)this.val$artifactRepository;
                        return this.getXML(compositeArtifactRepository.toState(), "compositeArtifactRepository");
                    }
                    return null;
                }

                @Override
                public Map<Report.LicenseDetail, Set<IInstallableUnit>> getLicenses() {
                    return this.val$sortedLicenseIUs;
                }

                @Override
                public String getTitle() {
                    String name = this.val$metadataRepository.getName();
                    return name.isEmpty() ? this.val$uri.lastSegment() : name;
                }

                @Override
                public String getTitle(boolean narrow) {
                    String name = this.val$metadataRepository.getName();
                    if (StringUtil.isEmpty((String)name)) {
                        name = "<span style=\"color: FireBrick;\">Unnamed Repository</span>";
                    }
                    String repoIdentifier = this.val$uri.lastSegment();
                    return String.valueOf(name) + (narrow ? "<br style=\"line-height: 4ex;\"/>" : " ") + "<span style=\"color: DarkOliveGreen;\">" + repoIdentifier + "</span>";
                }

                @Override
                public String getDate() {
                    String date = "unknown";
                    Map properties = this.val$metadataRepository.getProperties();
                    String timestamp = (String)properties.get("p2.timestamp");
                    if (timestamp != null) {
                        try {
                            long time = Long.parseLong(timestamp);
                            date = new SimpleDateFormat("yyyy'-'MM'-'dd' at 'HH':'mm ").format(new Date(time));
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                    return date;
                }

                @Override
                public List<String> getFeatures(Iterable<IInstallableUnit> features) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (IInstallableUnit iu : features) {
                        String name = this.getNameAndVersion(iu);
                        if (result.contains(name)) continue;
                        result.add(name);
                    }
                    Collections.sort(result, CommonPlugin.INSTANCE.getComparator());
                    return result;
                }

                @Override
                public List<String> getFeatures() {
                    return this.getFeatures(this.getFeatureIUs());
                }

                @Override
                public List<IInstallableUnit> getFeatureIUs() {
                    return this.val$featureIUs;
                }

                @Override
                public List<Report.LicenseDetail> getLicenses(IInstallableUnit iu) {
                    if ("true".equals(iu.getProperty("org.eclipse.equinox.p2.type.group"))) {
                        return RepositoryIntegrityAnalyzer.this.getLicenses(iu);
                    }
                    return null;
                }

                @Override
                public Set<IInstallableUnit> getProducts() {
                    return this.val$productIUs;
                }

                @Override
                public boolean isDuplicationExpected(String id) {
                    return this.val$expectedDuplicates.contains(id);
                }

                @Override
                public Set<IInstallableUnit> getAllIUs() {
                    return this.val$allIUs;
                }

                @Override
                public Set<IInstallableUnit> getResolvedRequirements(IInstallableUnit iu) {
                    TreeSet<IInstallableUnit> result = new TreeSet<IInstallableUnit>();
                    for (IRequirement requirement : iu.getRequirements()) {
                        Set ius = (Set)this.val$resolvedRequirements.get(requirement);
                        if (ius == null) continue;
                        result.addAll(ius);
                    }
                    return result;
                }

                @Override
                public String getArtifactImage(String artifact) {
                    if (artifact.startsWith("binary")) {
                        return this.getBinaryImage();
                    }
                    if (artifact.endsWith(".jar")) {
                        return this.getJarImage();
                    }
                    if (artifact.endsWith(".pack.gz")) {
                        return this.getPackGZImage();
                    }
                    return null;
                }

                @Override
                public String getArtifactSize(String artifact) {
                    long length = new File(this.val$artifactCacheFolder, artifact).length();
                    return RepositoryIntegrityAnalyzer.format(length);
                }

                public String getBinaryImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/platform/eclipse.platform.ui.git/plain/bundles/org.eclipse.ui.ide/icons/full/etool16/build_exec@2x.png"), this.val$outputLocation);
                }

                public String getJarImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/jdt/eclipse.jdt.ui.git/plain/org.eclipse.jdt.ui/icons/full/etool16/exportjar_wiz@2x.png"), this.val$outputLocation);
                }

                public String getPackGZImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/platform/eclipse.platform.ui.git/plain/bundles/org.eclipse.ui.ide/icons/full/etool16/exportzip_wiz@2x.png"), this.val$outputLocation);
                }

                @Override
                public String getIUImage(IInstallableUnit iu) {
                    if (this.isCategory(iu)) {
                        return this.getCategoryImage();
                    }
                    if (this.isProduct(iu)) {
                        return this.getProductImage();
                    }
                    if (this.isGroup(iu)) {
                        return this.getFeatureImage();
                    }
                    for (IProvidedCapability providedCapability : iu.getProvidedCapabilities()) {
                        if (!"java.package".equals(providedCapability.getNamespace())) continue;
                        return this.getPluginImage();
                    }
                    for (IRequirement requirement : iu.getRequirements()) {
                        IMatchExpression match = requirement.getMatches();
                        if (!RequiredCapability.isVersionRangeRequirement((IMatchExpression)match) || !"java.package".equals(RequiredCapability.extractNamespace((IMatchExpression)match))) continue;
                        return this.getPluginImage();
                    }
                    return this.getBundleImage();
                }

                @Override
                public String getLicenseImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/license_obj@2x.png"), this.val$outputLocation);
                }

                @Override
                public String getRepositoryImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/equinox/rt.equinox.p2.git/plain/bundles/org.eclipse.equinox.p2.ui/icons/obj/metadata_repo_obj@2x.png"), this.val$outputLocation);
                }

                @Override
                public String getProviderImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde/eclipse32.png"), this.val$outputLocation);
                }

                @Override
                public String getFeatureImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/feature_obj@2x.png"), this.val$outputLocation);
                }

                @Override
                public String getProductImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/product_xml_obj@2x.png"), this.val$outputLocation);
                }

                public String getPluginImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/plugin_obj@2x.png"), this.val$outputLocation);
                }

                @Override
                public String getBundleImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/bundle_obj@2x.png"), this.val$outputLocation);
                }

                @Override
                public String getCategoryImage() {
                    return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)"https://git.eclipse.org/c/equinox/rt.equinox.p2.git/plain/bundles/org.eclipse.equinox.p2.ui/icons/obj/category_obj@2x.png"), this.val$outputLocation);
                }

                @Override
                public Map<String, List<String>> getBundles() {
                    TreeMap<String, List<String>> result = new TreeMap<String, List<String>>(CommonPlugin.INSTANCE.getComparator());
                    for (IInstallableUnit iu : this.val$allIUs) {
                        String id = iu.getId();
                        ArrayList<String> lines = new ArrayList<String>();
                        for (IProvidedCapability providedCapability : iu.getProvidedCapabilities()) {
                            String namespace = providedCapability.getNamespace();
                            String name = providedCapability.getName();
                            if ("org.eclipse.equinox.p2.eclipse.type".equals(namespace) && "bundle".equals(name)) {
                                String iuName = iu.getProperty("org.eclipse.equinox.p2.name", null);
                                iuName = String.valueOf(iuName) + " " + iu.getVersion();
                                if (result.containsKey(iuName = iuName.substring(0, iuName.lastIndexOf(46)))) continue;
                                lines.add(0, "\u21d6 " + id + " " + iu.getVersion());
                                result.put(iuName, lines);
                                continue;
                            }
                            if (!"java.package".equals(namespace)) continue;
                            Version version = providedCapability.getVersion();
                            lines.add("\u2196 " + name + (Version.emptyVersion.equals(version) ? "" : " " + version));
                        }
                        for (IRequirement requirement : iu.getRequirements()) {
                            if (!(requirement instanceof IRequiredCapability)) continue;
                            IRequiredCapability requiredCapability = (IRequiredCapability)requirement;
                            String namespace = requiredCapability.getNamespace();
                            String line = null;
                            if ("osgi.bundle".equals(namespace)) {
                                line = "\u21d8 ";
                            } else if ("java.package".equals(namespace)) {
                                line = "\u2198 ";
                            }
                            if (line == null) continue;
                            String name = requiredCapability.getName();
                            VersionRange range = requiredCapability.getRange();
                            line = String.valueOf(line) + name;
                            if (!VersionRange.emptyRange.equals((Object)range)) {
                                line = String.valueOf(line) + " " + range;
                            }
                            if (requiredCapability.getMin() == 0) {
                                line = String.valueOf(line) + " optional";
                                if (requiredCapability.isGreedy()) {
                                    line = String.valueOf(line) + " greedy";
                                }
                            }
                            lines.add(line);
                        }
                    }
                    return result;
                }

                @Override
                public List<IUReport> getIUReports() {
                    ArrayList<IUReport> result = new ArrayList<IUReport>();
                    for (IInstallableUnit iu : this.val$allIUs) {
                        /*
                         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                         */
                        class MyIUReport
                        extends IUReport {
                            private final /* synthetic */ IInstallableUnit val$iu;

                            MyIUReport(IInstallableUnit iInstallableUnit) {
                                this.val$iu = iInstallableUnit;
                            }

                            @Override
                            public Report getReport() {
                                return this;
                            }

                            @Override
                            public String getNow() {
                                return this.getReport().getNow();
                            }

                            @Override
                            public IInstallableUnit getIU() {
                                return this.val$iu;
                            }

                            @Override
                            public String getDescription() {
                                String description = this.val$iu.getProperty("org.eclipse.equinox.p2.description", null);
                                return description;
                            }

                            @Override
                            public String getProvider() {
                                String provider = this.val$iu.getProperty("org.eclipse.equinox.p2.provider", null);
                                return provider;
                            }

                            @Override
                            public String getReportBrandingImage() {
                                return "../" + this.getReport().getReportBrandingImage();
                            }

                            @Override
                            public String getReportSource() {
                                return this.getReport().getReportSource();
                            }

                            @Override
                            public String getTitle() {
                                return this.val$iu.toString();
                            }

                            @Override
                            public String getTitle(boolean narrow) {
                                String id = this.val$iu.getId();
                                Version version = this.val$iu.getVersion();
                                return narrow ? String.valueOf(id) + "<br/><span style=\"color: DarkOliveGreen;\">" + version + "</span>" : String.valueOf(id) + " " + version;
                            }

                            @Override
                            public String getRelativeReportURL() {
                                return this.getRelativeIUReportURL(this.val$iu);
                            }

                            @Override
                            public Map<String, String> getBreadcrumbs() {
                                LinkedHashMap<String, String> breadcrumbs = new LinkedHashMap<String, String>(this.getReport().getBreadcrumbs());
                                Iterator iterator = breadcrumbs.entrySet().iterator();
                                while (iterator.hasNext()) {
                                    Map.Entry entry;
                                    String href = (String)(entry = iterator.next()).getValue();
                                    entry.setValue(href == null ? "../" + this.getReport().getRelativeIndexURL() : "../" + href);
                                }
                                breadcrumbs.put(this.val$iu.toString(), null);
                                return breadcrumbs;
                            }

                            @Override
                            public Map<String, String> getNavigation() {
                                LinkedHashMap<String, String> navigation = new LinkedHashMap<String, String>();
                                navigation.put("../" + this.getReport().getRelativeIndexURL(), this.getReport().getTitle(true));
                                return navigation;
                            }
                        }
                        result.add(new MyIUReport(iu));
                    }
                    return result;
                }
            }
            report = new MyReport(allIUs, artifactCache, rootOutputLocation, uri, rootURI, metadataRepository, reportSource, reportBranding, outputLocation, brandingImages, featureIUs, iuIDVersions, classContainingIUs, iuFiles, fileSignedContents, artifactCacheFolder, parentReport, childReports, artifactRepository, sortedLicenseIUs, productIUs, expectedDuplicates, resolvedRequirements, allProvidedCapabilities, resolvedCapabilities, capabilityResolutions, requiredCapabilities, requirementResolutions);
            if (metadataRepository instanceof ICompositeRepository) {
                ICompositeRepository compositeRepository = (ICompositeRepository)metadataRepository;
                List children = compositeRepository.getChildren();
                for (java.net.URI uRI : children) {
                    Report childReport = this.generateReport(report, rootURI, rootOutputLocation, this.toExternalRepositoryLocation(uRI), outputLocation, artifactCacheFolder, reportSource, reportBranding);
                    childReports.add(childReport);
                }
            }
            this.reports.put(uri, report);
        }
        return report;
    }

    private Future<List<String>> getIndex(File file) {
        String path = file.toString();
        final File effectiveFile = path.endsWith(".pack.gz") ? new File(path.substring(0, path.length() - ".pack.gz".length())) : file;
        Future<List<String>> future = this.fileIndices.get(effectiveFile);
        if (future == null) {
            future = this.getExecutor().submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    final ArrayList<String> result = new ArrayList<String>();
                    ZIPUtil.unzip((File)effectiveFile, (ZIPUtil.UnzipHandler)new ZIPUtil.UnzipHandler(){

                        public void unzipFile(String name, InputStream zipStream) throws IOException {
                            result.add(name);
                        }

                        public void unzipDirectory(String name) throws IOException {
                        }
                    });
                    return result;
                }
            });
            this.fileIndices.put(effectiveFile, future);
        }
        this.fileIndices.put(file, future);
        return future;
    }

    private Future<URI> getBrandingImage(IInstallableUnit iu, final IMetadataRepository metadataRepository, IArtifactRepository artifactRepository, Map<IInstallableUnit, Future<URI>> brandingImages, final Map<IArtifactKey, Future<Map<IArtifactDescriptor, File>>> artifactCache, File cache) {
        Future<URI> result = brandingImages.get(iu);
        if (result == null) {
            IQueryResult query;
            String id = iu.getId();
            final String baseID = id.replaceAll("(\\.source)?\\.feature\\.group$", "");
            if (id.endsWith(".source.feature.group") && !(query = metadataRepository.query(QueryUtil.createIUQuery((String)(String.valueOf(baseID) + ".feature.group")), (IProgressMonitor)new NullProgressMonitor())).isEmpty()) {
                result = this.getBrandingImage((IInstallableUnit)P2Util.asIterable(query).iterator().next(), metadataRepository, artifactRepository, brandingImages, artifactCache, cache);
                brandingImages.put(iu, result);
                return result;
            }
            String jarID = String.valueOf(baseID) + ".feature.jar";
            Version version = iu.getVersion();
            IQueryResult jarQuery = metadataRepository.query(QueryUtil.createIUQuery((String)jarID, (Version)version), (IProgressMonitor)new NullProgressMonitor());
            final ArrayList<Future<Map<IArtifactDescriptor, File>>> futures = new ArrayList<Future<Map<IArtifactDescriptor, File>>>();
            for (IInstallableUnit jarIU : P2Util.asIterable(jarQuery)) {
                Collection artifacts = jarIU.getArtifacts();
                for (IArtifactKey artifactKey : artifacts) {
                    futures.add(this.getArtifacts(artifactKey, artifactRepository, artifactCache, cache));
                }
            }
            result = this.getExecutor().submit(new Callable<URI>(){

                @Override
                public URI call() throws Exception {
                    for (Future future : futures) {
                        Collection values = ((Map)future.get()).values();
                        Iterator iterator = values.iterator();
                        if (!iterator.hasNext()) continue;
                        File file = (File)iterator.next();
                        URI artifactURI = URI.createFileURI((String)file.toString());
                        if ("jar".equals(artifactURI.fileExtension())) {
                            URI featureXML = URI.createURI((String)("archive:" + artifactURI + "!/feature.xml"));
                            Document document = RepositoryIntegrityAnalyzer.this.loadXML(featureXML);
                            Element documentElement = document.getDocumentElement();
                            String plugin = documentElement.getAttribute("plugin");
                            if (StringUtil.isEmpty((String)plugin)) {
                                plugin = baseID;
                            }
                            IQueryResult query = metadataRepository.query(QueryUtil.createIUQuery((String)plugin), (IProgressMonitor)new NullProgressMonitor());
                            for (IInstallableUnit brandingPlugin : P2Util.asIterable(query)) {
                                for (IArtifactKey artifactKey : brandingPlugin.getArtifacts()) {
                                    for (File brandingFile : ((Map)((Future)artifactCache.get(artifactKey)).get()).values()) {
                                        URI brandingArtifactURI = URI.createFileURI((String)brandingFile.toString());
                                        if (!"jar".equals(brandingArtifactURI.fileExtension())) continue;
                                        URI aboutINI = URI.createURI((String)("archive:" + brandingArtifactURI + "!/about.ini"));
                                        try {
                                            Properties properties = RepositoryIntegrityAnalyzer.this.loadProperties(aboutINI);
                                            Object featureImage = properties.get("featureImage");
                                            if (featureImage == null) continue;
                                            URI brandingImageURI = URI.createURI((String)("archive:" + brandingArtifactURI + "!/" + featureImage.toString().replaceAll("^/*", "")));
                                            return brandingImageURI;
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                        }
                        return null;
                    }
                    return null;
                }
            });
            brandingImages.put(iu, result);
        }
        return result;
    }

    private Properties loadProperties(URI uri) throws IOException {
        Properties properties = new Properties();
        InputStream propertiesIn = null;
        try {
            propertiesIn = URIConverter.INSTANCE.createInputStream(uri);
            properties.load(propertiesIn);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            IOUtil.close((Closeable)propertiesIn);
        }
    }

    private Document loadXML(URI uri) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
        InputStream in = null;
        try {
            Document document;
            in = URIConverter.INSTANCE.createInputStream(uri);
            Document document2 = document = XMLUtil.loadDocument((DocumentBuilder)documentBuilder, (InputStream)in);
            return document2;
        }
        finally {
            IOUtil.close((Closeable)in);
        }
    }

    private byte[] getImageBytes(URI imageURI) {
        byte[] bytes = this.imageBytes.get(imageURI);
        if (bytes == null) {
            block6: {
                InputStream in = null;
                try {
                    try {
                        in = URIConverter.INSTANCE.createInputStream(imageURI);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        IOUtil.copy((InputStream)in, (OutputStream)out);
                        bytes = out.toByteArray();
                    }
                    catch (IOException ex) {
                        System.err.println("###" + ex.getLocalizedMessage());
                        bytes = this.getImageBytes(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/error_st_obj@2x.png"));
                        IOUtil.close((Closeable)in);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close((Closeable)in);
            }
            this.imageBytes.put(imageURI, bytes);
        }
        return bytes;
    }

    /*
     * Exception decompiling
     */
    private String getImage(URI imageURI, File cache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getErrorImage(File cache) {
        return this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/error_st_obj@2x.png"), cache);
    }

    private String getWarningImage(File cache) {
        return this.getImage(URI.createURI((String)"https://git.eclipse.org/c/pde/eclipse.pde.ui.git/plain/ui/org.eclipse.pde.ui/icons/obj16/warning_st_obj@2x.png"), cache);
    }

    private String getImage(String pluginID, String imagePath, File cache) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        URL imageLocationURL = bundle.getEntry(imagePath);
        URI imagelocationURI = URI.createURI((String)imageLocationURL.toString());
        return this.getImage(imagelocationURI, cache);
    }

    private Future<Map<IArtifactDescriptor, File>> getArtifacts(final IArtifactKey artifactKey, final IArtifactRepository artifactRepository, Map<IArtifactKey, Future<Map<IArtifactDescriptor, File>>> artifactCache, final File cache) {
        Future<Map<IArtifactDescriptor, File>> result = artifactCache.get(artifactKey);
        if (result == null) {
            result = this.getExecutor().submit(new Callable<Map<IArtifactDescriptor, File>>(){

                @Override
                public Map<IArtifactDescriptor, File> call() throws Exception {
                    LinkedHashMap<IArtifactDescriptor, File> artifacts = new LinkedHashMap<IArtifactDescriptor, File>();
                    IArtifactDescriptor[] iArtifactDescriptorArray = artifactRepository.getArtifactDescriptors(artifactKey);
                    int n = iArtifactDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File targetLocation;
                        IArtifactDescriptor artifactDescriptor = iArtifactDescriptorArray[n2];
                        IArtifactRepository repository = artifactDescriptor.getRepository();
                        if (repository instanceof SimpleArtifactRepository) {
                            SimpleArtifactRepository simpleArtifactRepository = (SimpleArtifactRepository)repository;
                            java.net.URI artifactLocation = simpleArtifactRepository.getLocation(artifactDescriptor);
                            java.net.URI location = repository.getLocation();
                            java.net.URI relativeLocation = location.relativize(artifactLocation);
                            targetLocation = new File(cache, relativeLocation.toString());
                            if (!targetLocation.isFile()) {
                                targetLocation.getParentFile().mkdirs();
                                FileOutputStream out = null;
                                try {
                                    try {
                                        out = new FileOutputStream(targetLocation);
                                        artifactRepository.getRawArtifact(artifactDescriptor, (OutputStream)out, (IProgressMonitor)new NullProgressMonitor());
                                        if (relativeLocation.toString().startsWith("binary/")) {
                                            ZIPUtil.unzip((File)targetLocation, (File)new File(cache, "binary/unpacked/" + relativeLocation.toString().substring("binary/".length())));
                                        }
                                    }
                                    catch (Exception ex) {
                                        IOUtil.close(out);
                                        targetLocation.delete();
                                        throw ex;
                                    }
                                }
                                catch (Throwable throwable) {
                                    IOUtil.close(out);
                                    throw throwable;
                                }
                                IOUtil.close((Closeable)out);
                                IProcessingStepDescriptor[] processingSteps = artifactDescriptor.getProcessingSteps();
                                if (processingSteps.length != 0) {
                                    File targetProcessedLocation = new File(cache, String.valueOf(relativeLocation.toString()) + RepositoryIntegrityAnalyzer.PROCESSED);
                                    FileOutputStream out2 = null;
                                    try {
                                        try {
                                            out2 = new FileOutputStream(targetProcessedLocation);
                                            artifactRepository.getArtifact(artifactDescriptor, (OutputStream)out2, (IProgressMonitor)new NullProgressMonitor());
                                        }
                                        catch (Exception ex) {
                                            IOUtil.close(out2);
                                            targetLocation.delete();
                                            throw ex;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        IOUtil.close(out2);
                                        throw throwable;
                                    }
                                    IOUtil.close((Closeable)out2);
                                }
                            }
                        } else {
                            throw new RuntimeException("Invalid repository type " + repository);
                        }
                        artifacts.put(artifactDescriptor, targetLocation);
                        ++n2;
                    }
                    return artifacts;
                }
            });
            artifactCache.put(artifactKey, result);
        }
        return result;
    }

    private Map<File, Future<SignedContent>> getSignedContent(IInstallableUnit iu, Map<IArtifactKey, Future<Map<IArtifactDescriptor, File>>> artifactCache, Map<IInstallableUnit, Map<File, Future<SignedContent>>> signedContentCache) {
        Map<File, Future<SignedContent>> artifactSignedContent = signedContentCache.get(iu);
        if (artifactSignedContent == null) {
            LinkedHashMap<IInstallableUnit, Map<File, Future<SignedContent>>> result = new LinkedHashMap<IInstallableUnit, Map<File, Future<SignedContent>>>();
            BundleContext context = P2CorePlugin.INSTANCE.getBundleContext();
            ServiceReference contentFactoryRef = context.getServiceReference(SignedContentFactory.class);
            final SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
            try {
                ExecutorService executor = this.getExecutor();
                artifactSignedContent = new LinkedHashMap<File, Future<SignedContent>>();
                for (IArtifactKey artifactKey : iu.getArtifacts()) {
                    for (final File file : RepositoryIntegrityAnalyzer.get(artifactCache.get(artifactKey)).values()) {
                        Future<SignedContent> signedContent = executor.submit(new Callable<SignedContent>(){

                            @Override
                            public SignedContent call() throws Exception {
                                File processedFile = new File(String.valueOf(file.toString()) + RepositoryIntegrityAnalyzer.PROCESSED);
                                return verifierFactory.getSignedContent(processedFile.isFile() ? processedFile : file);
                            }
                        });
                        artifactSignedContent.put(file, signedContent);
                        this.getIndex(file);
                    }
                    result.put(iu, artifactSignedContent);
                }
                signedContentCache.put(iu, artifactSignedContent);
            }
            finally {
                context.ungetService(contentFactoryRef);
            }
        }
        return artifactSignedContent;
    }

    private static <T> T get(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    private IMetadataRepository loadMetadataRepository(IMetadataRepositoryManager manager, URI uri) throws URISyntaxException, ProvisionException {
        java.net.URI location;
        IMetadataRepository metadataRepository;
        if (this.verbose) {
            System.out.println("Loading metadata repository '" + uri + "'");
        }
        if ((metadataRepository = this.metadataRepositories.get(location = new java.net.URI(uri.toString()))) == null) {
            metadataRepository = manager.loadRepository(location, null);
            this.metadataRepositories.put(location, metadataRepository);
        }
        return metadataRepository;
    }

    private IArtifactRepository loadArtifactRepository(IArtifactRepositoryManager manager, URI uri) throws URISyntaxException, ProvisionException {
        IArtifactRepository artifactRepository;
        block5: {
            String mirrorsURL;
            block6: {
                java.net.URI location;
                if (this.artifactRepositories.isEmpty()) {
                    return null;
                }
                if (this.verbose) {
                    System.out.println("Loading artifact repository '" + uri + "'");
                }
                if ((artifactRepository = this.artifactRepositories.get(location = new java.net.URI(uri.toString()))) != null) break block5;
                artifactRepository = manager.loadRepository(location, null);
                this.artifactRepositories.put(location, artifactRepository);
                if (!(artifactRepository instanceof ICompositeRepository)) break block6;
                ICompositeRepository compositeRepository = (ICompositeRepository)artifactRepository;
                for (java.net.URI child : compositeRepository.getChildren()) {
                    this.loadArtifactRepository(manager, URI.createURI((String)child.toString()));
                }
                break block5;
            }
            if (!DOWNLOAD_ECLIPSE_ORG_FOLDER_EXISTS || (mirrorsURL = artifactRepository.getProperty("p2.mirrorsURL")) == null || !mirrorsURL.contains("www.eclipse.org/downloads/download.php?")) break block5;
            try {
                artifactRepository.setProperty("p2.mirrorsURL", null);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Could not disable mirrors for '" + artifactRepository.getLocation() + "'");
            }
        }
        return artifactRepository;
    }

    private ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);
        }
        return this.executor;
    }

    private void shutDownExecutor() throws InterruptedException {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor.awaitTermination(30L, TimeUnit.MINUTES);
            this.executor = null;
        }
    }

    public Agent getAgent() {
        if (this.agent == null) {
            try {
                File agentLocation = File.createTempFile("test-", "-agent");
                agentLocation.delete();
                agentLocation.mkdirs();
                this.agent = new AgentImpl(null, agentLocation);
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }
        return this.agent;
    }

    public void setAgent(Agent agent) {
        this.agent = agent;
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() {
        return this.getAgent().getMetadataRepositoryManager();
    }

    private IArtifactRepositoryManager getArtifactRepositoryManager() {
        return this.getAgent().getArtifactRepositoryManager();
    }

    private static String format(float size) {
        NumberFormat instance = NumberFormat.getInstance(Locale.US);
        instance.setMaximumFractionDigits(1);
        instance.setRoundingMode(RoundingMode.DOWN);
        if (size < 1024.0f) {
            return instance.format(size);
        }
        if (size < 1048576.0f) {
            return String.valueOf(instance.format(size / 1024.0f)) + "K";
        }
        if (size < 1.0737418E9f) {
            return String.valueOf(instance.format(size / 1024.0f / 1024.0f)) + "M";
        }
        if (size < 1.0995116E12f) {
            return String.valueOf(instance.format(size / 1024.0f / 1024.0f / 1024.0f)) + "G";
        }
        return String.valueOf(instance.format(size / 1024.0f / 1024.0f / 1024.0f / 1024.0f)) + "T";
    }

    private static String getIUID(IInstallableUnit iu) {
        return RepositoryIntegrityAnalyzer.getID(iu.toString());
    }

    private static String getRequirementID(IRequirement requirement) {
        return RepositoryIntegrityAnalyzer.getID(requirement.toString());
    }

    private static String getProvidedCapabilityID(IProvidedCapability capability) {
        return RepositoryIntegrityAnalyzer.getID(capability.toString());
    }

    private static String getID(String literal) {
        return literal.replace(' ', '_').replace('\"', '_').replace('&', '_').replace('<', '_').replace('\'', '_').replace('>', ' ').replace('#', '_');
    }

    public static abstract class IUReport
    implements Reporter {
        public abstract Report getReport();

        public abstract String getRelativeReportURL();

        public abstract IInstallableUnit getIU();

        public abstract String getDescription();

        public abstract String getProvider();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IndexReport
    implements Reporter {
        private final IndexReport parent;
        private final String reportSource;
        private final String reportBranding;
        private final File folder;
        private final Set<File> reportLocations;
        private final Map<String, String> allReports;
        private List<IndexReport> children;
        private File publishLocation;

        public IndexReport(IndexReport parent, String reportSource, String reportBranding, File folder, File publishLocation, Set<File> reportLocations, Map<String, String> allReports) {
            this.parent = parent;
            this.reportSource = reportSource;
            this.reportBranding = reportBranding;
            this.folder = folder;
            this.publishLocation = publishLocation;
            this.reportLocations = reportLocations;
            this.allReports = allReports;
        }

        @Override
        public String getNow() {
            return new SimpleDateFormat("yyyy'-'MM'-'dd' at 'HH':'mm ").format(System.currentTimeMillis());
        }

        public File getFolder() {
            return this.folder;
        }

        public File getPublishLocation() {
            return this.publishLocation;
        }

        @Override
        public String getTitle() {
            return this.folder.getName();
        }

        @Override
        public Map<String, String> getBreadcrumbs() {
            Map<Object, Object> result = this.parent == null ? new LinkedHashMap() : this.parent.getBreadcrumbs();
            Iterator<Map.Entry<Object, Object>> iterator = result.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry;
                String href = (String)(entry = iterator.next()).getValue();
                entry.setValue(href == null ? "../index.html" : "../" + href);
            }
            result.put(this.folder.getName(), null);
            return result;
        }

        @Override
        public Map<String, String> getNavigation() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            File[] fileArray = this.folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory() && (!this.reportLocations.contains(file) || this.parent != null)) {
                    String name = file.getName();
                    result.put(String.valueOf(name) + "/index.html", name);
                }
                ++n2;
            }
            return result;
        }

        @Override
        public String getTitle(boolean narrow) {
            return this.getTitle();
        }

        @Override
        public String getReportSource() {
            return this.reportSource;
        }

        @Override
        public String getReportBrandingImage() {
            return RepositoryIntegrityAnalyzer.this.getImage(URI.createURI((String)this.reportBranding), this.folder);
        }

        public List<IndexReport> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<IndexReport>();
                File[] fileArray = this.folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory() && !this.reportLocations.contains(file)) {
                        File childPulishLocation = this.publishLocation == null ? null : new File(this.publishLocation, file.getName());
                        this.children.add(new IndexReport(this, this.reportSource, this.reportBranding, file, childPulishLocation, this.reportLocations, null));
                    }
                    ++n2;
                }
            }
            return this.children;
        }

        public Map<String, String> getAllReports() {
            if (this.allReports != null) {
                TreeMap<String, String> result = new TreeMap<String, String>();
                java.net.URI baseURI = this.folder.toURI();
                for (Map.Entry<String, String> entry : this.allReports.entrySet()) {
                    result.put(entry.getKey(), baseURI.relativize(new File(entry.getValue()).toURI()).toString());
                }
                return result;
            }
            return null;
        }
    }

    public static class InstallableUnitWriter
    extends MetadataWriter {
        private ByteArrayOutputStream output;

        public InstallableUnitWriter() {
            this(new ByteArrayOutputStream());
        }

        private InstallableUnitWriter(OutputStream output) {
            super(output, null);
            this.output = (ByteArrayOutputStream)output;
        }

        public String toHTML(IInstallableUnit iu, ValueHandler valueHandler) {
            try {
                super.writeInstallableUnit(iu);
                this.flush();
                byte[] bytes = this.output.toByteArray();
                this.output.reset();
                HTMLResource resource = new HTMLResource(valueHandler);
                resource.load(new ByteArrayInputStream(bytes), null);
                StringWriter writer = new StringWriter();
                resource.save((OutputStream)new URIConverter.WriteableOutputStream((Writer)writer, "UTF-8"), null);
                String string = writer.toString();
                return string;
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
            finally {
                this.flush();
                this.output.reset();
            }
        }

        public String expandEntities(String xmlElementContent) {
            HTMLResource resource = new HTMLResource(null);
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<element>" + xmlElementContent + "</element>";
            URIConverter.ReadableInputStream input = new URIConverter.ReadableInputStream(xml);
            try {
                resource.load((InputStream)input, null);
                EObject documentRoot = (EObject)resource.getContents().get(0);
                AnyType anyType = (AnyType)documentRoot.eContents().get(0);
                Object value = ((FeatureMap.Entry)anyType.getMixed().get(0)).getValue();
                return value.toString();
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
        }

        private static class HTMLResource
        extends XMLResourceImpl {
            private static final URI RESOURCE_URI = URI.createURI((String)"iu.xml");
            private static final XMLParserPool XML_PARSER_POOL = new XMLParserPoolImpl();
            private final ValueHandler valueHandler;

            public HTMLResource(ValueHandler valueHandler) {
                super(RESOURCE_URI);
                this.valueHandler = valueHandler;
                this.setEncoding("UTF-8");
                Map defaultLoadOptions = this.getDefaultLoadOptions();
                BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData();
                defaultLoadOptions.put("EXTENDED_META_DATA", extendedMetaData);
                this.getDefaultSaveOptions().put("EXTENDED_META_DATA", extendedMetaData);
                defaultLoadOptions.put("USE_LEXICAL_HANDLER", Boolean.TRUE);
                defaultLoadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                defaultLoadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                defaultLoadOptions.put("USE_PARSER_POOL", XML_PARSER_POOL);
                XMLOptionsImpl xmlOptions = new XMLOptionsImpl();
                xmlOptions.setProcessAnyXML(true);
                defaultLoadOptions.put("XML_OPTIONS", xmlOptions);
            }

            protected XMLSave createXMLSave() {
                return new HTMLSave(this.createXMLHelper(), this.valueHandler);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            private static class HTMLSave
            extends XMLSaveImpl {
                private final ValueHandler valueHandler;

                public HTMLSave(XMLHelper helper, ValueHandler valueHandler) {
                    super(helper);
                    this.valueHandler = valueHandler;
                }

                protected void init(XMLResource resource, Map<?, ?> options) {
                    super.init(resource, options);
                    this.doc = new HTMLString(this.valueHandler);
                    this.declareXML = false;
                }

                private static class HTMLString
                extends XMLString {
                    private static final String LINE_SEPARATOR = "\n";
                    private static final String LINE_ELEMENT_NAME = "span";
                    private static final String LINE_ELEMENT_START_PREFIX = "<span";
                    private static final String LINE_ELEMENT_END = "</span>";
                    private static final String LINE_ELEMENT_SEPARATOR_PREFIX = "</span>\n<span";
                    private static final String ATTRIBUTE_QUOTE = "<span class='xml-token'>\"</span>";
                    private static final String ATTRIBUTE_EQUALS = "<span class='xml-token'>=</span>";
                    private static final String ELEMENT_START = "<span class='xml-token'>&lt;</span>";
                    private static final String ELEMENT_END = "<span class='xml-token'>&gt;</span>";
                    private static final String EMPTY_ELEMENT_END = "<span class='xml-token'>/&gt;</span>";
                    private static final String ELEMENT_CLOSE_START = "<span class='xml-token'>&lt;/</span>";
                    private static final String ATTRIBUTE_NAME_START = "<span class='xml-attribute'>";
                    private static final String ATTRIBUTE_NAME_END = "</span>";
                    private static final String ELEMENT_NAME_START = "<span class='xml-element'>";
                    private static final String ELEMENT_NAME_END = "</span>";
                    private static final String ATTRIBUTE_VALUE_START = "<span class='xml-attribute-value'>";
                    private static final String ATTRIBUTE_VALUE_END = "</span>";
                    private static final Pattern ELEMENT_VALUE_PATTERN = Pattern.compile("((\\S+[\\s&&[^\n\r]]*)+)");
                    private static final String ELEMENT_VALUE_REPLACEMENT = "<span class='xml-element-value'>$1</span>";
                    private static final String ATTRIBUTE_SEPARATOR = " ";
                    private static final long serialVersionUID = 1L;
                    private final ValueHandler valueHandler;
                    private String uuid;

                    public HTMLString(ValueHandler valueHandler) {
                        super(Integer.MAX_VALUE);
                        this.valueHandler = valueHandler;
                        this.setLineSeparator(LINE_SEPARATOR);
                        this.add(LINE_ELEMENT_START_PREFIX);
                        this.addLineID();
                    }

                    private void addLineID() {
                        this.add(" id=\"");
                        this.uuid = EcoreUtil.generateUUID();
                        this.add(this.uuid);
                        this.add("\">");
                    }

                    private String replaceLineSeparator(String string) {
                        Matcher matcher = Pattern.compile("\r?\n").matcher(string);
                        StringBuffer result = new StringBuffer();
                        if (matcher.find()) {
                            do {
                                matcher.appendReplacement(result, LINE_ELEMENT_SEPARATOR_PREFIX);
                                result.append(" id=\"");
                                this.uuid = EcoreUtil.generateUUID();
                                result.append(this.uuid);
                                result.append("\">");
                            } while (matcher.find());
                            matcher.appendTail(result);
                            return result.toString();
                        }
                        return string;
                    }

                    private String surroundElementContent(String string) {
                        return ELEMENT_VALUE_PATTERN.matcher(string).replaceAll(ELEMENT_VALUE_REPLACEMENT);
                    }

                    public void add(String string) {
                        super.add(this.replaceLineSeparator(string));
                    }

                    public void addText(String string) {
                        String elementContent = this.valueHandler.handleElementContent(this.elementNames, string);
                        if (string.equals(elementContent)) {
                            super.addText(this.replaceLineSeparator(this.surroundElementContent(string)));
                        } else {
                            super.addText(elementContent);
                        }
                    }

                    public void addAttribute(String name, String value) {
                        this.add(ATTRIBUTE_SEPARATOR);
                        this.add(ATTRIBUTE_NAME_START);
                        this.add(name);
                        this.add("</span>");
                        this.add(ATTRIBUTE_EQUALS);
                        this.add(ATTRIBUTE_QUOTE);
                        String attributeValue = this.valueHandler.handleAttributeValue(this.elementNames, name, value);
                        if (attributeValue.equals(value)) {
                            this.add(ATTRIBUTE_VALUE_START);
                            this.add(value);
                            this.add("</span>");
                        } else {
                            this.add(attributeValue);
                        }
                        this.add(ATTRIBUTE_QUOTE);
                    }

                    protected void closeStartElement() {
                        this.add(ELEMENT_END);
                        this.lastElementIsStart = false;
                    }

                    public void startElement(String name) {
                        if (this.lastElementIsStart) {
                            this.closeStartElement();
                        }
                        this.elementNames.add(name);
                        if (name != null) {
                            ++this.depth;
                            this.add(ELEMENT_START);
                            this.add(ELEMENT_NAME_START);
                            this.add(name);
                            this.valueHandler.startElement(this.elementNames, this.uuid);
                            this.add("</span>");
                            this.lastElementIsStart = true;
                        }
                        this.mixed.add(Boolean.TRUE);
                    }

                    public void endElement() {
                        if (this.lastElementIsStart) {
                            this.endEmptyElement();
                        } else {
                            String name = this.removeLast();
                            if (name != null) {
                                this.add(ELEMENT_CLOSE_START);
                                this.add(ELEMENT_NAME_START);
                                this.add(name);
                                this.add("</span>");
                                this.add(ELEMENT_END);
                            }
                        }
                        if (this.elementNames.isEmpty()) {
                            this.add("</span>");
                        }
                    }

                    public void endContentElement(String content) {
                        this.add(ELEMENT_END);
                        super.addText(this.replaceLineSeparator(this.surroundElementContent(content)));
                        this.add(ELEMENT_CLOSE_START);
                        String name = this.removeLast();
                        this.add(ELEMENT_NAME_START);
                        this.add(name);
                        this.add("</span>");
                        this.add(ELEMENT_END);
                        this.lastElementIsStart = false;
                    }

                    public void endEmptyElement() {
                        this.removeLast();
                        this.add(EMPTY_ELEMENT_END);
                        this.lastElementIsStart = false;
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ValueHandler {
            protected String getCurrentElementName(List<String> elementNames) {
                int size = elementNames.size();
                return size == 0 ? "" : elementNames.get(size - 1);
            }

            public String handleAttributeValue(List<String> elementNames, String attributeName, String attributeValue) {
                return attributeValue;
            }

            public String handleElementContent(List<String> elementNames, String elementContent) {
                return elementContent;
            }

            public void startElement(List<String> elementNames, String uuid) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Report
    implements Reporter {
        private static final URI NO_LICENSE_URI = URI.createURI((String)"");
        public static final ILicense NO_LICENSE;
        public static final ILicense SUA_10;
        public static final ILicense SUA_11;
        public static final ILicense SUA_20;
        public static final List<ILicense> SUAS;
        public static final int RETAINED_NIGHTLY_BUILDS = -1;

        static {
            try {
                NO_LICENSE = MetadataFactory.createLicense((java.net.URI)new java.net.URI("https://wwww.eclipse.org"), (String)"No License");
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            SUA_10 = Report.load(URI.createURI((String)"https://www.eclipse.org/legal/epl-v10.html"), URI.createURI((String)"archive:https://git.eclipse.org/c/cbi/org.eclipse.license.git/snapshot/org.eclipse.license-license-1.0.0.v20131003-1638.zip!/org.eclipse.license-license-1.0.0.v20131003-1638/org.eclipse.license/feature.properties"));
            SUA_11 = Report.load(URI.createURI((String)"https://www.eclipse.org/legal/epl-v10.html"), URI.createURI((String)"archive:https://git.eclipse.org/c/cbi/org.eclipse.license.git/snapshot/org.eclipse.license-license-1.0.1.v20140414-1359.zip!/org.eclipse.license-license-1.0.1.v20140414-1359/org.eclipse.license/feature.properties"));
            SUA_20 = Report.load(URI.createURI((String)"https://www.eclipse.org/org/documents/epl-2.0/EPL-2.0.html"), URI.createURI((String)"https://git.eclipse.org/c/cbi/org.eclipse.license.git/plain/org.eclipse.license/feature.properties"));
            SUAS = Collections.unmodifiableList(Arrays.asList(SUA_10, SUA_11, SUA_20));
        }

        @Override
        public abstract String getReportSource();

        @Override
        public abstract String getReportBrandingImage();

        public abstract Map<LicenseDetail, Set<IInstallableUnit>> getLicenses();

        public abstract List<String> getFeatures(Iterable<IInstallableUnit> var1);

        @Override
        public abstract Map<String, String> getBreadcrumbs();

        public List<String> getXML(IInstallableUnit iu) {
            return this.getXML(iu, null);
        }

        public abstract List<String> getXML(IInstallableUnit var1, Map<String, String> var2);

        public abstract String getErrorImage();

        public abstract Report getParent();

        public abstract List<Report> getChildren();

        public abstract String getBrandingImage(IInstallableUnit var1);

        public abstract boolean hasBrandingImage(IInstallableUnit var1);

        public abstract boolean hasBrokenBrandingImage(IInstallableUnit var1);

        public abstract Map<String, Set<IInstallableUnit>> getFeatureProviders();

        public abstract Set<String> getBrandingImages(Collection<IInstallableUnit> var1);

        public abstract String getSignedImage(boolean var1);

        public abstract String getLicenseImage();

        public abstract String getRepositoryImage();

        public abstract String getProviderImage();

        public abstract String getFeatureImage();

        public abstract String getProductImage();

        public abstract String getCategoryImage();

        public abstract String getBundleImage();

        public abstract Map<String, String> getCertificateComponents(Certificate var1);

        public abstract Map<List<Certificate>, Map<String, IInstallableUnit>> getCertificates();

        public abstract List<Certificate> getCertificates(IInstallableUnit var1);

        public abstract Map<String, Boolean> getIUArtifacts(IInstallableUnit var1);

        public abstract String getArtifactImage(String var1);

        public abstract String getArtifactSize(String var1);

        public abstract Map<String, Set<Version>> getIUVersions();

        public abstract Set<IInstallableUnit> getUnsignedIUs();

        public abstract Set<IInstallableUnit> getBadProviderIUs();

        public abstract Set<IInstallableUnit> getBadLicenseIUs();

        public abstract Set<IInstallableUnit> getBrokenBrandingIUs();

        public abstract Set<IInstallableUnit> getPluginsWithMissingPackGZ();

        public abstract boolean isSimple();

        public abstract boolean isRoot();

        public abstract String getDate();

        @Override
        public String getNow() {
            return new SimpleDateFormat("yyyy'-'MM'-'dd' at 'HH':'mm ").format(System.currentTimeMillis());
        }

        public abstract List<String> getFeatures();

        public abstract List<IInstallableUnit> getFeatureIUs();

        public boolean isFeature(IInstallableUnit iu) {
            String id = iu.getId();
            return id.endsWith(".feature.group");
        }

        public abstract List<LicenseDetail> getLicenses(IInstallableUnit var1);

        public String getName(IInstallableUnit iu, boolean defaultToID) {
            String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
            if (name == null) {
                name = iu.getId();
            }
            return name;
        }

        public String getVersion(IInstallableUnit iu) {
            return iu.getVersion().toString();
        }

        public String getNameAndVersion(IInstallableUnit iu) {
            String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
            name = String.valueOf(name) + " " + iu.getVersion();
            return name;
        }

        public abstract Map<String, List<String>> getBundles();

        public abstract boolean isDuplicationExpected(String var1);

        public abstract Set<IInstallableUnit> getAllIUs();

        public Set<IInstallableUnit> getSortedByName(Collection<? extends IInstallableUnit> ius) {
            TreeSet<IInstallableUnit> result = new TreeSet<IInstallableUnit>(NAME_VERSION_COMPARATOR);
            result.addAll(ius);
            return result;
        }

        public abstract Set<IInstallableUnit> getProducts();

        public Set<IInstallableUnit> getCategories() {
            TreeSet<IInstallableUnit> categories = new TreeSet<IInstallableUnit>();
            for (IInstallableUnit iu : this.getAllIUs()) {
                if (!this.isCategory(iu)) continue;
                categories.add(iu);
            }
            return categories;
        }

        public boolean isCategory(IInstallableUnit iu) {
            return "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.category"));
        }

        public boolean isGroup(IInstallableUnit iu) {
            return "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.group"));
        }

        public boolean isProduct(IInstallableUnit iu) {
            return "true".equals(iu.getProperty("org.eclipse.equinox.p2.type.product"));
        }

        public boolean isPlugin(IInstallableUnit iu) {
            return !this.isCategory(iu) && !this.isGroup(iu);
        }

        public abstract String getIUImage(IInstallableUnit var1);

        public abstract Set<IInstallableUnit> getResolvedRequirements(IInstallableUnit var1);

        public String getRelativeIndexURL() {
            String location = this.isRoot() ? "index.html" : String.valueOf(IOUtil.encodeFileName((String)this.getSiteURL())) + ".html";
            return location;
        }

        protected String getRelativeIUReportURL(IInstallableUnit iu) {
            URI indexURL = URI.createURI((String)this.getRelativeIndexURL());
            return indexURL.trimFileExtension().appendSegment(this.getIUID(iu)).appendFileExtension("html").toString();
        }

        public String getIUID(IInstallableUnit iu) {
            return RepositoryIntegrityAnalyzer.getIUID(iu);
        }

        public String getFolderID(String folder) {
            return "_" + new File(folder).getName().replace('.', '_').replace('\'', '_');
        }

        @Override
        public abstract Map<String, String> getNavigation();

        public abstract String getSiteURL();

        public abstract String getMetadataXML();

        public abstract String getArtifactML();

        @Override
        public abstract String getTitle(boolean var1);

        @Override
        public abstract String getTitle();

        private static ILicense load(URI licenseURI, URI uri) {
            InputStream in = null;
            try {
                in = URIConverter.INSTANCE.createInputStream(uri);
                Properties properties = new Properties();
                properties.load(in);
                Object license = properties.get("license");
                ILicense iLicense = MetadataFactory.createLicense((java.net.URI)new java.net.URI(licenseURI.toString()), (String)license.toString());
                return iLicense;
            }
            catch (IOException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
            catch (URISyntaxException ex) {
                throw new IORuntimeException((Throwable)ex);
            }
            finally {
                IOUtil.closeSilent((Closeable)in);
            }
        }

        public abstract List<IUReport> getIUReports();

        public static class LicenseDetail {
            private final URI licenseURL;
            private final ILicense license;
            private final ILicense matchedLicense;
            private final String body;
            private int prefix;
            private int suffix;
            private String replacement;

            private LicenseDetail(URI licenseURL, ILicense license) {
                this.licenseURL = licenseURL;
                this.license = license;
                this.body = license.getBody().trim();
                if (SUA_10.equals((Object)license)) {
                    this.matchedLicense = SUA_10;
                    this.prefix = this.suffix = this.body.length();
                } else if (SUA_11.equals((Object)license)) {
                    this.matchedLicense = SUA_11;
                    this.prefix = this.suffix = this.body.length();
                } else if (SUA_20.equals((Object)license)) {
                    this.matchedLicense = SUA_20;
                    this.prefix = this.suffix = this.body.length();
                } else {
                    ILicense bestMatch = null;
                    String bestMatchBody = null;
                    int longest = -1;
                    int longestMatchBody = -1;
                    ILicense[] iLicenseArray = new ILicense[]{SUA_10, SUA_11, SUA_20};
                    int n = iLicenseArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILicense otherLicense = iLicenseArray[n2];
                        String otherBody = otherLicense.getBody().trim();
                        boolean newLine = false;
                        int bodyIndex = 0;
                        int otherBodyIndex = 0;
                        int bodyLength = this.body.length();
                        int otherBodyLength = otherBody.length();
                        while (bodyIndex < bodyLength && otherBodyIndex < otherBodyLength) {
                            char bodyChar = this.body.charAt(bodyIndex);
                            char otherBodyChar = otherBody.charAt(otherBodyIndex);
                            if (Character.isWhitespace(bodyChar) && Character.isWhitespace(otherBodyChar)) {
                                if (bodyChar == '\n') {
                                    newLine = true;
                                }
                                while (++bodyIndex < bodyLength) {
                                    bodyChar = this.body.charAt(bodyIndex);
                                    if (!Character.isWhitespace(bodyChar)) break;
                                    if (bodyChar != '\n') continue;
                                    newLine = true;
                                }
                                while (++otherBodyIndex < otherBodyLength) {
                                    otherBodyChar = otherBody.charAt(otherBodyIndex);
                                    if (!Character.isWhitespace(otherBodyChar)) break;
                                }
                            }
                            if (bodyChar != otherBodyChar) break;
                            if (bodyIndex > longest && newLine) {
                                bestMatch = otherLicense;
                                bestMatchBody = otherBody;
                                longest = bodyIndex;
                                longestMatchBody = otherBodyIndex;
                            }
                            ++bodyIndex;
                            ++otherBodyIndex;
                        }
                        ++n2;
                    }
                    if (bestMatch != null) {
                        this.prefix = longest + 1;
                        this.suffix = this.body.length();
                        int bodyIndex = this.suffix - 1;
                        int otherBodyIndex = bestMatchBody.length() - 1;
                        while (bodyIndex >= 0 && otherBodyIndex >= 0) {
                            char bodyChar = this.body.charAt(bodyIndex);
                            char otherBodyChar = bestMatchBody.charAt(otherBodyIndex);
                            if (Character.isWhitespace(bodyChar) && Character.isWhitespace(otherBodyChar)) {
                                while (--bodyIndex >= 0) {
                                    bodyChar = this.body.charAt(bodyIndex);
                                    if (!Character.isWhitespace(bodyChar)) break;
                                }
                                while (--otherBodyIndex >= 0) {
                                    otherBodyChar = bestMatchBody.charAt(otherBodyIndex);
                                    if (!Character.isWhitespace(otherBodyChar)) break;
                                }
                            }
                            if (bodyChar != otherBodyChar) {
                                this.suffix = bodyIndex + 1;
                                this.replacement = bestMatchBody.substring(longestMatchBody + 1, otherBodyIndex + 1);
                                break;
                            }
                            --bodyIndex;
                            --otherBodyIndex;
                        }
                    } else {
                        this.prefix = 0;
                        this.suffix = this.body.length();
                    }
                    this.matchedLicense = SUA_10.equals(bestMatch) ? SUA_10 : (SUA_11.equals(bestMatch) ? SUA_11 : (SUA_20.equals(bestMatch) ? SUA_20 : null));
                }
            }

            public URI getLicenseURL() {
                return this.licenseURL;
            }

            public ILicense getLicense() {
                return this.license;
            }

            public String getUUID() {
                return this.license.getUUID();
            }

            public ILicense getMatchedLicense() {
                return this.matchedLicense;
            }

            public String getMatchingPrefix() {
                return this.body.substring(0, this.prefix);
            }

            public String getMismatching() {
                return this.body.substring(this.prefix, this.suffix);
            }

            public String getReplacement() {
                return this.replacement == null ? "" : this.replacement;
            }

            public String getMatchingSuffix() {
                return this.body.substring(this.suffix);
            }

            public boolean isSUA() {
                return SUAS.contains(this.license);
            }

            public boolean isMatchedSUA() {
                return SUAS.contains(this.matchedLicense);
            }

            public String getVersion() {
                int index = SUAS.indexOf(this.license);
                if (index == -1) {
                    index = SUAS.indexOf(this.matchedLicense);
                }
                switch (index) {
                    case 0: {
                        return "SUA 1.0";
                    }
                    case 1: {
                        return "SUA 1.1";
                    }
                    case 2: {
                        return "SUA 2.0";
                    }
                }
                return this.getSummary();
            }

            public String getSummary() {
                return this.license.getBody().replaceAll("[\n\r].*", "");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Reporter {
        public String getTitle();

        public Map<String, String> getBreadcrumbs();

        public Map<String, String> getNavigation();

        public String getTitle(boolean var1);

        public String getReportBrandingImage();

        public String getReportSource();

        public String getNow();
    }
}

