/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer.expressions;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.wizards.datatransfer.RecursiveFileFinder;

public class HasFileRecursivelyExpression
extends Expression {
    public static final String TAG = "hasFileRecursively";
    private String filename;

    public HasFileRecursivelyExpression(String filename) {
        this.filename = filename;
    }

    public HasFileRecursivelyExpression(IConfigurationElement element) {
        this(element.getAttribute("filename"));
    }

    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        Object root = context.getDefaultVariable();
        IContainer container = null;
        if (root instanceof IContainer) {
            container = (IContainer)root;
        } else if (root instanceof IAdaptable) {
            container = (IContainer)((IAdaptable)root).getAdapter(IContainer.class);
        }
        if (container != null) {
            RecursiveFileFinder finder = new RecursiveFileFinder(this.filename, null);
            container.accept((IResourceVisitor)finder);
            return EvaluationResult.valueOf((!finder.getFiles().isEmpty() ? 1 : 0) != 0);
        }
        if (root instanceof File && ((File)root).isDirectory()) {
            LinkedList<File> directoriesToVisit = new LinkedList<File>();
            directoriesToVisit.add((File)root);
            while (!directoriesToVisit.isEmpty()) {
                File currentDirectory = (File)directoriesToVisit.pop();
                if (new File(currentDirectory, this.filename).exists()) {
                    return EvaluationResult.TRUE;
                }
                File[] files = currentDirectory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File child) {
                        return child.isDirectory();
                    }
                });
                if (files == null) continue;
                directoriesToVisit.addAll(Arrays.asList(files));
            }
        }
        return EvaluationResult.FALSE;
    }
}

