/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIterator<T>
implements Iterator<T> {
    protected static final Object END_OF_DATA = new Object();
    private boolean nextComputed;
    private T next;

    @Override
    public final boolean hasNext() {
        if (this.nextComputed) {
            return true;
        }
        Object object = this.computeNextElement();
        this.nextComputed = true;
        if (object == END_OF_DATA) {
            return false;
        }
        Object cast = object;
        this.next = cast;
        return true;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextComputed = false;
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract Object computeNextElement();

    public static <T> ListIterator<T> empty() {
        return EmptyIterator.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyIterator
    implements ListIterator<Object> {
        private static final ListIterator<Object> INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            throw new NoSuchElementException();
        }

        @Override
        public int previousIndex() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Object e) {
            throw new UnsupportedOperationException();
        }
    }
}

