/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.spi.p2.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;

public final class LocalizationHelper {
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final Locale DEFAULT_LOCALE = new Locale("df", "LT");

    public static String getLocaleString(String filename, String prefix) {
        String localeString = null;
        if (filename.startsWith(prefix) && filename.endsWith(PROPERTIES_FILE_EXTENSION)) {
            localeString = filename.length() > prefix.length() + PROPERTIES_FILE_EXTENSION.length() ? filename.substring(prefix.length() + 1, filename.length() - PROPERTIES_FILE_EXTENSION.length()) : "";
        }
        return localeString;
    }

    public static Locale getLocale(String localeString) {
        Locale locale = DEFAULT_LOCALE;
        if (localeString.length() == 5 && localeString.indexOf(95) == 2) {
            locale = new Locale(localeString.substring(0, 2), localeString.substring(3, 5));
        } else if (localeString.length() == 2) {
            locale = new Locale(localeString.substring(0, 2));
        }
        return locale;
    }

    public static Map<Locale, Map<String, String>> getDirPropertyLocalizations(File root, String localizationPath, Locale defaultLocale, String[] propertyKeys) {
        File fullPath = new File(root, localizationPath);
        File localizationDir = fullPath.getParentFile();
        String localizationFile = fullPath.getName();
        String[] localizationFiles = LocalizationHelper.getLocalizationFiles(localizationDir, localizationFile);
        HashMap<Locale, Map<String, String>> localizations = null;
        if (localizationFiles != null && localizationFiles.length > 0) {
            localizations = new HashMap<Locale, Map<String, String>>(localizationFiles.length);
            String[] stringArray = localizationFiles;
            int n = localizationFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String nextFile = stringArray[n2];
                Locale nextLocale = LocalizationHelper.getLocale(LocalizationHelper.getLocaleString(nextFile, localizationFile));
                try {
                    Map<String, String> properties = LocalizationHelper.loadProperties(localizationDir, nextFile);
                    Map<String, String> localizedStrings = LocalizationHelper.getLocalizedProperties(propertyKeys, properties);
                    if (localizedStrings.size() > 0) {
                        localizations.put(nextLocale, localizedStrings);
                        if (DEFAULT_LOCALE.equals(nextLocale) && defaultLocale != null) {
                            localizations.put(nextLocale, localizedStrings);
                        }
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ++n2;
            }
        }
        return localizations;
    }

    public static Map<Locale, Map<String, String>> getJarPropertyLocalizations(File root, String localizationPath, Locale defaultLocale, String[] propertyKeys) {
        HashMap<Locale, Map<String, String>> localizations = new HashMap<Locale, Map<String, String>>(4);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipFile jarFile = new ZipFile(root, 1);){
                Enumeration<? extends ZipEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry nextEntry = entries.nextElement();
                    String nextName = nextEntry.getName();
                    String localeString = LocalizationHelper.getLocaleString(nextName, localizationPath);
                    if (nextEntry.isDirectory() || localeString == null) continue;
                    Locale nextLocale = LocalizationHelper.getLocale(localeString);
                    Throwable throwable2 = null;
                    Object var14_18 = null;
                    try (InputStream stream = jarFile.getInputStream(nextEntry);){
                        Map properties = CollectionUtils.loadProperties((InputStream)stream);
                        Map<String, String> localizedStrings = LocalizationHelper.getLocalizedProperties(propertyKeys, properties);
                        if (localizedStrings.size() <= 0) continue;
                        localizations.put(nextLocale, localizedStrings);
                        if (!DEFAULT_LOCALE.equals(nextLocale) || defaultLocale == null) continue;
                        localizations.put(nextLocale, localizedStrings);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return localizations;
    }

    private static Map<String, String> loadProperties(File root, String propertyFilename) throws IOException {
        try (InputStream propertyStream = null;){
            try {
                if (root.isDirectory()) {
                    propertyStream = new FileInputStream(new File(root, propertyFilename));
                } else {
                    URLConnection connection = new URL("jar:" + root.toURL().toExternalForm() + "!/" + propertyFilename).openConnection();
                    connection.setUseCaches(false);
                    propertyStream = connection.getInputStream();
                }
            }
            catch (FileNotFoundException e) {
                Map<String, String> map = Collections.emptyMap();
                if (propertyStream != null) {
                    propertyStream.close();
                }
                return map;
            }
            Map map = CollectionUtils.loadProperties((InputStream)propertyStream);
            return map;
        }
    }

    public static Map<String, String> getLocalizedProperties(String[] propertyKeys, Map<String, String> properties) {
        HashMap<String, String> localizedProperties = new HashMap<String, String>();
        String[] stringArray = propertyKeys;
        int n = propertyKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String localizedValue;
            String key = stringArray[n2];
            if (key != null && (localizedValue = properties.get(key)) != null) {
                localizedProperties.put(key, localizedValue);
            }
            ++n2;
        }
        return localizedProperties;
    }

    public static String[] getLocalizationFiles(File localizationDir, String filenamePrefix) {
        return localizationDir.list((directory, filename) -> LocalizationHelper.getLocaleString(filename, filenamePrefix) != null);
    }

    private LocalizationHelper() {
    }
}

