/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StandardElementGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;
    private Expression roleCheckExpr = null;

    public InstanceOfExpression(Expression expression, TypeReference type) {
        this.expression = expression;
        this.type = type;
        type.bits |= 0x40000000;
        this.bits |= 0x7C0;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FieldBinding field;
        if (this.roleCheckExpr != null) {
            return this.roleCheckExpr.analyseCode(currentScope, flowContext, flowInfo);
        }
        LocalVariableBinding local = this.expression.localVariableBinding();
        if (local != null && (local.type.tagBits & 2L) == 0L) {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            FlowInfo initsWhenTrue = flowInfo.copy();
            initsWhenTrue.markAsComparedEqualToNonNull(local);
            flowContext.recordUsingNullReference(currentScope, local, this.expression, 1025, flowInfo);
            return FlowInfo.conditional(initsWhenTrue, flowInfo.copy());
        }
        if (this.expression instanceof Reference && currentScope.compilerOptions().enableSyntacticNullAnalysisForFields && (field = ((Reference)this.expression).lastFieldBinding()) != null && (field.type.tagBits & 2L) == 0L) {
            flowContext.recordNullCheckedFieldReference((Reference)this.expression, 1);
        }
        return this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
    }

    @Override
    boolean handledByGeneratedMethod(Scope scope, TypeBinding castType, TypeBinding expressionType) {
        if (castType.isRole() && expressionType instanceof ReferenceBinding && TeamModel.isComparableToRole((ReferenceBinding)expressionType, (ReferenceBinding)castType)) {
            DependentTypeBinding roleCastType;
            if (!(castType instanceof DependentTypeBinding)) {
                castType = RoleTypeCreator.maybeWrapUnqualifiedRoleType(scope, castType, (ASTNode)this);
            }
            if ((roleCastType = (DependentTypeBinding)castType).hasEquivalentAnchorTo(expressionType)) {
                return false;
            }
            if (!(scope instanceof BlockScope)) {
                throw new InternalCompilerError("can't create roleCheck without BlockScope");
            }
            this.roleCheckExpr = StandardElementGenerator.createRoleInstanceOfCheck((BlockScope)scope, this, (ReferenceBinding)expressionType, roleCastType);
            return true;
        }
        return false;
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        if (this.roleCheckExpr != null) {
            this.roleCheckExpr.generateCode(currentScope, codeStream, valueRequired);
            return;
        }
        int pc = codeStream.position;
        this.expression.generateCode(currentScope, codeStream, true);
        codeStream.instance_of(this.type, this.type.resolvedType);
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.expression.printExpression(indent, output).append(" instanceof ");
        return this.type.print(0, output);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        TypeBinding expressionType = this.expression.resolveType(scope);
        TypeBinding checkedType = this.type.resolveType(scope, true);
        if (expressionType != null && checkedType != null && checkedType.hasNullTypeAnnotations() && (!expressionType.isCompatibleWith(checkedType) || NullAnnotationMatching.analyse(checkedType, expressionType, -1).isAnyMismatch())) {
            scope.problemReporter().nullAnnotationUnsupportedLocation(this.type);
        }
        if (expressionType == null || checkedType == null) {
            return null;
        }
        if (!checkedType.isReifiable()) {
            scope.problemReporter().illegalInstanceOfGenericType(checkedType, this);
        } else if (checkedType.isValidBinding() && (expressionType != TypeBinding.NULL && expressionType.isBaseType() || !this.checkCastTypesCompatibility(scope, checkedType, expressionType, null))) {
            scope.problemReporter().notCompatibleTypesError(this, expressionType, checkedType);
        }
        this.resolvedType = TypeBinding.BOOLEAN;
        return this.resolvedType;
    }

    @Override
    public void tagAsUnnecessaryCast(Scope scope, TypeBinding castType) {
        if (this.expression.resolvedType != TypeBinding.NULL) {
            scope.problemReporter().unnecessaryInstanceof(this, castType);
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            this.type.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

