/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.example.model.ISomeTask;

public class SomeTask
implements ISomeTask {
    private final ISomeTask.RunDb runDb;
    private ISomeTask.TaskType taskType;
    private final String id;
    private final String startTime;
    private final String description;
    private final String category;
    private final String emailAddress;
    private Date lastRunDate;
    private int percentComplete;
    private final List<SomeTask> children = new ArrayList<SomeTask>();
    private final long longValue;

    public SomeTask(ISomeTask.RunDb runDb, ISomeTask.TaskType taskType, String id, String startTime, String description, String category, String emailAddress, int percentComplete) {
        this(runDb, taskType, new Date(), id, startTime, description, category, emailAddress, percentComplete, 50000L);
    }

    public SomeTask(ISomeTask.RunDb runDb, ISomeTask.TaskType taskType, Date lastRunDate, String id, String startTime, String description, String category, String emailAddress, int percentComplete, long longValue) {
        this.runDb = runDb;
        this.taskType = taskType;
        this.lastRunDate = lastRunDate;
        this.id = id;
        this.startTime = startTime;
        this.description = description;
        this.category = category;
        this.emailAddress = emailAddress;
        this.percentComplete = percentComplete;
        this.longValue = longValue;
    }

    public void addChild(SomeTask someTask) {
        this.children.add(someTask);
    }

    public Collection<SomeTask> getChildren() {
        return this.children;
    }

    @Override
    public ISomeTask.RunDb getRunDb() {
        return this.runDb;
    }

    @Override
    public ISomeTask.TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    @Override
    public String getLastRunDateStr() {
        Date date = this.getLastRunDate();
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("MM/dd/yyyy hh:mm a").format(date);
    }

    @Override
    public int getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(int percentComplete) {
        this.percentComplete = percentComplete;
    }

    public void setLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }

    @Override
    public long getLongValue() {
        return this.longValue;
    }

    public void setTaskType(ISomeTask.TaskType taskType) {
        this.taskType = taskType;
    }
}

