/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.overview;

import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.IStyledFigure;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.lane.EventFigure;
import org.eclipse.nebula.widgets.timeline.figures.overview.OverviewEventFigure;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;

public class OverviewEventLayer
extends FreeformLayer
implements IStyledFigure {
    private static final int MINIMUM_WIDTH = 1;
    private int fEventHeight = 0;

    public OverviewEventLayer(ITimelineStyleProvider styleProvider) {
        this.updateStyle(styleProvider);
        this.setLayoutManager((LayoutManager)new OverviewLayout());
    }

    public OverviewEventFigure addEvent(EventFigure eventFigure) {
        OverviewEventFigure overviewEventFigure = new OverviewEventFigure(eventFigure);
        overviewEventFigure.setForegroundColor(eventFigure.getForegroundColor());
        this.add((IFigure)overviewEventFigure, eventFigure);
        return overviewEventFigure;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    @Override
    public void updateStyle(ITimelineStyleProvider styleProvider) {
        this.fEventHeight = styleProvider.getOverviewLaneHeight();
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        return null;
    }

    private class OverviewLayout
    extends XYLayout {
        private OverviewLayout() {
        }

        public Rectangle getConstraint(IFigure figure) {
            EventFigure eventFigure;
            ITimelineEvent event;
            TimeBaseConverter timeConverter = RootFigure.getTimeViewDetails(figure);
            Timing screenCoordinates = timeConverter.toOverviewScreenCoordinates((event = (eventFigure = (EventFigure)super.getConstraint(figure)).getEvent()).getTiming());
            PrecisionRectangle overviewEventArea = new PrecisionRectangle(screenCoordinates.left(), (double)(8 + (OverviewEventLayer.this.fEventHeight + 3) * RootFigure.getLaneIndex(eventFigure)), screenCoordinates.getDuration(), (double)OverviewEventLayer.this.fEventHeight);
            if (overviewEventArea.width() < 1) {
                overviewEventArea.setWidth(1);
            }
            return overviewEventArea;
        }
    }
}

