/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal.geomapbrowser;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class HeaderControl
extends Canvas {
    private static final int TOP_SPACE = 6;
    private Font font;
    private Color foreground;
    private String text = "";
    private Point size = new Point(1, 1);

    public HeaderControl(Composite parent) {
        super(parent, 0x20000000);
        this.addPaintListener(e -> this.onPaint(e));
        this.addDisposeListener(e -> this.onDispose(e));
        this.font = new Font((Device)this.getDisplay(), "Tahoma", 10, 1);
        this.foreground = new Color((Device)this.getDisplay(), 87, 166, 212);
        this.measureString("M");
    }

    private void measureString(String s) {
        GC gc = new GC((Drawable)this);
        try {
            gc.setFont(this.font);
            this.size = gc.stringExtent(s);
            this.size.y += 6;
        }
        finally {
            gc.dispose();
        }
    }

    private void onDispose(DisposeEvent e) {
        this.font.dispose();
        this.foreground.dispose();
    }

    private void onPaint(PaintEvent e) {
        GC gc = e.gc;
        gc.setFont(this.font);
        gc.setForeground(this.foreground);
        gc.drawString(this.text, 0, 6, true);
        Point size = this.getSize();
        int w = size.x;
        int h = size.y;
        gc.drawLine(0, h - 1, w, h - 1);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.measureString(text);
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(this.size.x, this.size.y);
    }
}

