/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.month;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.nebula.widgets.compositetable.day.CalendarableItemEventHandler;
import org.eclipse.nebula.widgets.compositetable.day.CalendarableSelectionChangeListener;
import org.eclipse.nebula.widgets.compositetable.month.MonthCalendarSelectedDay;
import org.eclipse.nebula.widgets.compositetable.month.internal.Day;
import org.eclipse.nebula.widgets.compositetable.month.internal.Week;
import org.eclipse.nebula.widgets.compositetable.month.internal.WeekHeader;
import org.eclipse.nebula.widgets.compositetable.timeeditor.AbstractEventEditor;
import org.eclipse.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.nebula.widgets.compositetable.timeeditor.EventContentProvider;
import org.eclipse.nebula.widgets.compositetable.timeeditor.EventCountProvider;
import org.eclipse.nebula.widgets.compositetable.timeeditor.IEventEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MonthCalendar
extends AbstractEventEditor
implements IEventEditor {
    private Date startDate;
    private WeekHeader weekHeader = null;
    private Composite weeksHolder = null;
    private Week[] weeks;
    private EventContentProvider eventContentProvider = null;
    private EventCountProvider eventCountProvider = null;
    private List<CalendarableItemEventHandler> deleteHandlers = new ArrayList<CalendarableItemEventHandler>();
    private List<CalendarableItemEventHandler> disposeHandlers = new ArrayList<CalendarableItemEventHandler>();
    private List<CalendarableItemEventHandler> itemEditHandlers = new ArrayList<CalendarableItemEventHandler>();
    private List<CalendarableSelectionChangeListener> selectionChangeListeners = new ArrayList<CalendarableSelectionChangeListener>();
    private MonthCalendarSelectedDay selectedDay = null;
    private List<FocusListener> focusListeners = new ArrayList<FocusListener>();
    private Day lastSelectedDay;
    private FocusListener dayFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            Day day = (Day)e.widget;
            if (MonthCalendar.this.lastSelectedDay != null && MonthCalendar.this.lastSelectedDay != day) {
                MonthCalendar.this.lastSelectedDay.setFocusState(1);
                MonthCalendar.this.lastSelectedDay.redraw();
            }
            Point coordinates = day.getMonthPosition();
            MonthCalendar.this.selectedDay = new MonthCalendarSelectedDay(day.getDate(), coordinates);
            e.data = MonthCalendar.this.selectedDay;
            MonthCalendar.this.lastSelectedDay = day;
            for (FocusListener listener : MonthCalendar.this.focusListeners) {
                listener.focusGained(e);
            }
        }

        public void focusLost(FocusEvent e) {
            Day day = (Day)e.widget;
            Point coordinates = day.getMonthPosition();
            e.data = new MonthCalendarSelectedDay(day.getDate(), coordinates);
            for (FocusListener listener : MonthCalendar.this.focusListeners) {
                listener.focusLost(e);
            }
        }
    };
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private MouseListener dayMouseListener = new MouseListener(){

        private Day getDay(MouseEvent e) {
            Control control = (Control)e.widget;
            while (!(control instanceof Day)) {
                control = control.getParent();
            }
            Day day = (Day)control;
            return day;
        }

        public void mouseDown(MouseEvent e) {
            Day day = this.getDay(e);
            Point coordinates = day.getMonthPosition();
            e.data = new MonthCalendarSelectedDay(day.getDate(), coordinates);
            for (MouseListener listener : MonthCalendar.this.mouseListeners) {
                listener.mouseDown(e);
            }
        }

        public void mouseUp(MouseEvent e) {
            Day day = this.getDay(e);
            Point coordinates = day.getMonthPosition();
            e.data = new MonthCalendarSelectedDay(day.getDate(), coordinates);
            for (MouseListener listener : MonthCalendar.this.mouseListeners) {
                listener.mouseUp(e);
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
            Day day = this.getDay(e);
            Point coordinates = day.getMonthPosition();
            e.data = new MonthCalendarSelectedDay(day.getDate(), coordinates);
            for (MouseListener listener : MonthCalendar.this.mouseListeners) {
                listener.mouseDoubleClick(e);
            }
        }
    };
    private List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    private KeyListener dayKeyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            Day day = (Day)e.widget;
            Point coordinates = day.getMonthPosition();
            e.data = new MonthCalendarSelectedDay(day.getDate(), coordinates);
            for (KeyListener listener : MonthCalendar.this.keyListeners) {
                listener.keyPressed(e);
            }
            if (!e.doit) {
                return;
            }
            switch (e.keyCode) {
                case 0x1000001: {
                    Day newDay;
                    if (coordinates.y > 0) {
                        newDay = MonthCalendar.this.weeks[coordinates.y - 1].getDay(coordinates.x);
                        newDay.setFocus();
                    }
                    return;
                }
                case 0x1000002: {
                    Day newDay;
                    if (coordinates.y < MonthCalendar.this.weeks.length - 1) {
                        newDay = MonthCalendar.this.weeks[coordinates.y + 1].getDay(coordinates.x);
                        newDay.setFocus();
                    }
                    return;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            Day day = (Day)e.widget;
            Point coordinates = day.getMonthPosition();
            e.data = new MonthCalendarSelectedDay(day.getDate(), coordinates);
            for (KeyListener listener : MonthCalendar.this.keyListeners) {
                listener.keyReleased(e);
            }
        }
    };

    public MonthCalendar(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.weeks = new Week[0];
        this.setStartDate(new Date());
    }

    private void initialize() {
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        this.createWeekHeader();
        this.setLayout((Layout)gl);
        this.createWeeksHolder();
    }

    private void createWeekHeader() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.weekHeader = new WeekHeader(this, 0);
        this.weekHeader.setLayoutData(gridData);
    }

    private void createWeeksHolder() {
        this.weeksHolder = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 1;
        gridLayout.marginHeight = 0;
        this.weeksHolder.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.weeksHolder.setLayoutData((Object)gd);
    }

    private Week createWeek() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        Week week = new Week(this.weeksHolder, 0);
        week.setLayoutData(gd);
        return week;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.checkWidget();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(startDate);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        this.startDate = c.getTime();
        this.refresh();
    }

    @Override
    public Date getStartDate() {
        this.checkWidget();
        return this.startDate;
    }

    @Override
    public void refresh(Date date) {
        this.checkWidget();
        if (date == null) {
            this.refresh();
            return;
        }
        GregorianCalendar currentDay = new GregorianCalendar();
        currentDay.setTime(this.startDate);
        currentDay.set(5, 1);
        currentDay.set(7, 1);
        GregorianCalendar endDay = new GregorianCalendar();
        endDay.setTime(date);
        endDay.set(11, 0);
        endDay.set(12, 0);
        endDay.set(13, 0);
        endDay.set(14, 0);
        Date targetDate = endDay.getTime();
        Day currentDayControl = null;
        int week = 0;
        while (week < this.weeks.length) {
            int day = 0;
            while (day < 7) {
                currentDayControl = this.weeks[week].getDay(day);
                ((Calendar)currentDay).add(5, 1);
                if (currentDay.getTime().after(targetDate)) {
                    this.refresh(date, currentDayControl);
                    return;
                }
                ++day;
            }
            ++week;
        }
    }

    private void refresh(Date date, Day dayControl) {
        dayControl.setDate(date);
        if (this.eventCountProvider == null || this.eventContentProvider == null) {
            return;
        }
        int numberOfEventsInDay = this.eventCountProvider.getNumberOfEventsInDay(date);
        CalendarableItem[] controls = new CalendarableItem[numberOfEventsInDay];
        int i = 0;
        while (i < controls.length) {
            controls[i] = new CalendarableItem(date);
            ++i;
        }
        this.eventContentProvider.refresh(date, controls);
        dayControl.setItems(controls);
    }

    @Override
    public void refresh() {
        this.checkWidget();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.startDate);
        int currentMonth = c.get(2);
        GregorianCalendar nextMonthCalendar = new GregorianCalendar();
        nextMonthCalendar.setTime(c.getTime());
        ((Calendar)nextMonthCalendar).add(2, 1);
        Date nextMonth = nextMonthCalendar.getTime();
        c.set(5, 1);
        c.set(7, c.getFirstDayOfWeek());
        LinkedList<Week> newWeeksArray = new LinkedList<Week>();
        int week = 0;
        while (c.getTime().before(nextMonth)) {
            if (this.weeks.length > week) {
                newWeeksArray.addLast(this.weeks[week]);
            } else {
                Week newWeek = this.createWeek();
                newWeeksArray.addLast(newWeek);
                int day = 0;
                while (day < 7) {
                    Day newDay = newWeek.getDay(day);
                    newDay.setMonthPosition(new Point(day, week));
                    newDay.addKeyListener(this.dayKeyListener);
                    newDay.addMouseListener(this.dayMouseListener);
                    newDay.addFocusListener(this.dayFocusListener);
                    ++day;
                }
            }
            int day = 0;
            while (day < 7) {
                Day currentDay = ((Week)((Object)newWeeksArray.get(week))).getDay(day);
                currentDay.setInCurrentMonth(c.get(2) == currentMonth);
                currentDay.setDayNumber(c.get(5));
                this.refresh(c.getTime(), currentDay);
                currentDay.layout(true);
                ((Calendar)c).add(5, 1);
                ++day;
            }
            ++week;
        }
        if (this.weeks.length > newWeeksArray.size()) {
            int extraWeek = newWeeksArray.size();
            while (extraWeek < this.weeks.length) {
                this.weeks[extraWeek].dispose();
                ++extraWeek;
            }
        }
        if (this.weeks.length != newWeeksArray.size()) {
            this.weeksHolder.layout(true);
        }
        this.weeks = newWeeksArray.toArray(new Week[newWeeksArray.size()]);
    }

    @Override
    public void setEventContentProvider(EventContentProvider eventContentProvider) {
        this.checkWidget();
        this.eventContentProvider = eventContentProvider;
    }

    @Override
    public void setEventCountProvider(EventCountProvider eventCountProvider) {
        this.checkWidget();
        this.eventCountProvider = eventCountProvider;
    }

    @Override
    public void addItemDeleteHandler(CalendarableItemEventHandler deleteHandler) {
        this.checkWidget();
        this.deleteHandlers.add(deleteHandler);
    }

    @Override
    public void removeItemDeleteHandler(CalendarableItemEventHandler deleteHandler) {
        this.checkWidget();
        this.deleteHandlers.remove(deleteHandler);
    }

    @Override
    public void addItemDisposeHandler(CalendarableItemEventHandler itemDisposeHandler) {
        this.checkWidget();
        this.disposeHandlers.add(itemDisposeHandler);
    }

    @Override
    public void removeItemDisposeHandler(CalendarableItemEventHandler itemDisposeHandler) {
        this.checkWidget();
        this.disposeHandlers.remove(itemDisposeHandler);
    }

    @Override
    public void addItemEditHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        this.itemEditHandlers.add(handler);
    }

    @Override
    public void removeItemEditHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        this.itemEditHandlers.remove(handler);
    }

    @Override
    public void addSelectionChangeListener(CalendarableSelectionChangeListener l) {
        this.checkWidget();
        this.selectionChangeListeners.add(l);
    }

    @Override
    public void removeSelectionChangeListener(CalendarableSelectionChangeListener l) {
        this.checkWidget();
        this.selectionChangeListeners.remove(l);
    }

    @Override
    public boolean fireDelete(CalendarableItem toDelete) {
        this.checkWidget();
        return false;
    }

    @Override
    public void setTimeBreakdown(int numberOfDays, int numberOfDivisionsInHour) {
        this.checkWidget();
    }

    @Override
    public int getNumberOfDays() {
        this.checkWidget();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(this.startDate);
        return ((Calendar)c).getActualMaximum(5);
    }

    @Override
    public int getNumberOfDivisionsInHour() {
        this.checkWidget();
        return -1;
    }

    public MonthCalendarSelectedDay getSelectedDay() {
        this.checkWidget();
        return this.selectedDay;
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        super.addFocusListener(listener);
        this.focusListeners.add(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        super.removeFocusListener(listener);
        this.focusListeners.remove(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        super.addMouseListener(listener);
        this.mouseListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        super.removeMouseListener(listener);
        this.mouseListeners.remove(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        super.addKeyListener(listener);
        this.keyListeners.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        super.removeKeyListener(listener);
        this.keyListeners.remove(listener);
    }

    public boolean setFocus() {
        this.checkWidget();
        int week = 0;
        int day = 0;
        if (this.selectedDay != null) {
            Point position = this.selectedDay.coordinates;
            week = position.y;
            day = position.x;
        } else {
            Calendar cal = GregorianCalendar.getInstance();
            week = cal.get(4) - 1;
            day = cal.get(7) - 1;
        }
        Day newDay = this.weeks[week].getDay(day);
        return newDay.setFocus();
    }

    public void select(Date newDate) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(newDate);
        int newMonth = cal.get(2);
        int week = cal.get(4) - 1;
        int day = cal.get(7) - 1;
        Point coords = new Point(day, week);
        MonthCalendarSelectedDay newSelectedDay = new MonthCalendarSelectedDay(newDate, coords);
        int state = -1;
        MonthCalendarSelectedDay oldSelectedDay = this.getSelectedDay();
        if (oldSelectedDay != null) {
            Day oldDay = this.weeks[oldSelectedDay.coordinates.y].getDay(oldSelectedDay.coordinates.x);
            state = oldDay.getFocusState();
            oldDay.setFocusState(1);
            oldDay.redraw();
        }
        cal.clear();
        cal.setTime(this.startDate);
        int currentMonth = cal.get(2);
        if (currentMonth != newMonth) {
            this.setStartDate(newDate);
        }
        Day newDay = this.weeks[week].getDay(day);
        if (state == 0) {
            newDay.setFocus();
        } else {
            newDay.setFocusState(-1);
            newDay.redraw();
            this.selectedDay = newSelectedDay;
        }
    }
}

