/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;

public class LinearScaleTickMarks
extends Figure {
    private LinearScale scale;
    public static final int LINE_WIDTH = 1;
    public static final int MAJOR_TICK_LENGTH = 6;
    public static final int MINOR_TICK_LENGTH = 3;
    private int minorGridStepInPixel;
    private int minorTicksNumber;

    public LinearScaleTickMarks(LinearScale scale) {
        this.scale = scale;
        this.setForegroundColor(scale.getForegroundColor());
    }

    public LinearScale getAxis() {
        return this.scale;
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        ITicksProvider ticks = this.scale.getTicksProvider();
        int width = this.getSize().width;
        int height = this.getSize().height;
        try {
            graphics.pushState();
            graphics.setAlpha(100);
            if (this.scale.isHorizontal()) {
                this.drawXTickMarks(graphics, ticks.getPositions(), this.scale.getTickLabelSide(), width, height);
            } else {
                this.drawYTickMarks(graphics, ticks.getPositions(), this.scale.getTickLabelSide(), width, height);
            }
        }
        finally {
            graphics.popState();
        }
    }

    private void updateMinorTickParas() {
        if (this.scale.isDateEnabled()) {
            this.minorTicksNumber = Math.abs(this.scale.getRange().getUpper() - this.scale.getRange().getLower()) < 600000.0 ? 5 : 6;
            this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 6.0);
            return;
        }
        if (this.scale.getScaleTickLabels().getGridStepInPixel() / 5 >= this.scale.getMinorTickMarkStepHint()) {
            this.minorTicksNumber = 5;
            this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 5.0);
            return;
        }
        if (this.scale.getScaleTickLabels().getGridStepInPixel() / 4 >= this.scale.getMinorTickMarkStepHint()) {
            this.minorTicksNumber = 4;
            this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 4.0);
            return;
        }
        this.minorTicksNumber = 2;
        this.minorGridStepInPixel = (int)((double)this.scale.getScaleTickLabels().getGridStepInPixel() / 2.0);
    }

    protected void drawXTickMarks(Graphics gc, List<Integer> tickLabelPositions, AbstractScale.LabelSide tickLabelSide, int width, int height) {
        this.updateMinorTickParas();
        gc.setLineStyle(1);
        if (this.scale.isLogScaleEnabled()) {
            ArrayList<Boolean> tickLabelVisibilities = this.scale.getScaleTickLabels().getTickVisibilities();
            int i = 0;
            while (i < tickLabelPositions.size()) {
                int x = tickLabelPositions.get(i);
                int y = 0;
                int tickLength = 0;
                tickLength = tickLabelVisibilities.get(i) != false ? 6 : 3;
                if (tickLabelSide == AbstractScale.LabelSide.Secondary) {
                    y = height - 1 - 1 - tickLength;
                }
                if (tickLabelVisibilities.get(i).booleanValue() || this.scale.isMinorTicksVisible()) {
                    gc.drawLine(x, y, x, y + tickLength);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < tickLabelPositions.size()) {
                int x = tickLabelPositions.get(i);
                int y = 0;
                if (tickLabelSide == AbstractScale.LabelSide.Secondary) {
                    y = height - 1 - 1 - 6;
                }
                gc.drawLine(x, y, x, y + 6);
                if (this.scale.isMinorTicksVisible() && i > 0) {
                    if (i == 1 && tickLabelPositions.get(1) - tickLabelPositions.get(0) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        x = tickLabelPositions.get(1);
                        while (x - tickLabelPositions.get(0) > this.minorGridStepInPixel + 3) {
                            this.drawXMinorTicks(gc, tickLabelSide, x -= this.minorGridStepInPixel, y);
                        }
                    } else if (i == tickLabelPositions.size() - 1 && tickLabelPositions.get(i) - tickLabelPositions.get(i - 1) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        x = tickLabelPositions.get(i - 1);
                        while (tickLabelPositions.get(i) - x > this.minorGridStepInPixel + 3) {
                            this.drawXMinorTicks(gc, tickLabelSide, x += this.minorGridStepInPixel, y);
                        }
                    } else {
                        int j = 0;
                        while (j < this.minorTicksNumber) {
                            x = tickLabelPositions.get(i - 1) + (tickLabelPositions.get(i) - tickLabelPositions.get(i - 1)) * j / this.minorTicksNumber;
                            this.drawXMinorTicks(gc, tickLabelSide, x, y);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.scale.isScaleLineVisible()) {
            if (tickLabelSide == AbstractScale.LabelSide.Primary) {
                gc.drawLine(this.scale.getMargin(), 0, width - this.scale.getMargin(), 0);
            } else {
                gc.drawLine(this.scale.getMargin(), height - 1, width - this.scale.getMargin(), height - 1);
            }
        }
    }

    private void drawXMinorTicks(Graphics gc, AbstractScale.LabelSide tickLabelSide, int x, int y) {
        if (tickLabelSide == AbstractScale.LabelSide.Primary) {
            gc.drawLine(x, y, x, y + 3);
        } else {
            gc.drawLine(x, y + 6 - 3, x, y + 6);
        }
    }

    protected void drawYTickMarks(Graphics gc, List<Integer> tickLabelPositions, AbstractScale.LabelSide tickLabelSide, int width, int height) {
        this.updateMinorTickParas();
        gc.setLineStyle(1);
        int x = 0;
        int y = 0;
        if (this.scale.isLogScaleEnabled()) {
            ArrayList<Boolean> tickLabelVisibilities = this.scale.getScaleTickLabels().getTickVisibilities();
            int i = 0;
            while (i < tickLabelPositions.size()) {
                int tickLength = 0;
                tickLength = tickLabelVisibilities.get(i) != false ? 6 : 3;
                x = tickLabelSide == AbstractScale.LabelSide.Primary ? width - 1 - 1 - tickLength : 1;
                y = height - tickLabelPositions.get(i);
                if (tickLabelVisibilities.get(i).booleanValue() || this.scale.isMinorTicksVisible()) {
                    gc.drawLine(x, y, x + tickLength, y);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < tickLabelPositions.size()) {
                x = tickLabelSide == AbstractScale.LabelSide.Primary ? width - 1 - 1 - 6 : 1;
                y = height - tickLabelPositions.get(i);
                gc.drawLine(x, y, x + 6, y);
                if (this.scale.isMinorTicksVisible() && i > 0) {
                    if (i == 1 && tickLabelPositions.get(1) - tickLabelPositions.get(0) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        y = tickLabelPositions.get(1);
                        while (y - tickLabelPositions.get(0) > this.minorGridStepInPixel + 3) {
                            this.drawYMinorTicks(gc, tickLabelSide, x, height - (y -= this.minorGridStepInPixel));
                        }
                    } else if (i == tickLabelPositions.size() - 1 && tickLabelPositions.get(i) - tickLabelPositions.get(i - 1) < this.scale.getScaleTickLabels().getGridStepInPixel()) {
                        y = tickLabelPositions.get(i - 1);
                        while (tickLabelPositions.get(i) - y > this.minorGridStepInPixel + 3) {
                            this.drawYMinorTicks(gc, tickLabelSide, x, height - (y += this.minorGridStepInPixel));
                        }
                    } else {
                        int j = 0;
                        while (j < this.minorTicksNumber) {
                            y = height - tickLabelPositions.get(i - 1) - (tickLabelPositions.get(i) - tickLabelPositions.get(i - 1)) * j / this.minorTicksNumber;
                            this.drawYMinorTicks(gc, tickLabelSide, x, y);
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.scale.isScaleLineVisible()) {
            if (tickLabelSide == AbstractScale.LabelSide.Primary) {
                gc.drawLine(width - 1, this.scale.getMargin(), width - 1, height - this.scale.getMargin());
            } else {
                gc.drawLine(0, this.scale.getMargin(), 0, height - this.scale.getMargin());
            }
        }
    }

    private void drawYMinorTicks(Graphics gc, AbstractScale.LabelSide tickLabelSide, int x, int y) {
        int verticalMinorTickLength = 2;
        if (tickLabelSide == AbstractScale.LabelSide.Primary) {
            gc.drawLine(x + 6 - verticalMinorTickLength, y, x + 6, y);
        } else {
            gc.drawLine(x, y, x + verticalMinorTickLength, y);
        }
    }

    public LinearScale getScaleProvider() {
        return this.scale;
    }
}

