/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.util.Preferences;
import org.eclipse.swt.widgets.Display;

public class CircleAnnotation
extends Annotation {
    private static final int CIRCLE_DIAMETER = 8;

    public CircleAnnotation(String name, Trace trace) {
        super(name, trace);
    }

    @Override
    public void setCurrentSnappedSample(ISample currentSnappedSample, boolean keepLabelPosition) {
        this.currentSnappedSample = currentSnappedSample;
        this.repaint();
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        if (this.trace != null && this.currentSnappedSample == null && !this.pointerDragged) {
            this.updateToDefaultPosition();
        }
        if (Preferences.useAdvancedGraphics()) {
            graphics.setAntialias(1);
        }
        graphics.setForegroundColor(Display.getCurrent().getSystemColor(3));
        this.xValue = this.currentSnappedSample.getXValue();
        this.yValue = this.currentSnappedSample.getYValue();
        int x = this.xAxis.getValuePosition(this.xValue, false);
        int y = this.yAxis.getValuePosition(this.yValue, false);
        graphics.drawOval(x - 4, y - 4, 8, 8);
    }
}

