/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.breadcrumb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.opal.breadcrumb.BreadcrumbItem;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class Breadcrumb
extends Canvas {
    private static final String IS_BUTTON_PRESSED = Breadcrumb.class.toString() + "_pressed";
    private final List<BreadcrumbItem> items = new ArrayList<BreadcrumbItem>();
    private static Color START_GRADIENT_COLOR = SWTGraphicUtil.getColorSafely((int)255, (int)255, (int)255);
    private static Color END_GRADIENT_COLOR = SWTGraphicUtil.getColorSafely((int)224, (int)224, (int)224);
    static Color BORDER_COLOR = SWTGraphicUtil.getColorSafely((int)128, (int)128, (int)128);
    static Color BORDER_COLOR_1 = SWTGraphicUtil.getColorSafely((int)212, (int)212, (int)212);
    static Color BORDER_COLOR_2 = SWTGraphicUtil.getColorSafely((int)229, (int)229, (int)229);
    static Color BORDER_COLOR_3 = SWTGraphicUtil.getColorSafely((int)243, (int)243, (int)243);
    boolean hasBorder = false;

    public Breadcrumb(Composite parent, int style) {
        super(parent, Breadcrumb.checkStyle(style) | 0x20000000);
        this.hasBorder = (style & 0x800) != 0;
        this.addListeners();
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return style & 0xFFFFF7FF;
        }
        return 0;
    }

    private void addListeners() {
        this.addMouseDownListener();
        this.addMouseUpListener();
        this.addMouseHoverListener();
        this.addPaintListener(e -> this.paintControl(e));
    }

    private void addMouseDownListener() {
        this.addListener(3, event -> {
            boolean isPush;
            BreadcrumbItem item = this.items.stream().filter(element -> element.getBounds().contains(event.x, event.y)).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            boolean isToggle = (item.getStyle() & 2) != 0;
            boolean bl = isPush = (item.getStyle() & 8) != 0;
            if (isToggle || isPush) {
                item.setSelection(!item.getSelection());
                this.redraw();
                this.update();
            }
            item.setData(IS_BUTTON_PRESSED, "*");
        });
    }

    private void addMouseUpListener() {
        this.addListener(4, event -> {
            BreadcrumbItem item = this.items.stream().filter(element -> element.getBounds().contains(event.x, event.y)).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            if (item.getData(IS_BUTTON_PRESSED) == null) {
                return;
            }
            item.setData(IS_BUTTON_PRESSED, null);
            if ((item.getStyle() & 8) != 0) {
                item.setSelection(false);
            }
            if ((item.getStyle() & 0xA) != 0) {
                item.fireSelectionEvent();
                this.redraw();
                this.update();
            }
        });
    }

    private void addMouseHoverListener() {
        this.addListener(32, event -> {
            BreadcrumbItem item = this.items.stream().filter(element -> element.getBounds().contains(event.x, event.y)).findFirst().orElse(null);
            if (item == null) {
                return;
            }
            this.setToolTipText(item.getTooltipText() == null ? "" : item.getTooltipText());
        });
    }

    private void paintControl(PaintEvent e) {
        GC gc = e.gc;
        gc.setAdvanced(true);
        gc.setAntialias(1);
        int width = this.getSize().x;
        int height = this.getSize().y;
        this.drawBackground(gc, width, height);
        Iterator<BreadcrumbItem> it = this.items.iterator();
        int x = 0;
        while (it.hasNext()) {
            BreadcrumbItem item = it.next();
            item.setGc(gc).setToolbarHeight(height).setIsLastItemOfTheBreadCrumb(!it.hasNext());
            item.drawButtonAtPosition(x);
            x += item.getWidth();
        }
    }

    private void drawBackground(GC gc, int width, int height) {
        gc.setForeground(START_GRADIENT_COLOR);
        gc.setBackground(END_GRADIENT_COLOR);
        gc.fillGradientRectangle(0, 0, width, height, true);
        if (this.hasBorder) {
            gc.setForeground(BORDER_COLOR);
            gc.drawRectangle(0, 0, width - 1, height - 1);
        }
    }

    void addItem(BreadcrumbItem item) {
        this.items.add(item);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int height = 0;
        for (BreadcrumbItem item : this.items) {
            width += item.getWidth();
            height = Math.max(height, item.getHeight());
        }
        return new Point(Math.max(width, wHint), Math.max(height, hHint));
    }

    public BreadcrumbItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index > this.items.size()) {
            SWT.error((int)5);
        }
        return this.items.get(index);
    }

    public BreadcrumbItem getItem(Point point) {
        this.checkWidget();
        BreadcrumbItem item = this.items.stream().filter(element -> element.getBounds().contains(point)).findFirst().orElse(null);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public BreadcrumbItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new BreadcrumbItem[this.items.size()]);
    }

    public int indexOf(BreadcrumbItem item) {
        this.checkWidget();
        return this.items.indexOf((Object)item);
    }

    public void removeItem(BreadcrumbItem item) {
        this.items.remove((Object)item);
    }
}

