/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PTSpinnerEditor
extends PTEditor {
    private final int max;
    private final int min;

    public PTSpinnerEditor(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public ControlEditor render(PTWidget widget, Item item, PTProperty property) {
        Object editor = widget.getWidget() instanceof Table ? new TableEditor((Table)widget.getWidget()) : new TreeEditor((Tree)widget.getWidget());
        Spinner spinner = new Spinner(widget.getWidget(), 256);
        spinner.setMinimum(this.min);
        spinner.setMaximum(this.max);
        Integer originalValue = (Integer)property.getValue();
        spinner.setSelection(originalValue == null ? this.min : originalValue);
        spinner.addListener(15, event -> widget.updateDescriptionPanel(property));
        spinner.addListener(24, event -> property.setValue(spinner.getSelection()));
        editor.grabHorizontal = true;
        if (widget.getWidget() instanceof Table) {
            editor.setEditor((Control)spinner, (TableItem)item, 1);
        } else {
            ((TreeEditor)editor).setEditor((Control)spinner, (TreeItem)item, 1);
        }
        spinner.setEnabled(property.isEnabled());
        return editor;
    }
}

