/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.nebula.widgets.timeline.ILane;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.ITimelineFactory;
import org.eclipse.nebula.widgets.timeline.ITimelinePackage;
import org.eclipse.nebula.widgets.timeline.ITrack;
import org.eclipse.nebula.widgets.timeline.impl.Colored;

public class Lane
extends Colored
implements ILane {
    protected EList<ITimelineEvent> timeEvents;

    protected Lane() {
    }

    @Override
    protected EClass eStaticClass() {
        return ITimelinePackage.Literals.LANE;
    }

    @Override
    public ITrack getTrack() {
        if (this.eContainerFeatureID() != 2) {
            return null;
        }
        return (ITrack)this.eInternalContainer();
    }

    public NotificationChain basicSetTrack(ITrack newTrack, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newTrack, 2, msgs);
        return msgs;
    }

    @Override
    public void setTrack(ITrack newTrack) {
        if (newTrack != this.eInternalContainer() || this.eContainerFeatureID() != 2 && newTrack != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newTrack)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newTrack != null) {
                msgs = ((InternalEObject)newTrack).eInverseAdd((InternalEObject)this, 1, ITrack.class, msgs);
            }
            if ((msgs = this.basicSetTrack(newTrack, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newTrack, (Object)newTrack));
        }
    }

    @Override
    public EList<ITimelineEvent> getTimeEvents() {
        if (this.timeEvents == null) {
            this.timeEvents = new EObjectContainmentWithInverseEList(ITimelineEvent.class, (InternalEObject)this, 3, 2);
        }
        return this.timeEvents;
    }

    @Override
    public ITimelineEvent createEvent(String title, String message, long startTimestamp, long duration, TimeUnit timeUnit) {
        ITimelineEvent event = ITimelineFactory.eINSTANCE.createTimelineEvent();
        event.setTitle(title);
        event.setMessage(message);
        event.setStartTimestamp(timeUnit.toNanos(startTimestamp));
        event.setDuration(timeUnit.toNanos(duration));
        this.getTimeEvents().add((Object)event);
        return event;
    }

    @Override
    public ITimelineEvent createEvent(String title, String message, long startTimestamp, long duration) {
        return this.createEvent(title, message, startTimestamp, duration, TimeUnit.NANOSECONDS);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetTrack((ITrack)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getTimeEvents()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetTrack(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getTimeEvents()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, ITrack.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getTrack();
            }
            case 3: {
                return this.getTimeEvents();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setTrack((ITrack)newValue);
                return;
            }
            case 3: {
                this.getTimeEvents().clear();
                this.getTimeEvents().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setTrack(null);
                return;
            }
            case 3: {
                this.getTimeEvents().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.getTrack() != null;
            }
            case 3: {
                return this.timeEvents != null && !this.timeEvents.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.createEvent((String)arguments.get(0), (String)arguments.get(1), (Long)arguments.get(2), (Long)arguments.get(3), (TimeUnit)((Object)arguments.get(4)));
            }
            case 1: {
                return this.createEvent((String)arguments.get(0), (String)arguments.get(1), (Long)arguments.get(2), (Long)arguments.get(3));
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

