/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.widgets.timeline.figures.IStyledFigure;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.DetailFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TracksFigure;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;
import org.eclipse.swt.graphics.Font;

public class TimeAxisFigure
extends Figure
implements IStyledFigure {
    public TimeAxisFigure(ITimelineStyleProvider styleProvider) {
        this.setOpaque(false);
        this.updateStyle(styleProvider);
    }

    @Override
    public void updateStyle(ITimelineStyleProvider styleProvider) {
        this.setVisible(styleProvider.showTimeAxis());
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(wHint, 20);
    }

    protected void paintClientArea(Graphics graphics) {
        this.paintMarkers(graphics);
        super.paintClientArea(graphics);
    }

    private DetailFigure getDetailFigure() {
        return (DetailFigure)this.getParent();
    }

    private void paintMarkers(Graphics graphics) {
        Rectangle bounds = this.getBounds();
        graphics.setForegroundColor(ColorConstants.darkGray);
        graphics.setLineStyle(1);
        Insets insets = RootFigure.getFigure((IFigure)this, TracksFigure.class).getInsets();
        ITimelineStyleProvider styleProvider = RootFigure.getRootFigure((IFigure)this).getStyleProvider();
        Map<Double, Integer> markerPositions = this.getDetailFigure().getMarkerPositions();
        for (Map.Entry<Double, Integer> entry : markerPositions.entrySet()) {
            String label = styleProvider.getTimeLabel(entry.getKey(), TimeUnit.NANOSECONDS);
            int textWidth = FigureUtilities.getTextWidth((String)label, (Font)graphics.getFont());
            graphics.drawLine(entry.getValue() + bounds.x() + insets.left, bounds.y, entry.getValue() + bounds.x() + insets.left, bounds.y + 5);
            graphics.drawText(label, entry.getValue() + bounds.x() + insets.left - textWidth / 2, bounds.y + 5);
        }
    }
}

