/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.horizontalspinner.snippets;

import org.eclipse.nebula.widgets.opal.horizontalspinner.HorizontalSpinner;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolTip;

public class HorizontalSpinnerSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(4, true));
        HorizontalSpinnerSnippet.createSpinnerGroup(shell);
        HorizontalSpinnerSnippet.createHorizontalSpinnerGroup(shell, "Default look", 0);
        HorizontalSpinnerSnippet.createHorizontalSpinnerGroup(shell, "Buttons on the left", 16384);
        HorizontalSpinnerSnippet.createHorizontalSpinnerGroup(shell, "Buttons on the right", 131072);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createSpinnerGroup(Shell shell) {
        Group group = new Group((Composite)shell, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        Label lbl1 = new Label((Composite)group, 0);
        lbl1.setText("Simple vertical spinner :");
        Spinner spinner1 = new Spinner((Composite)group, 2048);
        spinner1.setMinimum(0);
        spinner1.setMaximum(1000);
        spinner1.setSelection(500);
        spinner1.setIncrement(1);
        spinner1.setPageIncrement(100);
        Label lbl2 = new Label((Composite)group, 0);
        lbl2.setText("Floating point values in Spinner :");
        final Spinner spinner2 = new Spinner((Composite)group, 0);
        spinner2.setDigits(3);
        spinner2.setMinimum(1);
        spinner2.setMaximum(20000);
        spinner2.setIncrement(10);
        spinner2.setSelection(3456);
        spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = spinner2.getSelection();
                int digits = spinner2.getDigits();
                System.out.println("Selection is " + (double)selection / Math.pow(10.0, digits));
            }
        });
        Label lbl3 = new Label((Composite)group, 0);
        lbl3.setText("Validate input in a spinner widget :");
        Spinner spinner3 = new Spinner((Composite)group, 2048);
        spinner3.setValues(0, -100, 100, 0, 1, 10);
        spinner3.setLayoutData((Object)new GridData(200, -1));
        ToolTip toolTip = new ToolTip(shell, 4104);
        spinner3.addModifyListener(e -> {
            String string = spinner3.getText();
            Object message = null;
            try {
                int value = Integer.parseInt(string);
                int maximum = spinner3.getMaximum();
                int minimum = spinner3.getMinimum();
                if (value > maximum) {
                    message = "Current input is greater than the maximum limit (" + maximum + ")";
                } else if (value < minimum) {
                    message = "Current input is less than the minimum limit (" + minimum + ")";
                }
            }
            catch (Exception ex) {
                message = "Current input is not numeric";
            }
            if (message != null) {
                spinner3.setForeground(shell.getDisplay().getSystemColor(3));
                Rectangle rect = spinner3.getBounds();
                GC gc = new GC((Drawable)spinner3);
                Point pt = gc.textExtent(string);
                gc.dispose();
                toolTip.setLocation(shell.getDisplay().map((Control)shell, null, rect.x + pt.x, rect.y + rect.height));
                toolTip.setMessage((String)message);
                toolTip.setVisible(true);
            } else {
                toolTip.setVisible(false);
                spinner3.setForeground(null);
            }
        });
    }

    private static void createHorizontalSpinnerGroup(Shell shell, String title, int style) {
        Group group = new Group((Composite)shell, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(title);
        Label lbl1 = new Label((Composite)group, 0);
        lbl1.setText("Simple horizontal spinner :");
        HorizontalSpinner spinner1 = new HorizontalSpinner((Composite)group, 0x800 | style);
        spinner1.setMinimum(0);
        spinner1.setMaximum(1000);
        spinner1.setSelection(500);
        spinner1.setIncrement(1);
        spinner1.setPageIncrement(100);
        Label lbl2 = new Label((Composite)group, 0);
        lbl2.setText("Floating point values in Spinner :");
        final HorizontalSpinner spinner2 = new HorizontalSpinner((Composite)group, style);
        spinner2.setDigits(3);
        spinner2.setMinimum(1);
        spinner2.setMaximum(20000);
        spinner2.setIncrement(10);
        spinner2.setSelection(3456);
        spinner2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = spinner2.getSelection();
                int digits = spinner2.getDigits();
                System.out.println("Selection is " + (double)selection / Math.pow(10.0, digits));
            }
        });
        Label lbl3 = new Label((Composite)group, 0);
        lbl3.setText("Validate input in a spinner widget :");
        HorizontalSpinner spinner3 = new HorizontalSpinner((Composite)group, 0x800 | style);
        spinner3.setValues(0, -100, 100, 0, 1, 10);
        spinner3.setLayoutData((Object)new GridData(200, -1));
        ToolTip toolTip = new ToolTip(shell, 4104);
        spinner3.addModifyListener(e -> {
            String string = spinner3.getText();
            Object message = null;
            try {
                int value = Integer.parseInt(string);
                int maximum = spinner3.getMaximum();
                int minimum = spinner3.getMinimum();
                if (value > maximum) {
                    message = "Current input is greater than the maximum limit (" + maximum + ")";
                } else if (value < minimum) {
                    message = "Current input is less than the minimum limit (" + minimum + ")";
                }
            }
            catch (Exception ex) {
                message = "Current input is not numeric";
            }
            if (message != null) {
                spinner3.setForeground(shell.getDisplay().getSystemColor(3));
                Rectangle rect = spinner3.getBounds();
                GC gc = new GC((Drawable)spinner3);
                Point pt = gc.textExtent(string);
                gc.dispose();
                toolTip.setLocation(shell.getDisplay().map((Control)group, null, rect.x + pt.x, rect.y + rect.height));
                toolTip.setMessage((String)message);
                toolTip.setVisible(true);
            } else {
                toolTip.setVisible(false);
                spinner3.setForeground(null);
            }
        });
    }
}

