/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.led;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class LEDSeparator
extends Canvas {
    public LEDSeparator(Composite parent, int style) {
        super(parent, LEDSeparator.checkStyle(style));
        this.setBackground(this.getDisplay().getSystemColor(2));
        this.setForeground(this.getDisplay().getSystemColor(1));
        this.addListener(9, e -> this.onPaint(e));
    }

    private static int checkStyle(int style) {
        int mask = 2048;
        int newStyle = style & 0x800;
        return newStyle |= 0x20000000;
    }

    private void onPaint(Event e) {
        GC gc = e.gc;
        gc.setBackground(this.getBackground());
        gc.fillRectangle(this.getClientArea());
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setForeground(this.getForeground());
        gc.setLineWidth(1);
        gc.drawLine(0, this.getClientArea().height / 2, this.getClientArea().width, this.getClientArea().height / 2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int x = wHint == -1 ? 30 : wHint;
        int y = hHint == -1 ? 100 : hHint;
        return new Point(x, y);
    }
}

