/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pagination.example;

import java.util.Locale;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.pagination.IPageLoader;
import org.eclipse.nebula.widgets.pagination.collections.PageResultContentProvider;
import org.eclipse.nebula.widgets.pagination.example.model.NebulaWidget;
import org.eclipse.nebula.widgets.pagination.example.model.Person;
import org.eclipse.nebula.widgets.pagination.example.services.NebulaWidgetServices;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.ResultAndNavigationPageGraphicsRenderer;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.ResultAndNavigationPageGraphicsRendererFactory;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.BlackNavigationPageGraphicsConfigurator;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.BlueNavigationPageGraphicsConfigurator;
import org.eclipse.nebula.widgets.pagination.renderers.navigation.graphics.GreenNavigationPageGraphicsConfigurator;
import org.eclipse.nebula.widgets.pagination.table.PageableTable;
import org.eclipse.nebula.widgets.pagination.table.SortTableColumnSelectionListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PaginationExampleTab
extends AbstractExampleTab {
    private PageableTable pageableTable;

    public Control createControl(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        int pageSize = 10;
        this.pageableTable = new PageableTable(body, 2048, 2818, pageSize, PageResultContentProvider.getInstance(), ResultAndNavigationPageGraphicsRendererFactory.getBlueFactory(), null);
        this.pageableTable.setLayoutData((Object)new GridData(1808));
        TableViewer viewer = this.pageableTable.getViewer();
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        PaginationExampleTab.createColumns(viewer);
        this.pageableTable.setPageLoader((IPageLoader)NebulaWidgetServices.getInstance());
        this.pageableTable.setCurrentPage(0);
        return body;
    }

    private static void createColumns(TableViewer viewer) {
        TableViewerColumn col = PaginationExampleTab.createTableViewerColumn(viewer, "Widget", 150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NebulaWidget w = (NebulaWidget)element;
                return w.getName();
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)new SortTableColumnSelectionListener("name"));
        col = PaginationExampleTab.createTableViewerColumn(viewer, "Commiter", 150);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NebulaWidget w = (NebulaWidget)element;
                Person p = w.getCommitter();
                return p.getFirstName() + " " + p.getLastName();
            }
        });
        col.getColumn().addSelectionListener((SelectionListener)new SortTableColumnSelectionListener("committer.firstName"));
    }

    private static TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void createParameters(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        this.getSettings(parent);
    }

    private void getSettings(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Style:");
        Combo styleCombo = new Combo(parent, 8);
        styleCombo.setItems(new String[]{"Blue", "Green", "Black"});
        styleCombo.select(0);
        styleCombo.addListener(13, e -> {
            if (styleCombo.getText().equals("Blue")) {
                ((ResultAndNavigationPageGraphicsRenderer)this.pageableTable.getCompositeTop()).getNavigationPage().setConfigurator(BlueNavigationPageGraphicsConfigurator.getInstance());
            } else if (styleCombo.getText().equals("Green")) {
                ((ResultAndNavigationPageGraphicsRenderer)this.pageableTable.getCompositeTop()).setConfigurator(GreenNavigationPageGraphicsConfigurator.getInstance());
            } else {
                ((ResultAndNavigationPageGraphicsRenderer)this.pageableTable.getCompositeTop()).setConfigurator(BlackNavigationPageGraphicsConfigurator.getInstance());
            }
        });
        styleCombo.setLayoutData((Object)new GridData(1808));
        Label localeLabel = new Label(parent, 0);
        localeLabel.setText("Locale:");
        localeLabel.setLayoutData((Object)new GridData());
        Combo localeCombo = new Combo(parent, 8);
        localeCombo.setItems(new String[]{"en", "fr"});
        localeCombo.select(Locale.getDefault().equals(Locale.FRANCE) ? 1 : 0);
        localeCombo.setLayoutData((Object)new GridData(768));
        localeCombo.addListener(13, e -> {
            String locale = localeCombo.getText();
            if ("fr".equals(locale)) {
                this.pageableTable.setLocale(Locale.FRENCH);
            } else {
                this.pageableTable.setLocale(Locale.ENGLISH);
            }
        });
    }

    public String[] createLinks() {
        String[] links = new String[]{"<a href=\"http://angelozerr.wordpress.com/2012/01/06/nebula_pagination/\" >Pagination Control Article</a>"};
        return links;
    }
}

