/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.jface;

import java.util.Stack;
import org.eclipse.nebula.widgets.geomap.jface.SearchServer;
import org.xml.sax.Attributes;

public class OsmSearchServer
extends SearchServer {
    public OsmSearchServer() {
        super("http://nominatim.openstreetmap.org/search?format=xml&", "q={0}");
    }

    @Override
    protected Object startElement(String qName, Stack<String> path, Attributes attributes, Stack<Object> objects) {
        if ("place".equals(qName)) {
            SearchResult result = new SearchResult();
            result.setLon(attributes.getValue("lon"));
            result.setLat(attributes.getValue("lat"));
            if (result.getLonLat() == null) {
                return null;
            }
            String displayName = attributes.getValue("display_name");
            result.setText(displayName);
            int pos = displayName.indexOf(",");
            result.setName(pos > 0 ? displayName.substring(0, pos) : displayName);
            result.category = attributes.getValue("class");
            result.type = attributes.getValue("type");
            return result;
        }
        return null;
    }

    public static final class SearchResult
    extends SearchServer.Result {
        private String type;
        private String category;

        public String getType() {
            return this.type;
        }

        public String getCategory() {
            return this.category;
        }

        @Override
        public String toString() {
            return "SearchResult [text=" + this.getText() + ", location=" + String.valueOf(this.getLonLat()) + ", type=" + this.type + ", category=" + this.category + "]";
        }
    }
}

