/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerComputedColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerSorter;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.XViewerTextFilter;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnDateFilter;
import org.eclipse.nebula.widgets.xviewer.core.model.ColumnFilterData;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.DateRangeType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.core.util.Strings;
import org.eclipse.nebula.widgets.xviewer.util.Pair;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.swt.widgets.TreeColumn;

public class CustomizeManager {
    private final IXViewerFactory xViewerFactory;
    private final XViewer xViewer;
    private XViewerTextFilter xViewerTextFilter;
    private CustomizeData currentCustData;
    public static final String CURRENT_LABEL = XViewerText.get("label.current");
    public static final String TABLE_DEFAULT_LABEL = XViewerText.get("label.default");
    public boolean loading = true;
    private final Map<String, XViewerColumn> oldNameToColumnId = new HashMap<String, XViewerColumn>();

    public CustomizeManager(XViewer xViewer, IXViewerFactory xViewerFactory) throws XViewerException {
        this.xViewer = xViewer;
        this.xViewerFactory = xViewerFactory;
        CustomizeData userCustData = xViewerFactory.getXViewerCustomizations().getUserDefaultCustData();
        if (userCustData != null) {
            this.currentCustData = this.resolveLoadedCustomizeData(userCustData);
        } else {
            this.currentCustData = this.getTableDefaultCustData();
            this.currentCustData.setNameSpace(xViewerFactory.getNamespace());
        }
        xViewerFactory.getXViewerCustomMenu().init(xViewer);
    }

    public CustomizeData resolveLoadedCustomizeData(CustomizeData loadedCustData) {
        CustomizeData resolvedCustData = new CustomizeData();
        resolvedCustData.setName(loadedCustData.getName());
        resolvedCustData.setPersonal(loadedCustData.isPersonal());
        resolvedCustData.setGuid(loadedCustData.getGuid());
        resolvedCustData.setNameSpace(loadedCustData.getNameSpace());
        ArrayList<XViewerColumn> resolvedColumns = new ArrayList<XViewerColumn>();
        for (XViewerColumn storedCol : loadedCustData.getColumnData().getColumns()) {
            XViewerColumn resolvedCol = this.xViewer.getXViewerFactory().getDefaultXViewerColumn(storedCol.getId());
            if (resolvedCol == null) {
                resolvedCol = this.getKnownStoredValue(storedCol, resolvedCol);
            }
            if (resolvedCol == null) {
                resolvedCol = this.resolveByName(storedCol);
            }
            if (resolvedCol == null) {
                resolvedCol = this.resolveComputedColumns(storedCol, resolvedCol);
            }
            if (resolvedCol == null || resolvedCol.getWidth() <= 0) continue;
            if (storedCol.getWidth() > 0) {
                resolvedCol.setWidth(storedCol.getWidth());
            }
            resolvedCol.setName(storedCol.getName());
            resolvedCol.setShow(storedCol.isShow());
            resolvedCol.setSortForward(storedCol.isSortForward());
            resolvedColumns.add(resolvedCol);
        }
        this.addNewlyCreatedColumns(resolvedColumns);
        this.resolveComputedColumnsAgain(resolvedColumns);
        resolvedCustData.getColumnData().setColumns(resolvedColumns);
        resolvedCustData.getColumnFilterData().setFromXml(loadedCustData.getColumnFilterData().getXml());
        resolvedCustData.getFilterData().setFromXml(loadedCustData.getFilterData().getXml());
        resolvedCustData.getSortingData().setFromXml(loadedCustData.getSortingData().getXml());
        return resolvedCustData;
    }

    private void resolveComputedColumnsAgain(List<XViewerColumn> resolvedColumns) {
        for (XViewerColumn resolveCol : resolvedColumns) {
            if (!(resolveCol instanceof XViewerComputedColumn)) continue;
            ((XViewerComputedColumn)resolveCol).setSourceXViewerColumnFromColumns(resolvedColumns);
        }
    }

    private void addNewlyCreatedColumns(List<XViewerColumn> resolvedColumns) {
        for (XViewerColumn extraCol : this.xViewer.getXViewerFactory().getDefaultTableCustomizeData().getColumnData().getColumns()) {
            if (resolvedColumns.contains(extraCol)) continue;
            extraCol.setShow(false);
            resolvedColumns.add(extraCol);
        }
    }

    private XViewerColumn resolveComputedColumns(XViewerColumn storedCol, XViewerColumn resolvedCol) {
        for (XViewerComputedColumn xViewerComputedCol : this.xViewer.getComputedColumns()) {
            if (!xViewerComputedCol.isApplicableFor(storedCol.getId())) continue;
            resolvedCol = xViewerComputedCol.createFromStored(storedCol);
        }
        return resolvedCol;
    }

    private XViewerColumn resolveByName(XViewerColumn storedCol) {
        String name = storedCol.getName().replaceAll(" ", "");
        XViewerColumn resolvedCol = this.oldNameToColumnId.get(name);
        if (resolvedCol == null) {
            for (XViewerColumn xCol : this.xViewer.getXViewerFactory().getDefaultTableCustomizeData().getColumnData().getColumns()) {
                String oldName;
                String colId = xCol.getId().toLowerCase();
                if (!colId.endsWith(oldName = "." + name.toLowerCase())) continue;
                resolvedCol = xCol;
                this.oldNameToColumnId.put(name, resolvedCol);
                this.oldNameToColumnId.put(storedCol.getName(), resolvedCol);
                break;
            }
        }
        if (resolvedCol == null) {
            for (XViewerColumn xCol : this.xViewer.getXViewerFactory().getDefaultTableCustomizeData().getColumnData().getColumns()) {
                if (!xCol.getId().endsWith(name)) continue;
                resolvedCol = xCol;
                this.oldNameToColumnId.put(name, resolvedCol);
                this.oldNameToColumnId.put(storedCol.getName(), resolvedCol);
                break;
            }
        }
        return resolvedCol;
    }

    private XViewerColumn getKnownStoredValue(XViewerColumn storedCol, XViewerColumn resolvedCol) {
        String name = storedCol.getName();
        if (name.equals("Impacted Items")) {
            resolvedCol = this.xViewer.getXViewerFactory().getDefaultXViewerColumn("ats.column.actionableItems");
        } else if (name.equals("State Percent")) {
            resolvedCol = this.xViewer.getXViewerFactory().getDefaultXViewerColumn("ats.column.statePercentComplete");
        }
        return resolvedCol;
    }

    public void setFilterText(String text, boolean regex) {
        this.currentCustData.getFilterData().setFilterText(text, regex);
        try {
            this.xViewer.getTree().setRedraw(false);
            this.xViewerTextFilter.update();
            this.xViewer.refresh();
        }
        finally {
            this.xViewer.getTree().setRedraw(true);
        }
    }

    public String getFilterText() {
        return this.currentCustData.getFilterData().getFilterText();
    }

    public void setColumnFilterText(String colId, String text) {
        if (text == null || text.equals("")) {
            this.currentCustData.getColumnFilterData().removeFilterText(colId);
        } else {
            this.currentCustData.getColumnFilterData().setFilterText(colId, text);
        }
        this.xViewerTextFilter.update();
        this.xViewer.refresh();
    }

    public void clearFilters() {
        this.xViewer.getFilterDataUI().clear();
        this.currentCustData.getColumnFilterData().clear();
        this.xViewerTextFilter.update();
        this.xViewer.refresh();
    }

    public void clearAllColumnFilters() {
        this.currentCustData.getColumnFilterData().clear();
        this.xViewerTextFilter.update();
        this.xViewer.refresh();
    }

    public String getColumnFilterText(String colId) {
        return this.currentCustData.getColumnFilterData().getFilterText(colId);
    }

    public ColumnFilterData getColumnFilterData() {
        return this.currentCustData.getColumnFilterData();
    }

    public void loadCustomization() {
        this.loadCustomization(this.currentCustData);
    }

    public void resetDefaultSorter() {
        XViewerSorter sorter = this.xViewer.getXViewerFactory().createNewXSorter(this.xViewer);
        this.xViewer.setSorter(sorter);
    }

    public void clearSorter() {
        this.currentCustData.getSortingData().clearSorter();
        this.xViewer.setSorter(null);
        this.xViewer.updateStatusLabel();
    }

    public void handleTableCustomization() {
        Dialog dialog = this.xViewerFactory.getCustomizeDialog(this.xViewer);
        if (dialog != null) {
            dialog.open();
        }
    }

    public void appendToStatusLabel(StringBuilder sb) {
        if (this.currentCustData != null && this.currentCustData.getName() != null) {
            sb.append(XViewerText.get("label.custom", this.currentCustData.getName()));
        }
    }

    public CustomizeData generateCustDataFromTable() {
        CustomizeData custData = new CustomizeData();
        custData.setName(CURRENT_LABEL);
        custData.setNameSpace(this.xViewer.getXViewerFactory().getNamespace());
        ArrayList<XViewerColumn> columns = new ArrayList<XViewerColumn>(15);
        int[] nArray = this.xViewer.getTree().getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer index = nArray[n2];
            TreeColumn treeCol = this.xViewer.getTree().getColumn(index.intValue());
            XViewerColumn xCol = (XViewerColumn)treeCol.getData();
            XViewerColumn newXCol = xCol.copy();
            newXCol.setWidth(treeCol.getWidth());
            newXCol.setShow(treeCol.getWidth() > 0);
            columns.add(newXCol);
            ++n2;
        }
        for (XViewerColumn xCol : this.xViewer.getCustomizeMgr().getCurrentTableColumns()) {
            if (columns.contains(xCol)) continue;
            XViewerColumn newXCol = xCol.copy();
            newXCol.setShow(false);
            columns.add(newXCol);
        }
        custData.getColumnData().setColumns(columns);
        custData.getSortingData().setFromXml(this.currentCustData.getSortingData().getXml());
        custData.getFilterData().setFromXml(this.currentCustData.getFilterData().getXml());
        custData.getColumnFilterData().setFromXml(this.currentCustData.getColumnFilterData().getXml());
        return custData;
    }

    public List<XViewerColumn> getCurrentTableColumns() {
        return this.currentCustData.getColumnData().getColumns();
    }

    public XViewerColumn getCurrentTableColumn(String id) {
        return this.currentCustData.getColumnData().getXColumn(id);
    }

    public List<XViewerColumn> getCurrentTableColumnsInOrder() {
        ArrayList<XViewerColumn> columns = new ArrayList<XViewerColumn>(15);
        int[] nArray = this.xViewer.getTree().getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer index = nArray[n2];
            TreeColumn treeCol = this.xViewer.getTree().getColumn(index.intValue());
            XViewerColumn xCol = (XViewerColumn)treeCol.getData();
            columns.add(xCol);
            ++n2;
        }
        return columns;
    }

    public List<XViewerColumn> getCurrentVisibleTableColumns() {
        ArrayList<XViewerColumn> columns = new ArrayList<XViewerColumn>(15);
        for (XViewerColumn xCol : this.getCurrentTableColumns()) {
            if (!xCol.isShow()) continue;
            columns.add(xCol);
        }
        return columns;
    }

    public List<XViewerColumn> getCurrentHiddenTableColumns() {
        ArrayList<XViewerColumn> columns = new ArrayList<XViewerColumn>(15);
        for (XViewerColumn xCol : this.getCurrentTableColumns()) {
            if (xCol.isShow()) continue;
            columns.add(xCol);
        }
        return columns;
    }

    public Map<XViewerColumn, Integer> getCurrentTableColumnsIndex() {
        int[] index = this.xViewer.getTree().getColumnOrder();
        HashMap<XViewerColumn, Integer> xColToColumnIndex = new HashMap<XViewerColumn, Integer>(index.length);
        int x = 0;
        while (x < index.length) {
            TreeColumn treeCol = this.xViewer.getTree().getColumn(index[x]);
            XViewerColumn xCol = (XViewerColumn)treeCol.getData();
            xColToColumnIndex.put(xCol, index[x]);
            ++x;
        }
        return xColToColumnIndex;
    }

    public int getColumnNumFromXViewerColumn(XViewerColumn xCol) {
        int[] nArray = this.xViewer.getTree().getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer index = nArray[n2];
            TreeColumn treeCol = this.xViewer.getTree().getColumn(index.intValue());
            XViewerColumn treeXCol = (XViewerColumn)treeCol.getData();
            if (xCol.equals((Object)treeXCol)) {
                return index;
            }
            ++n2;
        }
        return 0;
    }

    public Pair<XViewerColumn, Integer> getColumnNumFromXViewerColumn(String columnId) {
        if (!this.xViewer.getTree().isDisposed()) {
            int[] nArray = this.xViewer.getTree().getColumnOrder();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer index = nArray[n2];
                TreeColumn treeCol = this.xViewer.getTree().getColumn(index.intValue());
                XViewerColumn treeXCol = (XViewerColumn)treeCol.getData();
                if (treeXCol.getId().equals(columnId)) {
                    return new Pair<XViewerColumn, Integer>(treeXCol, index);
                }
                ++n2;
            }
        }
        return null;
    }

    public CustomizeData getTableDefaultCustData() {
        CustomizeData custData = this.xViewer.getXViewerFactory().getDefaultTableCustomizeData();
        if (custData.getName() == null || custData.getName().equals("")) {
            custData.setName(TABLE_DEFAULT_LABEL);
        }
        custData.setNameSpace(this.xViewer.getViewerNamespace());
        return custData;
    }

    public void getSortingStr(StringBuilder sb) {
        if (this.currentCustData.getSortingData().isSorting()) {
            List<XViewerColumn> cols = this.getSortXCols();
            if (cols.isEmpty()) {
                return;
            }
            sb.append(XViewerText.get("label.status.sort"));
            for (XViewerColumn col : this.getSortXCols()) {
                if (col == null) continue;
                sb.append(XViewerText.get("label.status.sort.start"));
                sb.append(col.getName());
                sb.append(col.isSortForward() ? XViewerText.get("label.status.sort.fwd") : XViewerText.get("label.status.sort.rev"));
            }
        }
    }

    public int getDefaultWidth(String id) {
        XViewerColumn xCol = this.xViewerFactory.getDefaultXViewerColumn(id);
        if (xCol == null) {
            return 75;
        }
        return xCol.getWidth();
    }

    public boolean isCustomizationUserDefault(CustomizeData custData) throws XViewerException {
        return this.xViewerFactory.getXViewerCustomizations().isCustomizationUserDefault(custData);
    }

    public List<XViewerColumn> getSortXCols() {
        return this.currentCustData.getSortingData().getSortXCols(this.oldNameToColumnId);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public List<CustomizeData> getSavedCustDatas() throws Exception {
        ArrayList<CustomizeData> custDatas = new ArrayList<CustomizeData>();
        for (CustomizeData savedCustData : this.xViewerFactory.getXViewerCustomizations().getSavedCustDatas()) {
            custDatas.add(this.resolveLoadedCustomizeData(savedCustData));
        }
        return custDatas;
    }

    public void saveCustomization(CustomizeData custData) throws Exception {
        this.xViewerFactory.getXViewerCustomizations().saveCustomization(custData);
    }

    public void customizeColumnName(XViewerColumn xCol, String newName) {
        if (newName.equals("")) {
            XViewerColumn defaultXCol = this.xViewerFactory.getDefaultXViewerColumn(xCol.getId());
            if (defaultXCol == null) {
                XViewerLib.popup(XViewerText.get("error"), XViewerText.get("error.column_undefined"));
                return;
            }
            xCol.setName(defaultXCol.getName());
        } else {
            xCol.setName(newName);
        }
    }

    public void setUserDefaultCustData(CustomizeData newCustData, boolean set) throws Exception {
        this.xViewerFactory.getXViewerCustomizations().setUserDefaultCustData(newCustData, set);
    }

    public void deleteCustomization(CustomizeData custData) throws Exception {
        this.xViewerFactory.getXViewerCustomizations().deleteCustomization(custData);
    }

    public boolean isSorting() {
        return this.currentCustData.getSortingData().isSorting();
    }

    public void loadCustomization(CustomizeData newCustData) {
        this.loading = true;
        if (this.xViewerTextFilter == null) {
            this.xViewerTextFilter = this.xViewer.getXViewerTextFilter();
            this.xViewer.addFilter(this.xViewerTextFilter);
        }
        if (this.xViewer.getTree().isDisposed()) {
            return;
        }
        this.currentCustData = newCustData;
        if (this.currentCustData.getName() == null || this.currentCustData.getName().equals("")) {
            this.currentCustData.setName(CURRENT_LABEL);
        }
        this.currentCustData.setNameSpace(this.xViewer.getViewerNamespace());
        if (this.currentCustData.getSortingData().isSorting()) {
            this.xViewer.resetDefaultSorter();
        } else {
            this.xViewer.setSorter(null);
        }
        if (this.xViewer.getFilterDataUI() != null) {
            this.xViewer.getFilterDataUI().update();
        }
        this.xViewerTextFilter.update();
        TreeColumn[] treeColumnArray = this.xViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeCol = treeColumnArray[n2];
            treeCol.dispose();
            ++n2;
        }
        this.addColumns();
        this.xViewer.updateStatusLabel();
        if (this.xViewer.getLabelProvider() instanceof IXViewerLabelProvider) {
            ((IXViewerLabelProvider)this.xViewer.getLabelProvider()).clearXViewerColumnIndexCache();
        }
        this.loading = false;
    }

    public void addColumns() {
        for (XViewerColumn xCol : this.currentCustData.getColumnData().getColumns()) {
            if (!xCol.isShow()) continue;
            xCol.setXViewer((Object)this.xViewer);
            TreeColumn column = new TreeColumn(this.xViewer.getTree(), CustomizeManager.getSwtAlign(xCol.getAlign()));
            column.setMoveable(true);
            column.setData((Object)xCol);
            StringBuilder sb = new StringBuilder();
            sb.append(xCol.getName());
            if (Strings.isValid((String)xCol.getDescription()) && !xCol.getDescription().equals(xCol.getName())) {
                sb.append("\n");
                sb.append(xCol.getDescription());
            }
            if (Strings.isValid((String)xCol.getToolTip()) && !xCol.getToolTip().equals(xCol.getName()) && !xCol.getToolTip().equals(xCol.getDescription())) {
                sb.append("\n");
                sb.append(xCol.getToolTip());
            }
            if (xCol.getId() != null && !"".equals(xCol.getId()) && !xCol.getName().equals(xCol.getId())) {
                sb.append("\n");
                sb.append(xCol.getId());
            }
            column.setToolTipText(sb.toString());
            column.setText(xCol.getName());
            column.setWidth(xCol.getWidth());
            column.addListener(13, e -> {
                if (this.xViewer.getSorter() == null) {
                    this.resetDefaultSorter();
                }
                if (this.xViewer.isAltKeyDown()) {
                    this.xViewer.getColumnFilterDataUI().promptSetFilter(xCol);
                } else if (this.xViewer.isCtrlKeyDown()) {
                    ArrayList<XViewerColumn> currSortCols = this.currentCustData.getSortingData().getSortXCols(this.oldNameToColumnId);
                    if (currSortCols == null) {
                        currSortCols = new ArrayList<XViewerColumn>();
                        currSortCols.add(xCol);
                    } else if (currSortCols.contains(xCol)) {
                        for (XViewerColumn currXCol : currSortCols) {
                            if (!currXCol.equals((Object)xCol)) continue;
                            currXCol.reverseSort();
                        }
                    } else {
                        currSortCols.add(xCol);
                    }
                    this.currentCustData.getSortingData().setSortXCols(currSortCols);
                } else {
                    ArrayList<XViewerColumn> cols = new ArrayList<XViewerColumn>();
                    cols.add(xCol);
                    List currSortCols = this.currentCustData.getSortingData().getSortXCols(this.oldNameToColumnId);
                    if (currSortCols != null && currSortCols.size() == 1 && ((XViewerColumn)currSortCols.iterator().next()).equals((Object)xCol)) {
                        xCol.reverseSort();
                    }
                    this.currentCustData.getSortingData().setSortXCols(cols);
                }
                this.xViewer.refresh();
            });
        }
    }

    public static int getSwtAlign(XViewerAlign align) {
        if (align == XViewerAlign.Center) {
            return 0x1000000;
        }
        if (align == XViewerAlign.Right) {
            return 131072;
        }
        return 16384;
    }

    public boolean isFilterTextRegularExpression() {
        return this.currentCustData.getFilterData().isRegularExpression();
    }

    public void setColumnDateFilter(String columnId, DateRangeType dateRangeType, Date date1, Date date2) {
        if (dateRangeType == null || dateRangeType == DateRangeType.None) {
            this.currentCustData.getColumnFilterData().removeDateFilter(columnId);
        } else {
            this.currentCustData.getColumnFilterData().setDateFilter(columnId, dateRangeType, date1, date2);
        }
        this.xViewerTextFilter.update();
        this.xViewer.refresh();
    }

    public ColumnDateFilter getColumnDateFilter(String columnId) {
        return this.currentCustData.getColumnFilterData().getDateFilter(columnId);
    }

    public CustomizeData getCurrentCustomizeData() {
        return this.currentCustData;
    }
}

