/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.accessibility.gtk.GtkAccessible;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class AccessibleObject {
    int handle;
    int parentType;
    int index = -1;
    int id = -1;
    Accessible accessible;
    AccessibleObject parent;
    Hashtable children = new Hashtable(9);
    boolean isLightweight = false;
    static int actionNamePtr = -1;
    static int descriptionPtr = -1;
    static int keybindingPtr = -1;
    static int namePtr = -1;
    static final Hashtable AccessibleObjects = new Hashtable(9);
    static final int ATK_ACTION_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkAction", true));
    static final int ATK_COMPONENT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkComponent", true));
    static final int ATK_HYPERTEXT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkHypertext", true));
    static final int ATK_SELECTION_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkSelection", true));
    static final int ATK_TEXT_TYPE = ATK.g_type_from_name(Converter.wcsToMbcs(null, "AtkText", true));
    static final boolean DEBUG = Display.DEBUG;

    AccessibleObject(int n, int n2, Accessible accessible, int n3, boolean bl) {
        this.handle = ATK.g_object_new(n, 0);
        this.parentType = n3;
        ATK.atk_object_initialize(this.handle, n2);
        this.accessible = accessible;
        this.isLightweight = bl;
        AccessibleObjects.put(new LONG(this.handle), this);
        if (DEBUG) {
            System.out.println("new AccessibleObject: " + this.handle);
        }
    }

    void addChild(AccessibleObject accessibleObject) {
        this.children.put(new LONG(accessibleObject.handle), accessibleObject);
        accessibleObject.setParent(this);
    }

    static int atkAction_get_keybinding(int n, int n2) {
        int n3;
        AccessibleListener[] accessibleListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkAction_get_keybinding");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n4 = 0;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_ACTION_TYPE)) {
            int n5 = ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(accessibleObject.handle));
            object = new AtkActionIface();
            ATK.memmove((AtkActionIface)object, n5);
            if (((AtkActionIface)object).get_keybinding != 0) {
                n4 = ATK.call(((AtkActionIface)object).get_keybinding, accessibleObject.handle, n2);
            }
        }
        if ((accessibleListenerArray = accessibleObject.getAccessibleListeners()).length == 0) {
            return n4;
        }
        object = new AccessibleEvent(accessibleObject.accessible);
        ((AccessibleEvent)object).childID = accessibleObject.id;
        if (n4 != 0) {
            n3 = OS.strlen(n4);
            byte[] byArray = new byte[n3];
            OS.memmove(byArray, n4, n3);
            ((AccessibleEvent)object).result = new String(Converter.mbcsToWcs(null, byArray));
        }
        n3 = 0;
        while (n3 < accessibleListenerArray.length) {
            accessibleListenerArray[n3].getKeyboardShortcut((AccessibleEvent)object);
            ++n3;
        }
        if (((AccessibleEvent)object).result == null) {
            return n4;
        }
        if (keybindingPtr != -1) {
            OS.g_free(keybindingPtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, ((AccessibleEvent)object).result, true);
        keybindingPtr = OS.g_malloc(byArray.length);
        OS.memmove(keybindingPtr, byArray, byArray.length);
        return keybindingPtr;
    }

    static int atkAction_get_name(int n, int n2) {
        int n3;
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkAction_get_name");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n4 = 0;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_ACTION_TYPE)) {
            int n5 = ATK.g_type_interface_peek_parent(ATK.ATK_ACTION_GET_IFACE(accessibleObject.handle));
            object = new AtkActionIface();
            ATK.memmove((AtkActionIface)object, n5);
            if (((AtkActionIface)object).get_name != 0) {
                n4 = ATK.call(((AtkActionIface)object).get_name, accessibleObject.handle, n2);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return n4;
        }
        object = new AccessibleControlEvent(accessibleObject.accessible);
        ((AccessibleControlEvent)object).childID = accessibleObject.id;
        if (n4 != 0) {
            n3 = OS.strlen(n4);
            byte[] byArray = new byte[n3];
            OS.memmove(byArray, n4, n3);
            ((AccessibleControlEvent)object).result = new String(Converter.mbcsToWcs(null, byArray));
        }
        n3 = 0;
        while (n3 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n3].getDefaultAction((AccessibleControlEvent)object);
            ++n3;
        }
        if (((AccessibleControlEvent)object).result == null) {
            return n4;
        }
        if (actionNamePtr != -1) {
            OS.g_free(actionNamePtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, ((AccessibleControlEvent)object).result, true);
        actionNamePtr = OS.g_malloc(byArray.length);
        OS.memmove(actionNamePtr, byArray, byArray.length);
        return actionNamePtr;
    }

    static int atkComponent_get_extents(int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray;
        int[] nArray2;
        int n7;
        int n8;
        GtkAccessible gtkAccessible;
        int n9;
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_extents");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        OS.memmove(n2, new int[1], 4);
        OS.memmove(n3, new int[1], 4);
        OS.memmove(n4, new int[1], 4);
        OS.memmove(n5, new int[1], 4);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_COMPONENT_TYPE)) {
            int n10 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject.handle));
            object = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)object, n10);
            if (((AtkComponentIface)object).get_extents != 0) {
                ATK.call(((AtkComponentIface)object).get_extents, accessibleObject.handle, n2, n3, n4, n5, n6);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return 0;
        }
        object = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        OS.memmove((int[])object, n2, 4);
        OS.memmove(nArray3, n3, 4);
        OS.memmove(nArray4, n4, 4);
        OS.memmove(nArray5, n5, 4);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject.accessible);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.x = (int)object[0];
        accessibleControlEvent.y = nArray3[0];
        accessibleControlEvent.width = nArray4[0];
        accessibleControlEvent.height = nArray5[0];
        if (n6 == 1) {
            n9 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, n9);
            n8 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            n7 = OS.GTK_WIDGET_WINDOW(n8);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n7, nArray2, nArray);
            accessibleControlEvent.x += nArray2[0];
            accessibleControlEvent.y += nArray[0];
        }
        n9 = 0;
        while (n9 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n9].getLocation(accessibleControlEvent);
            ++n9;
        }
        if (n6 == 1) {
            n9 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, n9);
            n8 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            n7 = OS.GTK_WIDGET_WINDOW(n8);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n7, nArray2, nArray);
            accessibleControlEvent.x -= nArray2[0];
            accessibleControlEvent.y -= nArray[0];
        }
        OS.memmove(n2, new int[]{accessibleControlEvent.x}, 4);
        OS.memmove(n3, new int[]{accessibleControlEvent.y}, 4);
        OS.memmove(n4, new int[]{accessibleControlEvent.width}, 4);
        OS.memmove(n5, new int[]{accessibleControlEvent.height}, 4);
        return 0;
    }

    static int atkComponent_get_position(int n, int n2, int n3, int n4) {
        int[] nArray;
        int[] nArray2;
        int n5;
        int n6;
        GtkAccessible gtkAccessible;
        int n7;
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_position, object: " + n + " x: " + n2 + " y: " + n3 + " coord: " + n4);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        OS.memmove(n2, new int[1], 4);
        OS.memmove(n3, new int[1], 4);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_COMPONENT_TYPE)) {
            int n8 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject.handle));
            object = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)object, n8);
            if (((AtkComponentIface)object).get_extents != 0) {
                ATK.call(((AtkComponentIface)object).get_position, accessibleObject.handle, n2, n3, n4);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return 0;
        }
        object = new int[1];
        int[] nArray3 = new int[1];
        OS.memmove((int[])object, n2, 4);
        OS.memmove(nArray3, n3, 4);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject.accessible);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.x = (int)object[0];
        accessibleControlEvent.y = nArray3[0];
        if (n4 == 1) {
            n7 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, n7);
            n6 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            n5 = OS.GTK_WIDGET_WINDOW(n6);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n5, nArray2, nArray);
            accessibleControlEvent.x += nArray2[0];
            accessibleControlEvent.y += nArray[0];
        }
        n7 = 0;
        while (n7 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n7].getLocation(accessibleControlEvent);
            ++n7;
        }
        if (n4 == 1) {
            n7 = ATK.GTK_ACCESSIBLE(accessibleObject.handle);
            gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, n7);
            n6 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            n5 = OS.GTK_WIDGET_WINDOW(n6);
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gdk_window_get_origin(n5, nArray2, nArray);
            accessibleControlEvent.x -= nArray2[0];
            accessibleControlEvent.y -= nArray[0];
        }
        OS.memmove(n2, new int[]{accessibleControlEvent.x}, 4);
        OS.memmove(n3, new int[]{accessibleControlEvent.y}, 4);
        return 0;
    }

    static int atkComponent_get_size(int n, int n2, int n3, int n4) {
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkComponent_get_size");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        OS.memmove(n2, new int[1], 4);
        OS.memmove(n3, new int[1], 4);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_COMPONENT_TYPE)) {
            int n5 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject.handle));
            object = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)object, n5);
            if (((AtkComponentIface)object).get_extents != 0) {
                ATK.call(((AtkComponentIface)object).get_size, accessibleObject.handle, n2, n3, n4);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return 0;
        }
        object = new int[1];
        int[] nArray = new int[1];
        OS.memmove((int[])object, n2, 4);
        OS.memmove(nArray, n3, 4);
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject.accessible);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.width = (int)object[0];
        accessibleControlEvent.height = nArray[0];
        int n6 = 0;
        while (n6 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n6].getLocation(accessibleControlEvent);
            ++n6;
        }
        OS.memmove(n2, new int[]{accessibleControlEvent.width}, 4);
        OS.memmove(n3, new int[]{accessibleControlEvent.height}, 4);
        return 0;
    }

    static int atkComponent_ref_accessible_at_point(int n, int n2, int n3, int n4) {
        AccessibleObject accessibleObject;
        int n5;
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject2;
        if (DEBUG) {
            System.out.println("-->atkComponent_ref_accessible_at_point");
        }
        if ((accessibleObject2 = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n6 = 0;
        if (ATK.g_type_is_a(accessibleObject2.parentType, ATK_COMPONENT_TYPE)) {
            int n7 = ATK.g_type_interface_peek_parent(ATK.ATK_COMPONENT_GET_IFACE(accessibleObject2.handle));
            object = new AtkComponentIface();
            ATK.memmove((AtkComponentIface)object, n7);
            if (((AtkComponentIface)object).ref_accessible_at_point != 0) {
                n6 = ATK.call(((AtkComponentIface)object).ref_accessible_at_point, accessibleObject2.handle, n2, n3, n4);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject2.getControlListeners()).length == 0) {
            return n6;
        }
        object = new AccessibleControlEvent(accessibleObject2.accessible);
        ((AccessibleControlEvent)object).childID = accessibleObject2.id;
        ((AccessibleControlEvent)object).x = n2;
        ((AccessibleControlEvent)object).y = n3;
        if (n4 == 1) {
            n5 = ATK.GTK_ACCESSIBLE(accessibleObject2.handle);
            GtkAccessible gtkAccessible = new GtkAccessible();
            ATK.memmove(gtkAccessible, n5);
            int n8 = ATK.gtk_widget_get_toplevel(gtkAccessible.widget);
            int n9 = OS.GTK_WIDGET_WINDOW(n8);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_window_get_origin(n9, nArray, nArray2);
            ((AccessibleControlEvent)object).x += nArray[0];
            ((AccessibleControlEvent)object).y += nArray2[0];
        }
        n5 = 0;
        while (n5 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n5].getChildAtPoint((AccessibleControlEvent)object);
            ++n5;
        }
        if (((AccessibleControlEvent)object).childID == accessibleObject2.id) {
            ((AccessibleControlEvent)object).childID = -1;
        }
        if ((accessibleObject = accessibleObject2.getChildByID(((AccessibleControlEvent)object).childID)) != null) {
            if (n6 > 0) {
                OS.g_object_unref(n6);
            }
            OS.g_object_ref(accessibleObject.handle);
            return accessibleObject.handle;
        }
        return n6;
    }

    static int atkHypertext_get_link(int n, int n2) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link");
        }
        return 0;
    }

    static int atkHypertext_get_n_links(int n) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_n_links");
        }
        return 0;
    }

    static int atkHypertext_get_link_index(int n, int n2) {
        if (DEBUG) {
            System.out.println("-->atkHypertext_get_link_index");
        }
        return 0;
    }

    static int atkObject_get_description(int n) {
        int n2;
        AccessibleListener[] accessibleListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_description");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, n4);
        if (atkObjectClass.get_description != 0) {
            n3 = ATK.call(atkObjectClass.get_description, accessibleObject.handle);
        }
        if ((accessibleListenerArray = accessibleObject.getAccessibleListeners()).length == 0) {
            return n3;
        }
        AccessibleEvent accessibleEvent = new AccessibleEvent(accessibleObject.accessible);
        accessibleEvent.childID = accessibleObject.id;
        if (n3 != 0) {
            n2 = OS.strlen(n3);
            byte[] byArray = new byte[n2];
            OS.memmove(byArray, n3, n2);
            accessibleEvent.result = new String(Converter.mbcsToWcs(null, byArray));
        }
        n2 = 0;
        while (n2 < accessibleListenerArray.length) {
            accessibleListenerArray[n2].getDescription(accessibleEvent);
            ++n2;
        }
        if (accessibleEvent.result == null) {
            return n3;
        }
        if (descriptionPtr != -1) {
            OS.g_free(descriptionPtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, accessibleEvent.result, true);
        descriptionPtr = OS.g_malloc(byArray.length);
        OS.memmove(descriptionPtr, byArray, byArray.length);
        return descriptionPtr;
    }

    static int atkObject_get_name(int n) {
        int n2;
        AccessibleListener[] accessibleListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_name: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, n4);
        if (atkObjectClass.get_name != 0) {
            n3 = ATK.call(atkObjectClass.get_name, accessibleObject.handle);
        }
        if ((accessibleListenerArray = accessibleObject.getAccessibleListeners()).length == 0) {
            return n3;
        }
        AccessibleEvent accessibleEvent = new AccessibleEvent(accessibleObject.accessible);
        accessibleEvent.childID = accessibleObject.id;
        if (n3 != 0) {
            n2 = OS.strlen(n3);
            byte[] byArray = new byte[n2];
            OS.memmove(byArray, n3, n2);
            accessibleEvent.result = new String(Converter.mbcsToWcs(null, byArray));
        }
        n2 = 0;
        while (n2 < accessibleListenerArray.length) {
            accessibleListenerArray[n2].getName(accessibleEvent);
            ++n2;
        }
        if (accessibleEvent.result == null) {
            return n3;
        }
        if (namePtr != -1) {
            OS.g_free(namePtr);
        }
        byte[] byArray = Converter.wcsToMbcs(null, accessibleEvent.result, true);
        namePtr = OS.g_malloc(byArray.length);
        OS.memmove(namePtr, byArray, byArray.length);
        return namePtr;
    }

    static int atkObject_get_n_children(int n) {
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_n_children: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, n3);
        if (atkObjectClass.get_n_children != 0) {
            n2 = ATK.call(atkObjectClass.get_n_children, accessibleObject.handle);
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return n2;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject.accessible);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.detail = n2;
        int n4 = 0;
        while (n4 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n4].getChildCount(accessibleControlEvent);
            ++n4;
        }
        return accessibleControlEvent.detail;
    }

    static int atkObject_get_index_in_parent(int n) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObjectCB_get_index_in_parent.  ");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        if (accessibleObject.index != -1) {
            return accessibleObject.index;
        }
        int n2 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, n2);
        if (atkObjectClass.get_index_in_parent == 0) {
            return 0;
        }
        return ATK.call(atkObjectClass.get_index_in_parent, accessibleObject.handle);
    }

    static int atkObject_get_parent(int n) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_parent: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        if (accessibleObject.parent != null) {
            return accessibleObject.parent.handle;
        }
        int n2 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, n2);
        if (atkObjectClass.get_parent == 0) {
            return 0;
        }
        return ATK.call(atkObjectClass.get_parent, accessibleObject.handle);
    }

    static int atkObject_get_role(int n) {
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_get_role: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        if (accessibleObject.getAccessibleListeners().length != 0) {
            AccessibleControlListener[] accessibleControlListenerArray = accessibleObject.getControlListeners();
            object = new AccessibleControlEvent(accessibleObject.accessible);
            ((AccessibleControlEvent)object).childID = accessibleObject.id;
            ((AccessibleControlEvent)object).detail = -1;
            int n2 = 0;
            while (n2 < accessibleControlListenerArray.length) {
                accessibleControlListenerArray[n2].getRole((AccessibleControlEvent)object);
                ++n2;
            }
            if (((AccessibleControlEvent)object).detail != -1) {
                switch (((AccessibleControlEvent)object).detail) {
                    case 44: {
                        return 7;
                    }
                    case 10: {
                        return 18;
                    }
                    case 46: {
                        return 11;
                    }
                    case 18: {
                        return 16;
                    }
                    case 41: {
                        return 28;
                    }
                    case 30: {
                        return 60;
                    }
                    case 33: {
                        return 30;
                    }
                    case 34: {
                        return 31;
                    }
                    case 11: {
                        return 32;
                    }
                    case 2: {
                        return 33;
                    }
                    case 12: {
                        return 34;
                    }
                    case 48: {
                        return 41;
                    }
                    case 43: {
                        return 42;
                    }
                    case 3: {
                        return 47;
                    }
                    case 21: {
                        return 49;
                    }
                    case 51: {
                        return 50;
                    }
                    case 24: {
                        return 30;
                    }
                    case 29: {
                        return 31;
                    }
                    case 25: {
                        return 56;
                    }
                    case 26: {
                        return 57;
                    }
                    case 60: {
                        return 37;
                    }
                    case 37: {
                        return 36;
                    }
                    case 42: {
                        return 60;
                    }
                    case 22: {
                        return 62;
                    }
                    case 13: {
                        return 63;
                    }
                    case 35: {
                        return 64;
                    }
                    case 36: {
                        return 31;
                    }
                    case 45: {
                        return 43;
                    }
                    case 62: {
                        return 42;
                    }
                    case 9: {
                        return 68;
                    }
                }
            }
        }
        int n3 = ATK.g_type_class_peek(accessibleObject.parentType);
        object = new AtkObjectClass();
        ATK.memmove((AtkObjectClass)object, n3);
        if (((AtkObjectClass)object).get_role == 0) {
            return 0;
        }
        return ATK.call(((AtkObjectClass)object).get_role, accessibleObject.handle);
    }

    static int atkObject_ref_child(int n, int n2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_child: " + n2 + " of: " + n);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        accessibleObject.updateChildren();
        AccessibleObject accessibleObject2 = accessibleObject.getChildByIndex(n2);
        if (accessibleObject2 != null) {
            OS.g_object_ref(accessibleObject2.handle);
            return accessibleObject2.handle;
        }
        int n3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, n3);
        if (atkObjectClass.ref_child == 0) {
            return 0;
        }
        return ATK.call(atkObjectClass.ref_child, accessibleObject.handle, n2);
    }

    static int atkObject_ref_state_set(int n) {
        AccessibleControlListener[] accessibleControlListenerArray;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkObject_ref_state_set");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = ATK.g_type_class_peek(accessibleObject.parentType);
        AtkObjectClass atkObjectClass = new AtkObjectClass();
        ATK.memmove(atkObjectClass, n3);
        if (atkObjectClass.ref_state_set != 0) {
            n2 = ATK.call(atkObjectClass.ref_state_set, accessibleObject.handle);
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return n2;
        }
        int n4 = n2;
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(accessibleObject.accessible);
        accessibleControlEvent.childID = accessibleObject.id;
        accessibleControlEvent.detail = -1;
        int n5 = 0;
        while (n5 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n5].getState(accessibleControlEvent);
            ++n5;
        }
        if (accessibleControlEvent.detail != -1) {
            n5 = accessibleControlEvent.detail;
            if ((n5 & 0x800) != 0) {
                ATK.atk_state_set_add_state(n4, 3);
            }
            if ((n5 & 0x10) != 0) {
                ATK.atk_state_set_add_state(n4, 4);
            }
            if ((n5 & 0x200) != 0) {
                ATK.atk_state_set_add_state(n4, 9);
            }
            if ((n5 & 0x100000) != 0) {
                ATK.atk_state_set_add_state(n4, 10);
            }
            if ((n5 & 4) != 0) {
                ATK.atk_state_set_add_state(n4, 11);
            }
            if ((n5 & 0x80) != 0) {
                ATK.atk_state_set_add_state(n4, 2);
            }
            if ((n5 & 0x8000) == 0) {
                ATK.atk_state_set_add_state(n4, 28);
            }
            if ((n5 & 0x1000000) != 0) {
                ATK.atk_state_set_add_state(n4, 16);
            }
            if ((n5 & 0x10000) == 0) {
                ATK.atk_state_set_add_state(n4, 23);
            }
            if ((n5 & 8) != 0) {
                ATK.atk_state_set_add_state(n4, 18);
            }
            if ((n5 & 0x40) == 0) {
                ATK.atk_state_set_add_state(n4, 6);
            }
            if ((n5 & 0x200000) != 0) {
                ATK.atk_state_set_add_state(n4, 20);
            }
            if ((n5 & 2) != 0) {
                ATK.atk_state_set_add_state(n4, 21);
            }
            if ((n5 & 0x20000) != 0) {
                ATK.atk_state_set_add_state(n4, 19);
            }
        }
        return n4;
    }

    static int atkSelection_is_child_selected(int n, int n2) {
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkSelection_is_child_selected");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n3 = 0;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_SELECTION_TYPE)) {
            int n4 = ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(accessibleObject.handle));
            object = new AtkSelectionIface();
            ATK.memmove((AtkSelectionIface)object, n4);
            if (((AtkSelectionIface)object).is_child_selected != 0) {
                n3 = ATK.call(((AtkSelectionIface)object).is_child_selected, accessibleObject.handle, n2);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return n3;
        }
        object = new AccessibleControlEvent(accessibleObject.accessible);
        ((AccessibleControlEvent)object).childID = accessibleObject.id;
        int n5 = 0;
        while (n5 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n5].getSelection((AccessibleControlEvent)object);
            ++n5;
        }
        AccessibleObject accessibleObject2 = accessibleObject.getChildByID(((AccessibleControlEvent)object).childID);
        if (accessibleObject2 != null) {
            return accessibleObject2.index == n2 ? 1 : 0;
        }
        return n3;
    }

    static int atkSelection_ref_selection(int n, int n2) {
        AccessibleControlListener[] accessibleControlListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkSelection_ref_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n3 = 0;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_SELECTION_TYPE)) {
            int n4 = ATK.g_type_interface_peek_parent(ATK.ATK_SELECTION_GET_IFACE(accessibleObject.handle));
            object = new AtkSelectionIface();
            ATK.memmove((AtkSelectionIface)object, n4);
            if (((AtkSelectionIface)object).ref_selection != 0) {
                n3 = ATK.call(((AtkSelectionIface)object).ref_selection, accessibleObject.handle, n2);
            }
        }
        if ((accessibleControlListenerArray = accessibleObject.getControlListeners()).length == 0) {
            return n3;
        }
        object = new AccessibleControlEvent(accessibleObject.accessible);
        ((AccessibleControlEvent)object).childID = accessibleObject.id;
        int n5 = 0;
        while (n5 < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n5].getSelection((AccessibleControlEvent)object);
            ++n5;
        }
        AccessibleObject accessibleObject2 = accessibleObject.getChildByID(((AccessibleControlEvent)object).childID);
        if (accessibleObject2 != null) {
            if (n3 > 0) {
                OS.g_object_unref(n3);
            }
            OS.g_object_ref(accessibleObject2.handle);
            return accessibleObject2.handle;
        }
        return n3;
    }

    static int atkText_get_caret_offset(int n) {
        AccessibleTextListener[] accessibleTextListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_caret_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n2 = 0;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            int n3 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(accessibleObject.handle));
            object = new AtkTextIface();
            ATK.memmove((AtkTextIface)object, n3);
            if (((AtkTextIface)object).get_caret_offset != 0) {
                n2 = ATK.call(((AtkTextIface)object).get_caret_offset, accessibleObject.handle);
            }
        }
        if ((accessibleTextListenerArray = accessibleObject.getTextListeners()).length == 0) {
            return n2;
        }
        object = new AccessibleTextEvent(accessibleObject.accessible);
        ((AccessibleTextEvent)object).childID = accessibleObject.id;
        ((AccessibleTextEvent)object).offset = n2;
        int n4 = 0;
        while (n4 < accessibleTextListenerArray.length) {
            accessibleTextListenerArray[n4].getCaretOffset((AccessibleTextEvent)object);
            ++n4;
        }
        return ((AccessibleTextEvent)object).offset;
    }

    static int atkText_get_character_at_offset(int n, int n2) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_at_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        String string = accessibleObject.getText();
        if (string != null) {
            return string.charAt(n2);
        }
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            int n3 = ATK.g_type_class_peek(accessibleObject.parentType);
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, n3);
            if (atkTextIface.get_character_at_offset != 0) {
                return ATK.call(atkTextIface.get_character_at_offset, accessibleObject.handle, n2);
            }
        }
        return 0;
    }

    static int atkText_get_character_count(int n) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_character_count");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        String string = accessibleObject.getText();
        if (string != null) {
            return string.length();
        }
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            int n2 = ATK.g_type_class_peek(accessibleObject.parentType);
            AtkTextIface atkTextIface = new AtkTextIface();
            ATK.memmove(atkTextIface, n2);
            if (atkTextIface.get_character_count != 0) {
                return ATK.call(atkTextIface.get_character_count, accessibleObject.handle);
            }
        }
        return 0;
    }

    static int atkText_get_n_selections(int n) {
        AccessibleTextListener[] accessibleTextListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_n_selections");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n2 = 0;
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            int n3 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(accessibleObject.handle));
            object = new AtkTextIface();
            ATK.memmove((AtkTextIface)object, n3);
            if (((AtkTextIface)object).get_n_selections != 0) {
                n2 = ATK.call(((AtkTextIface)object).get_n_selections, accessibleObject.handle);
            }
        }
        if ((accessibleTextListenerArray = accessibleObject.getTextListeners()).length == 0) {
            return n2;
        }
        object = new AccessibleTextEvent(accessibleObject.accessible);
        ((AccessibleTextEvent)object).childID = accessibleObject.id;
        int n4 = 0;
        while (n4 < accessibleTextListenerArray.length) {
            accessibleTextListenerArray[n4].getSelectionRange((AccessibleTextEvent)object);
            ++n4;
        }
        return ((AccessibleTextEvent)object).length == 0 ? n2 : 1;
    }

    static int atkText_get_selection(int n, int n2, int n3, int n4) {
        AccessibleTextListener[] accessibleTextListenerArray;
        Object object;
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_selection");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        OS.memmove(n3, new int[1], 4);
        OS.memmove(n4, new int[1], 4);
        if (ATK.g_type_is_a(accessibleObject.parentType, ATK_TEXT_TYPE)) {
            int n5 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(accessibleObject.handle));
            object = new AtkTextIface();
            ATK.memmove((AtkTextIface)object, n5);
            if (((AtkTextIface)object).get_selection != 0) {
                ATK.call(((AtkTextIface)object).get_selection, accessibleObject.handle, n2, n3, n4);
            }
        }
        if ((accessibleTextListenerArray = accessibleObject.getTextListeners()).length == 0) {
            return 0;
        }
        object = new AccessibleTextEvent(accessibleObject.accessible);
        ((AccessibleTextEvent)object).childID = accessibleObject.id;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.memmove(nArray, n3, 4);
        OS.memmove(nArray2, n4, 4);
        ((AccessibleTextEvent)object).offset = nArray[0];
        ((AccessibleTextEvent)object).length = nArray2[0] - nArray[0];
        int n6 = 0;
        while (n6 < accessibleTextListenerArray.length) {
            accessibleTextListenerArray[n6].getSelectionRange((AccessibleTextEvent)object);
            ++n6;
        }
        OS.memmove(n3, new int[]{((AccessibleTextEvent)object).offset}, 4);
        OS.memmove(n4, new int[]{((AccessibleTextEvent)object).offset + ((AccessibleTextEvent)object).length}, 4);
        return 0;
    }

    static int atkText_get_text(int n, int n2, int n3) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text: " + n2 + "," + n3);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            n3 = n3 == -1 ? string.length() : Math.min(n3, string.length());
            n2 = Math.min(n2, n3);
            string = string.substring(n2, n3);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            int n4 = OS.g_malloc(byArray.length);
            OS.memmove(n4, byArray, byArray.length);
            return n4;
        }
        return 0;
    }

    static int atkText_get_text_after_offset(int n, int n2, int n3, int n4, int n5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_after_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n6 = n2;
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            int n7;
            int n8 = string.length();
            int n9 = n6 = Math.min(n6, n8 - 1);
            int n10 = n6;
            switch (n3) {
                case 0: {
                    if (n8 <= n6) break;
                    break;
                }
                case 1: {
                    int n11 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n6 - 1);
                    if (n11 == -1) {
                        n9 = n10 = n8;
                        break;
                    }
                    if ((n11 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n11)) == n8) {
                        n9 = n10 = n8;
                        break;
                    }
                    n9 = n11;
                    n7 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n11);
                    if (n7 == -1) {
                        n10 = n8;
                        break;
                    }
                    n10 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n7);
                    break;
                }
                case 2: {
                    int n11 = AccessibleObject.previousIndexOfNotChar(string, " \n", n6);
                    if (n11 == -1 || n11 != n6 - 1) {
                        n6 = AccessibleObject.nextIndexOfNotChar(string, " \n", n6);
                    }
                    if (n6 == -1) {
                        n9 = n10 = n8;
                        break;
                    }
                    n7 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n6);
                    if (n7 == -1) {
                        n9 = n10 = n8;
                        break;
                    }
                    if ((n7 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n7)) == n8) {
                        n9 = n10 = n8;
                        break;
                    }
                    n9 = n7;
                    int n12 = AccessibleObject.nextIndexOfNotChar(string, " \n", n7);
                    if (n12 == n8) {
                        n9 = n10 = n8;
                        break;
                    }
                    if ((n12 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n12)) == -1) {
                        n10 = n8;
                        break;
                    }
                    n10 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n12);
                    break;
                }
                case 3: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, "!?.", n6);
                    n7 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n6);
                    int n13 = 0;
                    if (n11 >= n7) {
                        n13 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n6);
                    } else {
                        n13 = AccessibleObject.nextIndexOfChar(string, "!?.", n6);
                        if (n13 == -1) {
                            n9 = n10 = n8;
                            break;
                        }
                        n13 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n13);
                    }
                    if (n13 == n8) {
                        n9 = n10 = n8;
                        break;
                    }
                    n9 = n13;
                    int n14 = AccessibleObject.nextIndexOfChar(string, "!?.", n13);
                    if (n14 == -1) {
                        n10 = n8;
                        break;
                    }
                    n10 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n14);
                    break;
                }
                case 4: {
                    int n11 = AccessibleObject.nextIndexOfChar(string, "!?.", n6);
                    if (n11 == -1) {
                        n9 = n10 = n8;
                        break;
                    }
                    if ((n11 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n11)) == n8) {
                        n9 = n10 = n8;
                        break;
                    }
                    n9 = n11;
                    n7 = AccessibleObject.nextIndexOfNotChar(string, " \n", n11);
                    if (n7 == n8) {
                        n9 = n10 = n8;
                        break;
                    }
                    if ((n7 = AccessibleObject.nextIndexOfChar(string, "!?.", n7)) == -1) {
                        n10 = n8;
                        break;
                    }
                    n10 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n7);
                    break;
                }
                case 5: {
                    int n11 = string.indexOf(10, n6 - 1);
                    if (n11 == -1) {
                        n9 = n10 = n8;
                        break;
                    }
                    if ((n11 = AccessibleObject.nextIndexOfNotChar(string, "\n", n11)) == n8) {
                        n9 = n10 = n8;
                        break;
                    }
                    n9 = n11;
                    n7 = string.indexOf(10, n11);
                    if (n7 == -1) {
                        n10 = n8;
                        break;
                    }
                    n10 = n7 = AccessibleObject.nextIndexOfNotChar(string, "\n", n7);
                    break;
                }
                case 6: {
                    int n11 = AccessibleObject.nextIndexOfChar(string, "\n", n6);
                    if (n11 == -1) {
                        n9 = n10 = n8;
                        break;
                    }
                    n9 = n11;
                    n10 = n9 == n8 ? n8 : ((n7 = AccessibleObject.nextIndexOfChar(string, "\n", n11 + 1)) == -1 ? n8 : n7);
                }
            }
            OS.memmove(n4, new int[]{n9}, 4);
            OS.memmove(n5, new int[]{++n10}, 4);
            string = string.substring(n9, n10);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            n7 = OS.g_malloc(byArray.length);
            OS.memmove(n7, byArray, byArray.length);
            return n7;
        }
        return 0;
    }

    static int atkText_get_text_at_offset(int n, int n2, int n3, int n4, int n5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_at_offset: " + n2 + " start: " + n4 + " end: " + n5);
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n6 = n2;
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            int n7;
            int n8 = string.length();
            int n9 = n6 = Math.min(n6, n8 - 1);
            int n10 = n6;
            switch (n3) {
                case 0: {
                    if (n8 <= n6) break;
                    break;
                }
                case 1: {
                    int n11 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n6);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    if ((n11 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n11) + 1) == -1) {
                        n9 = 0;
                        break;
                    }
                    n9 = n11;
                    n7 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n11);
                    n10 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n7);
                    break;
                }
                case 2: {
                    int n11 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n6 + 1);
                    n11 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n11);
                    n11 = AccessibleObject.previousIndexOfNotChar(string, " \n", n11 + 1);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n9 = n11 + 1;
                    n7 = AccessibleObject.nextIndexOfNotChar(string, " \n", n9);
                    if (n7 == n8) {
                        n10 = n9;
                        break;
                    }
                    if ((n7 = AccessibleObject.nextIndexOfChar(string, " !?.\n", n7)) == -1) {
                        n10 = n9;
                        break;
                    }
                    n10 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n7);
                    break;
                }
                case 3: {
                    int n11 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n6 + 1);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n11 = AccessibleObject.previousIndexOfChar(string, "!?.", n11) + 1;
                    n9 = AccessibleObject.nextIndexOfNotChar(string, " \n", n11);
                    n7 = AccessibleObject.nextIndexOfChar(string, "!?.", n9);
                    n10 = AccessibleObject.nextIndexOfNotChar(string, " !?.\n", n7);
                    break;
                }
                case 4: {
                    int n11 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n6 + 1);
                    n11 = AccessibleObject.previousIndexOfChar(string, "!?.", n11);
                    n11 = AccessibleObject.previousIndexOfNotChar(string, " \n", n11 + 1);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n9 = n11 + 1;
                    n7 = AccessibleObject.nextIndexOfNotChar(string, " \n", n9);
                    if (n7 == n8) {
                        n10 = n9;
                        break;
                    }
                    if ((n7 = AccessibleObject.nextIndexOfChar(string, "!?.", n7)) == -1) {
                        n10 = n9;
                        break;
                    }
                    n10 = AccessibleObject.nextIndexOfNotChar(string, "!?.", n7);
                    break;
                }
                case 5: {
                    n9 = AccessibleObject.previousIndexOfChar(string, "\n", n6) + 1;
                    int n11 = AccessibleObject.nextIndexOfChar(string, "\n", n9);
                    if (n11 < n8) {
                        ++n11;
                    }
                    n10 = n11;
                    break;
                }
                case 6: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, "\n", n6);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n9 = n11;
                    n10 = AccessibleObject.nextIndexOfChar(string, "\n", n11 + 1);
                }
            }
            OS.memmove(n4, new int[]{n9}, 4);
            OS.memmove(n5, new int[]{++n10}, 4);
            string = string.substring(n9, n10);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            n7 = OS.g_malloc(byArray.length);
            OS.memmove(n7, byArray, byArray.length);
            return n7;
        }
        return 0;
    }

    static int atkText_get_text_before_offset(int n, int n2, int n3, int n4, int n5) {
        AccessibleObject accessibleObject;
        if (DEBUG) {
            System.out.println("-->atkText_get_text_before_offset");
        }
        if ((accessibleObject = AccessibleObject.getAccessibleObject(n)) == null) {
            return 0;
        }
        int n6 = n2;
        String string = accessibleObject.getText();
        if (string.length() > 0) {
            int n7;
            int n8 = string.length();
            int n9 = n6 = Math.min(n6, n8 - 1);
            int n10 = n6;
            switch (n3) {
                case 0: {
                    if (n8 < n6 || n6 <= 0) break;
                    break;
                }
                case 1: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n6 - 1);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n7 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n11);
                    if (n7 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n10 = n11 + 1;
                    n9 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n7) + 1;
                    break;
                }
                case 2: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n6);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    if ((n11 = AccessibleObject.previousIndexOfNotChar(string, " \n", n11 + 1)) == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n10 = n11 + 1;
                    n7 = AccessibleObject.previousIndexOfNotChar(string, " !?.\n", n10);
                    if ((n7 = AccessibleObject.previousIndexOfChar(string, " !?.\n", n7)) == -1) {
                        n9 = 0;
                        break;
                    }
                    n9 = AccessibleObject.previousIndexOfNotChar(string, " \n", n7 + 1) + 1;
                    break;
                }
                case 3: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, "!?.", n6);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n7 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n11);
                    if (n7 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n10 = n11 + 1;
                    n9 = AccessibleObject.previousIndexOfChar(string, "!?.", n7) + 1;
                    break;
                }
                case 4: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, "!?.", n6);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    if ((n11 = AccessibleObject.previousIndexOfNotChar(string, " \n", n11 + 1)) == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n10 = n11 + 1;
                    n7 = AccessibleObject.previousIndexOfNotChar(string, "!?.", n10);
                    if ((n7 = AccessibleObject.previousIndexOfChar(string, "!?.", n7)) == -1) {
                        n9 = 0;
                        break;
                    }
                    n9 = AccessibleObject.previousIndexOfNotChar(string, " \n", n7 + 1) + 1;
                    break;
                }
                case 5: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, "\n", n6);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n10 = n11 + 1;
                    n9 = AccessibleObject.previousIndexOfChar(string, "\n", n11) + 1;
                    break;
                }
                case 6: {
                    int n11 = AccessibleObject.previousIndexOfChar(string, "\n", n6);
                    if (n11 == -1) {
                        n10 = 0;
                        n9 = 0;
                        break;
                    }
                    n10 = n11;
                    n9 = AccessibleObject.previousIndexOfChar(string, "\n", n11);
                    if (n9 != -1) break;
                    n9 = 0;
                }
            }
            OS.memmove(n4, new int[]{--n9}, 4);
            OS.memmove(n5, new int[]{n10}, 4);
            string = string.substring(n9, n10);
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            n7 = OS.g_malloc(byArray.length);
            OS.memmove(n7, byArray, byArray.length);
            return n7;
        }
        return 0;
    }

    AccessibleListener[] getAccessibleListeners() {
        if (this.accessible == null) {
            return new AccessibleListener[0];
        }
        AccessibleListener[] accessibleListenerArray = this.accessible.getAccessibleListeners();
        return accessibleListenerArray != null ? accessibleListenerArray : new AccessibleListener[]{};
    }

    static AccessibleObject getAccessibleObject(int n) {
        AccessibleObject accessibleObject = (AccessibleObject)AccessibleObjects.get(new LONG(n));
        if (accessibleObject == null) {
            return null;
        }
        if (accessibleObject.accessible == null) {
            return null;
        }
        Control control = accessibleObject.accessible.control;
        if (control == null || control.isDisposed()) {
            return null;
        }
        return accessibleObject;
    }

    AccessibleObject getChildByHandle(int n) {
        return (AccessibleObject)this.children.get(new LONG(n));
    }

    AccessibleObject getChildByID(int n) {
        if (n == -1) {
            return this;
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AccessibleObject accessibleObject = (AccessibleObject)enumeration.nextElement();
            if (accessibleObject.id != n) continue;
            return accessibleObject;
        }
        return null;
    }

    AccessibleObject getChildByIndex(int n) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AccessibleObject accessibleObject = (AccessibleObject)enumeration.nextElement();
            if (accessibleObject.index != n) continue;
            return accessibleObject;
        }
        return null;
    }

    AccessibleControlListener[] getControlListeners() {
        if (this.accessible == null) {
            return new AccessibleControlListener[0];
        }
        AccessibleControlListener[] accessibleControlListenerArray = this.accessible.getControlListeners();
        return accessibleControlListenerArray != null ? accessibleControlListenerArray : new AccessibleControlListener[]{};
    }

    String getText() {
        AccessibleControlListener[] accessibleControlListenerArray;
        int n;
        Object object;
        int n2 = 0;
        String string = "";
        if (ATK.g_type_is_a(this.parentType, ATK_TEXT_TYPE)) {
            int n3 = ATK.g_type_interface_peek_parent(ATK.ATK_TEXT_GET_IFACE(this.handle));
            object = new AtkTextIface();
            ATK.memmove((AtkTextIface)object, n3);
            n = 0;
            if (((AtkTextIface)object).get_character_count != 0) {
                n = ATK.call(((AtkTextIface)object).get_character_count, this.handle);
            }
            if (n > 0 && ((AtkTextIface)object).get_text != 0 && (n2 = ATK.call(((AtkTextIface)object).get_text, this.handle, 0, n)) != 0) {
                int n4 = OS.strlen(n2);
                byte[] byArray = new byte[n4];
                OS.memmove(byArray, n2, n4);
                string = new String(Converter.mbcsToWcs(null, byArray));
            }
        }
        if ((accessibleControlListenerArray = this.getControlListeners()).length == 0) {
            return string;
        }
        object = new AccessibleControlEvent(this.accessible);
        ((AccessibleControlEvent)object).childID = this.id;
        ((AccessibleControlEvent)object).result = string;
        n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getValue((AccessibleControlEvent)object);
            ++n;
        }
        return ((AccessibleControlEvent)object).result;
    }

    AccessibleTextListener[] getTextListeners() {
        if (this.accessible == null) {
            return new AccessibleTextListener[0];
        }
        AccessibleTextListener[] accessibleTextListenerArray = this.accessible.getTextListeners();
        return accessibleTextListenerArray != null ? accessibleTextListenerArray : new AccessibleTextListener[]{};
    }

    static int gObjectClass_finalize(int n) {
        int n2 = ATK.g_type_class_peek_parent(ATK.G_OBJECT_GET_CLASS(n));
        int n3 = ATK.G_OBJECT_CLASS(n2);
        GObjectClass gObjectClass = new GObjectClass();
        ATK.memmove(gObjectClass, n3);
        ATK.call(gObjectClass.finalize, n);
        AccessibleObject accessibleObject = (AccessibleObject)AccessibleObjects.get(new LONG(n));
        if (accessibleObject != null) {
            AccessibleObjects.remove(new LONG(n));
            accessibleObject.release();
        }
        return 0;
    }

    static int nextIndexOfChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.indexOf(c, n);
            if (n4 != -1) {
                n2 = Math.min(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int nextIndexOfNotChar(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (string2.indexOf(c) == -1) break;
            ++n3;
        }
        return n3;
    }

    static int previousIndexOfChar(String string, String string2, int n) {
        int n2 = -1;
        if (n < 0) {
            return n2;
        }
        string = string.substring(0, n);
        int n3 = 0;
        while (n3 < string2.length()) {
            char c = string2.charAt(n3);
            int n4 = string.lastIndexOf(c);
            if (n4 != -1) {
                n2 = Math.max(n2, n4);
            }
            ++n3;
        }
        return n2;
    }

    static int previousIndexOfNotChar(String string, String string2, int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (string2.indexOf(c) == -1) break;
            --n2;
        }
        return n2;
    }

    void release() {
        if (DEBUG) {
            System.out.println("AccessibleObject.release: " + this.handle);
        }
        this.accessible = null;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            AccessibleObject accessibleObject = (AccessibleObject)enumeration.nextElement();
            if (!accessibleObject.isLightweight) continue;
            OS.g_object_unref(accessibleObject.handle);
        }
        if (this.parent != null) {
            this.parent.removeChild(this, false);
        }
    }

    void removeChild(AccessibleObject accessibleObject, boolean bl) {
        this.children.remove(new LONG(accessibleObject.handle));
        if (bl && accessibleObject.isLightweight) {
            OS.g_object_unref(accessibleObject.handle);
        }
    }

    void selectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.selection_changed);
    }

    void setFocus(int n) {
        this.updateChildren();
        AccessibleObject accessibleObject = this.getChildByID(n);
        if (accessibleObject != null) {
            ATK.atk_focus_tracker_notify(accessibleObject.handle);
        }
    }

    void setParent(AccessibleObject accessibleObject) {
        this.parent = accessibleObject;
    }

    void textCaretMoved(int n) {
        OS.g_signal_emit_by_name(this.handle, ATK.text_caret_moved, n);
    }

    void textChanged(int n, int n2, int n3) {
        if (n == 1) {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_delete, n2, n3);
        } else {
            OS.g_signal_emit_by_name(this.handle, ATK.text_changed_insert, n2, n3);
        }
    }

    void textSelectionChanged() {
        OS.g_signal_emit_by_name(this.handle, ATK.text_selection_changed);
    }

    void updateChildren() {
        if (this.isLightweight) {
            return;
        }
        AccessibleControlListener[] accessibleControlListenerArray = this.getControlListeners();
        if (accessibleControlListenerArray.length == 0) {
            return;
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this.accessible);
        int n = 0;
        while (n < accessibleControlListenerArray.length) {
            accessibleControlListenerArray[n].getChildren(accessibleControlEvent);
            ++n;
        }
        if (accessibleControlEvent.children != null && accessibleControlEvent.children.length > 0) {
            AccessibleObject accessibleObject;
            int n2;
            int n3;
            Vector<LONG> vector = new Vector<LONG>(this.children.size());
            if (accessibleControlEvent.children[0] instanceof Integer) {
                n3 = AccessibleFactory.getDefaultParentType();
                n2 = 0;
                while (n2 < accessibleControlEvent.children.length) {
                    accessibleObject = this.getChildByIndex(n2);
                    if (accessibleObject == null) {
                        int n4 = AccessibleFactory.getChildType(this.accessible, n2);
                        accessibleObject = new AccessibleObject(n4, 0, this.accessible, n3, true);
                        AccessibleObjects.put(new LONG(accessibleObject.handle), accessibleObject);
                        this.addChild(accessibleObject);
                        accessibleObject.index = n2;
                    }
                    try {
                        accessibleObject.id = (Integer)accessibleControlEvent.children[n2];
                    }
                    catch (ClassCastException classCastException) {}
                    vector.addElement(new LONG(accessibleObject.handle));
                    ++n2;
                }
            } else {
                n3 = 0;
                n2 = 0;
                while (n2 < accessibleControlEvent.children.length) {
                    accessibleObject = null;
                    try {
                        accessibleObject = ((Accessible)accessibleControlEvent.children[n2]).accessibleObject;
                    }
                    catch (ClassCastException classCastException) {}
                    if (accessibleObject != null) {
                        accessibleObject.index = n3++;
                        vector.addElement(new LONG(accessibleObject.handle));
                    }
                    ++n2;
                }
            }
            Enumeration enumeration = this.children.keys();
            while (enumeration.hasMoreElements()) {
                LONG lONG = (LONG)enumeration.nextElement();
                if (vector.contains(lONG)) continue;
                accessibleObject = (AccessibleObject)this.children.get(lONG);
                this.removeChild(accessibleObject, true);
            }
        }
    }
}

