/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XCrossingEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XFontStruct;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XMotionEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.internal.motif.XWindowChanges;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    int drawCount;
    int redrawWindow;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    Region region;
    String toolTipText;
    Object layoutData;
    Accessible accessible;

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget(0);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    int borderHandle() {
        return this.topHandle();
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFFBF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0) {
                if (n == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x80) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x40;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBuffered() {
        this.style &= 0xDFFFFFFF;
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 64;
        int n4 = 64;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createWidget(int n) {
        int n2;
        this.state |= 0x4000;
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.checkBackground();
        this.checkBuffered();
        this.setParentTraversal();
        this.overrideTranslations();
        if (!this.hasIMSupport()) {
            OS.XmImRegister(this.handle, 0);
            n2 = this.focusHandle();
            if (this.handle != n2) {
                OS.XmImRegister(n2, 0);
            }
        }
        if (OS.XtIsRealized(n2 = this.topHandle()) && !OS.XtIsSubclass(n2, OS.shellWidgetClass())) {
            int n3;
            int n4 = OS.XtWindow(n2);
            if (n4 != 0 && (n3 = OS.XtDisplay(n2)) != 0) {
                OS.XLowerWindow(n3, n4);
            }
            this.realizeChildren();
        }
        OS.XtOverrideTranslations(this.handle, this.display.dragTranslations);
        this.font = this.defaultFont();
    }

    int defaultBackground() {
        return this.display.defaultBackground;
    }

    Font defaultFont() {
        return this.display.defaultFont;
    }

    int defaultForeground() {
        return this.display.defaultForeground;
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 2 || n2 != 1) {
            return false;
        }
        if (!this.dragDetect(n4, n5, false, null)) {
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5, true);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        return true;
    }

    boolean drawGripper(int n, int n2, int n3, int n4, boolean bl) {
        return false;
    }

    void enableWidget(boolean bl) {
        this.enableHandle(bl, this.handle);
    }

    Control findBackgroundControl() {
        if ((this.state & 0x10) != 0 || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x40) != 0 ? this.parent.findBackgroundControl() : null;
    }

    char findMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return string.charAt(n);
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
    }

    int focusHandle() {
        return this.handle;
    }

    int fontHandle() {
        return this.handle;
    }

    public boolean forceFocus() {
        boolean bl;
        int[] nArray;
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        decorations.bringToTop(false);
        int n = this.focusHandle();
        if (this.handle != n) {
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNnumChildren;
            nArray = nArray2;
            OS.XtGetValues(this.handle, nArray, nArray.length / 2);
            if (nArray[1] > 1) {
                int[] nArray3 = new int[2];
                nArray3[0] = OS.XmNtraversalOn;
                int[] nArray4 = nArray3;
                OS.XtGetValues(n, nArray4, nArray4.length / 2);
                if (nArray4[1] == 0) {
                    nArray4[1] = 1;
                    OS.XtSetValues(n, nArray4, nArray4.length / 2);
                    this.overrideTranslations();
                }
            } else {
                n = this.handle;
            }
        }
        int[] nArray5 = new int[2];
        nArray5[0] = OS.XmNtraversalOn;
        nArray = nArray5;
        OS.XtGetValues(n, nArray, nArray.length / 2);
        boolean bl2 = bl = nArray[1] == 0;
        if (bl) {
            this.state |= 8;
            nArray[1] = 1;
            OS.XtSetValues(n, nArray, nArray.length / 2);
            this.overrideTranslations();
        }
        if (this.XmProcessTraversal(n, 0)) {
            return true;
        }
        if (bl) {
            this.state &= 0xFFFFFFF7;
            nArray[1] = 0;
            OS.XtSetValues(n, nArray, nArray.length / 2);
        }
        return false;
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.motif_new(this.display, this.getXColor(control.getBackgroundPixel()));
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    int getBackgroundPixel() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNbackground;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getBorderWidth() {
        this.checkWidget();
        int n = this.borderHandle();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(n, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int n = this.topHandle();
        int[] nArray = new int[10];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        nArray[8] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(n, nArray2, nArray2.length / 2);
        int n2 = nArray2[9] * 2;
        return new Rectangle((short)nArray2[1], (short)nArray2[3], nArray2[5] + n2, nArray2[7] + n2);
    }

    Point getClientLocation() {
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
        short[] sArray3 = new short[1];
        short[] sArray4 = new short[1];
        OS.XtTranslateCoords(this.parent.handle, (short)0, (short)0, sArray3, sArray4);
        return new Point(sArray[0] - sArray3[0], sArray2[0] - sArray4[0]);
    }

    String getCodePage() {
        return this.font.codePage;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x4000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.topHandle(), nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font;
    }

    int getFontAscent(int n) {
        int n2;
        int[] nArray = new int[1];
        if (!OS.XmFontListInitFontContext(nArray, n)) {
            this.error(2);
        }
        int n3 = nArray[0];
        int n4 = 0;
        XFontStruct xFontStruct = new XFontStruct();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        while ((n2 = OS.XmFontListNextEntry(n3)) != 0) {
            int n5 = OS.XmFontListEntryGetFont(n2, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n5, 80);
                if (xFontStruct.ascent <= n4) continue;
                n4 = xFontStruct.ascent;
                continue;
            }
            int n6 = OS.XFontsOfFontSet(n5, nArray2, nArray3);
            int[] nArray4 = new int[n6];
            OS.memmove(nArray4, nArray2[0], n6 * 4);
            int n7 = 0;
            while (n7 < n6) {
                OS.memmove(xFontStruct, nArray4[n7], 80);
                if (xFontStruct.ascent > n4) {
                    n4 = xFontStruct.ascent;
                }
                ++n7;
            }
        }
        OS.XmFontListFreeFontContext(n3);
        return n4;
    }

    int getFontHeight(int n) {
        int n2;
        int[] nArray = new int[1];
        if (!OS.XmFontListInitFontContext(nArray, n)) {
            this.error(2);
        }
        int n3 = nArray[0];
        int n4 = 0;
        XFontStruct xFontStruct = new XFontStruct();
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        while ((n2 = OS.XmFontListNextEntry(n3)) != 0) {
            int n5;
            int n6 = OS.XmFontListEntryGetFont(n2, nArray);
            if (nArray[0] == 0) {
                OS.memmove(xFontStruct, n6, 80);
                n5 = xFontStruct.ascent + xFontStruct.descent;
                if (n5 <= n4) continue;
                n4 = n5;
                continue;
            }
            n5 = OS.XFontsOfFontSet(n6, nArray2, nArray3);
            int[] nArray4 = new int[n5];
            OS.memmove(nArray4, nArray2[0], n5 * 4);
            int n7 = 0;
            while (n7 < n5) {
                OS.memmove(xFontStruct, nArray4[n7], 80);
                int n8 = xFontStruct.ascent + xFontStruct.descent;
                if (n8 > n4) {
                    n4 = n8;
                }
                ++n7;
            }
        }
        OS.XmFontListFreeFontContext(n3);
        return n4;
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.motif_new(this.display, this.getXColor(this.getForegroundPixel()));
    }

    int getForegroundPixel() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNforeground;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    Caret getIMCaret() {
        return null;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        int n = this.topHandle();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] nArray2 = nArray;
        OS.XtGetValues(n, nArray2, nArray2.length / 2);
        return new Point((short)nArray2[1], (short)nArray2[3]);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMinimumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        int n;
        this.checkWidget();
        Monitor[] monitorArray = this.display.getMonitors();
        if (monitorArray.length == 1) {
            return monitorArray[0];
        }
        int n2 = -1;
        int n3 = -1;
        Rectangle rectangle = this.getBounds();
        if (this != this.getShell()) {
            rectangle = this.display.map((Control)this.parent, null, rectangle);
        }
        int n4 = 0;
        while (n4 < monitorArray.length) {
            Rectangle rectangle2 = rectangle.intersection(monitorArray[n4].getBounds());
            n = rectangle2.width * rectangle2.height;
            if (n > 0 && n > n3) {
                n2 = n4;
                n3 = n;
            }
            ++n4;
        }
        if (n2 >= 0) {
            return monitorArray[n2];
        }
        n4 = rectangle.x + rectangle.width / 2;
        int n5 = rectangle.y + rectangle.height / 2;
        n = 0;
        while (n < monitorArray.length) {
            int n6;
            Rectangle rectangle3 = monitorArray[n].getBounds();
            int n7 = n4 < rectangle3.x ? rectangle3.x - n4 : (n6 = n4 > rectangle3.x + rectangle3.width ? n4 - rectangle3.x - rectangle3.width : 0);
            int n8 = n5 < rectangle3.y ? rectangle3.y - n5 : (n5 > rectangle3.y + rectangle3.height ? n5 - rectangle3.y - rectangle3.height : 0);
            int n9 = n6 * n6 + n8 * n8;
            if (n2 == -1 || n9 < n3) {
                n2 = n;
                n3 = n9;
            }
            ++n;
        }
        return monitorArray[n2];
    }

    int getNavigationType() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNnavigationType;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        int n = this.topHandle();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(n, nArray2, nArray2.length / 2);
        int n2 = nArray2[5] * 2;
        return new Point(nArray2[1] + n2, nArray2[3] + n2);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        int n = this.topHandle();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmappedWhenManaged;
        int[] nArray2 = nArray;
        OS.XtGetValues(n, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    XColor getXColor(int n) {
        int n2 = OS.XtDisplay(this.handle);
        if (n2 == 0) {
            return null;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNcolormap;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n3 = nArray2[1];
        if (n3 == 0) {
            return null;
        }
        XColor xColor = new XColor();
        xColor.pixel = n;
        OS.XQueryColor(n2, n3, xColor);
        return xColor;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    boolean hasIMSupport() {
        return false;
    }

    void hookEvents() {
        int n = this.display.windowProc;
        OS.XtAddEventHandler(this.handle, 4, false, n, 1);
        OS.XtAddEventHandler(this.handle, 8, false, n, 2);
        OS.XtAddEventHandler(this.handle, 64, false, n, 26);
        OS.XtAddEventHandler(this.handle, 16, false, n, 4);
        OS.XtAddEventHandler(this.handle, 32, false, n, 8);
        OS.XtInsertEventHandler(this.handle, 32768, false, n, 3, 1);
        OS.XtAddCallback(this.handle, OS.XmNhelpCallback, n, 17);
        OS.XtAddEventHandler(this.handle, 1, false, n, 6);
        OS.XtAddEventHandler(this.handle, 2, false, n, 7);
        OS.XtInsertEventHandler(this.handle, 0x200000, false, n, 5, 1);
        int n2 = this.focusHandle();
        if (this.handle != n2) {
            OS.XtAddEventHandler(n2, 1, false, n, 6);
            OS.XtAddEventHandler(n2, 2, false, n, 7);
            OS.XtInsertEventHandler(n2, 0x200000, false, n, 5, 1);
        }
    }

    int hoverProc(int n) {
        return this.hoverProc(n, true);
    }

    int hoverProc(int n, boolean bl) {
        if (bl) {
            this.display.showToolTip(this.handle, this.toolTipText);
        }
        this.sendMouseEvent(32);
        return 0;
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        int n2;
        int n3;
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            Shell shell = this.getShell();
            shell.realizeWidget();
        }
        if ((n3 = OS.XtDisplay(this.handle)) == 0) {
            SWT.error(2);
        }
        if ((n2 = OS.XtWindow(this.handle)) == 0) {
            SWT.error(2);
        }
        if ((n = OS.XCreateGC(n3, n2, 0, null)) == 0) {
            SWT.error(2);
        }
        OS.XSetGraphicsExposures(n3, n, false);
        if (gCData != null) {
            int n4 = 0x6000000;
            if ((gCData.style & n4) == 0) {
                gCData.style |= this.style & (n4 | 0x8000000);
            }
            gCData.device = this.display;
            gCData.display = n3;
            gCData.drawable = n2;
            XColor xColor = new XColor();
            xColor.pixel = this.getForegroundPixel();
            gCData.foreground = xColor;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            XColor xColor2 = new XColor();
            xColor2.pixel = control.getBackgroundPixel();
            gCData.background = xColor2;
            gCData.backgroundImage = control.backgroundImage;
            gCData.font = this.font;
            int[] nArray = new int[2];
            nArray[0] = OS.XmNcolormap;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            gCData.colormap = nArray2[1];
        }
        return n;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        this.checkWidget();
        int n2 = 0;
        if (gCData != null) {
            n2 = gCData.display;
        }
        if (n2 == 0 && this.handle != 0) {
            n2 = OS.XtDisplay(this.handle);
        }
        if (n2 == 0) {
            SWT.error(2);
        }
        OS.XFreeGC(n2, n);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 1 || point.y == 1) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        if (((n = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (n & 0x18) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return false;
                }
                ++n;
            }
        }
        return ((n = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void manageChildren() {
        OS.XtSetMappedWhenManaged(this.handle, false);
        OS.XtManageChild(this.handle);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XtResizeWidget(this.handle, 1, 1, nArray2[1]);
        OS.XtSetMappedWhenManaged(this.handle, true);
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c) {
        return false;
    }

    boolean mnemonicMatch(char c) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
        OS.XtOverrideTranslations(this.handle, this.display.arrowTranslations);
        int n = this.focusHandle();
        if (this.handle != n) {
            OS.XtOverrideTranslations(n, this.display.tabTranslations);
            OS.XtOverrideTranslations(n, this.display.arrowTranslations);
        }
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl));
    }

    void propagateChildren(boolean bl) {
        this.propagateWidget(bl);
    }

    void propagateWidget(boolean bl) {
        int n = bl && this.cursor != null ? this.cursor.handle : 0;
        this.propagateHandle(bl, this.handle, n);
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void realizeChildren() {
        if (this.isEnabled()) {
            if (this.cursor != null) {
                int n = OS.XtWindow(this.handle);
                if (n == 0) {
                    return;
                }
                int n2 = OS.XtDisplay(this.handle);
                if (n2 == 0) {
                    return;
                }
                OS.XDefineCursor(n2, n, this.cursor.handle);
                OS.XFlush(n2);
            }
        } else {
            this.propagateWidget(false);
        }
        if ((this.state & 0x40) != 0) {
            this.setParentBackground();
        }
    }

    public void redraw() {
        this.checkWidget();
        this.redrawWidget(0, 0, 0, 0, true, false, false);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (n3 > 0 && n4 > 0) {
            this.redrawWidget(n, n2, n3, n4, false, bl, false);
        }
    }

    void redrawChildren() {
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        this.redrawHandle(n, n2, n3, n4, bl, this.handle);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        int n;
        super.releaseWidget();
        int n2 = this.defaultFont().handle;
        if (this.font.handle != n2) {
            n = this.fontHandle();
            int[] nArray = new int[]{OS.XmNfontList, n2};
            OS.XtSetValues(n, nArray, nArray.length / 2);
            OS.XmImSetValues(n, nArray, nArray.length / 2);
        }
        this.display.releaseToolTipHandle(this.handle);
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        if (!this.hasIMSupport()) {
            OS.XmImUnregister(this.handle);
            n = this.focusHandle();
            if (this.handle != n) {
                OS.XmImUnregister(n);
            }
        }
        this.layoutData = null;
        this.region = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4, boolean bl) {
        Event event = new Event();
        event.button = n;
        event.x = n3;
        event.y = n4;
        if (bl) {
            event.stateMask = n2;
        } else {
            this.setInputState(event, n2);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int n) {
        Display display = this.display;
        if (n == 15) {
            Combo combo = display.focusedCombo;
            display.focusedCombo = null;
            if (combo != null && combo != this && !combo.isDisposed()) {
                display.sendFocusEvent(combo, 16);
            }
        }
        display.sendFocusEvent(this, n);
    }

    void sendHelpEvent(int n) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return;
            }
            control = control.parent;
        }
    }

    boolean sendMouseEvent(int n) {
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        int n2 = OS.XtDisplay(this.handle);
        int n3 = OS.XtWindow(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.XQueryPointer(n2, n3, nArray4, nArray4, nArray4, nArray4, nArray, nArray2, nArray3);
        return this.sendMouseEvent(n, 0, 0, 0, false, 0, nArray[0], nArray2[0], nArray3[0]);
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8) {
        Event event = new Event();
        event.time = n5;
        event.button = n2;
        event.count = n3;
        event.detail = n4;
        event.x = n6;
        event.y = n7;
        this.setInputState(event, n8);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        return event.doit;
    }

    boolean sendMouseEvent(int n, XButtonEvent xButtonEvent) {
        int n2 = xButtonEvent.button;
        switch (n2) {
            case 4: 
            case 5: {
                if (n != 3) {
                    return true;
                }
                n = 37;
                if (!this.hooks(n) && !this.filters(n)) {
                    return true;
                }
                short[] sArray = new short[1];
                short[] sArray2 = new short[1];
                OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
                int n3 = xButtonEvent.x_root - sArray[0];
                int n4 = xButtonEvent.y_root - sArray2[0];
                int n5 = n2 == 4 ? 3 : -3;
                Control control = this;
                Shell shell = this.getShell();
                do {
                    if (!control.sendMouseEvent(n, 0, n5, 1, true, xButtonEvent.time, n3, n4, xButtonEvent.state)) {
                        return false;
                    }
                    if (control == shell) break;
                    control = control.parent;
                    OS.XtTranslateCoords(control.handle, (short)0, (short)0, sArray, sArray2);
                    n3 = xButtonEvent.x_root - sArray[0];
                    n4 = xButtonEvent.y_root - sArray2[0];
                } while (control != null);
                return true;
            }
            case 6: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 5;
            }
        }
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        short[] sArray = new short[1];
        short[] sArray3 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray3);
        int n6 = xButtonEvent.x_root - sArray[0];
        int n7 = xButtonEvent.y_root - sArray3[0];
        return this.sendMouseEvent(n, n2, this.display.clickCount, 0, false, xButtonEvent.time, n6, n7, xButtonEvent.state);
    }

    boolean sendMouseEvent(int n, XCrossingEvent xCrossingEvent) {
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
        int n2 = xCrossingEvent.x_root - sArray[0];
        int n3 = xCrossingEvent.y_root - sArray2[0];
        return this.sendMouseEvent(n, 0, 0, 0, false, xCrossingEvent.time, n2, n3, xCrossingEvent.state);
    }

    boolean sendMouseEvent(int n, XMotionEvent xMotionEvent) {
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
        int n2 = xMotionEvent.x_root - sArray[0];
        int n3 = xMotionEvent.y_root - sArray2[0];
        return this.sendMouseEvent(n, 0, 0, 0, false, xMotionEvent.time, n2, n3, xMotionEvent.state);
    }

    void setBackground() {
        if ((this.state & 0x40) != 0 && (this.state & 0x10) == 0 && this.backgroundImage == null) {
            this.setParentBackground();
        } else if (this.backgroundImage != null) {
            int[] nArray = new int[]{OS.XmNbackgroundPixmap, this.backgroundImage.pixmap};
            OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        } else {
            int n = this.getBackgroundPixel();
            this.setBackgroundPixel(n + 1);
            this.setBackgroundPixel(n);
        }
        this.redrawWidget(0, 0, 0, 0, true, false, false);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color == null) {
            this.state &= 0xFFFFFFEF;
            this.setBackgroundPixel(this.defaultBackground());
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            this.state |= 0x10;
            this.setBackgroundPixel(color.handle.pixel);
        }
        if ((this.state & 0x40) != 0 && (this.state & 0x10) == 0 && this.backgroundImage == null) {
            this.setParentBackground();
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
        this.redrawChildren();
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        int n = image != null ? image.pixmap : 2;
        int[] nArray = new int[]{OS.XmNbackgroundPixmap, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if ((this.state & 0x40) != 0 && (this.state & 0x10) == 0 && this.backgroundImage == null) {
            this.setParentBackground();
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
        this.redrawChildren();
    }

    void setBackgroundPixel(int n) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNhighlightColor;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmChangeColor(this.handle, n);
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = this.topHandle();
        if (bl && bl2) {
            boolean bl3;
            int[] nArray = new int[10];
            nArray[0] = OS.XmNx;
            nArray[2] = OS.XmNy;
            nArray[4] = OS.XmNwidth;
            nArray[6] = OS.XmNheight;
            nArray[8] = OS.XmNborderWidth;
            int[] nArray2 = nArray;
            OS.XtGetValues(n5, nArray2, nArray2.length / 2);
            n3 = Math.max(n3 - nArray2[9] * 2, 1);
            n4 = Math.max(n4 - nArray2[9] * 2, 1);
            boolean bl4 = n == (short)nArray2[1] && n2 == (short)nArray2[3];
            boolean bl5 = bl3 = n3 == nArray2[5] && n4 == nArray2[7];
            if (bl4 && bl3) {
                return false;
            }
            if (this.redrawWindow != 0) {
                int n6 = OS.XtDisplay(this.handle);
                OS.XResizeWindow(n6, this.redrawWindow, n3, n4);
            }
            OS.XtConfigureWidget(n5, n, n2, n3, n4, nArray2[9]);
            this.updateIM();
            if (!bl4) {
                Control control = this.findBackgroundControl();
                if (control != null && control.backgroundImage != null && this.isVisible()) {
                    this.redrawWidget(0, 0, 0, 0, true, true, true);
                }
                this.sendEvent(10);
            }
            if (!bl3) {
                this.sendEvent(11);
            }
            return true;
        }
        if (bl) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNx;
            nArray[2] = OS.XmNy;
            int[] nArray3 = nArray;
            OS.XtGetValues(n5, nArray3, nArray3.length / 2);
            if (n == (short)nArray3[1] && n2 == (short)nArray3[3]) {
                return false;
            }
            OS.XtMoveWidget(n5, n, n2);
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            this.sendEvent(10);
            return true;
        }
        if (bl2) {
            int[] nArray = new int[6];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            nArray[4] = OS.XmNborderWidth;
            int[] nArray4 = nArray;
            OS.XtGetValues(n5, nArray4, nArray4.length / 2);
            n3 = Math.max(n3 - nArray4[5] * 2, 1);
            n4 = Math.max(n4 - nArray4[5] * 2, 1);
            if (n3 == nArray4[1] && n4 == nArray4[3]) {
                return false;
            }
            if (this.redrawWindow != 0) {
                int n7 = OS.XtDisplay(this.handle);
                OS.XResizeWindow(n7, this.redrawWindow, n3, n4);
            }
            OS.XtResizeWidget(n5, n3, n4, nArray4[5]);
            this.updateIM();
            this.sendEvent(11);
            return true;
        }
        return false;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true);
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        if (bl) {
            int n2 = OS.XtWindow(this.handle);
            if (n2 == 0) {
                return;
            }
            OS.XGrabPointer(n, n2, 0, 76, 1, 1, 0, 0, 0);
        } else {
            OS.XUngrabPointer(n, 0);
        }
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled() && this != this.getShell()) {
            return;
        }
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int n2 = OS.XtWindow(this.handle);
        if (n2 == 0) {
            return;
        }
        if (cursor == null) {
            OS.XUndefineCursor(n, n2);
        } else {
            if (cursor.isDisposed()) {
                SWT.error(5);
            }
            OS.XDefineCursor(n, n2, cursor.handle);
        }
        OS.XFlush(n);
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x4000) : (this.state &= 0xFFFFBFFF);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (bl == this.getEnabled()) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.enableWidget(bl);
        if (bl2) {
            this.fixFocus(control);
        }
        if (!bl || this.isEnabled() && bl) {
            this.propagateChildren(bl);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = this.fontHandle();
        int[] nArray3 = new int[]{OS.XmNfontList, font.handle};
        OS.XtSetValues(n, nArray3, nArray3.length / 2);
        this.updateIM();
        OS.XtResizeWidget(this.handle, nArray2[1], nArray2[3], nArray2[5]);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color == null) {
            this.state &= 0xFFFFFFDF;
            this.setForegroundPixel(this.defaultForeground());
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            this.state |= 0x20;
            this.setForegroundPixel(color.handle.pixel);
        }
    }

    void setForegroundPixel(int n) {
        int[] nArray = new int[]{OS.XmNforeground, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        return false;
    }

    void setParentBackground() {
        this.setParentBackground(this.handle);
    }

    void setParentBackground(int n) {
        int n2 = OS.XtDisplay(n);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.XtWindow(n);
        if (n3 == 0) {
            return;
        }
        OS.XSetWindowBackgroundPixmap(n2, n3, 1);
    }

    void setParentTraversal() {
        if ((this.parent.style & 0x80000) != 0) {
            int n = this.parent.handle;
            int[] nArray = new int[2];
            nArray[0] = OS.XmNtraversalOn;
            int[] nArray2 = nArray;
            OS.XtGetValues(n, nArray2, nArray2.length / 2);
            if (nArray2[1] == 0) {
                nArray2[1] = 1;
                OS.XtSetValues(n, nArray2, nArray2.length / 2);
                this.parent.overrideTranslations();
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0 && this.redrawWindow != 0) {
                int n = OS.XtDisplay(this.handle);
                if (n == 0) {
                    return;
                }
                int n2 = OS.XtWindow(this.handle);
                if (n2 == 0) {
                    return;
                }
                OS.XDestroyWindow(n, this.redrawWindow);
                OS.XSelectInput(n, n2, OS.XtBuildEventMask(this.handle));
                this.redrawWindow = 0;
            }
        } else if (this.drawCount++ == 0) {
            int n = OS.XtDisplay(this.handle);
            if (n == 0) {
                return;
            }
            int n3 = OS.XtWindow(this.handle);
            if (n3 == 0) {
                return;
            }
            Rectangle rectangle = this.getBounds();
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            xSetWindowAttributes.background_pixmap = 0;
            xSetWindowAttributes.event_mask = 32768;
            int n4 = 6145;
            this.redrawWindow = OS.XCreateWindow(n, n3, 0, 0, rectangle.width, rectangle.height, 0, 0, 0, 0, n4, xSetWindowAttributes);
            if (this.redrawWindow != 0) {
                int n5 = 16364;
                OS.XSelectInput(n, n3, OS.XtBuildEventMask(this.handle) & ~n5);
                OS.XRaiseWindow(n, this.redrawWindow);
                OS.XMapWindow(n, this.redrawWindow);
            }
        }
    }

    public void setRegion(Region region) {
        int n;
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        int n2 = this.topHandle();
        Shell shell = this.getShell();
        if (!OS.XtIsRealized(n2)) {
            shell.realizeWidget();
        }
        if ((n = OS.XtDisplay(n2)) == 0) {
            return;
        }
        int n3 = OS.XtWindow(n2);
        if (n3 == 0) {
            return;
        }
        if (region != null) {
            OS.XShapeCombineRegion(n, n3, 0, 0, 0, region.handle, 0);
        } else {
            OS.XShapeCombineMask(n, n3, 0, 0, 0, 0, 0);
        }
        this.region = region;
    }

    boolean setTabGroupFocus(boolean bl) {
        return this.setTabItemFocus(bl);
    }

    boolean setTabItemFocus(boolean bl) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, point.x, point.y, false, true);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.display.setToolTipText(this.handle, this.toolTipText);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        int n = this.topHandle();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmappedWhenManaged;
        int[] nArray2 = nArray;
        OS.XtGetValues(n, nArray2, nArray2.length / 2);
        if (nArray2[1] != 0 == bl) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        OS.XtSetMappedWhenManaged(n, bl);
        if (bl2) {
            this.fixFocus(control);
        }
        if (this.isDisposed()) {
            return;
        }
        this.sendEvent(bl ? 22 : 23);
    }

    void setZOrder(Control control, boolean bl) {
        this.setZOrder(control, bl, true);
    }

    void setZOrder(Control control, boolean bl, boolean bl2) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4 = this.topHandle();
        int n5 = OS.XtDisplay(n4);
        if (n5 == 0) {
            return;
        }
        if (!OS.XtIsRealized(n4)) {
            Shell shell = this.getShell();
            shell.realizeWidget();
        }
        if ((n3 = OS.XtWindow(n4)) == 0) {
            return;
        }
        int n6 = n2 = bl2 ? this.parent.redrawWindow : 0;
        if (!(control != null || bl && n2 != 0)) {
            if (bl) {
                OS.XRaiseWindow(n5, n3);
                if (bl2) {
                    this.parent.moveAbove(n4, 0);
                }
            } else {
                OS.XLowerWindow(n5, n3);
                if (bl2) {
                    this.parent.moveBelow(n4, 0);
                }
            }
            return;
        }
        int n7 = 0;
        if (control != null) {
            n7 = control.topHandle();
            if (n5 != OS.XtDisplay(n7)) {
                return;
            }
            if (!OS.XtIsRealized(n7)) {
                object = control.getShell();
                ((Shell)object).realizeWidget();
            }
            n = OS.XtWindow(n7);
        } else {
            n = n2;
        }
        if (n == 0) {
            return;
        }
        object = new XWindowChanges();
        ((XWindowChanges)object).sibling = n;
        int n8 = ((XWindowChanges)object).stack_mode = bl ? 0 : 1;
        if (n == n2) {
            ((XWindowChanges)object).stack_mode = 1;
        }
        int n9 = OS.XDefaultScreen(n5);
        int n10 = 96;
        OS.XReconfigureWMWindow(n5, n3, n9, n10, (XWindowChanges)object);
        if (bl) {
            if (bl2) {
                this.parent.moveAbove(n4, n7);
            }
        } else if (bl2) {
            this.parent.moveBelow(n4, n7);
        }
    }

    void showMenu(int n, int n2) {
        Event event = new Event();
        event.x = n;
        event.y = n2;
        this.sendEvent(35, event);
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            if (event.x != n || event.y != n2) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
        }
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
        return new Point(n - sArray[0], n2 - sArray2[0]);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)n, (short)n2, sArray, sArray2);
        return new Point(sArray[0], sArray2[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateAccelerator(char c, int n, XKeyEvent xKeyEvent, boolean bl) {
        return this.menuShell().translateAccelerator(c, n, xKeyEvent, bl);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(char c, int n, XKeyEvent xKeyEvent) {
        int n2;
        if (c < ' ') {
            return false;
        }
        if (xKeyEvent.state == 0 ? ((n2 = this.traversalCode(c, xKeyEvent)) & 0x80) == 0 : (xKeyEvent.state & (n2 = 13)) != 8) {
            return false;
        }
        Decorations decorations = this.menuShell();
        if (decorations.isVisible() && decorations.isEnabled()) {
            Event event = new Event();
            event.time = xKeyEvent.time;
            event.detail = 128;
            event.character = c;
            event.keyCode = n;
            if (this.setInputState(event, xKeyEvent.state)) {
                return this.translateMnemonic(event, null) || decorations.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(int n, XKeyEvent xKeyEvent) {
        int n2 = 0;
        int n3 = this.traversalCode(n, xKeyEvent);
        boolean bl = false;
        switch (n) {
            case 65307: {
                bl = true;
                n2 = 2;
                break;
            }
            case 65293: 
            case 65421: {
                bl = true;
                n2 = 4;
                break;
            }
            case 65289: {
                boolean bl2 = (xKeyEvent.state & 1) == 0;
                n2 = bl2 ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean bl2 = n == 65364 || n == 65363;
                n2 = bl2 ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                bl = true;
                if ((xKeyEvent.state & 4) == 0) {
                    return false;
                }
                n2 = n == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (n3 & n2) != 0;
        event.detail = n2;
        event.time = xKeyEvent.time;
        if (!this.setKeyState(event, xKeyEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl && control != null);
        return false;
    }

    int traversalCode(int n, XKeyEvent xKeyEvent) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtraversalOn;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] == 0) {
            return 0;
        }
        int n2 = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            n2 |= 2;
        }
        if (this.getNavigationType() == 0) {
            n2 |= 0x60;
        }
        return n2;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        Control control = this.computeTabRoot();
        Control control2 = this.computeTabGroup();
        Control[] controlArray = control.computeTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == control2) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control3 = controlArray[n2];
            if (control3.isDisposed() || !control3.setTabGroupFocus(bl)) continue;
            return true;
        }
        if (control2.isDisposed()) {
            return false;
        }
        return control2.setTabGroupFocus(bl);
    }

    boolean traverseItem(boolean bl) {
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == this) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus(bl)) continue;
            return true;
        }
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseMnemonic(char c) {
        return this.mnemonicHit(c);
    }

    boolean traverseReturn() {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean bl) {
        if (bl) {
            this.display.update();
        } else {
            int n = OS.XtDisplay(this.handle);
            if (n == 0) {
                return;
            }
            int n2 = OS.XtWindow(this.handle);
            if (n2 == 0) {
                return;
            }
            int n3 = OS.XtMalloc(96);
            OS.XSync(n, false);
            OS.XSync(n, false);
            while (OS.XCheckWindowEvent(n, n2, 32768, n3)) {
                OS.XtDispatchEvent(n3);
            }
            OS.XtFree(n3);
        }
    }

    void updateBackgroundMode() {
        int n = this.state & 0x40;
        this.checkBackground();
        if (n != (this.state & 0x40)) {
            this.setBackground();
        }
    }

    void updateIM() {
        int n;
        int[] nArray;
        if (!OS.IsDBLocale) {
            return;
        }
        if (!this.hasFocus()) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.hasIMSupport()) {
            nArray = new int[]{OS.XmNfontList, this.font.handle};
        } else {
            n = 0;
            int n4 = 0;
            Font font = this.font;
            Caret caret = this.getIMCaret();
            if (caret != null) {
                n += caret.x + (caret.width <= 0 ? 2 : caret.width);
                n4 += caret.y;
                if (caret.font != null) {
                    font = caret.font;
                }
            }
            short[] sArray = new short[]{(short)n, (short)(n4 += this.getFontAscent(font.handle))};
            n2 = OS.XtMalloc(4);
            OS.memmove(n2, sArray, 4);
            int[] nArray2 = new int[4];
            nArray2[0] = OS.XmNwidth;
            nArray2[2] = OS.XmNheight;
            int[] nArray3 = nArray2;
            OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
            short[] sArray2 = new short[4];
            sArray2[2] = (short)nArray3[1];
            sArray2[3] = (short)nArray3[3];
            short[] sArray3 = sArray2;
            n3 = OS.XtMalloc(8);
            OS.memmove(n3, sArray3, 8);
            nArray = new int[]{OS.XmNfontList, font.handle, OS.XmNspotLocation, n2, OS.XmNarea, n3};
        }
        OS.XmImSetValues(this.handle, nArray, nArray.length / 2);
        n = this.focusHandle();
        if (this.handle != n) {
            OS.XmImSetValues(n, nArray, nArray.length / 2);
        }
        if (n2 != 0) {
            OS.XtFree(n2);
        }
        if (n3 != 0) {
            OS.XtFree(n3);
        }
    }

    void updateLayout(boolean bl) {
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        Display display = this.display;
        display.hideToolTip();
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        boolean bl = true;
        boolean bl2 = false;
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        int n5 = display.getDoubleClickTime();
        int n6 = display.lastTime;
        int n7 = xButtonEvent.time;
        int n8 = display.lastButton;
        int n9 = xButtonEvent.button;
        display.clickCount = n8 == n9 && n6 != 0 && Math.abs(n6 - n7) <= n5 ? ++display.clickCount : 1;
        display.lastTime = n7 == 0 ? 1 : n7;
        display.lastButton = n9;
        if (xButtonEvent.button == 2 && (this.state & 0x4000) != 0 && this.hooks(29)) {
            boolean[] blArray = new boolean[1];
            if (this.dragDetect(xButtonEvent.x, xButtonEvent.y, true, blArray)) {
                bl2 = true;
                boolean bl3 = bl = !blArray[0];
            }
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (!this.sendMouseEvent(3, xButtonEvent)) {
            bl = false;
        }
        if (this.isDisposed()) {
            return 1;
        }
        if (display.clickCount == 2) {
            if (!this.sendMouseEvent(8, xButtonEvent)) {
                bl = false;
            }
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (bl2) {
            this.sendDragEvent(xButtonEvent.button, xButtonEvent.state, xButtonEvent.x, xButtonEvent.y, false);
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (xButtonEvent.button == 3) {
            if ((this.menu != null || this.hooks(35)) && !this.isFocusControl()) {
                this.setFocus();
            }
            this.showMenu(xButtonEvent.x_root, xButtonEvent.y_root);
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        if (!bl) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XButtonRelease(int n, int n2, int n3, int n4) {
        this.display.hideToolTip();
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        if (!this.sendMouseEvent(4, xButtonEvent)) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XEnterWindow(int n, int n2, int n3, int n4) {
        XCrossingEvent xCrossingEvent = new XCrossingEvent();
        OS.memmove(xCrossingEvent, n3, 68);
        if (xCrossingEvent.mode != 0 && xCrossingEvent.mode != 2) {
            return 0;
        }
        if ((xCrossingEvent.state & 0x700) != 0) {
            return 0;
        }
        if (xCrossingEvent.subwindow != 0) {
            return 0;
        }
        if (!this.sendMouseEvent(6, xCrossingEvent)) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XExposure(int n, int n2, int n3, int n4) {
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        XExposeEvent xExposeEvent = new XExposeEvent();
        OS.memmove(xExposeEvent, n3, 40);
        int n5 = OS.XtDisplay(this.handle);
        if (n5 == 0) {
            return 0;
        }
        int n6 = OS.XCreateRegion();
        OS.XtAddExposureToRegion(n3, n6);
        Event event = new Event();
        event.count = xExposeEvent.count;
        event.x = xExposeEvent.x;
        event.y = xExposeEvent.y;
        event.width = xExposeEvent.width;
        event.height = xExposeEvent.height;
        GCData gCData = new GCData();
        gCData.damageRgn = n6;
        GC gC = event.gc = GC.motif_new(this, gCData);
        OS.XSetRegion(n5, gC.handle, n6);
        this.sendEvent(9, event);
        event.gc = null;
        gC.dispose();
        OS.XDestroyRegion(n6);
        return 0;
    }

    int XFocusChange(int n, int n2, int n3, int n4) {
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent();
        OS.memmove(xFocusChangeEvent, n3, 28);
        if (xFocusChangeEvent.mode != 0) {
            return 0;
        }
        if (xFocusChangeEvent.detail != 0 && xFocusChangeEvent.detail != 2 && xFocusChangeEvent.detail != 3) {
            return 0;
        }
        Display display = this.display;
        Shell shell = this.getShell();
        switch (xFocusChangeEvent.type) {
            case 9: {
                this.xFocusIn(xFocusChangeEvent);
                if (shell.isDisposed()) break;
                shell.setActiveControl(this);
                break;
            }
            case 10: {
                this.xFocusOut(xFocusChangeEvent);
                if (shell.isDisposed() || shell == display.getActiveShell()) break;
                shell.setActiveControl(null);
            }
        }
        return 0;
    }

    int xFocusIn(XFocusChangeEvent xFocusChangeEvent) {
        this.updateIM();
        if (!this.hasIMSupport()) {
            int n = OS.XtWindowToWidget(xFocusChangeEvent.display, xFocusChangeEvent.window);
            OS.XmImSetFocusValues(n, null, 0);
        }
        this.sendFocusEvent(15);
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xFocusChangeEvent) {
        int n;
        int n2 = OS.XtWindowToWidget(xFocusChangeEvent.display, xFocusChangeEvent.window);
        if (!this.hasIMSupport()) {
            OS.XmImUnsetFocus(n2);
        }
        if (!OS.IsAIX && this.font.handle != (n = this.defaultFont().handle)) {
            int[] nArray = new int[]{OS.XmNfontList, n};
            OS.XmImSetValues(n2, nArray, nArray.length / 2);
        }
        this.sendFocusEvent(16);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 0x80000) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNtraversalOn;
            int[] nArray2 = nArray;
            OS.XtGetValues(n2, nArray2, nArray2.length / 2);
            if (nArray2[1] != 0 && (this.state & 8) != 0) {
                nArray2[1] = 0;
                OS.XtSetValues(n2, nArray2, nArray2.length / 2);
            }
        }
        return 0;
    }

    int XKeyRelease(int n, int n2, int n3, int n4) {
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        if (this.menu != null && xKeyEvent.state == 1) {
            byte[] byArray = new byte[1];
            int[] nArray = new int[1];
            OS.XLookupString(xKeyEvent, byArray, byArray.length, nArray, null);
            if (nArray[0] == 65479) {
                this.showMenu(xKeyEvent.x_root, xKeyEvent.y_root);
            }
        }
        return super.XKeyRelease(n, n2, n3, n4);
    }

    int XLeaveWindow(int n, int n2, int n3, int n4) {
        this.display.removeMouseHoverTimeOut();
        this.display.hideToolTip();
        XCrossingEvent xCrossingEvent = new XCrossingEvent();
        OS.memmove(xCrossingEvent, n3, 68);
        if (xCrossingEvent.mode != 0 && xCrossingEvent.mode != 2) {
            return 0;
        }
        if ((xCrossingEvent.state & 0x700) != 0) {
            return 0;
        }
        if (xCrossingEvent.subwindow != 0) {
            return 0;
        }
        if (!this.sendMouseEvent(7, xCrossingEvent)) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XmNhelpCallback(int n, int n2, int n3) {
        this.sendHelpEvent(n3);
        return 0;
    }

    int XPointerMotion(int n, int n2, int n3, int n4) {
        this.display.addMouseHoverTimeOut(this.handle);
        XMotionEvent xMotionEvent = new XMotionEvent();
        OS.memmove(xMotionEvent, n3, 60);
        if (!this.sendMouseEvent(5, xMotionEvent)) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }
}

