/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    int targetList;
    boolean moveData = false;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static Callback DragGetData = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragGetData", 5);
    static Callback DragEnd;
    static Callback DragDataDelete;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DragSource;

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        this.control = control;
        if (DragGetData == null || DragEnd == null || DragDataDelete == null) {
            DND.error(2000);
        }
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        OS.g_signal_connect(control.handle, OS.drag_data_get, DragGetData.getAddress(), 0);
        OS.g_signal_connect(control.handle, OS.drag_end, DragEnd.getAddress(), 0);
        OS.g_signal_connect(control.handle, OS.drag_data_delete, DragDataDelete.getAddress(), 0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static int DragDataDelete(int n, int n2) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        dragSource.dragDataDelete(n, n2);
        return 0;
    }

    static int DragEnd(int n, int n2) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        dragSource.dragEnd(n, n2);
        return 0;
    }

    static int DragGetData(int n, int n2, int n3, int n4, int n5) {
        DragSource dragSource = DragSource.FindDragSource(n);
        if (dragSource == null) {
            return 0;
        }
        dragSource.dragGetData(n, n2, n3, n4, n5);
        return 0;
    }

    static DragSource FindDragSource(int n) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = (class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource).getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    void drag(Event event) {
        this.moveData = false;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.x = event.x;
        dNDEvent.y = event.y;
        dNDEvent.time = event.time;
        dNDEvent.doit = true;
        this.notifyListeners(2008, dNDEvent);
        if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        if (this.targetList == 0) {
            return;
        }
        int n = this.opToOsOp(this.getStyle());
        Image image = dNDEvent.image;
        int n2 = OS.gtk_drag_begin(this.control.handle, this.targetList, n, 1, 0);
        if (n2 != 0 && image != null) {
            if (OS.GTK3) {
                OS.gtk_drag_set_icon_surface(n2, image.surface);
            } else {
                int n3 = ImageList.createPixbuf(image);
                OS.gtk_drag_set_icon_pixbuf(n2, n3, 0, 0);
                OS.g_object_unref(n3);
            }
        }
    }

    void dragEnd(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (OS.GTK3) {
            n5 = OS.gdk_window_get_display(OS.gtk_widget_get_window(n));
            n4 = OS.gdk_display_get_device_manager(n5);
            n3 = OS.gdk_device_manager_get_client_pointer(n4);
            int n6 = OS.gdk_device_get_associated_device(n3);
            OS.gdk_device_ungrab(n3, 0);
            OS.gdk_device_ungrab(n6, 0);
        } else {
            OS.gdk_pointer_ungrab(0);
            OS.gdk_keyboard_ungrab(0);
        }
        n5 = 0;
        if (n2 != 0) {
            n4 = 0;
            n3 = 0;
            if (OS.GTK3) {
                n4 = OS.gdk_drag_context_get_dest_window(n2);
                n3 = OS.gdk_drag_context_get_selected_action(n2);
            } else {
                GdkDragContext gdkDragContext = new GdkDragContext();
                OS.memmove(gdkDragContext, n2, GdkDragContext.sizeof);
                n4 = gdkDragContext.dest_window;
                n3 = gdkDragContext.action;
            }
            if (n4 != 0) {
                if (this.moveData) {
                    n5 = 2;
                } else {
                    n5 = this.osOpToOp(n3);
                    if (n5 == 2) {
                        n5 = 0;
                    }
                }
            }
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.doit = n5 != 0;
        dNDEvent.detail = n5;
        this.notifyListeners(2000, dNDEvent);
        this.moveData = false;
    }

    void dragGetData(int n, int n2, int n3, int n4, int n5) {
        Object object;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n3 == 0) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            n9 = OS.gtk_selection_data_get_length(n3);
            n8 = OS.gtk_selection_data_get_format(n3);
            n7 = OS.gtk_selection_data_get_data(n3);
            n6 = OS.gtk_selection_data_get_target(n3);
        } else {
            object = new GtkSelectionData();
            OS.memmove((GtkSelectionData)object, n3, GtkSelectionData.sizeof);
            n9 = ((GtkSelectionData)object).length;
            n8 = ((GtkSelectionData)object).format;
            n7 = ((GtkSelectionData)object).data;
            n6 = ((GtkSelectionData)object).target;
        }
        if (n6 == 0) {
            return;
        }
        object = new TransferData();
        ((TransferData)object).type = n6;
        ((TransferData)object).pValue = n7;
        ((TransferData)object).length = n9;
        ((TransferData)object).format = n8;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = n5;
        dNDEvent.dataType = object;
        this.notifyListeners(2001, dNDEvent);
        if (!dNDEvent.doit) {
            return;
        }
        Transfer transfer = null;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transfer2 = this.transferAgents[i];
            if (transfer2 == null || !transfer2.isSupportedType((TransferData)object)) continue;
            transfer = transfer2;
            break;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(dNDEvent.data, (TransferData)object);
        if (((TransferData)object).result != 1) {
            return;
        }
        OS.gtk_selection_data_set(n3, ((TransferData)object).type, ((TransferData)object).format, ((TransferData)object).pValue, ((TransferData)object).length);
        OS.g_free(((TransferData)object).pValue);
    }

    void dragDataDelete(int n, int n2) {
        this.moveData = true;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listenerArray = this.getListeners(2008);
        int n = listenerArray.length;
        DragSourceListener[] dragSourceListenerArray = new DragSourceListener[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Listener listener = listenerArray[i];
            if (!(listener instanceof DNDListener)) continue;
            dragSourceListenerArray[n2] = (DragSourceListener)((DNDListener)listener).getEventListener();
            ++n2;
        }
        if (n2 == n) {
            return dragSourceListenerArray;
        }
        DragSourceListener[] dragSourceListenerArray2 = new DragSourceListener[n2];
        System.arraycopy(dragSourceListenerArray, 0, dragSourceListenerArray2, 0, n2);
        return dragSourceListenerArray2;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.targetList != 0) {
            OS.gtk_target_list_unref(this.targetList);
        }
        this.targetList = 0;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 2;
        }
        if ((n & 2) == 2) {
            n2 |= 4;
        }
        if ((n & 4) == 4) {
            n2 |= 8;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 2) == 2) {
            n2 |= 1;
        }
        if ((n & 4) == 4) {
            n2 |= 2;
        }
        if ((n & 8) == 8) {
            n2 |= 4;
        }
        return n2;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer[] transferArray) {
        int n;
        int n2;
        if (this.targetList != 0) {
            OS.gtk_target_list_unref(this.targetList);
            this.targetList = 0;
        }
        this.transferAgents = transferArray;
        if (transferArray == null || transferArray.length == 0) {
            return;
        }
        GtkTargetEntry[] gtkTargetEntryArray = new GtkTargetEntry[]{};
        for (n2 = 0; n2 < transferArray.length; ++n2) {
            Transfer transfer = transferArray[n2];
            if (transfer == null) continue;
            int[] nArray = transfer.getTypeIds();
            String[] stringArray = transfer.getTypeNames();
            for (int i = 0; i < nArray.length; ++i) {
                GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                byte[] byArray = Converter.wcsToMbcs(null, stringArray[i], true);
                gtkTargetEntry.target = OS.g_malloc(byArray.length);
                OS.memmove(gtkTargetEntry.target, byArray, byArray.length);
                gtkTargetEntry.info = nArray[i];
                GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                gtkTargetEntryArray = gtkTargetEntryArray2;
            }
        }
        n2 = OS.g_malloc(gtkTargetEntryArray.length * GtkTargetEntry.sizeof);
        for (n = 0; n < gtkTargetEntryArray.length; ++n) {
            OS.memmove(n2 + n * GtkTargetEntry.sizeof, gtkTargetEntryArray[n], GtkTargetEntry.sizeof);
        }
        this.targetList = OS.gtk_target_list_new(n2, gtkTargetEntryArray.length);
        for (n = 0; n < gtkTargetEntryArray.length; ++n) {
            OS.g_free(gtkTargetEntryArray[n].target);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (DragGetData.getAddress() == 0) {
            SWT.error(3);
        }
        if ((DragEnd = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragEnd", 2)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((DragDataDelete = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragDataDelete", 2)).getAddress() == 0) {
            SWT.error(3);
        }
    }
}

