/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Region
extends Resource {
    public int handle;
    NSAffineTransform transform;
    NSPoint pt = new NSPoint();
    short[] rect = new short[4];

    public Region() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region(Device device) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = OS.NewRgn();
            if (this.handle == 0) {
                SWT.error(2);
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    Region(Device device, int n) {
        super(device);
        this.handle = n;
    }

    public static Region cocoa_new(Device device, int n) {
        return new Region(device, n);
    }

    static int polyToRgn(int[] nArray, int n) {
        short[] sArray = new short[4];
        int n2 = OS.NewRgn();
        int n3 = OS.NewRgn();
        int n4 = nArray[1];
        int n5 = nArray[1];
        for (int i = 3; i < n; i += 2) {
            if (nArray[i] < n4) {
                n4 = nArray[i];
            }
            if (nArray[i] <= n5) continue;
            n5 = nArray[i];
        }
        int[] nArray2 = new int[n + 1];
        for (int i = n4; i <= n5; ++i) {
            int n6;
            int n7;
            int n8;
            int n9 = 0;
            int n10 = nArray[0];
            int n11 = nArray[1];
            for (n8 = 2; n8 < n; n8 += 2) {
                n7 = nArray[n8];
                n6 = nArray[n8 + 1];
                if (n11 != n6 && (n11 <= i && i < n6 || n6 <= i && i < n11)) {
                    nArray2[n9++] = (int)((float)(i - n11) / (float)(n6 - n11) * (float)(n7 - n10) + (float)n10 + 0.5f);
                }
                n10 = n7;
                n11 = n6;
            }
            n8 = nArray[0];
            n7 = nArray[1];
            if (n11 != n7 && (n11 <= i && i < n7 || n7 <= i && i < n11)) {
                nArray2[n9++] = (int)((float)(i - n11) / (float)(n7 - n11) * (float)(n8 - n10) + (float)n10 + 0.5f);
            }
            for (n6 = n9 / 2; n6 > 0; n6 /= 2) {
                for (int j = n6; j < n9; ++j) {
                    for (int k = j - n6; k >= 0 && nArray2[k] - nArray2[k + n6] > 0; k -= n6) {
                        int n12 = nArray2[k];
                        nArray2[k] = nArray2[k + n6];
                        nArray2[k + n6] = n12;
                    }
                }
            }
            for (n6 = 0; n6 < n9; n6 += 2) {
                OS.SetRect(sArray, (short)nArray2[n6], (short)i, (short)nArray2[n6 + 1], (short)(i + 1));
                OS.RectRgn(n3, sArray);
                OS.UnionRgn(n2, n3, n2);
            }
        }
        OS.DisposeRgn(n3);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int polyRgn(int[] nArray, int n) {
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n2;
            int n3;
            if (C.PTR_SIZEOF == 4) {
                n3 = OS.NewRgn();
                OS.OpenRgn();
                OS.MoveTo((short)nArray[0], (short)nArray[1]);
                for (n2 = 1; n2 < n / 2; ++n2) {
                    OS.LineTo((short)nArray[2 * n2], (short)nArray[2 * n2 + 1]);
                }
                OS.LineTo((short)nArray[0], (short)nArray[1]);
                OS.CloseRgn(n3);
            } else {
                n3 = Region.polyToRgn(nArray, n);
            }
            n2 = n3;
            return n2;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(nArray, nArray.length);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int[] nArray, int n) {
        if ((n = n / 2 * 2) <= 2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n2 = Region.polyRgn(nArray, n);
            OS.UnionRgn(this.handle, n2, this.handle);
            OS.DisposeRgn(n2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (rectangle.width < 0 || rectangle.height < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n5 = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            OS.RectRgn(n5, sArray);
            OS.UnionRgn(this.handle, n5, this.handle);
            OS.DisposeRgn(n5);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.UnionRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[]{(short)n2, (short)n};
            boolean bl = OS.PtInRgn(sArray, this.handle);
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    void convertRgn(NSAffineTransform nSAffineTransform) {
        int n = OS.NewRgn();
        Callback callback = new Callback(this, "convertRgn", 4);
        int n2 = callback.getAddress();
        if (n2 == 0) {
            SWT.error(3);
        }
        this.transform = nSAffineTransform;
        OS.QDRegionToRects(this.handle, 5, n2, n);
        this.transform = null;
        callback.dispose();
        OS.CopyRgn(n, this.handle);
        OS.DisposeRgn(n);
    }

    int convertRgn(int n, int n2, int n3, int n4) {
        if (n == 2) {
            short[] sArray = new short[4];
            OS.memmove(sArray, n3, sArray.length * 2);
            int n5 = 0;
            NSPoint nSPoint = new NSPoint();
            int[] nArray = new int[10];
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[0];
            nSPoint = this.transform.transformPoint(nSPoint);
            int n6 = n5++;
            short s = (short)nSPoint.x;
            nArray[n6] = s;
            int n7 = n5++;
            short s2 = (short)nSPoint.y;
            nArray[n7] = s2;
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[0];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n5++] = (short)Math.round(nSPoint.x);
            nArray[n5++] = (short)nSPoint.y;
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[2];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n5++] = (short)Math.round(nSPoint.x);
            nArray[n5++] = (short)Math.round(nSPoint.y);
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[2];
            nSPoint = this.transform.transformPoint(nSPoint);
            nArray[n5++] = (short)nSPoint.x;
            nArray[n5++] = (short)Math.round(nSPoint.y);
            nArray[n5++] = s;
            nArray[n5++] = s2;
            int n8 = Region.polyRgn(nArray, nArray.length);
            OS.UnionRgn(n4, n8, n4);
            OS.DisposeRgn(n8);
        }
        return 0;
    }

    void destroy() {
        OS.DisposeRgn(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[4];
            OS.GetRegionBounds(this.handle, sArray);
            int n = sArray[3] - sArray[1];
            int n2 = sArray[2] - sArray[0];
            Rectangle rectangle = new Rectangle(sArray[1], sArray[0], n, n2);
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    NSBezierPath getPath() {
        Callback callback = new Callback(this, "regionToRects", 4);
        if (callback.getAddress() == 0) {
            SWT.error(3);
        }
        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
        nSBezierPath.retain();
        OS.QDRegionToRects(this.handle, 5, callback.getAddress(), nSBezierPath.id);
        callback.dispose();
        if (nSBezierPath.isEmpty()) {
            nSBezierPath.appendBezierPathWithRect(new NSRect());
        }
        return nSBezierPath;
    }

    int regionToRects(int n, int n2, int n3, int n4) {
        if (n == 2) {
            OS.memmove(this.rect, n3, this.rect.length * 2);
            this.pt.x = this.rect[1];
            this.pt.y = this.rect[0];
            OS.objc_msgSend(n4, OS.sel_moveToPoint_, this.pt);
            this.pt.x = this.rect[3];
            OS.objc_msgSend(n4, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[3];
            this.pt.y = this.rect[2];
            OS.objc_msgSend(n4, OS.sel_lineToPoint_, this.pt);
            this.pt.x = this.rect[1];
            OS.objc_msgSend(n4, OS.sel_lineToPoint_, this.pt);
            OS.objc_msgSend(n4, OS.sel_closePath);
        }
        return 0;
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n5 = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            OS.RectRgn(n5, sArray);
            OS.SectRgn(this.handle, n5, this.handle);
            OS.DisposeRgn(n5);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.SectRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            boolean bl = OS.RectInRgn(sArray, this.handle);
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            boolean bl = OS.EmptyRgn(this.handle);
            return bl;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 2) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n = Region.polyRgn(nArray, nArray.length);
            OS.DiffRgn(this.handle, n, this.handle);
            OS.DisposeRgn(n);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n5 = OS.NewRgn();
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
            OS.RectRgn(n5, sArray);
            OS.DiffRgn(this.handle, n5, this.handle);
            OS.DisposeRgn(n5);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.DiffRgn(this.handle, region.handle, this.handle);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            OS.OffsetRgn(this.handle, (short)n, (short)n2);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.translate(point.x, point.y);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

