/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageRep;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public NSImage handle;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, int n, int n2) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(n, n2);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Image image, int n) {
        super(device);
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            device = this.device;
            this.type = image.type;
            NSSize nSSize = image.handle.size();
            int n2 = (int)nSSize.width;
            int n3 = (int)nSSize.height;
            NSBitmapImageRep nSBitmapImageRep = image.getRepresentation();
            int n4 = nSBitmapImageRep.bytesPerRow();
            this.transparentPixel = image.transparentPixel;
            this.alpha = image.alpha;
            if (image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            int n5 = nSBitmapImageRep.bitmapData();
            int n6 = nSBitmapImageRep.bitmapFormat();
            int n7 = nSBitmapImageRep.bitsPerPixel();
            this.handle = (NSImage)new NSImage().alloc();
            this.handle = this.handle.initWithSize(nSSize);
            NSBitmapImageRep nSBitmapImageRep2 = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            nSBitmapImageRep2 = nSBitmapImageRep2.initWithBitmapDataPlanes(0, n2, n3, nSBitmapImageRep.bitsPerSample(), nSBitmapImageRep.samplesPerPixel(), nSBitmapImageRep.hasAlpha(), nSBitmapImageRep.isPlanar(), OS.NSDeviceRGBColorSpace, n6, nSBitmapImageRep.bytesPerRow(), n7);
            this.handle.addRepresentation(nSBitmapImageRep2);
            nSBitmapImageRep2.release();
            this.handle.setCacheMode(3);
            int n8 = nSBitmapImageRep2.bitmapData();
            OS.memmove(n8, n5, n2 * n3 * 4);
            if (n != 0) {
                int n9;
                int n10;
                int n11;
                if (n7 == 32 && (n6 & 1) == 0) {
                    n11 = 0;
                    n10 = 1;
                    n9 = 2;
                } else {
                    n11 = 1;
                    n10 = 2;
                    n9 = 3;
                }
                switch (n) {
                    case 1: {
                        Color color = device.getSystemColor(18);
                        RGB rGB = color.getRGB();
                        byte by = (byte)rGB.red;
                        byte by2 = (byte)rGB.green;
                        byte by3 = (byte)rGB.blue;
                        Color color2 = device.getSystemColor(22);
                        RGB rGB2 = color2.getRGB();
                        byte by4 = (byte)rGB2.red;
                        byte by5 = (byte)rGB2.green;
                        byte by6 = (byte)rGB2.blue;
                        byte[] byArray = new byte[n4];
                        for (int i = 0; i < n3; ++i) {
                            OS.memmove(byArray, n8 + i * n4, n4);
                            int n12 = 0;
                            for (int j = 0; j < n2; ++j) {
                                int n13 = byArray[n12 + n11] & 0xFF;
                                int n14 = byArray[n12 + n10] & 0xFF;
                                int n15 = byArray[n12 + n9] & 0xFF;
                                int n16 = n13 * n13 + n14 * n14 + n15 * n15;
                                if (n16 < 98304) {
                                    byArray[n12 + n11] = by;
                                    byArray[n12 + n10] = by2;
                                    byArray[n12 + n9] = by3;
                                } else {
                                    byArray[n12 + n11] = by4;
                                    byArray[n12 + n10] = by5;
                                    byArray[n12 + n9] = by6;
                                }
                                n12 += 4;
                            }
                            OS.memmove(n8 + i * n4, byArray, n4);
                        }
                        break;
                    }
                    case 2: {
                        byte[] byArray = new byte[n4];
                        for (int i = 0; i < n3; ++i) {
                            OS.memmove(byArray, n8 + i * n4, n4);
                            int n17 = 0;
                            for (int j = 0; j < n2; ++j) {
                                byte by;
                                int n18 = byArray[n17 + n11] & 0xFF;
                                int n19 = byArray[n17 + n10] & 0xFF;
                                int n20 = byArray[n17 + n9] & 0xFF;
                                byte by7 = by = (byte)(n18 + n18 + n19 + n19 + n19 + n19 + n19 + n20 >> 3);
                                byArray[n17 + n9] = by7;
                                byArray[n17 + n10] = by7;
                                byArray[n17 + n11] = by7;
                                n17 += 4;
                            }
                            OS.memmove(n8 + i * n4, byArray, n4);
                        }
                        break;
                    }
                }
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(rectangle.width, rectangle.height);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData imageData) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(imageData);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            imageData2 = ImageData.convertMask(imageData2);
            ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
            imageData3.maskPad = imageData2.scanlinePad;
            imageData3.maskData = imageData2.data;
            this.init(imageData3);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, InputStream inputStream) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(new ImageData(inputStream));
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image(Device device, String string) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (string == null) {
                SWT.error(4);
            }
            this.initNative(string);
            if (this.handle == null) {
                this.init(new ImageData(string));
            }
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createAlpha() {
        if (this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            int n = nSBitmapImageRep.pixelsHigh();
            int n2 = nSBitmapImageRep.bytesPerRow();
            int n3 = nSBitmapImageRep.bitmapData();
            int n4 = nSBitmapImageRep.bitmapFormat();
            int n5 = n * n2;
            byte[] byArray = new byte[n5];
            OS.memmove(byArray, n3, n5);
            if (this.transparentPixel != -1) {
                if ((n4 & 1) != 0) {
                    for (int i = 0; i < n5; i += 4) {
                        int n6 = (byArray[i + 1] & 0xFF) << 16 | (byArray[i + 2] & 0xFF) << 8 | byArray[i + 3] & 0xFF;
                        byArray[i] = (byte)(n6 == this.transparentPixel ? 0 : 255);
                    }
                } else {
                    for (int i = 0; i < n5; i += 4) {
                        int n7 = (byArray[i + 0] & 0xFF) << 16 | (byArray[i + 1] & 0xFF) << 8 | byArray[i + 2] & 0xFF;
                        byArray[i] = (byte)(n7 == this.transparentPixel ? 0 : 255);
                    }
                }
            } else if (this.alpha != -1) {
                int n8;
                byte by = (byte)this.alpha;
                int n9 = n8 = (n4 & 1) != 0 ? 0 : 3;
                while (n8 < n5) {
                    byArray[n8] = by;
                    n8 += 4;
                }
            } else {
                int n10 = nSBitmapImageRep.pixelsWide();
                int n11 = 0;
                int n12 = (n4 & 1) != 0 ? 0 : 3;
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n10; ++j) {
                        byArray[n11] = this.alphaData[n12];
                        n11 += 4;
                        ++n12;
                    }
                }
            }
            nSBitmapImageRep.setAlpha(true);
            OS.memmove(n3, byArray, n5);
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        this.handle.release();
        this.handle = null;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle && this.transparentPixel == image.transparentPixel;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int n = this.transparentPixel >> 16 & 0xFF;
        int n2 = this.transparentPixel >> 8 & 0xFF;
        int n3 = this.transparentPixel >> 0 & 0xFF;
        return Color.cocoa_new(this.device, new float[]{(float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (this.width != -1 && this.height != -1) {
                Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
                return rectangle;
            }
            NSSize nSSize = this.handle.size();
            this.width = (int)nSSize.width;
            this.height = (int)nSSize.height;
            Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
            return rectangle;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n;
            int n2;
            Object object;
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            int n3 = nSBitmapImageRep.pixelsWide();
            int n4 = nSBitmapImageRep.pixelsHigh();
            int n5 = nSBitmapImageRep.bytesPerRow();
            int n6 = nSBitmapImageRep.bitsPerPixel();
            int n7 = nSBitmapImageRep.bitmapData();
            int n8 = nSBitmapImageRep.bitmapFormat();
            int n9 = n4 * n5;
            byte[] byArray = new byte[n9];
            OS.memmove(byArray, n7, n9);
            PaletteData paletteData = n6 == 32 && (n8 & 1) == 0 ? new PaletteData(-16777216, 0xFF0000, 65280) : new PaletteData(0xFF0000, 65280, 255);
            ImageData imageData = new ImageData(n3, n4, n6, paletteData, 1, byArray);
            imageData.bytesPerLine = n5;
            if (nSBitmapImageRep.hasAlpha() && this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
                object = new byte[n3 * n4];
                n2 = (n8 & 1) != 0 ? 0 : 3;
                int n10 = 0;
                for (n = n2; n < byArray.length; n += 4) {
                    object[n10++] = byArray[n];
                }
                imageData.alphaData = object;
            } else {
                imageData.transparentPixel = this.transparentPixel;
                if (this.transparentPixel == -1 && this.type == 1) {
                    int n11 = 2;
                    n2 = ((n3 + 7) / 8 + (n11 - 1)) / n11 * n11;
                    byte[] byArray2 = new byte[n4 * n2];
                    n = 0;
                    int n12 = 0;
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            if (byArray[n] != 0) {
                                int n13 = n12 + (j >> 3);
                                byArray2[n13] = (byte)(byArray2[n13] | 1 << 7 - (j & 7));
                            } else {
                                int n14 = n12 + (j >> 3);
                                byArray2[n14] = (byte)(byArray2[n14] & ~(1 << 7 - (j & 7)));
                            }
                            n += 4;
                        }
                        n12 += n2;
                    }
                    imageData.maskData = byArray2;
                    imageData.maskPad = n11;
                }
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
            }
            if (n6 == 32) {
                int n15;
                for (n2 = n15 = (n8 & 1) != 0 ? 0 : 3; n2 < byArray.length; n2 += 4) {
                    byArray[n2] = 0;
                }
            }
            object = imageData;
            return object;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public static Image cocoa_new(Device device, int n, NSImage nSImage) {
        Image image = new Image(device);
        image.type = n;
        image.handle = nSImage;
        return image;
    }

    NSBitmapImageRep getRepresentation() {
        int n;
        NSBitmapImageRep nSBitmapImageRep = new NSBitmapImageRep(this.handle.bestRepresentationForDevice(null));
        if (nSBitmapImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
            return nSBitmapImageRep;
        }
        NSArray nSArray = this.handle.representations();
        NSSize nSSize = this.handle.size();
        int n2 = nSArray.count();
        NSObject nSObject = null;
        for (n = 0; n < n2; ++n) {
            nSBitmapImageRep = new NSBitmapImageRep(nSArray.objectAtIndex(n));
            if (nSBitmapImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return nSBitmapImageRep;
            }
            if (nSObject != null && ((int)nSSize.width != nSBitmapImageRep.pixelsWide() || (int)nSSize.height != nSBitmapImageRep.pixelsHigh())) continue;
            nSObject = nSBitmapImageRep;
        }
        nSObject.retain();
        for (n = 0; n < n2; ++n) {
            this.handle.removeRepresentation(new NSImageRep(this.handle.representations().objectAtIndex(0)));
        }
        this.handle.addRepresentation((NSImageRep)nSObject);
        NSBitmapImageRep nSBitmapImageRep2 = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep2 = nSBitmapImageRep2.initWithData(this.handle.TIFFRepresentation());
        this.handle.addRepresentation(nSBitmapImageRep2);
        this.handle.removeRepresentation((NSImageRep)nSObject);
        nSObject.release();
        nSBitmapImageRep2.release();
        return nSBitmapImageRep2;
    }

    public int hashCode() {
        return this.handle != null ? this.handle.id : 0;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        this.width = n;
        this.height = n2;
        this.handle = (NSImage)new NSImage().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = n;
        nSSize.height = n2;
        this.handle = this.handle.initWithSize(nSSize);
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0, n, n2, 8, 3, false, false, OS.NSDeviceRGBColorSpace, 3, n * 4, 32);
        OS.memset(nSBitmapImageRep.bitmapData(), 255, n * n2 * 4);
        this.handle.addRepresentation(nSBitmapImageRep);
        nSBitmapImageRep.release();
        this.handle.setCacheMode(3);
    }

    void init(ImageData imageData) {
        RGB rGB;
        int n;
        byte[] byArray;
        Object object;
        boolean bl;
        if (imageData == null) {
            SWT.error(4);
        }
        this.width = imageData.width;
        this.height = imageData.height;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            SWT.error(38);
        }
        int n2 = this.width * this.height * 4;
        int n3 = this.width * 4;
        byte[] byArray2 = new byte[n2];
        if (paletteData.isDirect) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, this.width, this.height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, 0, 0, byArray2, 32, n3, 1, 0, 0, this.width, this.height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rGBArray = paletteData.getRGBs();
            bl = rGBArray.length;
            object = new byte[bl];
            byArray = new byte[bl];
            byte[] byArray3 = new byte[bl];
            for (n = 0; n < rGBArray.length; ++n) {
                rGB = rGBArray[n];
                if (rGB == null) continue;
                object[n] = (byte)rGB.red;
                byArray[n] = (byte)rGB.green;
                byArray3[n] = (byte)rGB.blue;
            }
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, this.width, this.height, object, byArray, byArray3, 255, null, 0, 0, 0, byArray2, 32, n3, 1, 0, 0, this.width, this.height, 0xFF0000, 65280, 255, false, false);
        }
        int n4 = imageData.getTransparencyType();
        boolean bl2 = bl = n4 != 0;
        if (n4 == 2 || imageData.transparentPixel != -1) {
            int n5 = this.type = imageData.transparentPixel != -1 ? 0 : 1;
            if (imageData.transparentPixel != -1) {
                Object object2;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                if (paletteData.isDirect) {
                    object2 = paletteData.getRGB(imageData.transparentPixel);
                    n6 = object2.red;
                    n7 = object2.green;
                    n8 = object2.blue;
                } else {
                    object2 = paletteData.getRGBs();
                    if (imageData.transparentPixel < ((RGB[])object2).length) {
                        rGB = object2[imageData.transparentPixel];
                        n6 = rGB.red;
                        n7 = rGB.green;
                        n8 = rGB.blue;
                    }
                }
                this.transparentPixel = n6 << 16 | n7 << 8 | n8;
            }
            object = imageData.getTransparencyMask();
            byArray = object.data;
            int n9 = object.bytesPerLine;
            n = 0;
            int n10 = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    byArray2[n] = (byArray[n10 + (j >> 3)] & 1 << 7 - (j & 7)) != 0 ? -1 : 0;
                    n += 4;
                }
                n10 += n9;
            }
        } else {
            this.type = 0;
            if (imageData.alpha != -1) {
                bl = true;
                this.alpha = imageData.alpha;
                byte by = (byte)this.alpha;
                for (int i = 0; i < byArray2.length; i += 4) {
                    byArray2[i] = by;
                }
            } else if (imageData.alphaData != null) {
                bl = true;
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                int n11 = 0;
                int n12 = 0;
                for (int i = 0; i < this.height; ++i) {
                    for (n = 0; n < this.width; ++n) {
                        byArray2[n11] = this.alphaData[n12];
                        n11 += 4;
                        ++n12;
                    }
                }
            }
        }
        if (this.handle != null) {
            this.handle.release();
        }
        this.handle = (NSImage)new NSImage().alloc();
        NSSize nSSize = new NSSize();
        nSSize.width = this.width;
        nSSize.height = this.height;
        this.handle = this.handle.initWithSize(nSSize);
        NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
        nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0, this.width, this.height, 8, bl ? 4 : 3, bl, false, OS.NSDeviceRGBColorSpace, 3, n3, 32);
        OS.memmove(nSBitmapImageRep.bitmapData(), byArray2, n2);
        this.handle.addRepresentation(nSBitmapImageRep);
        nSBitmapImageRep.release();
        this.handle.setCacheMode(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initNative(String string) {
        NSAutoreleasePool nSAutoreleasePool = null;
        NSImage nSImage = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            nSImage = new NSImage();
            nSImage.alloc();
            nSImage = nSImage.initWithContentsOfFile(NSString.stringWith(string));
            if (nSImage == null) {
                return;
            }
            NSImageRep nSImageRep = nSImage.bestRepresentationForDevice(null);
            if (!nSImageRep.isKindOfClass(OS.class_NSBitmapImageRep)) {
                return;
            }
            this.width = nSImageRep.pixelsWide();
            this.height = nSImageRep.pixelsHigh();
            boolean bl = nSImageRep.hasAlpha();
            int n = this.width * 4;
            this.handle = (NSImage)new NSImage().alloc();
            NSSize nSSize = new NSSize();
            nSSize.width = this.width;
            nSSize.height = this.height;
            this.handle = this.handle.initWithSize(nSSize);
            NSBitmapImageRep nSBitmapImageRep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
            nSBitmapImageRep = nSBitmapImageRep.initWithBitmapDataPlanes(0, this.width, this.height, 8, bl ? 4 : 3, bl, false, OS.NSDeviceRGBColorSpace, 3, n, 32);
            this.handle.addRepresentation(nSBitmapImageRep);
            nSBitmapImageRep.release();
            this.handle.setCacheMode(3);
            NSRect nSRect = new NSRect();
            nSRect.width = this.width;
            nSRect.height = this.height;
            int n2 = OS.CGColorSpaceCreateDeviceRGB();
            int n3 = OS.CGBitmapContextCreate(nSBitmapImageRep.bitmapData(), this.width, this.height, 8, n, n2, 6);
            OS.CGColorSpaceRelease(n2);
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(n3, false));
            nSImageRep.drawInRect(nSRect);
            NSGraphicsContext.static_restoreGraphicsState();
            OS.CGContextRelease(n3);
            if (bl) {
                int n4 = this.width;
                int n5 = n4 * this.height;
                int n6 = OS.malloc(n5);
                int n7 = OS.CGBitmapContextCreate(n6, this.width, this.height, 8, n4, 0, 7);
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(NSGraphicsContext.graphicsContextWithGraphicsPort(n7, false));
                nSImageRep.drawInRect(nSRect);
                NSGraphicsContext.static_restoreGraphicsState();
                byte[] byArray = new byte[n5];
                OS.memmove(byArray, n6, n5);
                OS.free(n6);
                OS.CGContextRelease(n7);
                byte[] byArray2 = new byte[this.height * n];
                OS.memmove(byArray2, nSBitmapImageRep.bitmapData(), byArray2.length);
                int n8 = 0;
                int n9 = 0;
                while (n8 < byArray.length) {
                    byArray2[n9] = byArray[n8];
                    float f = byArray[n8] & 0xFF;
                    if (f != 0.0f) {
                        byArray2[n9 + 1] = (byte)((float)(byArray2[n9 + 1] & 0xFF) / f * 255.0f);
                        byArray2[n9 + 2] = (byte)((float)(byArray2[n9 + 2] & 0xFF) / f * 255.0f);
                        byArray2[n9 + 3] = (byte)((float)(byArray2[n9 + 3] & 0xFF) / f * 255.0f);
                    }
                    ++n8;
                    n9 += 4;
                }
                OS.memmove(nSBitmapImageRep.bitmapData(), byArray2, byArray2.length);
                n8 = -1;
                n9 = 0;
                for (n9 = 0; n9 < byArray.length; ++n9) {
                    byte by = byArray[n9];
                    if (n8 == -1 && by == 0) {
                        n8 = n9;
                    }
                    if (by != 0 && by != -1) break;
                }
                this.alpha = -1;
                if (n9 == byArray.length && n8 != -1) {
                    NSColor nSColor = nSBitmapImageRep.colorAtX(n8 % this.width, n8 / this.width);
                    int n10 = (int)(nSColor.redComponent() * 255.0f);
                    int n11 = (int)(nSColor.greenComponent() * 255.0f);
                    int n12 = (int)(nSColor.blueComponent() * 255.0f);
                    this.transparentPixel = n10 << 16 | n11 << 8 | n12;
                    for (int i = 0; i < byArray2.length; i += 4) {
                        int n13;
                        if (byArray2[i] == 0 || (n13 = (byArray2[i + 1] & 0xFF) << 16 | (byArray2[i + 2] & 0xFF) << 8 | byArray2[i + 3] & 0xFF) != this.transparentPixel) continue;
                        this.transparentPixel = -1;
                        break;
                    }
                }
                if (this.transparentPixel == -1) {
                    this.alphaData = byArray;
                }
            }
            this.type = string.toLowerCase().endsWith(".ico") ? 1 : 0;
        }
        finally {
            if (nSImage != null) {
                nSImage.release();
            }
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int internal_new_GC(GCData gCData) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n;
            NSGraphicsContext nSGraphicsContext;
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            nSBitmapImageRep.setAlpha(false);
            NSGraphicsContext nSGraphicsContext2 = NSGraphicsContext.graphicsContextWithBitmapImageRep(nSBitmapImageRep);
            nSGraphicsContext2 = nSGraphicsContext = NSGraphicsContext.graphicsContextWithGraphicsPort(nSGraphicsContext2.graphicsPort(), true);
            nSGraphicsContext2.retain();
            if (gCData != null) {
                gCData.flippedContext = nSGraphicsContext;
            }
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(nSGraphicsContext2);
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            NSSize nSSize = this.handle.size();
            nSAffineTransform.translateXBy(0.0f, nSSize.height);
            nSAffineTransform.scaleXBy(1.0f, -1.0f);
            nSAffineTransform.set();
            NSGraphicsContext.static_restoreGraphicsState();
            if (gCData != null) {
                n = 0x6000000;
                if ((gCData.style & n) == 0) {
                    gCData.style |= 0x2000000;
                }
                gCData.device = this.device;
                gCData.background = this.device.COLOR_WHITE.handle;
                gCData.foreground = this.device.COLOR_BLACK.handle;
                gCData.font = this.device.systemFont;
                gCData.image = this;
            }
            n = nSGraphicsContext2.id;
            return n;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_dispose_GC(int n, GCData gCData) {
        int n2 = n;
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (n2 != 0) {
                NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
                nSBitmapImageRep.bitmapData();
                NSGraphicsContext nSGraphicsContext = new NSGraphicsContext(n2);
                nSGraphicsContext.release();
            }
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n;
            int n2;
            int n3;
            byte by = (byte)(this.transparentPixel >> 16 & 0xFF);
            byte by2 = (byte)(this.transparentPixel >> 8 & 0xFF);
            byte by3 = (byte)(this.transparentPixel >> 0 & 0xFF);
            byte by4 = (byte)((int)(color.handle[0] * 255.0f) & 0xFF);
            byte by5 = (byte)((int)(color.handle[1] * 255.0f) & 0xFF);
            byte by6 = (byte)((int)(color.handle[2] * 255.0f) & 0xFF);
            NSBitmapImageRep nSBitmapImageRep = this.getRepresentation();
            int n4 = nSBitmapImageRep.bytesPerRow();
            int n5 = nSBitmapImageRep.bitmapData();
            int n6 = nSBitmapImageRep.bitmapFormat();
            int n7 = nSBitmapImageRep.bitsPerPixel();
            if (n7 == 32 && (n6 & 1) == 0) {
                n3 = 0;
                n2 = 1;
                n = 2;
            } else {
                n3 = 1;
                n2 = 2;
                n = 3;
            }
            byte[] byArray = new byte[n4];
            int n8 = 0;
            int n9 = 0;
            while (n8 < this.height) {
                OS.memmove(byArray, n5 + n9, n4);
                for (int i = 0; i < byArray.length; i += 4) {
                    if (byArray[i + n3] != by || byArray[i + n2] != by2 || byArray[i + n] != by3) continue;
                    byArray[i + n3] = by4;
                    byArray[i + n2] = by5;
                    byArray[i + n] = by6;
                }
                OS.memmove(n5 + n9, byArray, n4);
                ++n8;
                n9 += n4;
            }
            this.transparentPixel = (by4 & 0xFF) << 16 | (by5 & 0xFF) << 8 | by6 & 0xFF;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }
}

