/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XCrossingEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XMotionEvent;
import org.eclipse.swt.internal.motif.XWindowChanges;
import org.eclipse.swt.internal.motif.XmAnyCallbackStruct;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    ToolBar parent;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    Control control;
    int width = 8;
    boolean set;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;
    static final int DEFAULT_SEPARATOR_WIDTH = 8;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        toolBar.createItem(this, n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        Control control;
        int n2 = this.parent.handle;
        if ((this.style & 2) != 0) {
            int n3 = (this.parent.style & 0x100) != 0 ? 1 : 2;
            int[] nArray = new int[]{OS.XmNheight, n3 == 1 ? 22 : 8, OS.XmNwidth, n3 == 2 ? 24 : 8, OS.XmNancestorSensitive, 1, OS.XmNpositionIndex, n, OS.XmNorientation, n3, OS.XmNseparatorType, (this.parent.style & 0x800000) != 0 ? 5 : 6};
            this.handle = OS.XmCreateSeparator(n2, null, nArray, nArray.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int[] nArray = new int[20];
        nArray[0] = OS.XmNwidth;
        nArray[1] = 24;
        nArray[2] = OS.XmNheight;
        nArray[3] = 22;
        nArray[4] = OS.XmNrecomputeSize;
        nArray[6] = OS.XmNhighlightThickness;
        nArray[7] = (this.parent.style & 0x80000) != 0 ? 0 : 1;
        nArray[8] = OS.XmNmarginWidth;
        nArray[9] = 2;
        nArray[10] = OS.XmNmarginHeight;
        nArray[11] = 1;
        nArray[12] = OS.XmNtraversalOn;
        nArray[13] = (this.parent.style & 0x80000) != 0 ? 0 : 1;
        nArray[14] = OS.XmNpositionIndex;
        nArray[15] = n;
        nArray[16] = OS.XmNshadowType;
        nArray[17] = 8;
        nArray[18] = OS.XmNancestorSensitive;
        nArray[19] = 1;
        int[] nArray2 = nArray;
        this.handle = OS.XmCreateDrawnButton(n2, null, nArray2, nArray2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((control = this.parent.findBackgroundControl()) == null) {
            control = this.parent;
        }
        this.setBackgroundPixel(this.parent.getBackgroundPixel());
    }

    void click(boolean bl, int n) {
        if ((this.style & 0x10) != 0) {
            this.selectRadio();
        } else if ((this.style & 0x20) != 0) {
            this.setSelection(!this.set);
        }
        Event event = new Event();
        if ((this.style & 4) != 0 && bl) {
            event.detail = 4;
            int[] nArray = new int[6];
            nArray[0] = OS.XmNx;
            nArray[2] = OS.XmNy;
            nArray[4] = OS.XmNheight;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            event.x = (short)nArray2[1];
            event.y = (short)nArray2[3] + (short)nArray2[5];
        }
        if (n != 0) {
            this.setInputState(event, n);
        }
        this.postEvent(13, event);
    }

    Point computeSize(GC gC) {
        int n = 0;
        int n2 = 0;
        if ((this.style & 2) != 0) {
            if ((this.parent.style & 0x100) != 0) {
                n = this.getWidth();
                n2 = 22;
            } else {
                n = 24;
                n2 = this.getWidth();
            }
            if (this.control != null) {
                n2 = Math.max(n2, this.control.getMinimumHeight());
            }
            return new Point(n, n2);
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNmarginHeight;
        nArray[2] = OS.XmNmarginWidth;
        nArray[4] = OS.XmNshadowThickness;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n3 = nArray2[1];
        int n4 = nArray2[3];
        int n5 = nArray2[5];
        if ((this.parent.style & 0x800000) != 0) {
            n5 = Math.min(2, this.display.buttonShadowThickness);
        }
        if (this.text.length() != 0 || this.image != null) {
            int n6;
            int n7 = 0;
            int n8 = 0;
            if (this.text.length() != 0) {
                n6 = 14;
                Point point = gC.textExtent(this.text, n6);
                n7 = point.x;
                n8 = point.y;
            }
            n6 = 0;
            int n9 = 0;
            if (this.image != null) {
                Rectangle rectangle = this.image.getBounds();
                n6 = rectangle.width;
                n9 = rectangle.height;
            }
            if ((this.parent.style & 0x20000) != 0) {
                n = n6 + n7;
                n2 = Math.max(n9, n8);
                if (n6 != 0 && n7 != 0) {
                    n += 2;
                }
            } else {
                n2 = n9 + n8;
                if (n9 != 0 && n8 != 0) {
                    n2 += 2;
                }
                n = Math.max(n6, n7);
            }
        } else {
            n = 24;
            n2 = 22;
        }
        if ((this.style & 4) != 0) {
            n += 12;
        }
        n = n != 0 ? (n += (n4 + n5) * 2 + 2) : 24;
        n2 = n2 != 0 ? (n2 += (n3 + n5) * 2 + 2) : 22;
        return new Point(n, n2);
    }

    void createWidget(int n) {
        super.createWidget(n);
        int n2 = this.topHandle();
        if (OS.XtIsRealized(n2)) {
            this.realizeChildren();
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar toolBar = this.parent;
        super.dispose();
        toolBar.relayout();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] nArray = new int[8];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return new Rectangle((short)nArray2[1], (short)nArray2[3], nArray2[5], nArray2[7]);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return this.set;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.width;
    }

    boolean hasCursor() {
        int n;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = OS.XtDisplay(this.handle);
        int n3 = OS.XDefaultRootWindow(n2);
        do {
            if (OS.XQueryPointer(n2, n3, nArray, nArray2, nArray, nArray, nArray, nArray, nArray) == 0) {
                return false;
            }
            n = nArray2[0];
            if (n == 0) continue;
            n3 = n;
        } while (n != 0);
        return this.handle == OS.XtWindowToWidget(n2, n3);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        int n = this.display.windowProc;
        OS.XtAddEventHandler(this.handle, 1, false, n, 6);
        OS.XtAddEventHandler(this.handle, 2, false, n, 7);
        OS.XtAddEventHandler(this.handle, 4, false, n, 1);
        OS.XtAddEventHandler(this.handle, 8, false, n, 2);
        OS.XtAddEventHandler(this.handle, 64, false, n, 26);
        OS.XtAddEventHandler(this.handle, 16, false, n, 4);
        OS.XtAddEventHandler(this.handle, 32, false, n, 8);
        OS.XtAddCallback(this.handle, OS.XmNexposeCallback, n, 31);
        OS.XtInsertEventHandler(this.handle, 0x200000, false, n, 5, 1);
    }

    int hoverProc(int n) {
        boolean bl = this.toolTipText != null;
        this.parent.hoverProc(n, !bl);
        if (bl) {
            this.display.showToolTip(this.handle, this.toolTipText);
        }
        return 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    void manageChildren() {
        OS.XtManageChild(this.handle);
    }

    void realizeChildren() {
        if ((this.parent.state & 0x40) != 0) {
            this.setParentBackground();
        }
    }

    void redraw() {
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return;
        }
        int n2 = OS.XtWindow(this.handle);
        if (n2 == 0) {
            return;
        }
        OS.XClearArea(n, n2, 0, 0, 0, 0, true);
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        this.redrawHandle(n, n2, n3, n4, bl, this.handle);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.releaseToolTipHandle(this.handle);
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.control = null;
        this.toolTipText = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        int n = 0;
        ToolItem[] toolItemArray = this.parent.getItems();
        while (n < toolItemArray.length && toolItemArray[n] != this) {
            ++n;
        }
        int n2 = n - 1;
        while (n2 >= 0 && toolItemArray[n2].setRadioSelection(false)) {
            --n2;
        }
        int n3 = n + 1;
        while (n3 < toolItemArray.length && toolItemArray[n3].setRadioSelection(false)) {
            ++n3;
        }
        this.setSelection(true);
    }

    void setBackgroundPixel(int n) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNhighlightColor;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XmChangeColor(this.handle, n);
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
    }

    void setBounds(int n, int n2, int n3, int n4) {
        int n5 = Math.max(n3, 1);
        int n6 = Math.max(n4, 1);
        OS.XtConfigureWidget(this.handle, n, n2, n5, n6, 0);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        int[] nArray = new int[2];
        nArray[0] = OS.XmNseparatorType;
        nArray[1] = control == null ? ((this.parent.style & 0x800000) != 0 ? 5 : 6) : 0;
        int[] nArray2 = nArray;
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        if (control != null && !control.isDisposed()) {
            int n;
            int n2;
            int n3 = OS.XtDisplay(this.handle);
            if (n3 == 0) {
                return;
            }
            if (!OS.XtIsRealized(this.handle)) {
                Shell shell = this.parent.getShell();
                shell.realizeWidget();
            }
            if ((n2 = OS.XtWindow(n = control.topHandle())) == 0) {
                return;
            }
            int n4 = this.topHandle();
            int n5 = OS.XtWindow(n4);
            if (n5 == 0) {
                return;
            }
            XWindowChanges xWindowChanges = new XWindowChanges();
            xWindowChanges.sibling = n5;
            xWindowChanges.stack_mode = 0;
            int n6 = OS.XDefaultScreen(n3);
            int n7 = 96;
            OS.XReconfigureWMWindow(n3, n2, n6, n7, xWindowChanges);
        }
        this.parent.relayout();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNsensitive, bl ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    void setForegroundPixel(int n) {
        int[] nArray = new int[]{OS.XmNforeground, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
        if (!this.getEnabled()) {
            this.redraw();
        }
    }

    boolean setFocus() {
        if ((this.style & 2) != 0) {
            return false;
        }
        return this.XmProcessTraversal(this.handle, 0);
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if ((this.parent.style & 0x800000) != 0) {
            this.redraw();
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        this.parent.relayout();
        this.redraw();
    }

    void setParentBackground() {
        this.parent.setParentBackground(this.handle);
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if (bl == this.set) {
            return;
        }
        this.set = bl;
        this.setDrawPressed(this.set);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        this.parent.relayout();
        this.redraw();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    void setVisible(boolean bl) {
        OS.XtSetMappedWhenManaged(this.handle, bl);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0 || this.width == n) {
            return;
        }
        this.width = n;
        this.parent.relayout();
    }

    void setDrawPressed(boolean bl) {
        int n = bl ? 7 : 8;
        int[] nArray = new int[]{OS.XmNshadowType, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    boolean translateAccelerator(char c, int n, XKeyEvent xKeyEvent, boolean bl) {
        return this.parent.translateAccelerator(c, n, xKeyEvent, bl);
    }

    boolean translateMnemonic(char c, int n, XKeyEvent xKeyEvent) {
        return this.parent.translateMnemonic(c, n, xKeyEvent);
    }

    boolean translateTraversal(int n, XKeyEvent xKeyEvent) {
        return this.parent.translateTraversal(n, xKeyEvent);
    }

    void propagateWidget(boolean bl) {
        this.propagateHandle(bl, this.handle, 0);
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        this.display.hideToolTip();
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        xButtonEvent.window = OS.XtWindow(this.parent.handle);
        xButtonEvent.x += nArray2[1];
        xButtonEvent.y += nArray2[3];
        OS.memmove(n3, xButtonEvent, 60);
        int n5 = this.parent.XButtonPress(n, n2, n3, n4);
        xButtonEvent.x -= nArray2[1];
        xButtonEvent.y -= nArray2[3];
        if (n5 == 0 && xButtonEvent.button == 1 && !this.set) {
            this.setDrawPressed(!this.set);
        }
        return n5;
    }

    int XButtonRelease(int n, int n2, int n3, int n4) {
        this.display.hideToolTip();
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        xButtonEvent.window = OS.XtWindow(this.parent.handle);
        xButtonEvent.x += nArray2[1];
        xButtonEvent.y += nArray2[3];
        OS.memmove(n3, xButtonEvent, 60);
        int n5 = this.parent.XButtonRelease(n, n2, n3, n4);
        xButtonEvent.x -= nArray2[1];
        xButtonEvent.y -= nArray2[3];
        if (n5 == 0 && xButtonEvent.button == 1) {
            int[] nArray3 = new int[4];
            nArray3[0] = OS.XmNwidth;
            nArray3[2] = OS.XmNheight;
            int[] nArray4 = nArray3;
            OS.XtGetValues(this.handle, nArray4, nArray4.length / 2);
            int n6 = nArray4[1];
            int n7 = nArray4[3];
            if (xButtonEvent.x >= 0 && xButtonEvent.x < n6 && xButtonEvent.y >= 0 && xButtonEvent.y < n7) {
                this.click(xButtonEvent.x > n6 - 12, xButtonEvent.state);
            }
            this.setDrawPressed(this.set);
        }
        return n5;
    }

    int XEnterWindow(int n, int n2, int n3, int n4) {
        XCrossingEvent xCrossingEvent = new XCrossingEvent();
        OS.memmove(xCrossingEvent, n3, 68);
        if ((xCrossingEvent.state & 0x100) != 0) {
            this.setDrawPressed(!this.set);
        } else if ((this.parent.style & 0x800000) != 0) {
            this.redraw();
        }
        return 0;
    }

    int XFocusChange(int n, int n2, int n3, int n4) {
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent();
        OS.memmove(xFocusChangeEvent, n3, 28);
        xFocusChangeEvent.window = OS.XtWindow(this.parent.handle);
        this.parent.XFocusChange(n, n2, n3, n4);
        return 0;
    }

    int XKeyPress(int n, int n2, int n3, int n4) {
        int n5 = 0;
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        int[] nArray = new int[1];
        OS.XLookupString(xKeyEvent, null, 0, nArray, null);
        nArray[0] = nArray[0] & 0xFFFF;
        switch (nArray[0]) {
            case 32: {
                this.click(false, xKeyEvent.state);
                n5 = 1;
                break;
            }
            case 65364: {
                if ((this.style & 4) == 0) break;
                this.click(true, xKeyEvent.state);
                n5 = 1;
            }
        }
        xKeyEvent.window = OS.XtWindow(this.parent.handle);
        this.parent.XKeyPress(n, n2, n3, n4);
        if (n5 == 1) {
            OS.memmove(n4, new int[1], 4);
        }
        return n5;
    }

    int XKeyRelease(int n, int n2, int n3, int n4) {
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        xKeyEvent.window = OS.XtWindow(this.parent.handle);
        this.parent.XKeyRelease(n, n2, n3, n4);
        return 0;
    }

    int XLeaveWindow(int n, int n2, int n3, int n4) {
        this.display.removeMouseHoverTimeOut();
        this.display.hideToolTip();
        XCrossingEvent xCrossingEvent = new XCrossingEvent();
        OS.memmove(xCrossingEvent, n3, 68);
        if ((xCrossingEvent.state & 0x100) != 0) {
            this.setDrawPressed(this.set);
        } else if ((this.parent.style & 0x800000) != 0) {
            this.redraw();
        }
        return 0;
    }

    int XmNexposureCallback(int n, int n2, int n3) {
        int n4;
        int n5;
        Object object;
        int n6;
        if ((this.style & 2) != 0) {
            return 0;
        }
        int n7 = OS.XtDisplay(this.handle);
        if (n7 == 0) {
            return 0;
        }
        int n8 = OS.XtWindow(this.handle);
        if (n8 == 0) {
            return 0;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNcolormap;
        nArray[2] = OS.XmNwidth;
        nArray[4] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n9 = nArray2[3];
        int n10 = nArray2[5];
        Image image = this.image;
        boolean bl = this.getEnabled();
        if ((this.parent.style & 0x800000) != 0) {
            boolean bl2 = this.hasCursor();
            n6 = 0;
            if (this.set || bl2 && bl) {
                n6 = Math.min(2, this.display.buttonShadowThickness);
            }
            nArray2 = new int[]{OS.XmNshadowThickness, n6};
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
            if (bl && bl2 && this.hotImage != null) {
                image = this.hotImage;
            }
        }
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.display = n7;
        gCData.drawable = n8;
        gCData.font = this.parent.font;
        gCData.colormap = nArray2[1];
        n6 = OS.XCreateGC(n7, n8, 0, null);
        if (n6 == 0) {
            SWT.error(2);
        }
        GC gC = GC.motif_new(n6, gCData);
        XmAnyCallbackStruct xmAnyCallbackStruct = new XmAnyCallbackStruct();
        OS.memmove(xmAnyCallbackStruct, n3, 8);
        if (xmAnyCallbackStruct.event != 0) {
            object = new XExposeEvent();
            OS.memmove((XExposeEvent)object, xmAnyCallbackStruct.event, 40);
            Rectangle rectangle = new Rectangle(((XExposeEvent)object).x, ((XExposeEvent)object).y, ((XExposeEvent)object).width, ((XExposeEvent)object).height);
            gC.setClipping(rectangle);
        }
        if (!bl) {
            image = this.disabledImage;
            if (image == null && this.image != null) {
                image = new Image((Device)this.display, this.image, 1);
            }
            object = this.display.getSystemColor(18);
            gC.setForeground((Color)object);
        } else {
            gC.setForeground(this.parent.getForeground());
        }
        gC.setBackground(this.parent.getBackground());
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        if (this.text.length() != 0) {
            n5 = 14;
            Point point = gC.textExtent(this.text, n5);
            n13 = point.x;
            n14 = point.y;
        }
        n5 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        if (image != null) {
            Rectangle rectangle = image.getBounds();
            n16 = rectangle.width;
            n17 = rectangle.height;
        }
        int n18 = 0;
        if (n13 != 0 && n16 != 0) {
            n18 = 2;
        }
        if ((this.parent.style & 0x20000) != 0) {
            n5 = (n9 - n16 - n13 - n18) / 2;
            n15 = (n10 - n17) / 2;
            n11 = n18 + n5 + n16;
            n12 = (n10 - n14) / 2;
        } else {
            n5 = (n9 - n16) / 2;
            n15 = (n10 - n17 - n14 - n18) / 2;
            n11 = (n9 - n13) / 2;
            n12 = n18 + n15 + n17;
        }
        if ((this.style & 4) != 0) {
            n11 -= 6;
            n5 -= 6;
        }
        if (n13 > 0) {
            n4 = 15;
            gC.drawText(this.text, n11, n12, n4);
        }
        if (n16 > 0) {
            gC.drawImage(image, n5, n15);
        }
        if ((this.style & 4) != 0) {
            n4 = n9 - 12;
            int n19 = (n10 - 2) / 2;
            int[] nArray3 = new int[]{n4, n19, n4 + 3, n19 + 3, n4 + 6, n19};
            gC.setBackground(this.parent.getForeground());
            gC.fillPolygon(nArray3);
            gC.drawPolygon(nArray3);
        }
        gC.dispose();
        OS.XFreeGC(n7, n6);
        if (!bl && this.disabledImage == null && image != null) {
            image.dispose();
        }
        return 0;
    }

    int XPointerMotion(int n, int n2, int n3, int n4) {
        this.display.addMouseHoverTimeOut(this.handle);
        XMotionEvent xMotionEvent = new XMotionEvent();
        OS.memmove(xMotionEvent, n3, 60);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        xMotionEvent.window = OS.XtWindow(this.parent.handle);
        xMotionEvent.x += nArray2[1];
        xMotionEvent.y += nArray2[3];
        if (!this.parent.sendMouseEvent(5, xMotionEvent)) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return 0;
    }
}

