/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int drawCount;
    int itemCount;
    ToolItem[] items;
    ToolItem lastFocus;

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n;
        int n4 = n2;
        if (n == -1) {
            n3 = Integer.MAX_VALUE;
        }
        if (n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        int[] nArray = this.layout(n3, n4, false);
        int n5 = this.getBorderWidth() * 2;
        Point point = new Point(nArray[1], nArray[2]);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        point.x += n5;
        point.y += n5;
        return point;
    }

    void createHandle(int n) {
        super.createHandle(n);
        this.state &= 0xFFFFFFFD;
    }

    void createItem(ToolItem toolItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        toolItem.createWidget(n);
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = toolItem;
        this.relayout();
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    void destroyItem(ToolItem toolItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        decorations.bringToTop(false);
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem.setFocus()) {
                return true;
            }
            ++n;
        }
        return super.forceFocus();
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            return this.items[n];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            Rectangle rectangle = this.items[n].getBounds();
            if (rectangle.contains(point)) {
                return this.items[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] toolItemArray = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, toolItemArray, 0, this.itemCount);
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        return this.layout(rectangle.width, rectangle.height, false)[0];
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int[] layoutHorizontal(int n, int n2, boolean bl) {
        Object object;
        int n3 = 0;
        int n4 = (this.style & 0x80000) != 0 ? 4 : 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        GC gC = new GC(this);
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize(gC);
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).y);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n7 + point.x > n) {
                ++n10;
                n7 = n5;
                n8 += n4 + n11;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, point.x, n11);
                boolean bl3 = n7 + point.x <= n && n8 + n11 <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    int n13 = n8 + (n11 - point.y) / 2;
                    control.setBounds(n7, n13, point.x, n11 - (n13 - n8));
                }
            }
            n9 = Math.max(n9, n7 += n3 + point.x);
            ++n12;
        }
        gC.dispose();
        return new int[]{n10, n9, n8 + n11};
    }

    int[] layoutVertical(int n, int n2, boolean bl) {
        Object object;
        int n3 = (this.style & 0x80000) != 0 ? 4 : 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        GC gC = new GC(this);
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize(gC);
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).x);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n8 + point.y > n2) {
                ++n10;
                n7 += n3 + n11;
                n8 = n6;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, n11, point.y);
                boolean bl3 = n7 + n11 <= n && n8 + point.y <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    int n13 = n7 + (n11 - point.x) / 2;
                    control.setBounds(n13, n8, n11 - (n13 - n7), point.y);
                }
            }
            n9 = Math.max(n9, n8 += n4 + point.y);
            ++n12;
        }
        return new int[]{n10, n7 + n11, n9};
    }

    int[] layout(int n, int n2, boolean bl) {
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(n, n2, bl);
        }
        return this.layoutHorizontal(n, n2, bl);
    }

    boolean mnemonicHit(char c) {
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            char c2 = this.findMnemonic(toolItem.getText());
            if (c2 != '\u0000' && Character.toUpperCase(c) == Character.toUpperCase(c2)) {
                this.XmProcessTraversal(toolItem.handle, 0);
                toolItem.click(false, 0);
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        int n = 0;
        while (n < this.itemCount) {
            char c2;
            ToolItem toolItem = this.items[n];
            if (toolItem.getEnabled() && (c2 = this.findMnemonic(toolItem.getText())) != '\u0000' && Character.toUpperCase(c) == Character.toUpperCase(c2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void propagateWidget(boolean bl) {
        super.propagateWidget(bl);
        int n = 0;
        while (n < this.itemCount) {
            this.items[n].propagateWidget(bl);
            ++n;
        }
    }

    void realizeChildren() {
        super.realizeChildren();
        if (this.items != null) {
            int n = 0;
            while (n < this.itemCount) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.realizeChildren();
                }
                ++n;
            }
        }
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (this.items != null) {
            int n5 = 0;
            while (n5 < this.itemCount) {
                ToolItem toolItem = this.items[n5];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.redrawWidget(n, n2, n3, n4, bl, bl2, true);
                }
                ++n5;
            }
        }
    }

    void relayout() {
        if (this.drawCount > 0) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        this.layout(rectangle.width, rectangle.height, true);
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.itemCount) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        int n2 = 0;
        while (n2 < this.itemCount) {
            this.items[n2].setBackgroundPixel(n);
            ++n2;
        }
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3 && bl2) {
            this.relayout();
        }
        return bl3;
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.relayout();
    }

    void setForegroundPixel(int n) {
        super.setForegroundPixel(n);
        int n2 = 0;
        while (n2 < this.itemCount) {
            this.items[n2].setForegroundPixel(n);
            ++n2;
        }
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0) {
                this.relayout();
            }
        } else {
            ++this.drawCount;
        }
    }

    boolean setTabItemFocus(boolean bl) {
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if ((toolItem.style & 2) == 0 && toolItem.getEnabled()) break;
            ++n;
        }
        if (n == this.itemCount) {
            return false;
        }
        return super.setTabItemFocus(bl);
    }

    int traversalCode(int n, XKeyEvent xKeyEvent) {
        return super.traversalCode(n, xKeyEvent) | 0x80;
    }

    int xFocusIn(XFocusChangeEvent xFocusChangeEvent) {
        int n = OS.XmGetFocusWidget(this.handle);
        if (n != this.focusHandle()) {
            int n2 = 0;
            while (n2 < this.itemCount) {
                if (this.items[n2].handle == n) {
                    this.lastFocus = this.items[n2];
                    break;
                }
                ++n2;
            }
        }
        return super.xFocusIn(xFocusChangeEvent);
    }
}

