/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    int scrollHandle;

    public Scale(Composite composite, int n) {
        super(composite, Scale.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Scale.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        int n6 = this.display.scrolledMarginX;
        int n7 = this.display.scrolledMarginY;
        if ((this.style & 0x100) != 0) {
            n4 += n6 * 10;
            n5 += n7;
        } else {
            n4 += n6;
            n5 += n7 * 10;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        this.state |= 0x80;
        int[] nArray = new int[10];
        nArray[0] = OS.XmNtitleString;
        nArray[2] = OS.XmNborderWidth;
        nArray[3] = (this.style & 0x800) != 0 ? 1 : 0;
        nArray[4] = OS.XmNorientation;
        nArray[5] = (this.style & 0x100) != 0 ? 2 : 1;
        nArray[6] = OS.XmNprocessingDirection;
        nArray[7] = (this.style & 0x100) != 0 ? 3 : 1;
        nArray[8] = OS.XmNancestorSensitive;
        nArray[9] = 1;
        int[] nArray2 = nArray;
        int n2 = this.parent.handle;
        this.handle = OS.XmCreateScale(n2, null, nArray2, nArray2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        byte[] byArray = Converter.wcsToMbcs(null, "Scrollbar\u0000");
        this.scrollHandle = OS.XtNameToWidget(this.handle, byArray);
    }

    void deregister() {
        super.deregister();
        if (this.scrollHandle != 0) {
            this.display.removeWidget(this.scrollHandle);
        }
    }

    public int getIncrement() {
        this.checkWidget();
        return 1;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNscaleMultiple;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNvalue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, n, 24);
        OS.XtAddCallback(this.handle, OS.XmNdragCallback, n, 15);
        if (this.scrollHandle != 0) {
            OS.XtAddEventHandler(this.scrollHandle, 4, false, n, 1);
            OS.XtAddEventHandler(this.scrollHandle, 8, false, n, 2);
            OS.XtAddEventHandler(this.scrollHandle, 16, false, n, 4);
            OS.XtAddEventHandler(this.scrollHandle, 32, false, n, 8);
            OS.XtAddEventHandler(this.scrollHandle, 1, false, n, 6);
            OS.XtAddEventHandler(this.scrollHandle, 2, false, n, 7);
            OS.XtInsertEventHandler(this.scrollHandle, 0x200000, false, n, 5, 1);
        }
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
    }

    void register() {
        super.register();
        if (this.scrollHandle != 0) {
            this.display.addWidget(this.scrollHandle, this);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNmaximum, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNminimum, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int[] nArray = new int[]{OS.XmNscaleMultiple, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNvalue, n};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.display.setWarnings(bl);
    }

    int XmNdragCallback(int n, int n2, int n3) {
        this.postEvent(13);
        return 0;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        this.postEvent(13);
        return 0;
    }
}

