/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.cde.CDE;
import org.eclipse.swt.internal.cde.DtActionArg;
import org.eclipse.swt.internal.gnome.GNOME;
import org.eclipse.swt.internal.gnome.GnomeVFSMimeApplication;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class Program {
    String name;
    String command;
    String iconPath;
    Display display;
    boolean gnomeExpectUri;
    static final String SHELL_HANDLE_KEY = "org.eclipse.swt.internal.motif.shellHandle";
    static final String[] CDE_ICON_EXT = new String[]{".m.pm", ".l.pm", ".s.pm", ".t.pm"};
    static final String[] CDE_MASK_EXT = new String[]{".m_m.bm", ".l_m.bm", ".s_m.bm", ".t_m.bm"};
    static final String DESKTOP_DATA = "Program_DESKTOP";
    static final String ICON_THEME_DATA = "Program_GNOME_ICON_THEME";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";
    static final int DESKTOP_UNKNOWN = 0;
    static final int DESKTOP_GNOME = 1;
    static final int DESKTOP_GNOME_24 = 2;
    static final int DESKTOP_CDE = 3;
    static final int PREFERRED_ICON_SIZE = 16;

    Program() {
    }

    static int getDesktop(final Display display) {
        int n;
        byte[] byArray;
        int n2;
        if (display == null) {
            return 0;
        }
        Integer n3 = (Integer)display.getData(DESKTOP_DATA);
        if (n3 != null) {
            return n3;
        }
        int n4 = 0;
        int n5 = display.xDisplay;
        int n6 = OS.XDefaultRootWindow(n5);
        int[] nArray = new int[1];
        int n7 = OS.XListProperties(n5, n6, nArray);
        int[] nArray2 = new int[nArray[0]];
        if (n7 != 0) {
            OS.memmove(nArray2, n7, nArray2.length * OS.PTR_SIZEOF);
            OS.XFree(n7);
        }
        if (n4 == 0 && (n2 = OS.XInternAtom(n5, byArray = Converter.wcsToMbcs(null, "_NET_SUPPORTING_WM_CHECK", true), true)) != 0 && Program.gnome_init()) {
            n4 = 1;
            n = GNOME.gnome_icon_theme_new();
            display.setData(ICON_THEME_DATA, new Integer(n));
            display.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    Integer n = (Integer)display.getData(Program.ICON_THEME_DATA);
                    if (n == null) {
                        return;
                    }
                    display.setData(Program.ICON_THEME_DATA, null);
                    int n2 = n;
                    if (n2 != 0) {
                        GNOME.g_object_unref(n2);
                    }
                }
            });
            byte[] byArray2 = Converter.wcsToMbcs(null, "libgnomevfs-2.so.0", true);
            int n8 = OS.dlopen(byArray2, 1);
            if (n8 != 0) {
                byArray2 = Converter.wcsToMbcs(null, "gnome_vfs_url_show", true);
                int n9 = OS.dlsym(n8, byArray2);
                if (n9 != 0) {
                    n4 = 2;
                }
                OS.dlclose(n8);
            }
        }
        if (n4 == 0) {
            byArray = Converter.wcsToMbcs(null, "_DT_SM_PREFERENCES", true);
            n2 = OS.XInternAtom(n5, byArray, true);
            n = 0;
            while (n4 == 0 && n < nArray2.length) {
                if (nArray2[n] != 0 && nArray2[n] == n2 && Program.cde_init(display)) {
                    n4 = 3;
                }
                ++n;
            }
        }
        display.setData(DESKTOP_DATA, new Integer(n4));
        return n4;
    }

    boolean cde_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.command, true);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        Integer n = (Integer)this.display.getData(SHELL_HANDLE_KEY);
        long l = 0L;
        if (n != null) {
            int n2 = OS.XtMalloc(byArray2.length);
            OS.memmove(n2, byArray2, byArray2.length);
            DtActionArg dtActionArg = new DtActionArg();
            dtActionArg.argClass = 1;
            dtActionArg.name = n2;
            l = CDE.DtActionInvoke(n, byArray, dtActionArg, 1, null, null, null, 1, 0, 0);
            OS.XtFree(n2);
        }
        return l != 0L;
    }

    static String cde_getAction(String string) {
        String string2 = null;
        String string3 = Program.cde_getAttribute(string, "ACTIONS");
        if (string3 != null) {
            int n = string3.indexOf("Open");
            string2 = n != -1 ? string3.substring(n, n + 4) : ((n = string3.indexOf(",")) != -1 ? string3.substring(0, n) : string3);
        }
        return string2;
    }

    static String cde_getAttribute(String string, String string2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = Converter.wcsToMbcs(null, string, true);
        int n = CDE.DtDtsDataTypeToAttributeValue(byArray3, byArray2 = Converter.wcsToMbcs(null, string2, true), byArray = (byte[])null);
        if (n == 0) {
            return null;
        }
        int n2 = OS.strlen(n);
        byte[] byArray4 = new byte[n2];
        OS.memmove(byArray4, n, n2);
        CDE.DtDtsFreeAttributeValue(n);
        return new String(Converter.mbcsToWcs(null, byArray4));
    }

    static Hashtable cde_getDataTypeInfo() {
        Hashtable hashtable = new Hashtable();
        int n = CDE.DtDtsDataTypeNames();
        if (n != 0) {
            int n2 = 0;
            int[] nArray = new int[1];
            OS.memmove(nArray, n + n2++ * 4, 4);
            while (nArray[0] != 0) {
                int n3 = OS.strlen(nArray[0]);
                byte[] byArray = new byte[n3];
                OS.memmove(byArray, nArray[0], n3);
                String string = new String(Converter.mbcsToWcs(null, byArray));
                String string2 = Program.cde_getExtension(string);
                if (!CDE.DtDtsDataTypeIsAction(byArray) && string2 != null && Program.cde_getAction(string) != null) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(string2);
                    hashtable.put(string, vector);
                }
                OS.memmove(nArray, n + n2++ * 4, 4);
            }
            CDE.DtDtsFreeDataTypeNames(n);
        }
        return hashtable;
    }

    static String cde_getExtension(String string) {
        String string2 = Program.cde_getAttribute(string, "NAME_TEMPLATE");
        if (string2 == null || string2.indexOf("%s.") == -1) {
            return null;
        }
        int n = string2.indexOf(".");
        return string2.substring(n);
    }

    ImageData cde_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        int n = this.display.xDisplay;
        int n2 = OS.XDefaultScreenOfDisplay(n);
        int n3 = OS.XWhitePixel(this.display.xDisplay, OS.XDefaultScreen(n));
        int n4 = OS.XBlackPixel(this.display.xDisplay, OS.XDefaultScreen(n));
        byte[] byArray = null;
        int n5 = 0;
        int n6 = 0;
        while (n6 < CDE_ICON_EXT.length && n5 == 0) {
            byte[] byArray2 = Converter.wcsToMbcs(null, String.valueOf(this.iconPath) + CDE_ICON_EXT[n6], true);
            byArray = Converter.wcsToMbcs(null, String.valueOf(this.iconPath) + CDE_MASK_EXT[n6], true);
            n5 = OS.XmGetPixmap(n2, byArray2, n3, n4);
            if (n5 == 2) {
                n5 = 0;
            }
            ++n6;
        }
        if (n5 != 0) {
            n6 = 1;
            int n7 = OS.XmGetPixmapByDepth(n2, byArray, 1, 0, 1);
            if (n7 == 2) {
                n6 = 0;
                n7 = 0;
            }
            Image image = Image.motif_new(this.display, n6, n5, n7);
            ImageData imageData = image.getImageData();
            OS.XmDestroyPixmap(n2, n5);
            if (n7 != 0) {
                OS.XmDestroyPixmap(n2, n7);
            }
            return imageData;
        }
        return null;
    }

    static String cde_getMimeType(String string) {
        String string2 = null;
        Hashtable hashtable = Program.cde_getDataTypeInfo();
        if (hashtable == null) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        block0: while (string2 == null && enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string3);
            int n = 0;
            while (n < vector.size()) {
                if (string.equals(vector.elementAt(n))) {
                    string2 = string3;
                    continue block0;
                }
                ++n;
            }
        }
        return string2;
    }

    static Program cde_getProgram(Display display, String string) {
        Program program = new Program();
        program.display = display;
        program.name = string;
        program.command = Program.cde_getAction(string);
        program.iconPath = Program.cde_getAttribute(program.name, "ICON");
        return program;
    }

    static boolean cde_init(Display display) {
        try {
            Library.loadLibrary("swt-cde");
        }
        catch (Throwable throwable) {
            return false;
        }
        byte[] byArray = Converter.wcsToMbcs(null, "SWT", true);
        int n = OS.XtDisplayToApplicationContext(display.xDisplay);
        Integer n2 = (Integer)display.getData(SHELL_HANDLE_KEY);
        boolean bl = CDE.DtAppInitialize(n, display.xDisplay, n2, byArray, byArray);
        if (bl) {
            CDE.DtDbLoad();
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    static String[] parseCommand(String var0) {
        var1_1 = new Vector<String>();
        var2_2 = 0;
        ** GOTO lbl25
        {
            ++var2_2;
            do {
                if (var2_2 < var0.length() && Compatibility.isWhitespace(var0.charAt(var2_2))) continue block0;
                if (var2_2 >= var0.length()) continue;
                if (var0.charAt(var2_2) == '\"' || var0.charAt(var2_2) == '\'') {
                    var3_3 = var2_2 + 1;
                    while (var3_3 < var0.length() && var0.charAt(var3_3) != var0.charAt(var2_2)) {
                        ++var3_3;
                    }
                    if (var3_3 >= var0.length()) {
                        var1_1.addElement(var0.substring(var2_2, var3_3));
                    } else {
                        var1_1.addElement(var0.substring(var2_2 + 1, var3_3));
                    }
                    var2_2 = var3_3 + 1;
                    continue;
                }
                var3_3 = var2_2;
                while (var3_3 < var0.length() && !Compatibility.isWhitespace(var0.charAt(var3_3))) {
                    ++var3_3;
                }
                var1_1.addElement(var0.substring(var2_2, var3_3));
                var2_2 = var3_3 + 1;
lbl25:
                // 4 sources

            } while (var2_2 < var0.length());
        }
        var4_4 = new String[var1_1.size()];
        var5_5 = 0;
        while (var5_5 < var1_1.size()) {
            var4_4[var5_5] = (String)var1_1.elementAt(var5_5);
            ++var5_5;
        }
        return var4_4;
    }

    boolean gnome_24_execute(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, this.name, true);
        int n = GNOME.gnome_vfs_mime_get_default_application(byArray);
        byte[] byArray2 = Converter.wcsToMbcs(null, string, true);
        int n2 = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray2, 2);
        int n3 = GNOME.g_list_append(0, n2);
        int n4 = GNOME.gnome_vfs_mime_application_launch(n, n3);
        GNOME.gnome_vfs_mime_application_free(n);
        GNOME.g_free(n2);
        GNOME.g_list_free(n3);
        return n4 == 0;
    }

    static boolean gnome_24_launch(String string) {
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = GNOME.gnome_vfs_make_uri_from_input_with_dirs(byArray, 2);
        int n2 = GNOME.gnome_vfs_url_show(n);
        GNOME.g_free(n);
        return n2 == 0;
    }

    boolean gnome_execute(String string) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        int n2;
        if (this.gnomeExpectUri && (n2 = GNOME.gnome_vfs_make_uri_from_input((byte[])(objectArray2 = (Object[])Converter.wcsToMbcs(null, string, true)))) != 0) {
            n = OS.strlen(n2);
            if (n > 0) {
                objectArray = new byte[n];
                OS.memmove(objectArray, n2, n);
                string = new String(Converter.mbcsToWcs(null, objectArray));
            }
            GNOME.g_free(n2);
        }
        objectArray2 = Program.parseCommand(this.command);
        n2 = -1;
        n = 0;
        while (n < objectArray2.length) {
            int n3 = objectArray2[n].indexOf("%f");
            if (n3 != -1) {
                String string2 = objectArray2[n];
                n2 = n;
                objectArray2[n] = String.valueOf(string2.substring(0, n3)) + string + string2.substring(n3 + 2);
            }
            ++n;
        }
        if (string.length() > 0 && n2 < 0) {
            objectArray = new String[objectArray2.length + 1];
            n = 0;
            while (n < objectArray2.length) {
                objectArray[n] = (byte)objectArray2[n];
                ++n;
            }
            objectArray[objectArray2.length] = (byte)string;
            objectArray2 = objectArray;
        }
        try {
            Compatibility.exec(objectArray2);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    ImageData gnome_getImageData() {
        if (this.iconPath == null) {
            return null;
        }
        try {
            return new ImageData(this.iconPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Hashtable gnome_getMimeInfo() {
        int n;
        Hashtable hashtable = new Hashtable();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = n = GNOME.gnome_vfs_get_registered_mime_types();
        while (n2 != 0) {
            OS.memmove(nArray, n2, OS.PTR_SIZEOF);
            int n3 = nArray[0];
            int n4 = OS.strlen(n3);
            byte[] byArray = new byte[n4];
            OS.memmove(byArray, n3, n4);
            String string = new String(Converter.mbcsToWcs(null, byArray));
            int n5 = GNOME.gnome_vfs_mime_get_extensions_list(n3);
            if (n5 != 0) {
                Vector<String> vector = new Vector<String>();
                int n6 = n5;
                while (n6 != 0) {
                    OS.memmove(nArray2, n6, OS.PTR_SIZEOF);
                    int n7 = nArray2[0];
                    int n8 = OS.strlen(n7);
                    byte[] byArray2 = new byte[n8];
                    OS.memmove(byArray2, n7, n8);
                    String string2 = new String(Converter.mbcsToWcs(null, byArray2));
                    string2 = String.valueOf('.') + string2;
                    vector.addElement(string2);
                    n6 = GNOME.g_list_next(n6);
                }
                GNOME.gnome_vfs_mime_extensions_list_free(n5);
                if (vector.size() > 0) {
                    hashtable.put(string, vector);
                }
            }
            n2 = GNOME.g_list_next(n2);
        }
        if (n != 0) {
            GNOME.gnome_vfs_mime_registered_mime_type_list_free(n);
        }
        return hashtable;
    }

    static String gnome_getMimeType(String string) {
        int n;
        String string2 = null;
        String string3 = "swt" + string;
        byte[] byArray = Converter.wcsToMbcs(null, string3, true);
        int n2 = GNOME.gnome_vfs_mime_type_from_name(byArray);
        if (n2 != 0 && (n = OS.strlen(n2)) > 0) {
            byte[] byArray2 = new byte[n];
            OS.memmove(byArray2, n2, n);
            string2 = new String(Converter.mbcsToWcs(null, byArray2));
        }
        return string2;
    }

    static Program gnome_getProgram(Display display, String string) {
        Program program = null;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n = GNOME.gnome_vfs_mime_get_default_application(byArray);
        if (n != 0) {
            program = new Program();
            program.display = display;
            program.name = string;
            GnomeVFSMimeApplication gnomeVFSMimeApplication = new GnomeVFSMimeApplication();
            GNOME.memmove(gnomeVFSMimeApplication, n, GnomeVFSMimeApplication.sizeof);
            int n2 = OS.strlen(gnomeVFSMimeApplication.command);
            byte[] byArray2 = new byte[n2];
            OS.memmove(byArray2, gnomeVFSMimeApplication.command, n2);
            program.command = new String(Converter.mbcsToWcs(null, byArray2));
            program.gnomeExpectUri = gnomeVFSMimeApplication.expects_uris == 0;
            n2 = OS.strlen(gnomeVFSMimeApplication.id);
            byArray2 = new byte[n2 + 1];
            OS.memmove(byArray2, gnomeVFSMimeApplication.id, n2);
            Integer n3 = (Integer)display.getData(ICON_THEME_DATA);
            int n4 = n3;
            int n5 = GNOME.gnome_icon_lookup(n4, 0, null, byArray2, 0, byArray, 0, null);
            int n6 = 0;
            if (n5 != 0) {
                n6 = GNOME.gnome_icon_theme_lookup_icon(n4, n5, 16, null, null);
            }
            if (n6 != 0) {
                n2 = OS.strlen(n6);
                if (n2 > 0) {
                    byArray2 = new byte[n2];
                    OS.memmove(byArray2, n6, n2);
                    program.iconPath = new String(Converter.mbcsToWcs(null, byArray2));
                }
                GNOME.g_free(n6);
            }
            if (n5 != 0) {
                GNOME.g_free(n5);
            }
            GNOME.gnome_vfs_mime_application_free(n);
        }
        return program;
    }

    static boolean gnome_init() {
        try {
            return GNOME.gnome_vfs_init();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Program findProgram(String string) {
        return Program.findProgram(Display.getCurrent(), string);
    }

    static Program findProgram(Display display, String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        int n = Program.getDesktop(display);
        String string2 = null;
        switch (n) {
            case 1: 
            case 2: {
                string2 = Program.gnome_getMimeType(string);
                break;
            }
            case 3: {
                string2 = Program.cde_getMimeType(string);
            }
        }
        if (string2 == null) {
            return null;
        }
        Program program = null;
        switch (n) {
            case 1: 
            case 2: {
                program = Program.gnome_getProgram(display, string2);
                break;
            }
            case 3: {
                program = Program.cde_getProgram(display, string2);
            }
        }
        return program;
    }

    public static String[] getExtensions() {
        return Program.getExtensions(Display.getCurrent());
    }

    static String[] getExtensions(Display display) {
        String[] stringArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                hashtable = Program.gnome_getMimeInfo();
                break;
            }
            case 3: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new String[0];
        }
        Vector vector = new Vector();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(stringArray);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (!vector.contains(vector2.elementAt(n2))) {
                    vector.addElement(vector2.elementAt(n2));
                }
                ++n2;
            }
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public static Program[] getPrograms() {
        return Program.getPrograms(Display.getCurrent());
    }

    static Program[] getPrograms(Display display) {
        Program[] programArray;
        int n = Program.getDesktop(display);
        Hashtable hashtable = null;
        switch (n) {
            case 2: {
                break;
            }
            case 1: {
                hashtable = Program.gnome_getMimeInfo();
                break;
            }
            case 3: {
                hashtable = Program.cde_getDataTypeInfo();
            }
        }
        if (hashtable == null) {
            return new Program[0];
        }
        Vector<Program> vector = new Vector<Program>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            programArray = (String)enumeration.nextElement();
            Program program = null;
            switch (n) {
                case 1: {
                    program = Program.gnome_getProgram(display, (String)programArray);
                    break;
                }
                case 3: {
                    program = Program.cde_getProgram(display, (String)programArray);
                }
            }
            if (program == null) continue;
            vector.addElement(program);
        }
        programArray = new Program[vector.size()];
        int n2 = 0;
        while (n2 < programArray.length) {
            programArray[n2] = (Program)vector.elementAt(n2);
            ++n2;
        }
        return programArray;
    }

    public static boolean launch(String string) {
        return Program.launch(Display.getCurrent(), string);
    }

    static boolean launch(Display display, String string) {
        String string2;
        Program program;
        if (string == null) {
            SWT.error(4);
        }
        switch (Program.getDesktop(display)) {
            case 2: {
                if (!Program.gnome_24_launch(string)) break;
                return true;
            }
        }
        int n = string.lastIndexOf(46);
        if (n != -1 && (program = Program.findProgram(display, string2 = string.substring(n))) != null && program.execute(string)) {
            return true;
        }
        string2 = string.toLowerCase();
        if (string2.startsWith(PREFIX_HTTP) || string2.startsWith(PREFIX_HTTPS)) {
            program = Program.findProgram(display, ".html");
            if (program == null) {
                program = Program.findProgram(display, ".htm");
            }
            if (program != null && program.execute(string)) {
                return true;
            }
        }
        try {
            Compatibility.exec(string);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Program)) {
            return false;
        }
        Program program = (Program)object;
        return this.display == program.display && this.name.equals(program.name) && this.command.equals(program.command);
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = Program.getDesktop(this.display);
        switch (n) {
            case 2: {
                return this.gnome_24_execute(string);
            }
            case 1: {
                return this.gnome_execute(string);
            }
            case 3: {
                return this.cde_execute(string);
            }
        }
        return false;
    }

    public ImageData getImageData() {
        switch (Program.getDesktop(this.display)) {
            case 1: 
            case 2: {
                return this.gnome_getImageData();
            }
            case 3: {
                return this.cde_getImageData();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.display.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

