/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    int currentEffect = 0;
    TableItem currentItem;
    PaintListener paintListener;
    TableItem dropSelection = null;
    TableItem scrollItem;
    long scrollBeginTime;

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
        this.currentItem = null;
        this.dropSelection = null;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.control;
        if (this.currentItem != null) {
            this.setDropSelection(table, null);
            this.currentItem = null;
        }
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Table table = (Table)this.control;
        int n = this.checkEffect(dropTargetEvent.feedback);
        TableItem tableItem = (TableItem)this.getItem(table, dropTargetEvent.x, dropTargetEvent.y);
        if ((n & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (tableItem != null && tableItem.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int n2;
                Rectangle rectangle = table.getClientArea();
                int n3 = table.getHeaderHeight();
                int n4 = table.getItemHeight();
                Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
                point = table.getDisplay().map(null, (Control)table, point);
                TableItem tableItem2 = null;
                if (point.y < rectangle.y + n3 + 2 * n4) {
                    n2 = Math.max(0, table.indexOf(tableItem) - 1);
                    tableItem2 = table.getItem(n2);
                }
                if (point.y > rectangle.y + rectangle.height - 2 * n4) {
                    n2 = Math.min(table.getItemCount() - 1, table.indexOf(tableItem) + 1);
                    tableItem2 = table.getItem(n2);
                }
                if (tableItem2 != null) {
                    table.showItem(tableItem2);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = tableItem;
        }
        if ((n & 1) != 0) {
            if (this.currentItem != tableItem || (this.currentEffect & 1) == 0) {
                this.setDropSelection(table, tableItem);
                this.currentEffect = n;
                this.currentItem = tableItem;
            }
        } else {
            this.setDropSelection(table, null);
        }
    }

    void setDropSelection(Table table, TableItem tableItem) {
        Rectangle rectangle;
        if (tableItem == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            rectangle = this.dropSelection.getBounds(0);
            table.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        this.dropSelection = tableItem;
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            rectangle = this.dropSelection.getBounds(0);
            table.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        if (this.dropSelection == null) {
            if (this.paintListener != null) {
                table.removePaintListener(this.paintListener);
                this.paintListener = null;
            }
        } else if (this.paintListener == null) {
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    if (TableDropTargetEffect.this.dropSelection == null || TableDropTargetEffect.this.dropSelection.isDisposed()) {
                        return;
                    }
                    GC gC = paintEvent.gc;
                    boolean bl = gC.getXORMode();
                    gC.setXORMode(true);
                    Rectangle rectangle = TableDropTargetEffect.this.dropSelection.getBounds(0);
                    gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    gC.setXORMode(bl);
                }
            };
            table.addPaintListener(this.paintListener);
        }
    }
}

