/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.motif.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            transferDataArray[n] = new TransferData();
            transferDataArray[n].type = nArray[n];
            ++n;
        }
        return transferDataArray;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        int n = 0;
        while (n < nArray.length) {
            if (transferData.type == nArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        byte[] byArray;
        int n;
        transferData.result = 0;
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((n = OS.XtMalloc((byArray = (byte[])object).length)) == 0) {
            return;
        }
        OS.memmove(n, byArray, byArray.length);
        transferData.length = byArray.length;
        transferData.format = 8;
        transferData.pValue = n;
        transferData.result = 1;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int n = transferData.format * transferData.length / 8;
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        OS.memmove(byArray, transferData.pValue, n);
        return byArray;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

